/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationOperation;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManagerShared;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeRidBag;
import java.io.IOException;

public class ORidBagDeleteSerializationOperation
implements ORecordSerializationOperation {
    private final OBonsaiCollectionPointer collectionPointer;
    private final OSBTreeCollectionManager collectionManager;
    private final OSBTreeRidBag ridBag;
    private Runnable deleteTask;

    public ORidBagDeleteSerializationOperation(OBonsaiCollectionPointer collectionPointer, OSBTreeRidBag ridBag) {
        this.collectionPointer = collectionPointer;
        this.ridBag = ridBag;
        this.collectionManager = ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager();
    }

    @Override
    public void execute(OAbstractPaginatedStorage paginatedStorage) {
        OSBTreeBonsai<OIdentifiable, Integer> treeBonsai = this.loadTree();
        try {
            treeBonsai.markToDelete();
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("Error during ridbag deletion"), e);
        }
        finally {
            this.releaseTree();
        }
        long delay = paginatedStorage.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.RID_BAG_SBTREEBONSAI_DELETE_DALAY);
        long schedule = delay / 3L;
        this.deleteTask = () -> {
            if (!((OSBTreeCollectionManagerShared)this.collectionManager).tryDelete(this.collectionPointer, delay)) {
                Orient.instance().scheduleTask(this.deleteTask, schedule, 0L);
            }
        };
        Orient.instance().scheduleTask(this.deleteTask, schedule, 0L);
        this.ridBag.confirmDelete();
    }

    private OSBTreeBonsai<OIdentifiable, Integer> loadTree() {
        return this.collectionManager.loadSBTree(this.collectionPointer);
    }

    private void releaseTree() {
        this.collectionManager.releaseSBTree(this.collectionPointer);
    }
}

