/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractPageWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageChangesPortion;
import java.nio.ByteBuffer;

public class OUpdatePageRecord
extends OAbstractPageWALRecord {
    private OWALChanges changes;

    public OUpdatePageRecord() {
    }

    public OUpdatePageRecord(long pageIndex, long fileId, OOperationUnitId operationUnitId, OWALChanges changes) {
        super(pageIndex, fileId, operationUnitId);
        this.changes = changes;
    }

    public OWALChanges getChanges() {
        return this.changes;
    }

    @Override
    public int serializedSize() {
        int serializedSize = super.serializedSize();
        serializedSize += this.changes.serializedSize();
        return serializedSize += 16;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        offset = this.changes.toStream(offset, content);
        return offset;
    }

    @Override
    public void toStream(ByteBuffer buffer) {
        super.toStream(buffer);
        this.changes.toStream(buffer);
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        offset = super.fromStream(content, offset);
        this.changes = new OWALPageChangesPortion();
        offset = this.changes.fromStream(offset, content);
        return offset;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OUpdatePageRecord that = (OUpdatePageRecord)o;
        if (this.lsn == null && that.lsn == null) {
            return true;
        }
        if (this.lsn == null) {
            return false;
        }
        if (that.lsn == null) {
            return false;
        }
        return this.lsn.equals(that.lsn);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.lsn.hashCode();
        return result;
    }

    @Override
    public byte getId() {
        return 0;
    }
}

