/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class OWALSegmentCache {
    private static final int CLOSER_TIMEOUT_MIN = 15;
    private final Object lockObject = new Object();
    private final Path path;
    private FileChannel segChannel;
    private long firstCachedPage = -1L;
    private final List<ByteBuffer> pageCache = new ArrayList<ByteBuffer>();
    private long lastAccessTime = -1L;
    private final int fileTTL;
    private final int bufferSize;
    private long lastWrittenPageIndex = -1L;
    private ByteBuffer lastWrittenPage;
    private final ScheduledExecutorService closer;

    OWALSegmentCache(Path path, int fileTTL, int bufferSize, ScheduledExecutorService closer) {
        this.path = path;
        this.fileTTL = fileTTL;
        this.bufferSize = bufferSize;
        this.closer = closer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePage(ByteBuffer page, long pageIndex) throws IOException {
        Object object = this.lockObject;
        synchronized (object) {
            this.lastAccessTime = System.nanoTime();
            if (pageIndex >= this.firstCachedPage && pageIndex <= this.firstCachedPage + (long)this.pageCache.size()) {
                if (pageIndex < this.firstCachedPage + (long)this.pageCache.size()) {
                    this.pageCache.set((int)(pageIndex - this.firstCachedPage), page);
                } else {
                    this.pageCache.add(page);
                }
            } else if (this.pageCache.isEmpty()) {
                this.pageCache.add(page);
                this.firstCachedPage = pageIndex;
            }
            this.lastWrittenPage = page;
            this.lastWrittenPageIndex = pageIndex;
            if (this.pageCache.size() * OWALPage.PAGE_SIZE >= this.bufferSize + OWALPage.PAGE_SIZE) {
                this.flushAllBufferPagesExceptLastOne();
            }
        }
    }

    private void flushAllBufferPagesExceptLastOne() throws IOException {
        if (this.pageCache.size() > 1) {
            ByteBuffer[] buffers = this.pageCache.toArray(new ByteBuffer[0]);
            ByteBuffer[] buffersToFlush = new ByteBuffer[buffers.length - 1];
            for (int i = 0; i < buffersToFlush.length; ++i) {
                buffersToFlush[i] = buffers[i];
                buffersToFlush[i].position(0);
            }
            this.initFile();
            this.segChannel.position(this.firstCachedPage * (long)OWALPage.PAGE_SIZE);
            OIOUtils.writeByteBuffers(buffersToFlush, this.segChannel, OWALPage.PAGE_SIZE * buffersToFlush.length);
            this.pageCache.clear();
            this.pageCache.add(buffers[buffers.length - 1]);
            this.firstCachedPage += (long)buffersToFlush.length;
        }
    }

    private void flushBuffer() throws IOException {
        if (!this.pageCache.isEmpty()) {
            ByteBuffer[] buffers;
            for (ByteBuffer buffer : buffers = this.pageCache.toArray(new ByteBuffer[0])) {
                buffer.position(0);
            }
            this.initFile();
            this.segChannel.position(this.firstCachedPage * (long)OWALPage.PAGE_SIZE);
            OIOUtils.writeByteBuffers(buffers, this.segChannel, OWALPage.PAGE_SIZE * buffers.length);
            this.pageCache.clear();
            this.firstCachedPage = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readPage(long pageIndex) throws IOException {
        Object object = this.lockObject;
        synchronized (object) {
            this.lastAccessTime = System.nanoTime();
            if (pageIndex == this.lastWrittenPageIndex) {
                return this.lastWrittenPage.array();
            }
            if (pageIndex >= this.firstCachedPage && pageIndex < this.firstCachedPage + (long)this.pageCache.size()) {
                ByteBuffer buffer = this.pageCache.get((int)(pageIndex - this.firstCachedPage));
                return buffer.array();
            }
            ByteBuffer buffer = ByteBuffer.allocate(OWALPage.PAGE_SIZE).order(ByteOrder.nativeOrder());
            this.initFile();
            this.segChannel.position(pageIndex * (long)OWALPage.PAGE_SIZE);
            OIOUtils.readByteBuffer(buffer, this.segChannel);
            return buffer.array();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void truncate(long pageIndex) throws IOException {
        Object object = this.lockObject;
        synchronized (object) {
            this.lastAccessTime = System.nanoTime();
            this.flushBuffer();
            this.lastWrittenPageIndex = -1L;
            this.lastWrittenPage = null;
            this.segChannel.truncate(pageIndex * (long)OWALPage.PAGE_SIZE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer readPageBuffer(long pageIndex) throws IOException {
        Object object = this.lockObject;
        synchronized (object) {
            this.lastAccessTime = System.nanoTime();
            if (pageIndex == this.lastWrittenPageIndex) {
                ByteBuffer copy = ByteBuffer.allocate(OWALPage.PAGE_SIZE).order(ByteOrder.nativeOrder());
                this.lastWrittenPage.position(0);
                copy.put(this.lastWrittenPage);
                return copy;
            }
            if (pageIndex >= this.firstCachedPage && pageIndex < this.firstCachedPage + (long)this.pageCache.size()) {
                ByteBuffer buffer = this.pageCache.get((int)(pageIndex - this.firstCachedPage));
                ByteBuffer copy = ByteBuffer.allocate(OWALPage.PAGE_SIZE).order(ByteOrder.nativeOrder());
                buffer.position(0);
                copy.put(buffer);
                return copy;
            }
            ByteBuffer buffer = ByteBuffer.allocate(OWALPage.PAGE_SIZE).order(ByteOrder.nativeOrder());
            this.initFile();
            this.segChannel.position(pageIndex * (long)OWALPage.PAGE_SIZE);
            OIOUtils.readByteBuffer(buffer, this.segChannel);
            buffer.position(0);
            return buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws IOException {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.segChannel != null) {
                this.lastAccessTime = System.nanoTime();
                this.flushBuffer();
                this.segChannel.force(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush) {
        block9: {
            this.closer.shutdown();
            try {
                if (!this.closer.awaitTermination(15L, TimeUnit.MINUTES)) {
                    OLogManager.instance().error(this, "Can not close file " + this.path.getFileName(), null, new Object[0]);
                    break block9;
                }
                Object object = this.lockObject;
                synchronized (object) {
                    try {
                        if (this.segChannel != null) {
                            this.closeFile(flush);
                        }
                    }
                    catch (IOException ioe) {
                        OLogManager.instance().error(this, "Can not close file " + this.path.getFileName(), ioe, new Object[0]);
                    }
                }
            }
            catch (InterruptedException ie) {
                OLogManager.instance().warn((Object)this, "WAL file " + this.path.getFileName() + " close was interrupted", ie, new Object[0]);
            }
        }
    }

    private void closeFile(boolean flush) throws IOException {
        if (flush) {
            this.flushBuffer();
            this.segChannel.force(false);
        }
        this.segChannel.close();
        this.segChannel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        block9: {
            this.closer.shutdown();
            try {
                if (!this.closer.awaitTermination(15L, TimeUnit.MINUTES)) {
                    OLogManager.instance().error(this, "Can not delete file " + this.path.getFileName(), null, new Object[0]);
                    break block9;
                }
                Object object = this.lockObject;
                synchronized (object) {
                    try {
                        if (this.segChannel != null) {
                            this.segChannel.close();
                            this.segChannel = null;
                        }
                    }
                    catch (IOException ioe) {
                        OLogManager.instance().error(this, "Can not delete file " + this.path.getFileName(), ioe, new Object[0]);
                    }
                    Files.deleteIfExists(this.path);
                }
            }
            catch (InterruptedException ie) {
                OLogManager.instance().warn((Object)this, "WAL file " + this.path.getFileName() + " delete was interrupted", ie, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        Object object = this.lockObject;
        synchronized (object) {
            this.lastAccessTime = System.nanoTime();
            this.initFile();
            long pagesCount = this.segChannel.size() / (long)OWALPage.PAGE_SIZE;
            if (this.segChannel.size() % (long)OWALPage.PAGE_SIZE > 0L) {
                OLogManager.instance().error(this, "Last WAL page was written partially, auto fix", null, new Object[0]);
                this.segChannel.truncate((long)OWALPage.PAGE_SIZE * pagesCount);
            }
            this.firstCachedPage = -1L;
            this.pageCache.clear();
            this.lastWrittenPage = null;
            this.lastWrittenPageIndex = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long filledUpTo() throws IOException {
        Object object = this.lockObject;
        synchronized (object) {
            this.lastAccessTime = System.nanoTime();
            this.initFile();
            long endPage = this.segChannel.size() / (long)OWALPage.PAGE_SIZE;
            if (this.firstCachedPage == -1L) {
                return endPage;
            }
            return Math.max(endPage, this.firstCachedPage + (long)this.pageCache.size());
        }
    }

    private void initFile() throws IOException {
        if (this.segChannel == null) {
            this.segChannel = FileChannel.open(this.path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            if (this.fileTTL > 0) {
                FileCloser task = new FileCloser();
                task.self = this.closer.scheduleWithFixedDelay(task, this.fileTTL, this.fileTTL, TimeUnit.SECONDS);
            }
        }
    }

    private final class FileCloser
    implements Runnable {
        private volatile ScheduledFuture<?> self = null;

        private FileCloser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = OWALSegmentCache.this.lockObject;
            synchronized (object) {
                if (OWALSegmentCache.this.segChannel == null) {
                    if (this.self != null) {
                        this.self.cancel(false);
                    }
                } else {
                    long now = System.nanoTime();
                    if (OWALSegmentCache.this.lastAccessTime == -1L || TimeUnit.SECONDS.convert(now - OWALSegmentCache.this.lastAccessTime, TimeUnit.NANOSECONDS) > (long)OWALSegmentCache.this.fileTTL) {
                        try {
                            OWALSegmentCache.this.closeFile(true);
                            if (this.self != null) {
                                this.self.cancel(false);
                            }
                        }
                        catch (IOException ioe) {
                            OLogManager.instance().error(this, "Can not auto close file in WAL", ioe, new Object[0]);
                        }
                    }
                }
            }
        }
    }
}

