/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.engine;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexUpdateAction;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.index.engine.OIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashFunction;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashIndexBucket;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashTable;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OLocalHashTable;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OMurmurHash3HashFunction;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OSHA256HashFunction;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public final class OHashTableIndexEngine
implements OIndexEngine {
    public static final int VERSION = 2;
    public static final String METADATA_FILE_EXTENSION = ".him";
    public static final String TREE_FILE_EXTENSION = ".hit";
    public static final String BUCKET_FILE_EXTENSION = ".hib";
    public static final String NULL_BUCKET_FILE_EXTENSION = ".hnb";
    private final OHashTable<Object, Object> hashTable;
    private final AtomicLong bonsayFileId = new AtomicLong(0L);
    private final int version;
    private final String name;

    public OHashTableIndexEngine(String name, OAbstractPaginatedStorage storage, int version) {
        this.version = version;
        if (version < 2) {
            throw new IllegalStateException("Unsupported version of hash index");
        }
        this.hashTable = new OLocalHashTable<Object, Object>(name, METADATA_FILE_EXTENSION, TREE_FILE_EXTENSION, BUCKET_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, storage);
        this.name = name;
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void create(OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Set<String> clustersToIndex, Map<String, String> engineProperties, ODocument metadata, OEncryption encryption) throws IOException {
        OHashFunction hashFunction = encryption != null ? new OSHA256HashFunction(keySerializer) : new OMurmurHash3HashFunction(keySerializer);
        this.hashTable.create(keySerializer, valueSerializer, keyTypes, encryption, hashFunction, nullPointerSupport);
    }

    @Override
    public void flush() {
    }

    @Override
    public void deleteWithoutLoad(String indexName) throws IOException {
        this.hashTable.deleteWithoutLoad(indexName);
    }

    @Override
    public String getIndexNameByKey(Object key) {
        return this.name;
    }

    @Override
    public void delete() throws IOException {
        this.hashTable.delete();
    }

    @Override
    public void load(String indexName, OBinarySerializer valueSerializer, boolean isAutomatic, OBinarySerializer keySerializer, OType[] keyTypes, boolean nullPointerSupport, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
        OHashFunction hashFunction = encryption != null ? new OSHA256HashFunction(keySerializer) : new OMurmurHash3HashFunction(keySerializer);
        this.hashTable.load(indexName, keyTypes, nullPointerSupport, encryption, hashFunction, keySerializer, valueSerializer);
    }

    @Override
    public boolean contains(Object key) {
        return this.hashTable.get(key) != null;
    }

    @Override
    public boolean remove(Object key) throws IOException {
        return this.hashTable.remove(key) != null;
    }

    @Override
    public void clear() throws IOException {
        this.hashTable.clear();
    }

    @Override
    public void close() {
        this.hashTable.close();
    }

    @Override
    public Object get(Object key) {
        return this.hashTable.get(key);
    }

    @Override
    public void put(Object key, Object value) throws IOException {
        this.hashTable.put(key, value);
    }

    @Override
    public void update(Object key, OIndexKeyUpdater<Object> updater) throws IOException {
        Object value = this.get(key);
        OIndexUpdateAction<Object> updated = updater.update(value, this.bonsayFileId);
        if (updated.isChange()) {
            this.put(key, updated.getValue());
        } else if (updated.isRemove()) {
            this.remove(key);
        } else if (updated.isNothing()) {
            // empty if block
        }
    }

    @Override
    public boolean validatedPut(Object key, ORID value, OBaseIndexEngine.Validator<Object, ORID> validator) throws IOException {
        return this.hashTable.validatedPut(key, value, validator);
    }

    @Override
    public long size(OBaseIndexEngine.ValuesTransformer transformer) {
        OHashIndexBucket.Entry<Object, Object> firstEntry;
        Object nullValue;
        if (transformer == null) {
            return this.hashTable.size();
        }
        long counter = 0L;
        if (this.hashTable.isNullKeyIsSupported() && (nullValue = this.hashTable.get(null)) != null) {
            counter += (long)transformer.transformFromValue(nullValue).size();
        }
        if ((firstEntry = this.hashTable.firstEntry()) == null) {
            return counter;
        }
        OHashIndexBucket.Entry<Object, Object>[] entries = this.hashTable.ceilingEntries(firstEntry.key);
        while (entries.length > 0) {
            for (OHashIndexBucket.Entry<Object, Object> entry : entries) {
                counter += (long)transformer.transformFromValue(entry.value).size();
            }
            entries = this.hashTable.higherEntries(entries[entries.length - 1].key);
        }
        return counter;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return false;
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        throw new UnsupportedOperationException("iterateEntriesBetween");
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        throw new UnsupportedOperationException("iterateEntriesMajor");
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        throw new UnsupportedOperationException("iterateEntriesMinor");
    }

    @Override
    public Object getFirstKey() {
        throw new UnsupportedOperationException("firstKey");
    }

    @Override
    public Object getLastKey() {
        throw new UnsupportedOperationException("lastKey");
    }

    @Override
    public OIndexCursor cursor(final OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        return new OIndexAbstractCursor(){
            private int nextEntriesIndex;
            private OHashIndexBucket.Entry<Object, Object>[] entries;
            private Iterator<ORID> currentIterator = new OEmptyIterator<ORID>();
            private Object currentKey;
            {
                OHashIndexBucket.Entry firstEntry = OHashTableIndexEngine.this.hashTable.firstEntry();
                this.entries = firstEntry == null ? OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY : OHashTableIndexEngine.this.hashTable.ceilingEntries(firstEntry.key);
                if (this.entries.length == 0) {
                    this.currentIterator = null;
                }
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.currentIterator == null) {
                    return null;
                }
                if (this.currentIterator.hasNext()) {
                    return this.nextCursorValue();
                }
                while (this.currentIterator != null && !this.currentIterator.hasNext()) {
                    if (this.entries.length == 0) {
                        this.currentIterator = null;
                        return null;
                    }
                    OHashIndexBucket.Entry<Object, Object> bucketEntry = this.entries[this.nextEntriesIndex];
                    this.currentKey = bucketEntry.key;
                    Object value = bucketEntry.value;
                    this.currentIterator = valuesTransformer != null ? valuesTransformer.transformFromValue(value).iterator() : Collections.singletonList((ORID)value).iterator();
                    ++this.nextEntriesIndex;
                    if (this.nextEntriesIndex < this.entries.length) continue;
                    this.entries = OHashTableIndexEngine.this.hashTable.higherEntries(this.entries[this.entries.length - 1].key);
                    this.nextEntriesIndex = 0;
                }
                if (this.currentIterator != null && !this.currentIterator.hasNext()) {
                    return this.nextCursorValue();
                }
                this.currentIterator = null;
                return null;
            }

            private Map.Entry<Object, OIdentifiable> nextCursorValue() {
                final OIdentifiable identifiable = this.currentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return currentKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return identifiable;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public OIndexCursor descCursor(final OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        return new OIndexAbstractCursor(){
            private int nextEntriesIndex;
            private OHashIndexBucket.Entry<Object, Object>[] entries;
            private Iterator<ORID> currentIterator = new OEmptyIterator<ORID>();
            private Object currentKey;
            {
                OHashIndexBucket.Entry lastEntry = OHashTableIndexEngine.this.hashTable.lastEntry();
                this.entries = lastEntry == null ? OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY : OHashTableIndexEngine.this.hashTable.floorEntries(lastEntry.key);
                if (this.entries.length == 0) {
                    this.currentIterator = null;
                }
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.currentIterator == null) {
                    return null;
                }
                if (this.currentIterator.hasNext()) {
                    return this.nextCursorValue();
                }
                while (this.currentIterator != null && !this.currentIterator.hasNext()) {
                    if (this.entries.length == 0) {
                        this.currentIterator = null;
                        return null;
                    }
                    OHashIndexBucket.Entry<Object, Object> bucketEntry = this.entries[this.nextEntriesIndex];
                    this.currentKey = bucketEntry.key;
                    Object value = bucketEntry.value;
                    this.currentIterator = valuesTransformer != null ? valuesTransformer.transformFromValue(value).iterator() : Collections.singletonList((ORID)value).iterator();
                    --this.nextEntriesIndex;
                    if (this.nextEntriesIndex >= 0) continue;
                    this.entries = OHashTableIndexEngine.this.hashTable.lowerEntries(this.entries[0].key);
                    this.nextEntriesIndex = this.entries.length - 1;
                }
                if (this.currentIterator != null && !this.currentIterator.hasNext()) {
                    return this.nextCursorValue();
                }
                this.currentIterator = null;
                return null;
            }

            private Map.Entry<Object, OIdentifiable> nextCursorValue() {
                final OIdentifiable identifiable = this.currentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return currentKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return identifiable;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        return new OIndexKeyCursor(){
            private int nextEntriesIndex;
            private OHashIndexBucket.Entry<Object, Object>[] entries;
            {
                OHashIndexBucket.Entry firstEntry = OHashTableIndexEngine.this.hashTable.firstEntry();
                this.entries = firstEntry == null ? OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY : OHashTableIndexEngine.this.hashTable.ceilingEntries(firstEntry.key);
            }

            @Override
            public Object next(int prefetchSize) {
                if (this.entries.length == 0) {
                    return null;
                }
                OHashIndexBucket.Entry<Object, Object> bucketEntry = this.entries[this.nextEntriesIndex];
                ++this.nextEntriesIndex;
                if (this.nextEntriesIndex >= this.entries.length) {
                    this.entries = OHashTableIndexEngine.this.hashTable.higherEntries(this.entries[this.entries.length - 1].key);
                    this.nextEntriesIndex = 0;
                }
                return bucketEntry.key;
            }
        };
    }

    @Override
    public boolean acquireAtomicExclusiveLock(Object key) {
        this.hashTable.acquireAtomicExclusiveLock();
        return true;
    }
}

