/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtreebonsai.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OSBTreeBonsaiLocalException;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OBonsaiBucketAbstract;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsaiLocal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class OSBTreeBonsaiBucket<K, V>
extends OBonsaiBucketAbstract {
    public static final int MAX_BUCKET_SIZE_BYTES = OGlobalConfiguration.SBTREEBONSAI_BUCKET_SIZE.getValueAsInteger() * 1024;
    private static final byte LEAF = 1;
    private static final byte DELETED = 2;
    private static final byte TO_DELETE = 4;
    private static final int MAX_ENTREE_SIZE = 0x1770000;
    private static final int FREE_POINTER_OFFSET = 28;
    private static final int SIZE_OFFSET = 32;
    private static final int FLAGS_OFFSET = 36;
    private static final int FREE_LIST_POINTER_OFFSET = 37;
    private static final int LEFT_SIBLING_OFFSET = 49;
    private static final int RIGHT_SIBLING_OFFSET = 61;
    private static final int TREE_SIZE_OFFSET = 73;
    private static final int KEY_SERIALIZER_OFFSET = 81;
    private static final int VALUE_SERIALIZER_OFFSET = 82;
    private static final int POSITIONS_ARRAY_OFFSET = 83;
    private final boolean isLeaf;
    private final int offset;
    private final OBinarySerializer<K> keySerializer;
    private final OBinarySerializer<V> valueSerializer;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final OSBTreeBonsaiLocal<K, V> tree;

    public OSBTreeBonsaiBucket(OCacheEntry cacheEntry, int pageOffset, boolean isLeaf, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OSBTreeBonsaiLocal<K, V> tree) throws IOException {
        super(cacheEntry);
        this.offset = pageOffset;
        this.isLeaf = isLeaf;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.setIntValue(this.offset + 28, MAX_BUCKET_SIZE_BYTES);
        this.setIntValue(this.offset + 32, 0);
        this.setByteValue(this.offset + 36, isLeaf ? (byte)1 : 0);
        this.setLongValue(this.offset + 49, -1L);
        this.setLongValue(this.offset + 61, -1L);
        this.setLongValue(this.offset + 73, 0L);
        this.setByteValue(this.offset + 81, keySerializer.getId());
        this.setByteValue(this.offset + 82, valueSerializer.getId());
        this.tree = tree;
    }

    public OSBTreeBonsaiBucket(OCacheEntry cacheEntry, int pageOffset, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OSBTreeBonsaiLocal<K, V> tree) {
        super(cacheEntry);
        this.offset = pageOffset;
        this.isLeaf = (this.getByteValue(this.offset + 36) & 1) == 1;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.tree = tree;
    }

    public byte getKeySerializerId() {
        return this.getByteValue(this.offset + 81);
    }

    public void setKeySerializerId(byte keySerializerId) {
        this.setByteValue(this.offset + 81, keySerializerId);
    }

    public byte getValueSerializerId() {
        return this.getByteValue(this.offset + 82);
    }

    public void setValueSerializerId(byte valueSerializerId) {
        this.setByteValue(this.offset + 82, valueSerializerId);
    }

    public long getTreeSize() {
        return this.getLongValue(this.offset + 73);
    }

    public void setTreeSize(long size) throws IOException {
        this.setLongValue(this.offset + 73, size);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int find(K key) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            K midVal = this.getKey(mid);
            int cmp = this.comparator.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void remove(int entryIndex) throws IOException {
        int entryPosition = this.getIntValue(this.offset + 83 + entryIndex * 4);
        int entrySize = this.getObjectSizeInDirectMemory(this.keySerializer, this.offset + entryPosition);
        if (this.isLeaf) {
            assert (this.valueSerializer.isFixedLength());
            entrySize += this.valueSerializer.getFixedLength();
        } else {
            throw new IllegalStateException("Remove is applies to leaf buckets only");
        }
        int size = this.size();
        if (entryIndex < size - 1) {
            this.moveData(this.offset + 83 + (entryIndex + 1) * 4, this.offset + 83 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(this.offset + 32, --size);
        int freePointer = this.getIntValue(this.offset + 28);
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(this.offset + freePointer, this.offset + freePointer + entrySize, entryPosition - freePointer);
        }
        this.setIntValue(this.offset + 28, freePointer + entrySize);
        int currentPositionOffset = this.offset + 83;
        for (int i = 0; i < size; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
    }

    public int size() {
        return this.getIntValue(this.offset + 32);
    }

    public SBTreeEntry<K, V> getEntry(int entryIndex) {
        int entryPosition = this.getIntValue(this.offset + entryIndex * 4 + 83);
        if (this.isLeaf) {
            K key = this.deserializeFromDirectMemory(this.keySerializer, this.offset + entryPosition);
            entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, this.offset + entryPosition);
            V value = this.deserializeFromDirectMemory(this.valueSerializer, this.offset + entryPosition);
            return new SBTreeEntry<K, V>(OBonsaiBucketPointer.NULL, OBonsaiBucketPointer.NULL, key, value);
        }
        OBonsaiBucketPointer leftChild = this.getBucketPointer(this.offset + entryPosition);
        OBonsaiBucketPointer rightChild = this.getBucketPointer(this.offset + (entryPosition += 12));
        K key = this.deserializeFromDirectMemory(this.keySerializer, this.offset + (entryPosition += 12));
        return new SBTreeEntry<K, Object>(leftChild, rightChild, key, null);
    }

    byte[] getRawEntry(int entryIndex) {
        int entryPosition;
        int startEntryPosition = entryPosition = this.getIntValue(this.offset + entryIndex * 4 + 83);
        if (this.isLeaf) {
            int keySize = this.getObjectSizeInDirectMemory(this.keySerializer, this.offset + entryPosition);
            int valueSize = this.getObjectSizeInDirectMemory(this.valueSerializer, this.offset + (entryPosition += keySize));
            return this.getBinaryValue(startEntryPosition + this.offset, keySize + valueSize);
        }
        int keyLen = this.getObjectSizeInDirectMemory(this.keySerializer, this.offset + (entryPosition += 24));
        return this.getBinaryValue(startEntryPosition + this.offset, keyLen + 24);
    }

    public K getKey(int index) {
        int entryPosition = this.getIntValue(this.offset + index * 4 + 83);
        if (!this.isLeaf) {
            entryPosition += 24;
        }
        return this.deserializeFromDirectMemory(this.keySerializer, this.offset + entryPosition);
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void addAll(List<byte[]> entries) {
        for (int i = 0; i < entries.size(); ++i) {
            this.appendRawEntry(i, entries.get(i));
        }
        this.setIntValue(this.offset + 32, entries.size());
    }

    public void shrink(int newSize) {
        ArrayList<byte[]> rawEntries = new ArrayList<byte[]>(newSize);
        for (int i = 0; i < newSize; ++i) {
            rawEntries.add(this.getRawEntry(i));
        }
        this.setIntValue(this.offset + 28, MAX_BUCKET_SIZE_BYTES);
        int index = 0;
        for (byte[] entry : rawEntries) {
            this.appendRawEntry(index, entry);
            ++index;
        }
        this.setIntValue(this.offset + 32, newSize);
    }

    public boolean addEntry(int index, SBTreeEntry<K, V> treeEntry, boolean updateNeighbors) throws IOException {
        int keySize = this.keySerializer.getObjectSize(treeEntry.key, new Object[0]);
        int valueSize = 0;
        int entrySize = keySize;
        if (this.isLeaf) {
            assert (this.valueSerializer.isFixedLength());
            valueSize = this.valueSerializer.getFixedLength();
            this.checkEntreeSize(entrySize += valueSize);
        } else {
            entrySize += 24;
        }
        int size = this.size();
        int freePointer = this.getIntValue(this.offset + 28);
        if (freePointer - entrySize < (size + 1) * 4 + 83) {
            if (size > 1) {
                return false;
            }
            throw new OSBTreeBonsaiLocalException("Entry size ('key + value') is more than is more than allowed " + (freePointer - 8 + 83) + " bytes, either increase page size using '" + OGlobalConfiguration.SBTREEBONSAI_BUCKET_SIZE.getKey() + "' parameter, or decrease 'key + value' size.", this.tree);
        }
        if (index <= size - 1) {
            this.moveData(this.offset + 83 + index * 4, this.offset + 83 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(this.offset + 28, freePointer -= entrySize);
        this.setIntValue(this.offset + 83 + index * 4, freePointer);
        this.setIntValue(this.offset + 32, size + 1);
        if (this.isLeaf) {
            byte[] serializedKey = new byte[keySize];
            this.keySerializer.serializeNativeObject(treeEntry.key, serializedKey, 0, new Object[0]);
            this.setBinaryValue(this.offset + freePointer, serializedKey);
            byte[] serializedValue = new byte[valueSize];
            this.valueSerializer.serializeNativeObject(treeEntry.value, serializedValue, 0, new Object[0]);
            this.setBinaryValue(this.offset + (freePointer += keySize), serializedValue);
        } else {
            this.setBucketPointer(this.offset + freePointer, treeEntry.leftChild);
            this.setBucketPointer(this.offset + (freePointer += 12), treeEntry.rightChild);
            byte[] serializedKey = new byte[keySize];
            this.keySerializer.serializeNativeObject(treeEntry.key, serializedKey, 0, new Object[0]);
            this.setBinaryValue(this.offset + (freePointer += 12), serializedKey);
            if (updateNeighbors && ++size > 1) {
                if (index < size - 1) {
                    int nextEntryPosition = this.getIntValue(this.offset + 83 + (index + 1) * 4);
                    this.setBucketPointer(this.offset + nextEntryPosition, treeEntry.rightChild);
                }
                if (index > 0) {
                    int prevEntryPosition = this.getIntValue(this.offset + 83 + (index - 1) * 4);
                    this.setBucketPointer(this.offset + prevEntryPosition + 8 + 4, treeEntry.leftChild);
                }
            }
        }
        return true;
    }

    private void appendRawEntry(int index, byte[] rawEntry) {
        int freePointer = this.getIntValue(this.offset + 28);
        this.setIntValue(this.offset + 28, freePointer -= rawEntry.length);
        this.setIntValue(this.offset + 83 + index * 4, freePointer);
        this.setBinaryValue(this.offset + freePointer, rawEntry);
    }

    public int updateValue(int index, V value) throws IOException {
        assert (this.valueSerializer.isFixedLength());
        int entryPosition = this.getIntValue(this.offset + index * 4 + 83);
        entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, this.offset + entryPosition);
        int size = this.valueSerializer.getFixedLength();
        byte[] serializedValue = new byte[size];
        this.valueSerializer.serializeNativeObject(value, serializedValue, 0, new Object[0]);
        byte[] oldSerializedValue = this.getBinaryValue(this.offset + entryPosition, size);
        if (ODefaultComparator.INSTANCE.compare(oldSerializedValue, serializedValue) == 0) {
            return 0;
        }
        this.setBinaryValue(this.offset + entryPosition, serializedValue);
        return 1;
    }

    public OBonsaiBucketPointer getFreeListPointer() {
        return this.getBucketPointer(this.offset + 37);
    }

    public void setFreeListPointer(OBonsaiBucketPointer pointer) throws IOException {
        this.setBucketPointer(this.offset + 37, pointer);
    }

    public void setDelted(boolean deleted) {
        byte value = this.getByteValue(this.offset + 36);
        if (deleted) {
            this.setByteValue(this.offset + 36, (byte)(value | 2));
        } else {
            this.setByteValue(this.offset + 36, (byte)(value & 0xFFFFFFFD));
        }
    }

    public boolean isDeleted() {
        return (this.getByteValue(this.offset + 36) & 2) == 2;
    }

    public void setToDelete(boolean toDelete) {
        byte value = this.getByteValue(this.offset + 36);
        if (toDelete) {
            this.setByteValue(this.offset + 36, (byte)(value | 4));
        } else {
            this.setByteValue(this.offset + 36, (byte)(value & 0xFFFFFFFB));
        }
    }

    public boolean isToDelete() {
        return (this.getByteValue(this.offset + 36) & 4) == 4;
    }

    public OBonsaiBucketPointer getLeftSibling() {
        return this.getBucketPointer(this.offset + 49);
    }

    public void setLeftSibling(OBonsaiBucketPointer pointer) throws IOException {
        this.setBucketPointer(this.offset + 49, pointer);
    }

    public OBonsaiBucketPointer getRightSibling() {
        return this.getBucketPointer(this.offset + 61);
    }

    public void setRightSibling(OBonsaiBucketPointer pointer) throws IOException {
        this.setBucketPointer(this.offset + 61, pointer);
    }

    private void checkEntreeSize(int entreeSize) {
        if (entreeSize > 0x1770000) {
            throw new OSBTreeBonsaiLocalException("Serialized key-value pair size bigger than allowed " + entreeSize + " vs " + 0x1770000 + ".", this.tree);
        }
    }

    public static final class SBTreeEntry<K, V>
    implements Map.Entry<K, V>,
    Comparable<SBTreeEntry<K, V>> {
        public final OBonsaiBucketPointer leftChild;
        public final OBonsaiBucketPointer rightChild;
        public final K key;
        public final V value;
        private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;

        public SBTreeEntry(OBonsaiBucketPointer leftChild, OBonsaiBucketPointer rightChild, K key, V value) {
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("SBTreeEntry.setValue");
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SBTreeEntry that = (SBTreeEntry)o;
            if (!this.leftChild.equals(that.leftChild)) {
                return false;
            }
            if (!this.rightChild.equals(that.rightChild)) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        @Override
        public int hashCode() {
            int result = this.leftChild.hashCode();
            result = 31 * result + this.rightChild.hashCode();
            result = 31 * result + this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "SBTreeEntry{leftChild=" + this.leftChild + ", rightChild=" + this.rightChild + ", key=" + this.key + ", value=" + this.value + '}';
        }

        @Override
        public int compareTo(SBTreeEntry<K, V> other) {
            return this.comparator.compare(this.key, other.key);
        }
    }
}

