/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.impl.OClusterOwnershipAssignmentStrategy;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ODefaultClusterOwnershipAssignmentStrategy
implements OClusterOwnershipAssignmentStrategy {
    private final ODistributedAbstractPlugin manager;

    public ODefaultClusterOwnershipAssignmentStrategy(ODistributedAbstractPlugin manager) {
        this.manager = manager;
    }

    @Override
    public List<String> assignClusterOwnershipOfClass(ODatabaseInternal iDatabase, OModifiableDistributedConfiguration cfg, OClass iClass, Set<String> availableNodes, boolean canCreateNewClusters) {
        Iterator<String> it = availableNodes.iterator();
        while (it.hasNext()) {
            String node = it.next();
            if (cfg.getServerRole(node) == ODistributedConfiguration.ROLES.MASTER) continue;
            it.remove();
        }
        if (availableNodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (iClass.isAbstract()) {
            return Collections.EMPTY_LIST;
        }
        int[] clusterIds = iClass.getClusterIds();
        HashSet<String> clusterNames = new HashSet<String>(clusterIds.length);
        for (int clusterId : clusterIds) {
            String clusterName = iDatabase.getClusterNameById(clusterId);
            if (clusterName == null) continue;
            clusterNames.add(clusterName);
        }
        Map<String, String> clusterToAssignOwnership = this.reassignClusters(cfg, availableNodes, clusterNames);
        for (Map.Entry<String, String> entry : clusterToAssignOwnership.entrySet()) {
            String cluster = entry.getKey();
            String node = entry.getValue();
            this.assignClusterOwnership(iDatabase, cfg, iClass, cluster, node);
        }
        Collection<String> allClusterNames = iDatabase.getClusterNames();
        ArrayList<String> serversToCreateANewCluster = new ArrayList<String>();
        if (canCreateNewClusters) {
            for (String server : availableNodes) {
                String newClusterName;
                List<String> ownedClusters = cfg.getOwnedClustersByServer(clusterNames, server);
                if (!ownedClusters.isEmpty()) continue;
                int i = 1;
                while (allClusterNames.contains(newClusterName = iClass.getName().toLowerCase(Locale.ENGLISH) + "_" + i) || serversToCreateANewCluster.contains(newClusterName)) {
                    ++i;
                }
                serversToCreateANewCluster.add(newClusterName);
                this.assignClusterOwnership(iDatabase, cfg, iClass, newClusterName, server);
            }
        }
        return serversToCreateANewCluster;
    }

    /*
     * WARNING - void declaration
     */
    protected Map<String, String> reassignClusters(ODistributedConfiguration cfg, Set<String> availableNodes, Set<String> clusterNames) {
        Set<String> allConfiguredNodes = cfg.getServers(clusterNames);
        ArrayList<OPair<String, Object>> nodeOwners = new ArrayList<OPair<String, Object>>(allConfiguredNodes.size());
        for (String server : allConfiguredNodes) {
            List<String> ownedClusters = cfg.getOwnedClustersByServer(clusterNames, server);
            Iterator<String> iterator = ownedClusters.iterator();
            while (iterator.hasNext()) {
                String cluster = iterator.next();
                if (cfg.getConfiguredClusterOwner(cluster) == null) continue;
                iterator.remove();
            }
            nodeOwners.add(new OPair<String, Object>(server, ownedClusters));
        }
        Collections.sort(nodeOwners, new Comparator<OPair<String, List<String>>>(){

            @Override
            public int compare(OPair<String, List<String>> o1, OPair<String, List<String>> o2) {
                return o2.getValue().size() - o1.getValue().size();
            }
        });
        HashMap<String, String> clusterToAssignOwnership = new HashMap<String, String>();
        HashSet clustersOfClassToReassign = new HashSet();
        for (OPair oPair : nodeOwners) {
            String server = (String)oPair.getKey();
            List list = (List)oPair.getValue();
            if (availableNodes.contains(server)) continue;
            clustersOfClassToReassign.addAll(list);
        }
        int currentServerIndex = 0;
        boolean bl = false;
        for (OPair oPair : nodeOwners) {
            void var9_14;
            int targetClustersPerNode;
            String server = (String)oPair.getKey();
            List ownedClusters = (List)oPair.getValue();
            int nodesLeft = availableNodes.size() - currentServerIndex;
            int n = targetClustersPerNode = nodesLeft < 1 ? 1 : (clusterNames.size() - var9_14) / nodesLeft;
            if (targetClustersPerNode == 0 || nodesLeft > 0 && (clusterNames.size() - var9_14) % nodesLeft > 0) {
                ++targetClustersPerNode;
            }
            if (ownedClusters.size() > targetClustersPerNode && ownedClusters.size() > 0) {
                while (ownedClusters.size() > targetClustersPerNode) {
                    clustersOfClassToReassign.add(ownedClusters.remove(ownedClusters.size() - 1));
                }
            } else if (ownedClusters.size() < targetClustersPerNode) {
                while (ownedClusters.size() < targetClustersPerNode && !clustersOfClassToReassign.isEmpty()) {
                    Iterator it = clustersOfClassToReassign.iterator();
                    boolean reassigned = false;
                    while (it.hasNext()) {
                        String cluster = (String)it.next();
                        List<String> serverPerClusterList = cfg.getConfiguredServers(cluster);
                        if (serverPerClusterList == null || !serverPerClusterList.contains(server)) continue;
                        it.remove();
                        clusterToAssignOwnership.put(cluster, server);
                        ownedClusters.add(cluster);
                        reassigned = true;
                        break;
                    }
                    if (reassigned) continue;
                    break;
                }
            }
            var9_14 += ownedClusters.size();
            ++currentServerIndex;
        }
        return clusterToAssignOwnership;
    }

    private void assignClusterOwnership(ODatabaseInternal iDatabase, OModifiableDistributedConfiguration cfg, OClass iClass, String cluster, String node) {
        ODistributedServerLog.debug((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Class '%s': change mastership of cluster '%s' (id=%d) to node '%s'", iClass, cluster, iDatabase.getClusterIdByName(cluster), node);
        cfg.setServerOwner(cluster, node);
    }
}

