/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.Member;
import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.console.ODefaultConsoleReader;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OAnsiCode;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedLifecycleListener;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManager;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStrategy;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactoryManager;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolverFactory;
import com.orientechnologies.orient.server.distributed.impl.OClusterOwnershipAssignmentStrategy;
import com.orientechnologies.orient.server.distributed.impl.ODefaultClusterOwnershipAssignmentStrategy;
import com.orientechnologies.orient.server.distributed.impl.ODefaultDistributedStrategy;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedLockManagerExecutor;
import com.orientechnologies.orient.server.distributed.impl.ODistributedLockManagerRequester;
import com.orientechnologies.orient.server.distributed.impl.ODistributedMessageServiceImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ODistributedResponseManagerFactory;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.ODistributedWorker;
import com.orientechnologies.orient.server.distributed.impl.OIncrementalServerSync;
import com.orientechnologies.orient.server.distributed.impl.OSyncReceiver;
import com.orientechnologies.orient.server.distributed.impl.task.ORemoteTaskFactoryManagerImpl;
import com.orientechnologies.orient.server.distributed.impl.task.OSyncDatabaseDeltaTask;
import com.orientechnologies.orient.server.distributed.impl.task.OSyncDatabaseTask;
import com.orientechnologies.orient.server.distributed.impl.task.OUpdateDatabaseStatusTask;
import com.orientechnologies.orient.server.distributed.sql.OCommandExecutorSQLHASyncCluster;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODatabaseIsOldException;
import com.orientechnologies.orient.server.distributed.task.ODistributedDatabaseDeltaSyncException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ODistributedAbstractPlugin
extends OServerPluginAbstract
implements ODistributedServerManager,
ODatabaseLifecycleListener,
OCommandOutputListener {
    public static final String REPLICATOR_USER = "_CrossServerTempUser";
    protected static final String PAR_DEF_DISTRIB_DB_CONFIG = "configuration.db.default";
    protected static final String NODE_NAME_ENV = "ORIENTDB_NODE_NAME";
    protected OServer serverInstance;
    protected String nodeUuid;
    protected String nodeName = null;
    protected int nodeId = -1;
    protected File defaultDatabaseConfigFile;
    protected final ConcurrentMap<String, ODistributedStorage> storages = new ConcurrentHashMap<String, ODistributedStorage>();
    protected volatile ODistributedServerManager.NODE_STATUS status = ODistributedServerManager.NODE_STATUS.OFFLINE;
    protected long lastClusterChangeOn;
    protected List<ODistributedLifecycleListener> listeners = new ArrayList<ODistributedLifecycleListener>();
    protected final ConcurrentMap<String, ORemoteServerController> remoteServers = new ConcurrentHashMap<String, ORemoteServerController>();
    protected TimerTask publishLocalNodeConfigurationTask = null;
    protected TimerTask haStatsTask = null;
    protected TimerTask healthCheckerTask = null;
    protected AtomicLong localMessageIdCounter = new AtomicLong();
    protected OClusterOwnershipAssignmentStrategy clusterAssignmentStrategy = new ODefaultClusterOwnershipAssignmentStrategy(this);
    protected static final int DEPLOY_DB_MAX_RETRIES = 10;
    protected ConcurrentMap<String, Member> activeNodes = new ConcurrentHashMap<String, Member>();
    protected ConcurrentMap<String, String> activeNodesNamesByUuid = new ConcurrentHashMap<String, String>();
    protected ConcurrentMap<String, String> activeNodesUuidByName = new ConcurrentHashMap<String, String>();
    protected final List<String> registeredNodeById = new CopyOnWriteArrayList<String>();
    protected final ConcurrentMap<String, Integer> registeredNodeByName = new ConcurrentHashMap<String, Integer>();
    protected ConcurrentMap<String, Long> autoRemovalOfServers = new ConcurrentHashMap<String, Long>();
    protected Set<String> installingDatabases = Collections.newSetFromMap(new ConcurrentHashMap());
    protected volatile ODistributedMessageServiceImpl messageService;
    protected Date startedOn = new Date();
    protected ODistributedStrategy responseManagerFactory = new ODefaultDistributedStrategy();
    protected ORemoteTaskFactoryManager taskFactoryManager = new ORemoteTaskFactoryManagerImpl(this);
    private volatile String lastServerDump = "";
    protected CountDownLatch serverStarted = new CountDownLatch(1);
    private ODistributedConflictResolverFactory conflictResolverFactory = new ODistributedConflictResolverFactory();
    private final ODistributedLockManagerRequester lockManagerRequester = new ODistributedLockManagerRequester(this);
    private ODistributedLockManagerExecutor lockManagerExecutor;

    protected ODistributedAbstractPlugin() {
    }

    @Override
    public void waitUntilNodeOnline() throws InterruptedException {
        this.serverStarted.await();
    }

    @Override
    public void waitUntilNodeOnline(String nodeName, String databaseName) throws InterruptedException {
        while (this.messageService == null || this.messageService.getDatabase(databaseName) == null || !this.isNodeOnline(nodeName, databaseName)) {
            Thread.sleep(100L);
        }
    }

    @Override
    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.LAST;
    }

    @Override
    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        this.serverInstance = oServer;
        oServer.setVariable("ODistributedAbstractPlugin", this);
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(OSystemVariableResolver.resolveSystemVariables(param.value))) continue;
                this.enabled = false;
                return;
            }
            if (param.name.equalsIgnoreCase("nodeName")) {
                this.nodeName = param.value;
                if (!this.nodeName.contains(".")) continue;
                throw new OConfigurationException("Illegal node name '" + this.nodeName + "'. '.' is not allowed in node name");
            }
            if (!param.name.startsWith(PAR_DEF_DISTRIB_DB_CONFIG)) continue;
            this.setDefaultDatabaseConfigFile(param.value);
        }
        this.lockManagerExecutor = new ODistributedLockManagerExecutor(this);
        if (this.serverInstance.getUser("replicator") == null) {
            OLogManager.instance().config(this, "Found 'replicator' user. Starting from OrientDB v2.2 this internal user is no needed anymore. Removing it...", new Object[0]);
        }
        try {
            this.serverInstance.dropUser("replicator");
        }
        catch (IOException e) {
            throw OException.wrapException(new OConfigurationException("Error on deleting 'replicator' user"), e);
        }
    }

    @Override
    @Deprecated
    public String getCoordinatorServer() {
        return this.getLockManagerServer();
    }

    @Override
    public String getLockManagerServer() {
        return this.lockManagerRequester.getServer();
    }

    @Override
    public File getDefaultDatabaseConfigFile() {
        return this.defaultDatabaseConfigFile;
    }

    public void setDefaultDatabaseConfigFile(String iFile) {
        this.defaultDatabaseConfigFile = new File(OSystemVariableResolver.resolveSystemVariables(iFile));
        if (!this.defaultDatabaseConfigFile.exists()) {
            throw new OConfigurationException("Cannot find distributed database config file: " + this.defaultDatabaseConfigFile);
        }
    }

    @Override
    public void startup() {
        if (!this.enabled) {
            return;
        }
        Orient.instance().addDbLifecycleListener(this);
    }

    @Override
    public ODistributedAbstractPlugin registerLifecycleListener(ODistributedLifecycleListener iListener) {
        this.listeners.add(iListener);
        return this;
    }

    @Override
    public ODistributedAbstractPlugin unregisterLifecycleListener(ODistributedLifecycleListener iListener) {
        this.listeners.remove(iListener);
        return this;
    }

    @Override
    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        for (ORemoteServerController server : this.remoteServers.values()) {
            server.close();
        }
        this.remoteServers.clear();
        if (this.publishLocalNodeConfigurationTask != null) {
            this.publishLocalNodeConfigurationTask.cancel();
        }
        if (this.healthCheckerTask != null) {
            this.healthCheckerTask.cancel();
        }
        if (this.haStatsTask != null) {
            this.haStatsTask.cancel();
        }
        if (this.messageService != null) {
            this.messageService.shutdown();
        }
        this.activeNodes.clear();
        this.activeNodesNamesByUuid.clear();
        this.activeNodesUuidByName.clear();
        if (this.lockManagerExecutor != null) {
            this.lockManagerExecutor.shutdown();
        }
        if (this.lockManagerRequester != null) {
            this.lockManagerRequester.shutdown();
        }
        this.setNodeStatus(ODistributedServerManager.NODE_STATUS.OFFLINE);
        Orient.instance().removeDbLifecycleListener(this);
        for (ODistributedStorage s : this.storages.values()) {
            try {
                s.shutdownAsynchronousWorker();
                s.close();
            }
            catch (Exception exception) {}
        }
        this.storages.clear();
    }

    @Override
    public ODistributedLockManagerRequester getLockManagerRequester() {
        return this.lockManagerRequester;
    }

    @Override
    public ODistributedLockManagerExecutor getLockManagerExecutor() {
        return this.lockManagerExecutor;
    }

    @Override
    public void onOpen(ODatabaseInternal iDatabase) {
        if (!this.isRelatedToLocalServer(iDatabase)) {
            return;
        }
        if (this.isOffline() && this.status != ODistributedServerManager.NODE_STATUS.STARTING) {
            return;
        }
        ODatabaseDocumentInternal currDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            String dbName = iDatabase.getName();
            ODistributedConfiguration cfg = this.getDatabaseConfiguration(dbName);
            if (cfg == null) {
                return;
            }
        }
        catch (HazelcastException e) {
            throw OException.wrapException(new OOfflineNodeException("Hazelcast instance is not available"), e);
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException(new OOfflineNodeException("Hazelcast instance is not available"), e);
        }
        finally {
            ODatabaseRecordThreadLocal.instance().set(currDb);
        }
    }

    public void registerNewDatabaseIfNeeded(String dbName, ODistributedConfiguration cfg) {
        ODistributedDatabaseImpl distribDatabase = this.getMessageService().getDatabase(dbName);
        if (distribDatabase == null) {
            distribDatabase = this.messageService.registerDatabase(dbName, cfg);
            distribDatabase.checkNodeInConfiguration(cfg, this.getLocalNodeName());
            distribDatabase.resume();
            distribDatabase.setOnline();
        }
    }

    @Override
    public void onClose(ODatabaseInternal iDatabase) {
    }

    @Override
    public void onDrop(ODatabaseInternal iDatabase) {
        ODistributedMessageServiceImpl msgService = this.getMessageService();
        if (msgService != null) {
            msgService.unregisterDatabase(iDatabase.getName());
        }
        this.removeStorage(iDatabase.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStorage(String name) {
        ConcurrentMap<String, ODistributedStorage> concurrentMap = this.storages;
        synchronized (concurrentMap) {
            ODistributedStorage storage = (ODistributedStorage)this.storages.remove(name);
            if (storage != null) {
                storage.closeOnDrop();
            }
        }
    }

    @Override
    public void onDropClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    @Override
    public String getName() {
        return "cluster";
    }

    @Override
    public void sendShutdown() {
        this.shutdown();
    }

    public String getNodeName(Member iMember) {
        return this.getNodeName(iMember, true);
    }

    public String getNodeName(Member iMember, boolean useCache) {
        if (iMember == null || iMember.getUuid() == null) {
            return "?";
        }
        if (this.nodeUuid.equals(iMember.getUuid())) {
            return this.nodeName;
        }
        String name = (String)this.activeNodesNamesByUuid.get(iMember.getUuid());
        if (name != null) {
            return name;
        }
        ODocument cfg = this.getNodeConfigurationByUuid(iMember.getUuid(), useCache);
        if (cfg != null) {
            return (String)cfg.field("name");
        }
        return "ext:" + iMember.getUuid();
    }

    public boolean updateCachedDatabaseConfiguration(String iDatabaseName, OModifiableDistributedConfiguration cfg) {
        int currVersion;
        boolean modified;
        Integer oldVersion;
        ODistributedStorage stg = (ODistributedStorage)this.storages.get(iDatabaseName);
        if (stg == null) {
            return false;
        }
        ODistributedConfiguration dCfg = stg.getDistributedConfiguration();
        ODocument oldCfg = dCfg != null ? dCfg.getDocument() : null;
        Integer n = oldVersion = oldCfg != null ? (Integer)oldCfg.field("version") : null;
        if (oldVersion == null) {
            oldVersion = 0;
        }
        boolean bl = modified = (currVersion = cfg.getVersion()) > oldVersion;
        if (oldCfg != null && !modified) {
            OLogManager.instance().debug((Object)this, "Skip saving of distributed configuration file for database '%s' because is unchanged (version %d)", iDatabaseName, currVersion);
            return false;
        }
        stg.setDistributedConfiguration(cfg);
        ODistributedServerLog.info((Object)this, this.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Broadcasting new distributed configuration for database: %s (version=%d)\n", iDatabaseName, currVersion);
        return modified;
    }

    @Override
    public ODistributedConfiguration getDatabaseConfiguration(String iDatabaseName) {
        return this.getDatabaseConfiguration(iDatabaseName, true);
    }

    @Override
    public ODistributedConfiguration getDatabaseConfiguration(String iDatabaseName, boolean createIfNotPresent) {
        ODistributedStorage stg;
        ODistributedStorage oDistributedStorage = stg = createIfNotPresent ? this.getStorage(iDatabaseName) : this.getStorageIfExists(iDatabaseName);
        if (stg == null) {
            return null;
        }
        return stg.getDistributedConfiguration();
    }

    @Override
    public OServer getServerInstance() {
        return this.serverInstance;
    }

    @Override
    public ODocument getClusterConfiguration() {
        if (!this.enabled) {
            return null;
        }
        ODocument cluster = new ODocument();
        cluster.field("localName", this.getName());
        cluster.field("localId", this.nodeUuid);
        ArrayList<ODocument> members = new ArrayList<ODocument>();
        cluster.field("members", members, OType.EMBEDDEDLIST);
        for (Member member : this.activeNodes.values()) {
            members.add(this.getNodeConfigurationByUuid(member.getUuid(), true));
        }
        return cluster;
    }

    public abstract String getPublicAddress();

    @Override
    public ODocument getLocalNodeConfiguration() {
        ODocument nodeCfg = new ODocument();
        nodeCfg.setTrackingChanges(false);
        nodeCfg.field("id", this.nodeId);
        nodeCfg.field("uuid", this.nodeUuid);
        nodeCfg.field("name", this.nodeName);
        nodeCfg.field("version", OConstants.getRawVersion());
        nodeCfg.field("publicAddress", this.getPublicAddress());
        nodeCfg.field("startedOn", this.startedOn);
        nodeCfg.field("status", (Object)this.getNodeStatus());
        nodeCfg.field("connections", this.serverInstance.getClientConnectionManager().getTotal());
        ArrayList listeners = new ArrayList();
        nodeCfg.field("listeners", listeners, OType.EMBEDDEDLIST);
        for (OServerNetworkListener listener : this.serverInstance.getNetworkListeners()) {
            HashMap<String, String> listenerCfg = new HashMap<String, String>();
            listeners.add(listenerCfg);
            listenerCfg.put("protocol", listener.getProtocolType().getSimpleName());
            listenerCfg.put("listen", listener.getListeningAddress(true));
        }
        OServerUserConfiguration user = this.serverInstance.getUser(REPLICATOR_USER);
        if (user != null) {
            nodeCfg.field("user_replicator", this.serverInstance.getUser((String)REPLICATOR_USER).password);
        }
        nodeCfg.field("databases", this.getManagedDatabases());
        long maxMem = Runtime.getRuntime().maxMemory();
        long totMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totMem - freeMem;
        nodeCfg.field("usedMemory", usedMem);
        nodeCfg.field("freeMemory", freeMem);
        nodeCfg.field("maxMemory", maxMem);
        nodeCfg.field("latencies", this.getMessageService().getLatencies(), OType.EMBEDDED);
        nodeCfg.field("messages", this.getMessageService().getMessageStats(), OType.EMBEDDED);
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            ODatabaseLifecycleListener listener = it.next();
            if (listener == null) continue;
            listener.onLocalNodeConfigurationRequest(nodeCfg);
        }
        return nodeCfg;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public ODistributedServerManager.NODE_STATUS getNodeStatus() {
        return this.status;
    }

    @Override
    public void setNodeStatus(ODistributedServerManager.NODE_STATUS iStatus) {
        if (this.status.equals((Object)iStatus)) {
            return;
        }
        this.status = iStatus;
        ODistributedServerLog.info((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Updated node status to '%s'", new Object[]{this.status});
    }

    @Override
    public boolean checkNodeStatus(ODistributedServerManager.NODE_STATUS iStatus2Check) {
        return this.status.equals((Object)iStatus2Check);
    }

    @Override
    public ODistributedResponse sendRequest(String iDatabaseName, Collection<String> iClusterNames, Collection<String> iTargetNodes, ORemoteTask iTask, long reqId, ODistributedRequest.EXECUTION_MODE iExecutionMode, Object localResult, OCallable<Void, ODistributedRequestId> iAfterSentCallback, OCallable<Void, ODistributedResponseManager> endCallback) {
        return this.sendRequest(iDatabaseName, iClusterNames, iTargetNodes, iTask, reqId, iExecutionMode, localResult, iAfterSentCallback, endCallback, null);
    }

    public ODistributedResponse sendRequest(String iDatabaseName, Collection<String> iClusterNames, Collection<String> iTargetNodes, ORemoteTask iTask, long reqId, ODistributedRequest.EXECUTION_MODE iExecutionMode, Object localResult, OCallable<Void, ODistributedRequestId> iAfterSentCallback, OCallable<Void, ODistributedResponseManager> endCallback, ODistributedResponseManagerFactory responseManagerFactory) {
        ODistributedRequest req = new ODistributedRequest(this, this.nodeId, reqId, iDatabaseName, iTask);
        ODatabaseDocumentInternal currentDatabase = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (currentDatabase != null && currentDatabase.getUser() != null && currentDatabase.getUser().getIdentity().getIdentity().isValid()) {
            req.setUserRID((ORecordId)currentDatabase.getUser().getIdentity().getIdentity());
        }
        ODistributedDatabaseImpl db = this.messageService.getDatabase(iDatabaseName);
        if (iTargetNodes == null || iTargetNodes.isEmpty()) {
            ODistributedServerLog.error((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.OUT, "No nodes configured for partition '%s.%s' request: %s", iDatabaseName, iClusterNames, req);
            throw new ODistributedException("No nodes configured for partition '" + iDatabaseName + "." + iClusterNames + "' request: " + req);
        }
        if (db == null) {
            ODistributedServerLog.error((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.OUT, "Distributed database '%s' not found", iDatabaseName);
            throw new ODistributedException("Distributed database '" + iDatabaseName + "' not found on server '" + this.nodeName + "'");
        }
        this.messageService.updateMessageStats(iTask.getName());
        if (responseManagerFactory != null) {
            return db.send2Nodes(req, iClusterNames, iTargetNodes, iExecutionMode, localResult, iAfterSentCallback, endCallback, responseManagerFactory);
        }
        return db.send2Nodes(req, iClusterNames, iTargetNodes, iExecutionMode, localResult, iAfterSentCallback, endCallback);
    }

    @Override
    public void executeOnLocalNodeFromRemote(ODistributedRequest request) {
        Object response = this.executeOnLocalNode(request.getId(), request.getTask(), null);
        ODistributedWorker.sendResponseBack(this, this, request, response);
    }

    @Override
    public Object executeOnLocalNode(final ODistributedRequestId reqId, final ORemoteTask task, final ODatabaseDocumentInternal database) {
        if (database != null && !(database.getStorage() instanceof ODistributedStorage)) {
            throw new ODistributedException("Distributed storage was not installed for database '" + database.getName() + "'. Implementation found: " + database.getStorage().getClass().getName());
        }
        final ODistributedAbstractPlugin manager = this;
        return OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Object result = task.execute(reqId, ODistributedAbstractPlugin.this.serverInstance, manager, database);
                    if (result instanceof Throwable && !(result instanceof OException)) {
                        ODistributedServerLog.debug((Object)this, ODistributedAbstractPlugin.this.nodeName, ODistributedAbstractPlugin.this.getNodeNameById(reqId.getNodeId()), ODistributedServerLog.DIRECTION.IN, "Error on executing request %d (%s) on local node: ", (Throwable)result, reqId, task);
                    } else {
                        ODistributedDatabaseImpl ddb;
                        String sourceNodeName = task.getNodeSource();
                        if (database != null && (ddb = ODistributedAbstractPlugin.this.getMessageService().getDatabase(database.getName())) != null && !(result instanceof Throwable) && task instanceof OAbstractReplicatedTask && !task.isIdempotent()) {
                            ddb.setLSN(sourceNodeName, ((OAbstractReplicatedTask)task).getLastLSN(), true);
                            ddb.setLSN(ODistributedAbstractPlugin.this.getLocalNodeName(), ((OAbstractPaginatedStorage)database.getStorage().getUnderlying()).getLSN(), true);
                        }
                    }
                    return result;
                }
                catch (InterruptedException e) {
                    ODistributedServerLog.debug((Object)this, ODistributedAbstractPlugin.this.nodeName, ODistributedAbstractPlugin.this.getNodeNameById(reqId.getNodeId()), ODistributedServerLog.DIRECTION.IN, "Interrupted execution on executing distributed request %s on local node: %s", e, reqId, task);
                    return e;
                }
                catch (Exception e) {
                    if (!(e instanceof OException)) {
                        ODistributedServerLog.error((Object)this, ODistributedAbstractPlugin.this.nodeName, ODistributedAbstractPlugin.this.getNodeNameById(reqId.getNodeId()), ODistributedServerLog.DIRECTION.IN, "Error on executing distributed request %s on local node: %s", e, reqId, task);
                    }
                    return e;
                }
            }
        });
    }

    public Set<String> getManagedDatabases() {
        return this.messageService != null ? this.messageService.getDatabases() : Collections.EMPTY_SET;
    }

    @Override
    public String getLocalNodeName() {
        return this.nodeName;
    }

    @Override
    public int getLocalNodeId() {
        return this.nodeId;
    }

    @Override
    public void onLocalNodeConfigurationRequest(ODocument iConfiguration) {
    }

    @Override
    public void onCreateClass(ODatabaseInternal iDatabase, OClass iClass) {
        if (iDatabase.getStorage() instanceof OAutoshardedStorage && ((OAutoshardedStorage)((Object)iDatabase.getStorage())).isLocalEnv()) {
            return;
        }
        if (this.isOffline() && this.status != ODistributedServerManager.NODE_STATUS.STARTING) {
            return;
        }
        if (!this.isRelatedToLocalServer(iDatabase)) {
            return;
        }
        if (this.messageService == null || this.messageService.getDatabase(iDatabase.getName()) == null) {
            return;
        }
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabase.getName());
        this.installClustersOfClass(iDatabase, iClass, cfg.modify());
    }

    @Override
    public ODocument getStats() {
        ODocument doc = new ODocument();
        HashMap nodes = new HashMap();
        doc.field("nodes", nodes);
        HashMap<String, Object> localNode = new HashMap<String, Object>();
        doc.field("localNode", localNode);
        localNode.put("name", this.nodeName);
        localNode.put("averageResponseTime", this.messageService.getAverageResponseTime());
        HashMap databases = new HashMap();
        localNode.put("databases", databases);
        for (String dbName : this.messageService.getDatabases()) {
            HashMap db = new HashMap();
            databases.put(dbName, db);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeNameById(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Node id " + id + " is invalid");
        }
        List<String> list = this.registeredNodeById;
        synchronized (list) {
            if (id < this.registeredNodeById.size()) {
                return this.registeredNodeById.get(id);
            }
        }
        return null;
    }

    @Override
    public int getNodeIdByName(String name) {
        Integer val = (Integer)this.registeredNodeByName.get(name);
        if (val == null) {
            return -1;
        }
        return val;
    }

    @Override
    public String getNodeUuidByName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Node name " + name + " is invalid");
        }
        return (String)this.activeNodesUuidByName.get(name);
    }

    @Override
    public void updateLastClusterChange() {
        this.lastClusterChangeOn = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reassignClustersOwnership(final String iNode, String databaseName, OModifiableDistributedConfiguration cfg, final boolean canCreateNewClusters) {
        ODatabaseDocumentInternal current = ODatabaseRecordThreadLocal.instance().getIfDefined();
        final ODatabaseDocumentInternal database = this.serverInstance.openDatabase(databaseName, "internal", "internal", null, true);
        try {
            this.executeInDistributedDatabaseLock(databaseName, 20000L, cfg, new OCallable<Boolean, OModifiableDistributedConfiguration>(){

                @Override
                public Boolean call(OModifiableDistributedConfiguration cfg) {
                    ODistributedAbstractPlugin.this.rebalanceClusterOwnership(iNode, database, cfg, canCreateNewClusters);
                    return null;
                }
            });
        }
        finally {
            database.activateOnCurrentThread();
            database.close();
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    @Override
    public boolean isNodeAvailable(String iNodeName, String iDatabaseName) {
        ODistributedServerManager.DB_STATUS s = this.getDatabaseStatus(iNodeName, iDatabaseName);
        return s != ODistributedServerManager.DB_STATUS.OFFLINE && s != ODistributedServerManager.DB_STATUS.NOT_AVAILABLE;
    }

    @Override
    public boolean isNodeStatusEqualsTo(String iNodeName, String iDatabaseName, ODistributedServerManager.DB_STATUS ... statuses) {
        ODistributedServerManager.DB_STATUS s = this.getDatabaseStatus(iNodeName, iDatabaseName);
        for (ODistributedServerManager.DB_STATUS st : statuses) {
            if (s != st) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNodeAvailable(String iNodeName) {
        if (iNodeName == null) {
            return false;
        }
        return this.activeNodes.containsKey(iNodeName);
    }

    @Override
    public boolean isNodeOnline(String iNodeName, String iDatabaseName) {
        return this.getDatabaseStatus(iNodeName, iDatabaseName) == ODistributedServerManager.DB_STATUS.ONLINE;
    }

    @Override
    public boolean isOffline() {
        return this.status != ODistributedServerManager.NODE_STATUS.ONLINE;
    }

    @Override
    public int getAvailableNodes(Collection<String> iNodes, String databaseName) {
        Iterator<String> it = iNodes.iterator();
        while (it.hasNext()) {
            String node = it.next();
            if (this.isNodeAvailable(node, databaseName)) continue;
            it.remove();
        }
        return iNodes.size();
    }

    @Override
    public int getNodesWithStatus(Collection<String> iNodes, String databaseName, ODistributedServerManager.DB_STATUS ... statuses) {
        Iterator<String> it = iNodes.iterator();
        while (it.hasNext()) {
            String node = it.next();
            if (this.isNodeStatusEqualsTo(node, databaseName, statuses)) continue;
            it.remove();
        }
        return iNodes.size();
    }

    public String toString() {
        return this.nodeName;
    }

    @Override
    public ODistributedMessageServiceImpl getMessageService() {
        while (this.messageService == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw OException.wrapException(new OOfflineNodeException("Message Service is not available"), e);
            }
        }
        return this.messageService;
    }

    @Override
    public long getLastClusterChangeOn() {
        return this.lastClusterChangeOn;
    }

    @Override
    public int getTotalNodes(String iDatabaseName) {
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabaseName);
        if (cfg != null) {
            return cfg.getAllConfiguredServers().size();
        }
        return 0;
    }

    @Override
    public int getAvailableNodes(String iDatabaseName) {
        int availableNodes = 0;
        for (Map.Entry entry : this.activeNodes.entrySet()) {
            if (!this.isNodeAvailable((String)entry.getKey(), iDatabaseName)) continue;
            ++availableNodes;
        }
        return availableNodes;
    }

    @Override
    public List<String> getOnlineNodes(String iDatabaseName) {
        ArrayList<String> onlineNodes = new ArrayList<String>(this.activeNodes.size());
        for (Map.Entry entry : this.activeNodes.entrySet()) {
            if (!this.isNodeOnline((String)entry.getKey(), iDatabaseName)) continue;
            onlineNodes.add((String)entry.getKey());
        }
        return onlineNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean installDatabase(final boolean iStartup, final String databaseName, final boolean forceDeployment, final boolean tryWithDeltaFirst) {
        if (this.getDatabaseStatus(this.getLocalNodeName(), databaseName) == ODistributedServerManager.DB_STATUS.OFFLINE) {
            return false;
        }
        if (databaseName.equalsIgnoreCase("OSystem")) {
            return false;
        }
        if (this.installingDatabases.contains(databaseName)) {
            return false;
        }
        final ODistributedDatabaseImpl distrDatabase = this.messageService.registerDatabase(databaseName, null);
        try {
            this.installingDatabases.add(databaseName);
            boolean bl = this.executeInDistributedDatabaseLock(databaseName, 20000L, null, new OCallable<Boolean, OModifiableDistributedConfiguration>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call(OModifiableDistributedConfiguration cfg) {
                    boolean databaseInstalled;
                    block19: {
                        distrDatabase.checkNodeInConfiguration(cfg, ODistributedAbstractPlugin.this.nodeName);
                        List<String> nodes = cfg.getServers(null, ODistributedAbstractPlugin.this.nodeName);
                        ODistributedAbstractPlugin.this.getAvailableNodes(nodes, databaseName);
                        if (nodes.size() == 0) {
                            ODistributedServerLog.error((Object)this, ODistributedAbstractPlugin.this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Cannot install database '%s' on local node, because no servers are available", databaseName);
                            return false;
                        }
                        ODistributedServerLog.info((Object)this, ODistributedAbstractPlugin.this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Current node is a %s for database '%s'", new Object[]{cfg.getServerRole(ODistributedAbstractPlugin.this.nodeName), databaseName});
                        if (!forceDeployment && ODistributedAbstractPlugin.this.getDatabaseStatus(ODistributedAbstractPlugin.this.getLocalNodeName(), databaseName) == ODistributedServerManager.DB_STATUS.ONLINE) {
                            return false;
                        }
                        ODistributedStorage stg = ODistributedAbstractPlugin.this.getStorage(databaseName);
                        stg.setDistributedConfiguration(cfg);
                        distrDatabase.suspend();
                        Boolean deploy = forceDeployment ? Boolean.TRUE : Boolean.valueOf(cfg.isAutoDeploy());
                        try {
                            if (!distrDatabase.exists() || distrDatabase.getSyncConfiguration().getMomentum().isEmpty()) {
                                if (deploy == null || !deploy.booleanValue()) {
                                    ODistributedServerLog.debug((Object)this, ODistributedAbstractPlugin.this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Skipping download of database '%s' from the cluster because autoDeploy=false", databaseName);
                                    distrDatabase.setOnline();
                                    distrDatabase.resume();
                                    return false;
                                }
                                databaseInstalled = ODistributedAbstractPlugin.this.requestFullDatabase(distrDatabase, databaseName, iStartup, cfg);
                            } else if (tryWithDeltaFirst) {
                                try {
                                    databaseInstalled = ODistributedAbstractPlugin.this.requestDatabaseDelta(distrDatabase, databaseName, cfg);
                                }
                                catch (ODistributedDatabaseDeltaSyncException e) {
                                    if (deploy == null || !deploy.booleanValue()) {
                                        ODistributedServerLog.debug((Object)this, ODistributedAbstractPlugin.this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Skipping download of the entire database '%s' from the cluster because autoDeploy=false", databaseName);
                                        distrDatabase.setOnline();
                                        distrDatabase.resume();
                                        return false;
                                    }
                                    databaseInstalled = ODistributedAbstractPlugin.this.requestFullDatabase(distrDatabase, databaseName, iStartup, cfg);
                                }
                            } else {
                                databaseInstalled = ODistributedAbstractPlugin.this.requestFullDatabase(distrDatabase, databaseName, iStartup, cfg);
                            }
                            if (databaseInstalled) {
                                ODatabaseDocumentInternal current = ODatabaseRecordThreadLocal.instance().getIfDefined();
                                ODatabaseDocumentInternal db = distrDatabase.getDatabaseInstance();
                                try {
                                    try {
                                        distrDatabase.getSyncConfiguration().setLastLSN(ODistributedAbstractPlugin.this.nodeName, ((OLocalPaginatedStorage)db.getStorage().getUnderlying()).getLSN(), true);
                                    }
                                    catch (IOException e) {
                                        ODistributedServerLog.error((Object)this, ODistributedAbstractPlugin.this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Error on setting LSN after the installation of database '%s'", databaseName);
                                    }
                                    ODistributedAbstractPlugin.this.notifyLsnAfterInstall(db, nodes);
                                    break block19;
                                }
                                finally {
                                    db.close();
                                    if (current != null) {
                                        current.activateOnCurrentThread();
                                    }
                                }
                            }
                            ODistributedAbstractPlugin.this.setDatabaseStatus(ODistributedAbstractPlugin.this.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                        }
                        catch (ODatabaseIsOldException e) {
                            distrDatabase.setOnline();
                            ODistributedServerLog.info((Object)this, ODistributedAbstractPlugin.this.nodeName, null, ODistributedServerLog.DIRECTION.OUT, "Current copy of database '%s' is newer than the copy present in the cluster. Use the local copy and force other nodes to download this", databaseName);
                            databaseInstalled = true;
                            distrDatabase.resume();
                        }
                    }
                    return databaseInstalled;
                }
            });
            return bl;
        }
        finally {
            this.installingDatabases.remove(databaseName);
        }
    }

    private void notifyLsnAfterInstall(ODatabaseDocumentInternal db, Collection<String> nodes) {
        OLogSequenceNumber lsn = ((OLocalPaginatedStorage)db.getStorage().getUnderlying()).getLSN();
        if (!nodes.isEmpty()) {
            OUpdateDatabaseStatusTask statusTask = new OUpdateDatabaseStatusTask(db.getName(), ODistributedServerManager.DB_STATUS.ONLINE.toString(), lsn);
            ODistributedResponse result = this.sendRequest(db.getName(), null, nodes, statusTask, this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
            ODistributedDatabaseImpl database1 = this.getMessageService().getDatabase(db.getName());
            Map payload = (Map)result.getPayload();
            if (database1 != null) {
                for (Map.Entry nodePayload : payload.entrySet()) {
                    if (!(nodePayload.getValue() instanceof OUpdateDatabaseStatusTask.OUpdateResult)) continue;
                    try {
                        database1.getSyncConfiguration().setLastLSN((String)nodePayload.getKey(), ((OUpdateDatabaseStatusTask.OUpdateResult)nodePayload.getValue()).getSequenceNumber(), false);
                    }
                    catch (IOException e) {
                        OLogManager.instance().error(this, "error updating lsn", e, new Object[0]);
                    }
                }
            }
        }
    }

    protected boolean requestFullDatabase(ODistributedDatabaseImpl distrDatabase, String databaseName, boolean backupDatabase, OModifiableDistributedConfiguration cfg) {
        ODistributedServerLog.info((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Requesting full sync for database '%s'...", databaseName);
        for (int retry = 0; retry < 10; ++retry) {
            if (this.requestDatabaseFullSync(distrDatabase, backupDatabase, databaseName, retry > 0, cfg)) {
                return true;
            }
            try {
                Thread.sleep(this.serverInstance.getContextConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_MAX_STARTUP_DELAY));
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    public boolean requestDatabaseDelta(ODistributedDatabaseImpl distrDatabase, String databaseName, OModifiableDistributedConfiguration cfg) {
        List<String> nodes = cfg.getServers(null, this.nodeName);
        this.getAvailableNodes(nodes, databaseName);
        if (nodes.size() == 0) {
            return false;
        }
        ODistributedServerLog.warn((Object)this, this.nodeName, nodes.toString(), ODistributedServerLog.DIRECTION.OUT, "requesting delta database sync for '%s' on local server...", databaseName);
        this.checkIntegrityOfLastTransactions(distrDatabase);
        HashMap<String, OLogSequenceNumber> selectedNodes = new HashMap<String, OLogSequenceNumber>(nodes.size());
        for (String node : nodes) {
            OLogSequenceNumber lsn = distrDatabase.getSyncConfiguration().getLastLSN(node);
            if (lsn != null) {
                selectedNodes.put(node, lsn);
                continue;
            }
            ODistributedServerLog.info((Object)this, this.nodeName, node, ODistributedServerLog.DIRECTION.OUT, "Last LSN not found for database '%s', skip delta database sync", databaseName);
        }
        if (selectedNodes.isEmpty()) {
            ODistributedServerLog.error((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "No LSN found for delta sync for database '%s'. Asking for full database sync...", databaseName);
            throw new ODistributedDatabaseDeltaSyncException("Requested database delta sync but no LSN was found");
        }
        boolean databaseInstalledCorrectly = false;
        for (Map.Entry entry : selectedNodes.entrySet()) {
            String targetNode = (String)entry.getKey();
            OLogSequenceNumber lsn = (OLogSequenceNumber)entry.getValue();
            if (!this.isNodeOnline(targetNode, databaseName)) {
                ODistributedServerLog.info((Object)this, this.nodeName, targetNode, ODistributedServerLog.DIRECTION.OUT, "Skip synchronizing database delta for '%s' (LSN=%s), because server '%s' is not online", databaseName, lsn, targetNode);
                continue;
            }
            OSyncDatabaseDeltaTask deployTask = new OSyncDatabaseDeltaTask(lsn, distrDatabase.getSyncConfiguration().getLastOperationTimestamp());
            Set<String> clustersOnLocalServer = cfg.getClustersOnServer(this.getLocalNodeName());
            for (String c : clustersOnLocalServer) {
                deployTask.includeClusterName(c);
            }
            ArrayList<String> targetNodes = new ArrayList<String>(1);
            targetNodes.add(targetNode);
            ODistributedServerLog.info((Object)this, this.nodeName, targetNode, ODistributedServerLog.DIRECTION.OUT, "Requesting database delta sync for '%s' LSN=%s...", databaseName, lsn);
            try {
                ODistributedResponse response = this.sendRequest(databaseName, null, targetNodes, deployTask, this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                if (response == null) {
                    throw new ODistributedDatabaseDeltaSyncException(lsn);
                }
                Map results = (Map)response.getPayload();
                ODistributedServerLog.debug((Object)this, this.nodeName, ((Object)selectedNodes).toString(), ODistributedServerLog.DIRECTION.OUT, "Database delta sync returned: %s", results);
                databaseInstalledCorrectly = this.installResponseDeltaSync(distrDatabase, databaseName, cfg, targetNode, results);
            }
            catch (ODatabaseIsOldException e) {
                throw e;
            }
            catch (ODistributedDatabaseDeltaSyncException e) {
                throw e;
            }
            catch (Exception e) {
                ODistributedServerLog.error((Object)this, this.nodeName, targetNode, ODistributedServerLog.DIRECTION.OUT, "Error on asking delta backup of database '%s' (err=%s)", databaseName, e.getMessage());
                throw OException.wrapException(new ODistributedDatabaseDeltaSyncException(lsn, e.toString()), e);
            }
            if (!databaseInstalledCorrectly || cfg.isSharded()) continue;
            break;
        }
        if (databaseInstalledCorrectly) {
            distrDatabase.resume();
            return true;
        }
        throw new ODistributedDatabaseDeltaSyncException("Requested database delta sync error");
    }

    private boolean installResponseDeltaSync(ODistributedDatabaseImpl distrDatabase, String databaseName, OModifiableDistributedConfiguration cfg, String targetNode, Map<String, Object> results) {
        String dbPath = this.serverInstance.getDatabaseDirectory() + databaseName;
        boolean databaseInstalledCorrectly = false;
        for (Map.Entry<String, Object> r : results.entrySet()) {
            Object value = r.getValue();
            if (value instanceof Boolean) {
                databaseInstalledCorrectly = true;
                distrDatabase.setOnline();
                continue;
            }
            String server = r.getKey();
            if (value instanceof ODistributedDatabaseDeltaSyncException) {
                ODistributedDatabaseDeltaSyncException exc = (ODistributedDatabaseDeltaSyncException)value;
                ODistributedServerLog.warn((Object)this, this.nodeName, server, ODistributedServerLog.DIRECTION.IN, "Error on installing database delta for '%s' (err=%s)", databaseName, exc.getMessage());
                throw (ODistributedDatabaseDeltaSyncException)value;
            }
            if (value instanceof ODatabaseIsOldException) {
                throw (ODatabaseIsOldException)value;
            }
            if (value instanceof Throwable) {
                ODistributedServerLog.error((Object)this, this.nodeName, server, ODistributedServerLog.DIRECTION.IN, "Error on installing database delta %s in %s (%s)", value, databaseName, dbPath, value);
                this.setDatabaseStatus(this.nodeName, databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                throw OException.wrapException(new ODistributedDatabaseDeltaSyncException("Requested database delta sync but no LSN was found"), (Throwable)value);
            }
            if (value instanceof ODistributedDatabaseChunk) {
                File uniqueClustersBackupDirectory = this.getClusterOwnedExclusivelyByCurrentNode(dbPath, databaseName);
                try {
                    this.installDatabaseFromNetwork(dbPath, databaseName, distrDatabase, server, (ODistributedDatabaseChunk)value, true, uniqueClustersBackupDirectory, cfg);
                    ODistributedServerLog.info((Object)this, this.nodeName, targetNode, ODistributedServerLog.DIRECTION.IN, "Installed delta of database '%s'", databaseName);
                    databaseInstalledCorrectly = true;
                }
                catch (OException e) {
                    OLogManager.instance().error(this, "Error installing database from network", e, new Object[0]);
                    databaseInstalledCorrectly = false;
                }
                break;
            }
            throw new IllegalArgumentException("Type " + value + " not supported");
        }
        return databaseInstalledCorrectly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIntegrityOfLastTransactions(ODistributedDatabaseImpl distrDatabase) {
        ODatabaseDocumentInternal current = ODatabaseRecordThreadLocal.instance().getIfDefined();
        ODatabaseDocumentInternal db = distrDatabase.getDatabaseInstance();
        if (db == null) {
            return;
        }
        try {
            int checkIntegrityLastTxs = OGlobalConfiguration.DISTRIBUTED_CHECKINTEGRITY_LAST_TX.getValueAsInteger();
            if (checkIntegrityLastTxs < 1) {
                return;
            }
            Set<String> clusters2Include = this.getDatabaseConfiguration(distrDatabase.getDatabaseName()).getClustersOnServer(this.getLocalNodeName());
            OAbstractPaginatedStorage stg = (OAbstractPaginatedStorage)db.getStorage().getUnderlying();
            Set<ORecordId> changedRecords = stg.recordsChangedRecently(checkIntegrityLastTxs);
            int av = this.getAvailableNodes(distrDatabase.getDatabaseName());
            if (changedRecords != null && !changedRecords.isEmpty()) {
                ODistributedServerLog.info((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Executing the realignment of the last records modified before last close %s...", changedRecords);
                ODistributedConfiguration config = this.getDatabaseConfiguration(distrDatabase.getDatabaseName());
                config.forceWriteQuorum(av + 1);
                distrDatabase.getDatabaseRepairer().repairRecords(changedRecords);
                config.clearForceWriteQuorum();
                ODistributedServerLog.info((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Realignment completed.", new Object[0]);
            }
        }
        finally {
            db.close();
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected boolean requestDatabaseFullSync(ODistributedDatabaseImpl distrDatabase, boolean backupDatabase, String databaseName, boolean iAskToAllNodes, OModifiableDistributedConfiguration cfg) {
        List<String> nodes = cfg.getServers(null, this.nodeName);
        if (nodes.isEmpty()) {
            ODistributedServerLog.warn((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Cannot request full deploy of database '%s' because there are no nodes available with such database", databaseName);
            return false;
        }
        ArrayList<String> selectedNodes = new ArrayList<String>();
        if (!iAskToAllNodes) {
            for (String n : nodes) {
                if (!this.isNodeStatusEqualsTo(n, databaseName, ODistributedServerManager.DB_STATUS.BACKUP)) continue;
                selectedNodes.add(n);
                break;
            }
            if (selectedNodes.isEmpty()) {
                for (String f : nodes) {
                    if (!this.isNodeStatusEqualsTo(f, databaseName, ODistributedServerManager.DB_STATUS.ONLINE, ODistributedServerManager.DB_STATUS.BACKUP)) continue;
                    selectedNodes.add(f);
                    break;
                }
            }
        }
        if (selectedNodes.isEmpty()) {
            selectedNodes.addAll(nodes);
        }
        Iterator iter = selectedNodes.iterator();
        while (iter.hasNext()) {
            if (this.isNodeAvailable((String)iter.next())) continue;
            iter.remove();
        }
        ODistributedServerLog.info((Object)this, this.nodeName, ((Object)selectedNodes).toString(), ODistributedServerLog.DIRECTION.OUT, "Requesting deploy of database '%s' on local server...", databaseName);
        for (String noteToSend : selectedNodes) {
            OLogSequenceNumber lastLSN = distrDatabase.getSyncConfiguration().getLastLSN(noteToSend);
            OSyncDatabaseTask deployTask = new OSyncDatabaseTask(lastLSN, distrDatabase.getSyncConfiguration().getLastOperationTimestamp());
            ArrayList<String> singleNode = new ArrayList<String>();
            singleNode.add(noteToSend);
            Map results = (Map)this.sendRequest(databaseName, null, singleNode, deployTask, this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null).getPayload();
            if (results == null) {
                ODistributedServerLog.error((Object)this, this.nodeName, ((Object)selectedNodes).toString(), ODistributedServerLog.DIRECTION.IN, "Timeout waiting the sync database please set the `distributed.deployDbTaskTimeout` to appropriate value", new Object[0]);
                this.setDatabaseStatus(this.nodeName, databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                return false;
            }
            ODistributedServerLog.debug((Object)this, this.nodeName, ((Object)selectedNodes).toString(), ODistributedServerLog.DIRECTION.OUT, "Deploy returned: %s", results);
            String dbPath = this.serverInstance.getDatabaseDirectory() + databaseName;
            for (Map.Entry r : results.entrySet()) {
                Object value = r.getValue();
                if (value instanceof Boolean) {
                    distrDatabase.setOnline();
                    continue;
                }
                if (value instanceof ODatabaseIsOldException) {
                    throw (ODatabaseIsOldException)value;
                }
                if (value instanceof Throwable) {
                    ODistributedServerLog.error((Object)this, this.nodeName, (String)r.getKey(), ODistributedServerLog.DIRECTION.IN, "Error on installing database '%s' in %s", (Throwable)value, databaseName, dbPath);
                    this.setDatabaseStatus(this.nodeName, databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                    if (!(value instanceof ODistributedException)) continue;
                    throw (ODistributedException)value;
                }
                if (value instanceof ODistributedDatabaseChunk) {
                    File uniqueClustersBackupDirectory = this.getClusterOwnedExclusivelyByCurrentNode(dbPath, databaseName);
                    if (backupDatabase) {
                        this.backupCurrentDatabase(databaseName);
                    }
                    try {
                        this.installDatabaseFromNetwork(dbPath, databaseName, distrDatabase, (String)r.getKey(), (ODistributedDatabaseChunk)value, false, uniqueClustersBackupDirectory, cfg);
                    }
                    catch (OException e) {
                        OLogManager.instance().error(this, "Error installing database from network", e, new Object[0]);
                        return false;
                    }
                    OStorage storage = (OStorage)this.storages.get(databaseName);
                    this.replaceStorageInSessions(storage);
                    distrDatabase.resume();
                    return true;
                }
                throw new IllegalArgumentException("Type " + value + " not supported");
            }
        }
        throw new ODistributedException("No response received from remote nodes for auto-deploy of database '" + databaseName + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceStorageInSessions(OStorage storage) {
        for (OClientConnection conn : this.serverInstance.getClientConnectionManager().getConnections()) {
            ODatabaseDocumentInternal connDb = conn.getDatabase();
            if (connDb == null || !connDb.getName().equals(storage.getName())) continue;
            conn.acquire();
            try {
                conn.getDatabase().replaceStorage(storage);
                conn.getDatabase().getMetadata().reload();
            }
            finally {
                conn.release();
            }
        }
    }

    protected File getClusterOwnedExclusivelyByCurrentNode(String dbPath, String iDatabaseName) {
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabaseName);
        HashSet<String> clusters = new HashSet<String>();
        for (String clName : cfg.getClusterNames()) {
            List<String> servers = cfg.getServers(clName, null);
            if (servers == null || servers.size() != 1 || !servers.get(0).equals(this.getLocalNodeName())) continue;
            clusters.add(clName);
        }
        if (!clusters.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            Orient.instance();
            String backupDirectory = stringBuilder.append(Orient.getHomePath()).append("/temp/db_").append(iDatabaseName).toString();
            File backupFullPath = new File(backupDirectory);
            if (backupFullPath.exists()) {
                OFileUtils.deleteRecursively(backupFullPath);
            } else {
                backupFullPath.mkdirs();
            }
            ODistributedServerLog.warn((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Saving clusters %s to directory '%s' to be replaced after distributed full backup...", clusters, backupFullPath);
            for (String clName : clusters) {
                File oldFile = new File(dbPath + "/" + clName + ".pcl");
                File newFile = new File(backupFullPath + "/" + clName + ".pcl");
                if (oldFile.exists() && !oldFile.renameTo(newFile)) {
                    ODistributedServerLog.error((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Cannot make a safe copy of exclusive clusters. Error on moving file %s -> %s: restore of database '%s' has been aborted because unsafe", oldFile, newFile, iDatabaseName);
                    throw new ODistributedException("Cannot make a safe copy of exclusive clusters");
                }
                oldFile = new File(dbPath + "/" + clName + ".cpm");
                newFile = new File(backupFullPath + "/" + clName + ".cpm");
                if (!oldFile.exists() || oldFile.renameTo(newFile)) continue;
                ODistributedServerLog.error((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Cannot make a safe copy of exclusive clusters. Error on moving file %s -> %s: restore of database '%s' has been aborted because unsafe", oldFile, newFile, iDatabaseName);
                throw new ODistributedException("Cannot make a safe copy of exclusive clusters");
            }
            return backupFullPath;
        }
        return null;
    }

    protected void backupCurrentDatabase(String iDatabaseName) {
        File backupfullpath;
        this.serverInstance.getDatabases().forceDatabaseClose(iDatabaseName);
        String backupDirectory = this.serverInstance.getContextConfiguration().getValueAsString(OGlobalConfiguration.DISTRIBUTED_BACKUP_DIRECTORY);
        if (backupDirectory == null || OIOUtils.getStringContent(backupDirectory).trim().isEmpty()) {
            return;
        }
        String backupPath = backupDirectory.startsWith("/") ? backupDirectory : (backupDirectory.startsWith("../") ? new File(this.serverInstance.getDatabaseDirectory()).getParent() + backupDirectory.substring("..".length()) : this.serverInstance.getDatabaseDirectory() + backupDirectory);
        if (!backupPath.endsWith("/")) {
            backupPath = backupPath + "/";
        }
        if ((backupfullpath = new File(backupPath = backupPath + iDatabaseName)).exists()) {
            OFileUtils.deleteRecursively(backupfullpath);
        } else {
            backupfullpath.mkdirs();
        }
        String dbpath = this.serverInstance.getDatabaseDirectory() + iDatabaseName;
        ODistributedServerLog.warn((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Moving existent database '%s' in '%s' to '%s' and get a fresh copy from a remote node...", iDatabaseName, dbpath, backupPath);
        File oldDirectory = new File(dbpath);
        if (oldDirectory.exists() && oldDirectory.isDirectory()) {
            try {
                Files.move(oldDirectory.toPath(), backupfullpath.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                ODistributedServerLog.warn((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Error on moving existent database '%s' located in '%s' to '%s' (error=%s). Deleting old database anyway", iDatabaseName, dbpath, backupfullpath, e);
                OFileUtils.deleteRecursively(oldDirectory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installDatabaseFromNetwork(String dbPath, String databaseName, ODistributedDatabaseImpl distrDatabase, String iNode, ODistributedDatabaseChunk firstChunk, boolean delta, File uniqueClustersBackupDirectory, OModifiableDistributedConfiguration cfg) {
        String localNodeName = this.nodeName;
        AtomicReference<ODistributedMomentum> momentum = new AtomicReference<ODistributedMomentum>();
        OSyncReceiver receiver = new OSyncReceiver(this, databaseName, firstChunk, momentum, iNode, dbPath);
        try {
            Thread t = new Thread(receiver);
            t.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            t.start();
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Error on transferring database '%s' ", e, databaseName);
            throw OException.wrapException(new ODistributedException("Error on transferring database"), e);
        }
        ODatabaseDocumentInternal db = this.installDatabaseOnLocalNode(databaseName, dbPath, iNode, delta, uniqueClustersBackupDirectory, cfg, firstChunk.incremental, receiver);
        if (db == null) {
            return;
        }
        try {
            distrDatabase.getSyncConfiguration().load();
            distrDatabase.getSyncConfiguration().setLastLSN(localNodeName, ((OLocalPaginatedStorage)db.getStorage().getUnderlying()).getLSN(), false);
        }
        catch (IOException e) {
            ODistributedServerLog.error((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Error on loading %s file for database '%s'", e, "distributed-sync.json", databaseName);
        }
        try {
            distrDatabase.setOnline();
        }
        finally {
            db.activateOnCurrentThread();
            db.close();
        }
        Set<String> localManagedClusters = cfg.getClustersOnServer(localNodeName);
        Set<String> sourceNodeClusters = cfg.getClustersOnServer(iNode);
        localManagedClusters.removeAll(sourceNodeClusters);
        HashSet<String> toSynchClusters = new HashSet<String>();
        for (String cl : localManagedClusters) {
            List<String> servers = cfg.getServers(cl, localNodeName);
            this.getAvailableNodes(servers, databaseName);
            if (servers.isEmpty()) continue;
            toSynchClusters.add(cl);
        }
        for (String cl : toSynchClusters) {
            OCommandExecutorSQLHASyncCluster.replaceCluster(this, this.serverInstance, databaseName, cl);
        }
        try {
            this.rebalanceClusterOwnership(this.nodeName, db, cfg, false);
        }
        catch (Exception e) {
            ODistributedServerLog.warn((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Error on re-balancing the cluster for database '%s'", e, databaseName);
        }
    }

    @Override
    public ORemoteTaskFactoryManager getTaskFactoryManager() {
        return this.taskFactoryManager;
    }

    public boolean installClustersOfClass(final ODatabaseInternal iDatabase, final OClass iClass, OModifiableDistributedConfiguration cfg) {
        String databaseName = iDatabase.getName();
        if (iClass.isAbstract()) {
            return false;
        }
        this.getMessageService().registerDatabase(databaseName, cfg);
        return this.executeInDistributedDatabaseLock(databaseName, 20000L, cfg, new OCallable<Boolean, OModifiableDistributedConfiguration>(){

            @Override
            public Boolean call(OModifiableDistributedConfiguration lastCfg) {
                Set<String> availableNodes = ODistributedAbstractPlugin.this.getAvailableNodeNames(iDatabase.getName());
                List<String> cluster2Create = ODistributedAbstractPlugin.this.clusterAssignmentStrategy.assignClusterOwnershipOfClass(iDatabase, lastCfg, iClass, availableNodes, true);
                HashMap<OClass, List<String>> cluster2CreateMap = new HashMap<OClass, List<String>>(1);
                cluster2CreateMap.put(iClass, cluster2Create);
                ODistributedAbstractPlugin.this.createClusters(iDatabase, cluster2CreateMap, lastCfg);
                return true;
            }
        });
    }

    private void createClusters(final ODatabaseInternal iDatabase, final Map<OClass, List<String>> cluster2Create, OModifiableDistributedConfiguration cfg) {
        if (cluster2Create.isEmpty()) {
            return;
        }
        this.executeInDistributedDatabaseLock(iDatabase.getName(), 20000L, cfg, new OCallable<Object, OModifiableDistributedConfiguration>(){

            @Override
            public Object call(OModifiableDistributedConfiguration cfg) {
                ODistributedAbstractPlugin.this.updateCachedDatabaseConfiguration(iDatabase.getName(), cfg, true);
                for (Map.Entry entry : cluster2Create.entrySet()) {
                    final OClass clazz = (OClass)entry.getKey();
                    for (final String newClusterName : (List)entry.getValue()) {
                        ODistributedServerLog.info((Object)this, ODistributedAbstractPlugin.this.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Class '%s', creation of new local cluster '%s' (id=%d)", clazz, newClusterName, iDatabase.getClusterIdByName(newClusterName));
                        OScenarioThreadLocal.executeAsDefault(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                block2: {
                                    try {
                                        clazz.addCluster(newClusterName);
                                    }
                                    catch (Exception e) {
                                        if (iDatabase.getClusterNames().contains(newClusterName)) break block2;
                                        ODistributedServerLog.error((Object)this, ODistributedAbstractPlugin.this.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on creating cluster '%s' in class '%s': ", newClusterName, clazz, e);
                                        throw OException.wrapException(new ODistributedException("Error on creating cluster '" + newClusterName + "' in class '" + clazz + "'"), e);
                                    }
                                }
                                return null;
                            }
                        });
                    }
                }
                return null;
            }
        });
    }

    @Override
    public ODistributedStrategy getDistributedStrategy() {
        return this.responseManagerFactory;
    }

    @Override
    public void setDistributedStrategy(ODistributedStrategy streatgy) {
        this.responseManagerFactory = streatgy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeInDistributedDatabaseLock(String databaseName, long timeoutLocking, OModifiableDistributedConfiguration lastCfg, OCallable<T, OModifiableDistributedConfiguration> iCallback) {
        boolean updated2;
        T result;
        this.lockManagerRequester.acquireExclusiveLock(databaseName, this.nodeName, timeoutLocking);
        try {
            if (lastCfg == null) {
                lastCfg = this.getDatabaseConfiguration(databaseName).modify();
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Current distributed configuration for database '%s': %s", databaseName, lastCfg.getDocument().toJSON());
            }
            try {
                result = iCallback.call(lastCfg);
            }
            catch (Throwable throwable) {
                if (ODistributedServerLog.isDebugEnabled()) {
                    ODistributedServerLog.debug((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "New distributed configuration for database '%s': %s", databaseName, lastCfg.getDocument().toJSON());
                }
                boolean updated2 = this.updateCachedDatabaseConfiguration(databaseName, lastCfg, true);
                throw throwable;
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "New distributed configuration for database '%s': %s", databaseName, lastCfg.getDocument().toJSON());
            }
            updated2 = this.updateCachedDatabaseConfiguration(databaseName, lastCfg, true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lockManagerRequester.releaseExclusiveLock(databaseName, this.nodeName);
        }
        if (updated2) {
            this.notifyClients(databaseName);
            this.serverInstance.getClientConnectionManager().pushDistribCfg2Clients(this.getClusterConfiguration());
        }
        return result;
    }

    @Override
    public abstract void notifyClients(String var1);

    protected void onDatabaseEvent(String nodeName, String databaseName, ODistributedServerManager.DB_STATUS status) {
        this.updateLastClusterChange();
        this.dumpServersStatus();
    }

    protected void rebalanceClusterOwnership(String iNode, ODatabaseInternal iDatabase, OModifiableDistributedConfiguration cfg, boolean canCreateNewClusters) {
        ODistributedConfiguration.ROLES role = cfg.getServerRole(iNode);
        if (role != ODistributedConfiguration.ROLES.MASTER) {
            return;
        }
        if (iDatabase.isClosed()) {
            iDatabase = this.getServerInstance().openDatabase(iDatabase.getName());
        }
        ODistributedServerLog.info((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Reassigning ownership of clusters for database %s...", iDatabase.getName());
        Set<String> availableNodes = this.getAvailableNodeNames(iDatabase.getName());
        iDatabase.activateOnCurrentThread();
        OSchema schema = iDatabase.getDatabaseOwner().getMetadata().getSchema();
        HashMap<OClass, List<String>> cluster2CreateMap = new HashMap<OClass, List<String>>(1);
        for (OClass clazz : schema.getClasses()) {
            List<String> cluster2Create = this.clusterAssignmentStrategy.assignClusterOwnershipOfClass(iDatabase, cfg, clazz, availableNodes, canCreateNewClusters);
            cluster2CreateMap.put(clazz, cluster2Create);
        }
        if (canCreateNewClusters) {
            this.createClusters(iDatabase, cluster2CreateMap, cfg);
        }
        ODistributedServerLog.info((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Reassignment of clusters for database '%s' completed (classes=%d)", iDatabase.getName(), cluster2CreateMap.size());
    }

    protected void assignNodeName() {
        this.nodeName = OSystemVariableResolver.resolveVariable(NODE_NAME_ENV);
        if (this.nodeName != null) {
            this.nodeName = this.nodeName.trim();
            if (this.nodeName.isEmpty()) {
                this.nodeName = null;
            }
        }
        if (this.nodeName == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            System.out.println();
            System.out.println();
            System.out.println(OAnsiCode.format("$ANSI{yellow +---------------------------------------------------------------+}"));
            System.out.println(OAnsiCode.format("$ANSI{yellow |         WARNING: FIRST DISTRIBUTED RUN CONFIGURATION          |}"));
            System.out.println(OAnsiCode.format("$ANSI{yellow +---------------------------------------------------------------+}"));
            System.out.println(OAnsiCode.format("$ANSI{yellow | This is the first time that the server is running as          |}"));
            System.out.println(OAnsiCode.format("$ANSI{yellow | distributed. Please type the name you want to assign to the   |}"));
            System.out.println(OAnsiCode.format("$ANSI{yellow | current server node.                                          |}"));
            System.out.println(OAnsiCode.format("$ANSI{yellow |                                                               |}"));
            System.out.println(OAnsiCode.format("$ANSI{yellow | To avoid this message set the environment variable or JVM     |}"));
            System.out.println(OAnsiCode.format("$ANSI{yellow | setting ORIENTDB_NODE_NAME to the server node name to use.    |}"));
            System.out.println(OAnsiCode.format("$ANSI{yellow +---------------------------------------------------------------+}"));
            System.out.print(OAnsiCode.format("\n$ANSI{yellow Node name [BLANK=auto generate it]: }"));
            ODefaultConsoleReader reader = new ODefaultConsoleReader();
            try {
                this.nodeName = reader.readLine();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.nodeName != null) {
                this.nodeName = this.nodeName.trim();
                if (this.nodeName.isEmpty()) {
                    this.nodeName = null;
                }
            }
        }
        if (this.nodeName == null) {
            this.nodeName = "node" + System.currentTimeMillis();
        }
        OLogManager.instance().warn((Object)this, "Assigning distributed node name: %s", this.nodeName);
        boolean found = false;
        OServerConfiguration cfg = this.serverInstance.getConfiguration();
        for (OServerHandlerConfiguration h : cfg.handlers) {
            if (!h.clazz.equals(this.getClass().getName())) continue;
            for (OServerParameterConfiguration p : h.parameters) {
                if (!p.name.equals("nodeName")) continue;
                found = true;
                p.value = this.nodeName;
                break;
            }
            if (!found) {
                h.parameters = OArrays.copyOf(h.parameters, h.parameters.length + 1);
                h.parameters[h.parameters.length - 1] = new OServerParameterConfiguration("nodeName", this.nodeName);
            }
            try {
                this.serverInstance.saveConfiguration();
                break;
            }
            catch (IOException e) {
                throw OException.wrapException(new OConfigurationException("Cannot save server configuration"), e);
            }
        }
    }

    protected ODatabaseDocumentInternal installDatabaseOnLocalNode(final String databaseName, final String dbPath, final String iNode, final boolean delta, final File uniqueClustersBackupDirectory, OModifiableDistributedConfiguration cfg, final boolean incremental, final OSyncReceiver receiver) {
        ODistributedServerLog.info((Object)this, this.nodeName, iNode, ODistributedServerLog.DIRECTION.IN, "Installing database '%s' to: %s...", databaseName, dbPath);
        new File(dbPath).mkdirs();
        try {
            receiver.getStarted().await();
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OInterruptedException("Interrupted waiting receive of sync"), e);
        }
        final ODistributedAbstractPlugin me = this;
        this.executeInDistributedDatabaseLock(databaseName, 20000L, cfg, new OCallable<Void, OModifiableDistributedConfiguration>(){

            @Override
            public Void call(OModifiableDistributedConfiguration cfg) {
                try {
                    if (incremental) {
                        OStorage storage = ODistributedAbstractPlugin.this.serverInstance.getDatabases().fullSync(databaseName, receiver.getInputStream(), OrientDBConfig.defaultConfig());
                        ODistributedStorage distributedStorage = ODistributedAbstractPlugin.this.getStorage(databaseName);
                        distributedStorage.replaceIfNeeded((OAbstractPaginatedStorage)storage);
                        distributedStorage.saveDatabaseConfiguration();
                        distributedStorage.getLocalDistributedDatabase().getSyncConfiguration().save();
                        if (uniqueClustersBackupDirectory != null && uniqueClustersBackupDirectory.exists()) {
                            for (File f : uniqueClustersBackupDirectory.listFiles()) {
                                File oldFile = new File(dbPath + "/" + f.getName());
                                if (oldFile.exists()) {
                                    oldFile.delete();
                                }
                                if (f.renameTo(oldFile)) continue;
                                throw new ODistributedException("Cannot restore exclusive cluster file '" + f.getAbsolutePath() + "' into " + oldFile.getAbsolutePath());
                            }
                            uniqueClustersBackupDirectory.delete();
                        }
                        OLogSequenceNumber lsn = ((OAbstractPaginatedStorage)storage).getLSN();
                        OSyncDatabaseDeltaTask deployTask = new OSyncDatabaseDeltaTask(lsn, ODistributedAbstractPlugin.this.getMessageService().getDatabase(databaseName).getSyncConfiguration().getLastOperationTimestamp());
                        Set<String> clustersOnLocalServer = cfg.getClustersOnServer(ODistributedAbstractPlugin.this.getLocalNodeName());
                        for (String c : clustersOnLocalServer) {
                            deployTask.includeClusterName(c);
                        }
                        ArrayList<String> targetNodes = new ArrayList<String>(1);
                        targetNodes.add(iNode);
                        ODistributedServerLog.info((Object)this, ODistributedAbstractPlugin.this.nodeName, iNode, ODistributedServerLog.DIRECTION.OUT, "Requesting database delta sync for '%s' LSN=%s...", databaseName, lsn);
                        try {
                            ODistributedResponse response = ODistributedAbstractPlugin.this.sendRequest(databaseName, null, targetNodes, deployTask, ODistributedAbstractPlugin.this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                            Map results = (Map)response.getPayload();
                            ODistributedAbstractPlugin.this.installResponseDeltaSync(ODistributedAbstractPlugin.this.messageService.getDatabase(databaseName), databaseName, cfg, iNode, results);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        if (delta) {
                            try (PipedInputStream in = receiver.getInputStream();){
                                new OIncrementalServerSync().importDelta(ODistributedAbstractPlugin.this.serverInstance, databaseName, in, iNode);
                            }
                        }
                        try (PipedInputStream in = receiver.getInputStream();){
                            ODistributedAbstractPlugin.this.serverInstance.getDatabases().restore(databaseName, in, null, new Callable<Object>(){

                                @Override
                                public Object call() throws Exception {
                                    if (uniqueClustersBackupDirectory != null && uniqueClustersBackupDirectory.exists()) {
                                        for (File f : uniqueClustersBackupDirectory.listFiles()) {
                                            File oldFile = new File(dbPath + "/" + f.getName());
                                            if (oldFile.exists()) {
                                                oldFile.delete();
                                            }
                                            if (f.renameTo(oldFile)) continue;
                                            throw new ODistributedException("Cannot restore exclusive cluster file '" + f.getAbsolutePath() + "' into " + oldFile.getAbsolutePath());
                                        }
                                        uniqueClustersBackupDirectory.delete();
                                    }
                                    return null;
                                }
                            }, ODistributedServerLog.isDebugEnabled() ? me : null);
                        }
                    }
                    return null;
                }
                catch (IOException e) {
                    throw OException.wrapException(new OIOException("Error on distributed sync of database"), e);
                }
            }
        });
        ODatabaseDocumentInternal database = this.serverInstance.openDatabase(databaseName);
        ODistributedServerLog.info((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Installed database '%s' (LSN=%s)", databaseName, ((OAbstractPaginatedStorage)database.getStorage().getUnderlying()).getLSN());
        return database;
    }

    @Override
    public void onMessage(String iText) {
        if (iText.startsWith("\r\n")) {
            iText = iText.substring(2);
        } else if (iText.startsWith("\n")) {
            iText = iText.substring(1);
        }
        OLogManager.instance().debug((Object)this, iText, new Object[0]);
    }

    public void stopNode(String iNode) throws IOException {
        ODistributedServerLog.warn((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Sending request of stopping node '%s'...", iNode);
        ODistributedRequest request = new ODistributedRequest(this, this.nodeId, this.getNextMessageIdCounter(), null, this.getTaskFactoryManager().getFactoryByServerName(iNode).createTask(9));
        this.getRemoteServer(iNode).sendRequest(request);
    }

    public void restartNode(String iNode) throws IOException {
        ODistributedServerLog.warn((Object)this, this.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Sending request of restarting node '%s'...", iNode);
        ODistributedRequest request = new ODistributedRequest(this, this.nodeId, this.getNextMessageIdCounter(), null, this.getTaskFactoryManager().getFactoryByServerName(iNode).createTask(10));
        this.getRemoteServer(iNode).sendRequest(request);
    }

    @Override
    public Set<String> getAvailableNodeNames(String iDatabaseName) {
        HashSet<String> nodes = new HashSet<String>();
        for (Map.Entry entry : this.activeNodes.entrySet()) {
            if (!this.isNodeAvailable((String)entry.getKey(), iDatabaseName)) continue;
            nodes.add((String)entry.getKey());
        }
        return nodes;
    }

    @Override
    public long getNextMessageIdCounter() {
        return this.localMessageIdCounter.getAndIncrement();
    }

    public void closeRemoteServer(String node) {
        ORemoteServerController c = (ORemoteServerController)this.remoteServers.remove(node);
        if (c != null) {
            c.close();
        }
    }

    protected boolean isRelatedToLocalServer(ODatabaseInternal iDatabase) {
        String dbUrl = OSystemVariableResolver.resolveSystemVariables(iDatabase.getURL());
        if (iDatabase.getName().equalsIgnoreCase("OSystem")) {
            return false;
        }
        if (dbUrl.startsWith("plocal:")) {
            OLocalPaginatedStorage paginatedStorage = (OLocalPaginatedStorage)iDatabase.getStorage().getUnderlying();
            Path storagePath = paginatedStorage.getStoragePath();
            Path dbDirectoryPath = Paths.get(this.serverInstance.getDatabaseDirectory(), new String[0]);
            return storagePath.startsWith(dbDirectoryPath);
        }
        return !dbUrl.startsWith("remote:");
    }

    protected void dumpServersStatus() {
        ODocument cfg = this.getClusterConfiguration();
        String compactStatus = ODistributedOutput.getCompactServerStatus(this, cfg);
        if (!this.lastServerDump.equals(compactStatus)) {
            this.lastServerDump = compactStatus;
            ODistributedServerLog.info((Object)this, this.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Distributed servers status (*=current @=lockmgr[%s]):\n%s", this.getLockManagerServer(), ODistributedOutput.formatServerStatus(this, cfg));
        }
    }

    public ODistributedStorage getStorageIfExists(String dbName) {
        return (ODistributedStorage)this.storages.get(dbName);
    }

    @Override
    public ODistributedStorage getStorage(String dbName) {
        ODistributedStorage oldStorage;
        ODistributedStorage storage = (ODistributedStorage)this.storages.get(dbName);
        if (storage == null && (oldStorage = this.storages.putIfAbsent(dbName, storage = new ODistributedStorage(this.serverInstance, dbName))) != null) {
            storage = oldStorage;
        }
        return storage;
    }

    public ODistributedStorage getStorage(String dbName, OAbstractPaginatedStorage wrapped) {
        ODistributedStorage oldStorage;
        ODistributedStorage storage = (ODistributedStorage)this.storages.get(dbName);
        if (storage == null && (oldStorage = this.storages.putIfAbsent(dbName, storage = new ODistributedStorage(this.serverInstance, dbName))) != null) {
            storage = oldStorage;
        }
        if (storage.getUnderlying() == null) {
            storage.wrap(wrapped);
        }
        if (storage.getUnderlying() != wrapped) {
            storage.replaceIfNeeded(wrapped);
        }
        return storage;
    }

    @Override
    public ODistributedConflictResolverFactory getConflictResolverFactory() {
        return this.conflictResolverFactory;
    }

    public static String getListeningBinaryAddress(ODocument cfg) {
        if (cfg == null) {
            return null;
        }
        String url = (String)cfg.field("publicAddress");
        Collection listeners = (Collection)cfg.field("listeners");
        if (listeners == null) {
            throw new ODatabaseException("Cannot connect to a remote node because bad distributed configuration: missing 'listeners' array field");
        }
        String listenUrl = null;
        for (Map listener : listeners) {
            if (!listener.get("protocol").equals("ONetworkProtocolBinary")) continue;
            listenUrl = (String)listener.get("listen");
            break;
        }
        if (url == null) {
            url = listenUrl;
        } else {
            int pos = listenUrl.lastIndexOf(":");
            String port = pos != -1 ? listenUrl.substring(pos + 1) : "2424";
            url = url + ":" + port;
        }
        return url;
    }
}

