/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.ODistributedCommand;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.replication.OAsyncReplicationError;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorageComponent;
import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.enterprise.channel.binary.ODistributedRedirectException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.OAsynchDistributedOperation;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedConfigurationChangedException;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.OWriteOperationNotPermittedException;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorageEventListener;
import com.orientechnologies.orient.server.distributed.impl.metadata.OClassDistributed;
import com.orientechnologies.orient.server.distributed.impl.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OReadRecordIfNotLatestTask;
import com.orientechnologies.orient.server.distributed.impl.task.OReadRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OSQLCommandTask;
import com.orientechnologies.orient.server.distributed.impl.task.OScriptTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractCommandTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ODistributedStorage
implements OStorage,
OFreezableStorageComponent,
OAutoshardedStorage {
    private final String name;
    private final OServer serverInstance;
    private final ODistributedServerManager dManager;
    private volatile OAbstractPaginatedStorage wrapped;
    private BlockingQueue<OAsynchDistributedOperation> asynchronousOperationsQueue;
    private Thread asynchWorker;
    private ODistributedServerManager.DB_STATUS prevStatus;
    private ODistributedDatabase localDistributedDatabase;
    private ODistributedStorageEventListener eventListener;
    private volatile ODistributedConfiguration distributedConfiguration;
    private volatile boolean running = false;
    private volatile OSyncSource lastValidBackup = null;

    public ODistributedStorage(OServer iServer, String dbName) {
        this.serverInstance = iServer;
        this.dManager = iServer.getDistributedManager();
        this.name = dbName;
    }

    public synchronized void replaceIfNeeded(OAbstractPaginatedStorage wrapped) {
        if (this.wrapped != wrapped) {
            this.wrapped = wrapped;
        }
    }

    public synchronized void wrap(OAbstractPaginatedStorage wrapped) {
        if (this.wrapped != null) {
            return;
        }
        this.wrapped = wrapped;
        this.wrapped.underDistributedStorage();
        this.localDistributedDatabase = this.dManager.getMessageService().getDatabase(this.getName());
        ODistributedServerLog.debug((Object)this, this.dManager != null ? this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.NONE, "Installing distributed storage on database '%s'", wrapped.getName());
        int queueSize = this.getServer().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_ASYNCH_QUEUE_SIZE);
        this.asynchronousOperationsQueue = queueSize <= 0 ? new LinkedBlockingQueue<OAsynchDistributedOperation>() : new LinkedBlockingQueue<OAsynchDistributedOperation>(queueSize);
        this.startAsynchronousWorker();
    }

    @Override
    public String getCreatedAtVersion() {
        throw new UnsupportedOperationException("Supported only in embedded storage. Use 'SELECT FROM metadata:storage' instead.");
    }

    public void startAsynchronousWorker() {
        this.asynchWorker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (ODistributedStorage.this.running) {
                    try {
                        OAsynchDistributedOperation operation = (OAsynchDistributedOperation)ODistributedStorage.this.asynchronousOperationsQueue.take();
                        ODistributedRequestId reqId = null;
                        try {
                            ODistributedResponse dResponse = ODistributedStorage.this.dManager.sendRequest(operation.getDatabaseName(), operation.getClusterNames(), operation.getNodes(), operation.getTask(), operation.getMessageId(), operation.getCallback() != null ? ODistributedRequest.EXECUTION_MODE.RESPONSE : ODistributedRequest.EXECUTION_MODE.NO_RESPONSE, operation.getLocalResult(), operation.getAfterSendCallback(), null);
                            if (dResponse != null) {
                                reqId = dResponse.getRequestId();
                                if (operation.getCallback() != null) {
                                    operation.getCallback().call(new OPair<ODistributedRequestId, Object>(reqId, dResponse.getPayload()));
                                }
                            }
                            if (operation.getAfterSendCallback() == null) continue;
                            operation.getAfterSendCallback().call(reqId);
                        }
                        catch (Throwable throwable) {
                            if (operation.getAfterSendCallback() != null) {
                                operation.getAfterSendCallback().call(reqId);
                            }
                            throw throwable;
                        }
                    }
                    catch (InterruptedException e) {
                        int pendingMessages = ODistributedStorage.this.asynchronousOperationsQueue.size();
                        if (pendingMessages > 0) {
                            ODistributedServerLog.info((Object)this, ODistributedStorage.this.dManager != null ? ODistributedStorage.this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.NONE, "Received shutdown signal, waiting for asynchronous queue is empty (pending msgs=%d)...", pendingMessages);
                        }
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        if (!ODistributedStorage.this.running) continue;
                        if (e instanceof ONeedRetryException) {
                            ODistributedServerLog.debug((Object)this, ODistributedStorage.this.dManager != null ? ODistributedStorage.this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.OUT, "Error on executing asynchronous operation", e, new Object[0]);
                            continue;
                        }
                        ODistributedServerLog.error((Object)this, ODistributedStorage.this.dManager != null ? ODistributedStorage.this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.OUT, "Error on executing asynchronous operation", e, new Object[0]);
                    }
                }
                ODistributedServerLog.debug((Object)this, ODistributedStorage.this.dManager != null ? ODistributedStorage.this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.NONE, "Shutdown asynchronous queue worker for database '%s' completed", ODistributedStorage.this.wrapped.getName());
            }
        };
        this.asynchWorker.setName("OrientDB Distributed asynch ops node=" + this.getNodeId() + " db=" + this.getName());
        this.asynchWorker.start();
    }

    @Override
    public boolean isDistributed() {
        return true;
    }

    @Override
    public boolean isAssigningClusterIds() {
        return true;
    }

    @Override
    public Object command(final OCommandRequestText iCommand) {
        OCommandExecutor exec;
        if (this.isLocalEnv()) {
            return this.wrapped.command(iCommand);
        }
        ArrayList<String> servers = (ArrayList<String>)iCommand.getContext().getVariable("servers");
        if (servers == null) {
            servers = new ArrayList<String>();
            iCommand.getContext().setVariable("servers", servers);
        }
        final String localNodeName = this.dManager.getLocalNodeName();
        servers.add(localNodeName);
        ODistributedConfiguration dbCfg = this.distributedConfiguration;
        if (!dbCfg.isReplicationActive(null, localNodeName)) {
            return this.wrapped.command(iCommand);
        }
        OCommandExecutor executor = OCommandManager.instance().getExecutor(iCommand);
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse(iCommand);
        OCommandExecutor oCommandExecutor = exec = executor instanceof OCommandExecutorSQLDelegate ? ((OCommandExecutorSQLDelegate)executor).getDelegate() : executor;
        if (!exec.isIdempotent()) {
            this.resetLastValidBackup();
        }
        if (exec.isIdempotent() && !this.dManager.isNodeAvailable(this.dManager.getLocalNodeName(), this.getName())) {
            ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Node '%s' is %s, the command '%s' against database '%s' will be executed only on local server with the possibility to have partial result", new Object[]{this.dManager.getLocalNodeName(), this.dManager.getDatabaseStatus(this.dManager.getLocalNodeName(), this.getName()), iCommand, this.wrapped.getName()});
            return this.wrapped.command(iCommand);
        }
        if (!exec.isIdempotent()) {
            this.checkNodeIsMaster(localNodeName, dbCfg, "Command '" + iCommand + "'");
        }
        try {
            Object result = null;
            OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE executionMode = OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
            OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT resultMgmt = OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.CHECK_FOR_EQUALS;
            boolean executeOnLocalNodeFirst = true;
            if (OScenarioThreadLocal.INSTANCE.getRunMode() != OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED && exec instanceof OCommandDistributedReplicateRequest) {
                executionMode = ((OCommandDistributedReplicateRequest)((Object)exec)).getDistributedExecutionMode();
                resultMgmt = ((OCommandDistributedReplicateRequest)((Object)exec)).getDistributedResultManagement();
                executeOnLocalNodeFirst = ((OCommandDistributedReplicateRequest)((Object)exec)).isDistributedExecutingOnLocalNodeFirst();
            }
            switch (executionMode) {
                case LOCAL: {
                    return this.wrapped.command(iCommand);
                }
                case REPLICATE: {
                    final Set<String> involvedClusters = exec.getInvolvedClusters();
                    if (resultMgmt == OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.MERGE) {
                        Map<String, Object> results;
                        if (!exec.isIdempotent() && dbCfg.isSharded()) {
                            throw new ODistributedException("Cannot distribute the command '" + iCommand.getText() + "' because it is not idempotent and a map-reduce has been requested");
                        }
                        Map<String, Collection<String>> nodeClusterMap = dbCfg.getServerClusterMap(involvedClusters, localNodeName, exec.isIdempotent());
                        if (exec.isIdempotent() && nodeClusterMap.size() == 1 && nodeClusterMap.keySet().iterator().next().equals(localNodeName)) {
                            result = this.wrapped.command(iCommand);
                            results = new HashMap<String, Object>(1);
                            results.put(localNodeName, result);
                        } else {
                            results = this.executeOnServers(iCommand, exec, involvedClusters, nodeClusterMap);
                        }
                        OCommandExecutorSQLSelect select = exec instanceof OCommandExecutorSQLSelect ? (OCommandExecutorSQLSelect)exec : null;
                        result = select != null && select.isAnyFunctionAggregates() && !select.hasGroupBy() ? this.mergeResultByAggregation(select, results) : exec.mergeResults(results);
                        if (!(result instanceof Throwable) || !results.containsKey(localNodeName)) break;
                        this.undoCommandOnLocalServer(iCommand);
                        break;
                    }
                    final OAbstractCommandTask task = iCommand instanceof OCommandScript ? new OScriptTask(iCommand) : new OSQLCommandTask(iCommand, new HashSet<String>());
                    task.setResultStrategy(ORemoteTask.RESULT_STRATEGY.ANY);
                    final Set<String> nodes = dbCfg.getServers(involvedClusters);
                    if (iCommand instanceof ODistributedCommand) {
                        nodes.removeAll(((ODistributedCommand)((Object)iCommand)).nodesToExclude());
                    }
                    if (this.executeOnlyLocally(localNodeName, dbCfg, exec, involvedClusters, nodes)) {
                        return this.wrapped.command(iCommand);
                    }
                    final boolean executedLocally = executeOnLocalNodeFirst && nodes.contains(localNodeName);
                    result = exec.involveSchema() ? this.dManager.executeInDistributedDatabaseLock(this.getName(), 20000L, this.dManager.getDatabaseConfiguration(this.getName()).modify(), new OCallable<Object, OModifiableDistributedConfiguration>(){

                        @Override
                        public Object call(OModifiableDistributedConfiguration iArgument) {
                            return ODistributedStorage.this.executeCommand(iCommand, localNodeName, involvedClusters, task, nodes, executedLocally);
                        }
                    }) : this.executeCommand(iCommand, localNodeName, involvedClusters, task, nodes, executedLocally);
                }
            }
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)result;
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            if (result instanceof Exception) {
                throw OException.wrapException(new ODistributedException("Error on execution distributed COMMAND"), (Exception)result);
            }
            return result;
        }
        catch (OConcurrentModificationException e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord((ORecordId)e.getRid());
            throw e;
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException(new OOfflineNodeException("Hazelcast instance is not available"), e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException(new OOfflineNodeException("Hazelcast instance is not available"), e);
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route COMMAND operation to the distributed node", e, new Object[0]);
            return null;
        }
    }

    @Override
    public void acquireDistributedExclusiveLock(long timeout) {
        this.dManager.getLockManagerRequester().acquireExclusiveLock(this.getName(), this.dManager.getLocalNodeName(), timeout);
    }

    @Override
    public void releaseDistributedExclusiveLock() {
        this.dManager.getLockManagerRequester().releaseExclusiveLock(this.getName(), this.dManager.getLocalNodeName());
    }

    protected Object executeCommand(final OCommandRequestText iCommand, String localNodeName, Collection<String> involvedClusters, OAbstractCommandTask task, Set<String> nodes, boolean executedLocally) {
        Object result;
        Object localResult;
        if (executedLocally) {
            try {
                localResult = OScenarioThreadLocal.executeAsDistributed(new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.command(iCommand);
                    }
                });
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw OException.wrapException(new ODistributedException("Cannot execute command " + iCommand), e);
            }
            nodes.remove(localNodeName);
        } else {
            localResult = null;
        }
        if (!nodes.isEmpty()) {
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), nodes.toString(), ODistributedServerLog.DIRECTION.OUT, "Sending command '%s' database '%s'", iCommand, this.wrapped.getName());
            }
            ODistributedResponse dResponse = this.dManager.sendRequest(this.getName(), involvedClusters, nodes, task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, localResult, null, null);
            result = dResponse.getPayload();
            if (executedLocally && result instanceof Throwable) {
                this.undoCommandOnLocalServer(iCommand);
            }
        } else {
            result = localResult;
        }
        return result;
    }

    protected void undoCommandOnLocalServer(final OCommandRequestText iCommand) {
        OScenarioThreadLocal.executeAsDistributed(new Callable(){

            public Object call() throws Exception {
                OCommandExecutor executor = OCommandManager.instance().getExecutor(iCommand);
                executor.setContext(iCommand.getContext());
                executor.setProgressListener(iCommand.getProgressListener());
                executor.parse(iCommand);
                String undoCommand = ((OCommandDistributedReplicateRequest)((Object)executor)).getUndoCommand();
                if (undoCommand != null) {
                    ODistributedStorage.this.wrapped.command(new OCommandSQL(undoCommand));
                }
                return null;
            }
        });
    }

    protected Map<String, Object> executeOnServers(OCommandRequestText iCommand, OCommandExecutor exec, Collection<String> involvedClusters, Map<String, Collection<String>> nodeClusterMap) {
        HashMap<String, Object> results = new HashMap<String, Object>(nodeClusterMap.size());
        ArrayList<String> nodes = new ArrayList<String>(1);
        for (Map.Entry<String, Collection<String>> c : nodeClusterMap.entrySet()) {
            String nodeName = c.getKey();
            if (!this.dManager.isNodeAvailable(nodeName, this.getName())) {
                ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), nodeName, ODistributedServerLog.DIRECTION.OUT, "Node '%s' is involved in the command '%s' against database '%s', but the node is not active. Excluding it", nodeName, iCommand, this.wrapped.getName());
                continue;
            }
            OAbstractCommandTask task = iCommand instanceof OCommandScript ? new OScriptTask(iCommand) : new OSQLCommandTask(iCommand, c.getValue());
            task.setResultStrategy(ORemoteTask.RESULT_STRATEGY.ANY);
            nodes.clear();
            nodes.add(nodeName);
            try {
                ODistributedResponse response = this.dManager.sendRequest(this.getName(), involvedClusters, nodes, task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                if (response == null || response.getPayload() instanceof ODistributedOperationException) continue;
                results.put(nodeName, response.getPayload());
            }
            catch (Exception e) {
                ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), nodeName, ODistributedServerLog.DIRECTION.OUT, "Error on execution of command '%s' against server '%s', database '%s'", iCommand, nodeName, this.wrapped.getName());
            }
        }
        if (results.isEmpty()) {
            throw new ODistributedException("No active nodes found to execute command: " + iCommand);
        }
        return results;
    }

    protected Object mergeResultByAggregation(OCommandExecutorSQLSelect select, Map<String, Object> iResults) {
        ArrayList<ODocument> list = null;
        ODocument doc = null;
        boolean hasNonAggregates = false;
        Map<String, Object> proj = select.getProjections();
        for (Map.Entry<String, Object> p : proj.entrySet()) {
            if (p.getValue() instanceof OSQLFunctionRuntime) continue;
            hasNonAggregates = true;
            break;
        }
        if (hasNonAggregates) {
            for (Map.Entry<String, Object> entry : iResults.entrySet()) {
                List resultSet = (List)entry.getValue();
                if (resultSet == null) continue;
                if (list == null) {
                    list = new ArrayList<ODocument>();
                    doc = new ODocument();
                    list.add(doc);
                }
                for (Object r : resultSet) {
                    if (!(r instanceof ODocument)) continue;
                    ODocument d = (ODocument)r;
                    for (Map.Entry<String, Object> p : proj.entrySet()) {
                        if (p.getValue() instanceof OSQLFunctionRuntime) continue;
                        doc.field(p.getKey(), d.field(p.getKey()));
                    }
                }
            }
        }
        ArrayList<Object> toMerge = new ArrayList<Object>();
        for (Map.Entry<String, Object> p : proj.entrySet()) {
            if (!(p.getValue() instanceof OSQLFunctionRuntime)) continue;
            OSQLFunctionRuntime f = (OSQLFunctionRuntime)p.getValue();
            toMerge.clear();
            for (Map.Entry<String, Object> entry : iResults.entrySet()) {
                List resultSet = (List)entry.getValue();
                if (resultSet == null) continue;
                if (list == null) {
                    list = new ArrayList();
                    doc = new ODocument();
                    list.add(doc);
                }
                for (Object r : resultSet) {
                    if (!(r instanceof ODocument)) continue;
                    ODocument d = (ODocument)r;
                    toMerge.add(d.rawField(p.getKey()));
                }
            }
            if (doc == null) continue;
            doc.field(p.getKey(), f.getFunction().mergeDistributedResult(toMerge));
        }
        return list;
    }

    protected boolean executeOnlyLocally(String localNodeName, ODistributedConfiguration dbCfg, OCommandExecutor exec, Collection<String> involvedClusters, Collection<String> nodes) {
        boolean executeLocally = false;
        if (exec.isIdempotent()) {
            int maxReadQuorum;
            int availableNodes = nodes.size();
            if (involvedClusters.isEmpty()) {
                maxReadQuorum = dbCfg.getReadQuorum(null, availableNodes, localNodeName);
            } else {
                maxReadQuorum = 0;
                for (String cl : involvedClusters) {
                    maxReadQuorum = Math.max(maxReadQuorum, dbCfg.getReadQuorum(cl, availableNodes, localNodeName));
                }
            }
            if (nodes.contains(localNodeName) && maxReadQuorum <= 1) {
                executeLocally = true;
            }
        }
        return executeLocally;
    }

    @Override
    public OStorageOperationResult<OPhysicalPosition> createRecord(final ORecordId iRecordId, final byte[] iContent, final int iRecordVersion, final byte iRecordType, final int iMode, final ORecordCallback<Long> iCallback) {
        this.resetLastValidBackup();
        if (this.isLocalEnv()) {
            return this.wrapped.createRecord(iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
        }
        String localNodeName = this.dManager.getLocalNodeName();
        ODistributedConfiguration dbCfg = this.distributedConfiguration;
        int clusterId = iRecordId.getClusterId();
        if (clusterId == -1) {
            throw new IllegalArgumentException("Cluster not valid");
        }
        this.checkNodeIsMaster(localNodeName, dbCfg, "Create record " + iRecordId);
        String clusterName = this.getClusterNameByRID(iRecordId);
        this.checkWriteQuorum(dbCfg, clusterName, localNodeName);
        try {
            ODocument documentForClusterSelection = (ODocument)iRecordId.getRecord();
            if (documentForClusterSelection == null) {
                documentForClusterSelection = (ODocument)ORecordInternal.fill(new ODocument(), iRecordId, iRecordVersion, iContent, false);
            }
            this.checkForCluster(documentForClusterSelection, localNodeName, dbCfg);
            final List<String> servers = dbCfg.getServers(clusterName, null);
            if (servers.isEmpty()) {
                return this.wrapped.createRecord(iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
            }
            final String finalClusterName = clusterName;
            final Set<String> clusterNames = Collections.singleton(finalClusterName);
            servers.remove(localNodeName);
            Boolean executionModeSynch = dbCfg.isExecutionModeSynchronous(finalClusterName);
            if (executionModeSynch == null) {
                executionModeSynch = iMode == 0;
            }
            final boolean syncMode = executionModeSynch;
            return (OStorageOperationResult)this.executeRecordOperationInLock(syncMode, iRecordId, new OCallable<Object, OCallable<Void, ODistributedRequestId>>(){

                @Override
                public Object call(OCallable<Void, ODistributedRequestId> unlockCallback) {
                    OStorageOperationResult<OPhysicalPosition> localResult;
                    block9: {
                        localResult = ODistributedStorage.this.wrapped.createRecord(iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
                        iRecordId.setClusterPosition(localResult.getResult().clusterPosition);
                        OPlaceholder localPlaceholder = new OPlaceholder(iRecordId, localResult.getResult().recordVersion);
                        if (!servers.isEmpty()) {
                            OCreateRecordTask task = (OCreateRecordTask)ODistributedStorage.this.dManager.getTaskFactoryManager().getFactoryByServerNames(servers).createTask(0);
                            task.init(iRecordId, iContent, iRecordVersion, iRecordType);
                            task.setLastLSN(ODistributedStorage.this.wrapped.getLSN());
                            if (syncMode) {
                                try {
                                    ODistributedResponse dResponse = ODistributedStorage.this.dManager.sendRequest(ODistributedStorage.this.getName(), clusterNames, servers, task, ODistributedStorage.this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, localPlaceholder, unlockCallback, null);
                                    Object payload = dResponse.getPayload();
                                    if (payload != null) {
                                        if (payload instanceof Exception) {
                                            ODistributedStorage.this.executeUndoOnLocalServer(dResponse.getRequestId(), task);
                                            if (payload instanceof ONeedRetryException) {
                                                throw (ONeedRetryException)payload;
                                            }
                                            throw OException.wrapException(new ODistributedException("Error on execution distributed create record"), (Exception)payload);
                                        }
                                        OPlaceholder masterPlaceholder = (OPlaceholder)payload;
                                        iRecordId.copyFrom(masterPlaceholder.getIdentity());
                                        return new OStorageOperationResult<OPhysicalPosition>(new OPhysicalPosition(masterPlaceholder.getIdentity().getClusterPosition(), masterPlaceholder.getVersion()));
                                    }
                                    break block9;
                                }
                                catch (RuntimeException e) {
                                    ODistributedStorage.this.executeUndoOnLocalServer(null, task);
                                    throw e;
                                }
                                catch (Exception e) {
                                    ODistributedStorage.this.executeUndoOnLocalServer(null, task);
                                    throw ODatabaseException.wrapException(new ODistributedException("Cannot execute distributed create record"), e);
                                }
                            }
                            ODistributedStorage.this.asynchronousExecution(new OAsynchDistributedOperation(ODistributedStorage.this.getName(), Collections.singleton(finalClusterName), servers, task, ODistributedStorage.this.dManager.getNextMessageIdCounter(), localPlaceholder, unlockCallback, null));
                        } else {
                            unlockCallback.call(null);
                        }
                    }
                    return localResult;
                }
            });
        }
        catch (ODistributedRecordLockedException e) {
            throw e;
        }
        catch (ONeedRetryException e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord(iRecordId);
            ORecordId lockEntireCluster = iRecordId.copy();
            lockEntireCluster.setClusterPosition(-1L);
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord(lockEntireCluster);
            throw e;
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException(new OOfflineNodeException("Hazelcast instance is not available"), e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException(new OOfflineNodeException("Hazelcast instance is not available"), e);
        }
        catch (Exception e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord(iRecordId);
            ORecordId lockEntireCluster = iRecordId.copy();
            lockEntireCluster.setClusterPosition(-1L);
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord(lockEntireCluster);
            this.handleDistributedException("Cannot route create record operation for %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    @Override
    public boolean isLocalEnv() {
        return this.localDistributedDatabase == null || this.dManager == null || this.distributedConfiguration == null || OScenarioThreadLocal.INSTANCE.isRunModeDistributed();
    }

    @Override
    public OStorageOperationResult<ORawBuffer> readRecord(final ORecordId iRecordId, final String iFetchPlan, final boolean iIgnoreCache, final boolean prefetchRecords, final ORecordCallback<ORawBuffer> iCallback) {
        if (this.isLocalEnv()) {
            return this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, prefetchRecords, iCallback);
        }
        ORawBuffer memCopy = this.localDistributedDatabase.getRecordIfLocked(iRecordId);
        if (memCopy != null) {
            return new OStorageOperationResult<ORawBuffer>(memCopy);
        }
        try {
            Object dResult;
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dbCfg = this.distributedConfiguration;
            List<String> nodes = dbCfg.getServers(clusterName, null);
            int availableNodes = nodes.size();
            String localNodeName = this.dManager.getLocalNodeName();
            if (nodes.isEmpty() || nodes.contains(this.dManager.getLocalNodeName()) && dbCfg.getReadQuorum(clusterName, availableNodes, localNodeName) <= 1) {
                return (OStorageOperationResult)OScenarioThreadLocal.executeAsDistributed(new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, prefetchRecords, iCallback);
                    }
                });
            }
            OReadRecordTask task = ((OReadRecordTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(nodes).createTask(1)).init(iRecordId);
            ODistributedResponse response = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), nodes, task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
            Object object = dResult = response != null ? response.getPayload() : null;
            if (dResult instanceof ONeedRetryException) {
                throw (ONeedRetryException)dResult;
            }
            if (dResult instanceof Exception) {
                throw OException.wrapException(new ODistributedException("Error on execution distributed read record"), (Exception)dResult);
            }
            return new OStorageOperationResult<ORawBuffer>((ORawBuffer)dResult);
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException(new OOfflineNodeException("Hazelcast instance is not available"), e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException(new OOfflineNodeException("Hazelcast instance is not available"), e);
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route read record operation for %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    @Override
    public OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(final ORecordId rid, final String fetchPlan, final boolean ignoreCache, final int recordVersion) throws ORecordNotFoundException {
        if (this.isLocalEnv()) {
            return this.wrapped.readRecordIfVersionIsNotLatest(rid, fetchPlan, ignoreCache, recordVersion);
        }
        ORawBuffer memCopy = this.localDistributedDatabase.getRecordIfLocked(rid);
        if (memCopy != null) {
            return new OStorageOperationResult<ORawBuffer>(memCopy);
        }
        try {
            String clusterName = this.getClusterNameByRID(rid);
            ODistributedConfiguration dbCfg = this.distributedConfiguration;
            List<String> nodes = dbCfg.getServers(clusterName, null);
            int availableNodes = nodes.size();
            String localNodeName = this.dManager.getLocalNodeName();
            if (nodes.isEmpty() || nodes.contains(this.dManager.getLocalNodeName()) && dbCfg.getReadQuorum(clusterName, availableNodes, localNodeName) <= 1) {
                return (OStorageOperationResult)OScenarioThreadLocal.executeAsDistributed(new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.readRecordIfVersionIsNotLatest(rid, fetchPlan, ignoreCache, recordVersion);
                    }
                });
            }
            OReadRecordIfNotLatestTask task = (OReadRecordIfNotLatestTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(nodes).createTask(2);
            task.init(rid, recordVersion);
            Object result = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), nodes, task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null).getPayload();
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)result;
            }
            if (result instanceof Exception) {
                throw OException.wrapException(new ODistributedException("Error on execution distributed read record"), (Exception)result);
            }
            return new OStorageOperationResult<ORawBuffer>((ORawBuffer)result);
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException(new OOfflineNodeException("Hazelcast instance is not available"), e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException(new OOfflineNodeException("Hazelcast instance is not available"), e);
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route read record operation for %s to the distributed node", e, rid);
            return null;
        }
    }

    @Override
    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRecordId, int iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        return this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
    }

    @Override
    public OSBTreeCollectionManager getSBtreeCollectionManager() {
        return this.wrapped.getSBtreeCollectionManager();
    }

    protected void checkWriteQuorum(ODistributedConfiguration dbCfg, String clusterName, String localNodeName) {
        int availableNodes;
        List<String> clusterServers = dbCfg.getServers(clusterName, null);
        int writeQuorum = dbCfg.getWriteQuorum(clusterName, clusterServers.size(), localNodeName);
        if (writeQuorum > (availableNodes = this.dManager.getAvailableNodes(this.getName()))) {
            throw new ODistributedException("Quorum (" + writeQuorum + ") cannot be reached on server '" + localNodeName + "' because it is major than available nodes (" + availableNodes + ")");
        }
    }

    @Override
    public OStorageOperationResult<Integer> recyclePosition(ORecordId iRecordId, byte[] iContent, int iVersion, byte iRecordType) {
        return this.wrapped.recyclePosition(iRecordId, iContent, iVersion, iRecordType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeRecordOperationInLock(boolean iUnlockAtTheEnd, ORecordId rid, final OCallable<Object, OCallable<Void, ODistributedRequestId>> callback) throws Exception {
        Object object;
        block9: {
            final ORecordId rid2Lock = !rid.isPersistent() ? new ORecordId(rid.getClusterId(), -1L) : rid;
            ODistributedRequestId requestId = null;
            OLogSequenceNumber lastLSN = this.wrapped.getLSN();
            final AtomicBoolean lockReleased = new AtomicBoolean(false);
            try {
                OLogSequenceNumber currentLSN;
                final ODistributedRequestId finalReqId = requestId = this.acquireRecordLock(rid2Lock);
                final OCallable<Void, ODistributedRequestId> unlockCallback = new OCallable<Void, ODistributedRequestId>(){

                    @Override
                    public Void call(ODistributedRequestId requestId) {
                        if (lockReleased.compareAndSet(false, true)) {
                            ODistributedStorage.this.releaseRecordLock(rid2Lock, finalReqId);
                            lockReleased.set(true);
                        }
                        return null;
                    }
                };
                object = OScenarioThreadLocal.executeAsDistributed(new Callable(){

                    public Object call() throws Exception {
                        return callback.call(unlockCallback);
                    }
                });
                if (iUnlockAtTheEnd && lockReleased.compareAndSet(false, true)) {
                    this.releaseRecordLock(rid2Lock, requestId);
                }
                if (lastLSN.equals(currentLSN = this.wrapped.getLSN())) break block9;
            }
            catch (Throwable throwable) {
                OLogSequenceNumber currentLSN;
                if (iUnlockAtTheEnd && lockReleased.compareAndSet(false, true)) {
                    this.releaseRecordLock(rid2Lock, requestId);
                }
                if (!lastLSN.equals(currentLSN = this.wrapped.getLSN())) {
                    try {
                        this.localDistributedDatabase.getSyncConfiguration().setLastLSN(this.getDistributedManager().getLocalNodeName(), ((OLocalPaginatedStorage)this.getUnderlying()).getLSN(), true);
                    }
                    catch (IOException e) {
                        ODistributedServerLog.debug((Object)this, this.dManager != null ? this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.NONE, "Error on updating local LSN configuration for database '%s'", this.wrapped.getName());
                    }
                }
                throw throwable;
            }
            try {
                this.localDistributedDatabase.getSyncConfiguration().setLastLSN(this.getDistributedManager().getLocalNodeName(), ((OLocalPaginatedStorage)this.getUnderlying()).getLSN(), true);
            }
            catch (IOException e) {
                ODistributedServerLog.debug((Object)this, this.dManager != null ? this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.NONE, "Error on updating local LSN configuration for database '%s'", this.wrapped.getName());
            }
        }
        return object;
    }

    public int getConfigurationUpdated() {
        return this.distributedConfiguration.getVersion();
    }

    @Override
    public OStorageOperationResult<Boolean> hideRecord(ORecordId recordId, int mode, ORecordCallback<Boolean> callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        return this.wrapped.getRecordMetadata(rid);
    }

    @Override
    public boolean cleanOutRecord(ORecordId recordId, int recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.wrapped.cleanOutRecord(recordId, recordVersion, iMode, callback);
    }

    @Override
    public boolean existsResource(String iName) {
        return this.wrapped.existsResource(iName);
    }

    @Override
    public OCluster getClusterByName(String iName) {
        return this.wrapped.getClusterByName(iName);
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        return this.getUnderlying().getConflictStrategy();
    }

    @Override
    public void setConflictStrategy(ORecordConflictStrategy iResolver) {
        this.getUnderlying().setConflictStrategy(iResolver);
    }

    @Override
    public <T> T removeResource(String iName) {
        return this.wrapped.removeResource(iName);
    }

    @Override
    public <T> T getResource(String iName, Callable<T> iCallback) {
        return this.wrapped.getResource(iName, iCallback);
    }

    @Override
    public void open(String iUserName, String iUserPassword, OContextConfiguration iProperties) {
        this.wrapped.open(iUserName, iUserPassword, iProperties);
    }

    @Override
    public void create(OContextConfiguration iProperties) throws IOException {
        this.wrapped.create(iProperties);
    }

    @Override
    public boolean exists() {
        return this.wrapped.exists();
    }

    @Override
    public void reload() {
        this.wrapped.reload();
    }

    @Override
    public void delete() {
        if (this.wrapped instanceof OLocalPaginatedStorage) {
            this.dropStorageFiles();
        }
        this.wrapped.delete();
    }

    @Override
    public String incrementalBackup(String backupDirectory, OCallable<Void, Void> started) {
        return this.wrapped.incrementalBackup(backupDirectory, started);
    }

    @Override
    public void restoreFromIncrementalBackup(String filePath) {
        this.wrapped.restoreFromIncrementalBackup(filePath);
    }

    @Override
    public boolean supportIncremental() {
        return this.wrapped.supportIncremental();
    }

    @Override
    public void fullIncrementalBackup(OutputStream stream) throws UnsupportedOperationException {
        this.wrapped.fullIncrementalBackup(stream);
    }

    @Override
    public void restoreFullIncrementalBackup(InputStream stream) throws UnsupportedOperationException {
        this.wrapped.restoreFullIncrementalBackup(stream);
    }

    @Override
    public void close() {
        this.close(false, false);
    }

    @Override
    public void close(boolean iForce, boolean onDelete) {
        if (this.wrapped == null) {
            return;
        }
        if (onDelete && this.wrapped instanceof OLocalPaginatedStorage) {
            this.dropStorageFiles();
        }
        this.wrapped.close(iForce, onDelete);
        if (this.isClosed()) {
            this.shutdownAsynchronousWorker();
        }
    }

    public void closeOnDrop() {
        if (this.wrapped == null) {
            return;
        }
        if (this.wrapped instanceof OLocalPaginatedStorage) {
            this.dropStorageFiles();
        }
        this.serverInstance.getDatabases().forceDatabaseClose(this.getName());
        if (this.isClosed()) {
            this.shutdownAsynchronousWorker();
        }
    }

    @Override
    public boolean isClosed() {
        if (this.wrapped == null) {
            return true;
        }
        return this.wrapped.isClosed();
    }

    @Override
    public List<ORecordOperation> commit(OTransactionInternal iTx) {
        return this.wrapped.commit(iTx);
    }

    protected ODistributedRequestId acquireRecordLock(ORecordId rid) {
        ODistributedRequestId localReqId = new ODistributedRequestId(this.dManager.getLocalNodeId(), this.dManager.getNextMessageIdCounter());
        this.localDistributedDatabase.lockRecord(rid, localReqId, OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong() / 2L);
        if (this.eventListener != null) {
            try {
                this.eventListener.onAfterRecordLock(rid);
            }
            catch (Exception t) {
                ODistributedServerLog.error((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Caught exception during ODistributedStorageEventListener.onAfterRecordLock", t, new Object[0]);
            }
        }
        return localReqId;
    }

    protected void releaseRecordLock(ORecordId rid, ODistributedRequestId requestId) {
        this.localDistributedDatabase.unlockRecord(rid, requestId);
        if (this.eventListener != null) {
            try {
                this.eventListener.onAfterRecordUnlock(rid);
            }
            catch (Exception t) {
                ODistributedServerLog.error((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Caught exception during ODistributedStorageEventListener.onAfterRecordUnlock", t, new Object[0]);
            }
        }
    }

    @Override
    public void rollback(OTransactionInternal iTx) {
        this.wrapped.rollback(iTx);
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.wrapped.getConfiguration();
    }

    @Override
    public int getClusters() {
        return this.wrapped.getClusters();
    }

    @Override
    public Set<String> getClusterNames() {
        return this.wrapped.getClusterNames();
    }

    @Override
    public OCluster getClusterById(int iId) {
        return this.wrapped.getClusterById(iId);
    }

    @Override
    public Collection<? extends OCluster> getClusterInstances() {
        return this.wrapped.getClusterInstances();
    }

    @Override
    public int addCluster(final String iClusterName, final Object ... iParameters) {
        for (int retry = 0; retry < 10; ++retry) {
            final AtomicInteger clId = new AtomicInteger();
            if (!this.isLocalEnv()) {
                final StringBuilder cmd = new StringBuilder("create cluster `");
                cmd.append(iClusterName);
                cmd.append("`");
                Object result = null;
                try {
                    result = this.dManager.executeInDistributedDatabaseLock(this.getName(), 20000L, this.dManager.getDatabaseConfiguration(this.getName()).modify(), new OCallable<Object, OModifiableDistributedConfiguration>(){

                        @Override
                        public Object call(OModifiableDistributedConfiguration iArgument) {
                            clId.set(ODistributedStorage.this.wrapped.addCluster(iClusterName, iParameters));
                            OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                            commandSQL.addExcludedNode(ODistributedStorage.this.getNodeId());
                            return ODistributedStorage.this.command(commandSQL);
                        }
                    });
                }
                catch (Exception e) {
                    this.wrapped.dropCluster(iClusterName, false);
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e2) {}
                    continue;
                }
                if (result != null && ((Integer)result).intValue() != clId.get()) {
                    ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on creating cluster '%s' on distributed nodes: ids are different (local=%d and remote=%d). Local clusters %s. Retrying %d/%d...", iClusterName, clId.get(), (int)((Integer)result), this.getClusterNames(), retry, 10);
                    this.wrapped.dropCluster(clId.get(), false);
                    cmd.setLength(0);
                    cmd.append("drop cluster ");
                    cmd.append(iClusterName);
                    OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                    commandSQL.addExcludedNode(this.getNodeId());
                    this.command(commandSQL);
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.wrapped.reload();
                    continue;
                }
            } else {
                clId.set(this.wrapped.addCluster(iClusterName, iParameters));
            }
            return clId.get();
        }
        throw new ODistributedException("Error on creating cluster '" + iClusterName + "' on distributed nodes: local and remote ids assigned are different");
    }

    @Override
    public int addCluster(final String iClusterName, final int iRequestedId, final Object ... iParameters) {
        this.resetLastValidBackup();
        for (int retry = 0; retry < 10; ++retry) {
            final AtomicInteger clId = new AtomicInteger();
            if (!this.isLocalEnv()) {
                final StringBuilder cmd = new StringBuilder("create cluster `");
                cmd.append(iClusterName);
                cmd.append("`");
                cmd.append(" ID ");
                cmd.append(iRequestedId);
                Object result = null;
                try {
                    result = this.dManager.executeInDistributedDatabaseLock(this.getName(), 20000L, this.dManager.getDatabaseConfiguration(this.getName()).modify(), new OCallable<Object, OModifiableDistributedConfiguration>(){

                        @Override
                        public Object call(OModifiableDistributedConfiguration iArgument) {
                            clId.set(ODistributedStorage.this.wrapped.addCluster(iClusterName, iRequestedId, iParameters));
                            OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                            commandSQL.addExcludedNode(ODistributedStorage.this.getNodeId());
                            return ODistributedStorage.this.command(commandSQL);
                        }
                    });
                }
                catch (Exception e) {
                    this.wrapped.dropCluster(iClusterName, false);
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e2) {}
                    continue;
                }
                if (result != null && ((Integer)result).intValue() != clId.get()) {
                    ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on creating cluster '%s' on distributed nodes: ids are different (local=%d and remote=%d). Local clusters %s. Retrying %d/%d...", iClusterName, clId.get(), (int)((Integer)result), this.getClusterNames(), retry, 10);
                    this.wrapped.dropCluster(clId.get(), false);
                    cmd.setLength(0);
                    cmd.append("drop cluster ");
                    cmd.append(iClusterName);
                    OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                    commandSQL.addExcludedNode(this.getNodeId());
                    this.command(commandSQL);
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.wrapped.reload();
                    continue;
                }
            } else {
                clId.set(this.wrapped.addCluster(iClusterName, iRequestedId, iParameters));
            }
            return clId.get();
        }
        throw new ODistributedException("Error on creating cluster '" + iClusterName + "' on distributed nodes: local and remote ids assigned are different");
    }

    @Override
    public boolean dropCluster(final String iClusterName, final boolean iTruncate) {
        this.resetLastValidBackup();
        final AtomicBoolean clId = new AtomicBoolean();
        if (!this.isLocalEnv()) {
            final StringBuilder cmd = new StringBuilder();
            if (iTruncate) {
                cmd.append("truncate cluster `");
            } else {
                cmd.append("create cluster `");
            }
            cmd.append(iClusterName);
            cmd.append("`");
            this.dManager.executeInDistributedDatabaseLock(this.getName(), 20000L, this.dManager.getDatabaseConfiguration(this.getName()).modify(), new OCallable<Object, OModifiableDistributedConfiguration>(){

                @Override
                public Object call(OModifiableDistributedConfiguration iArgument) {
                    clId.set(ODistributedStorage.this.wrapped.dropCluster(iClusterName, iTruncate));
                    OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                    commandSQL.addExcludedNode(ODistributedStorage.this.getNodeId());
                    return ODistributedStorage.this.command(commandSQL);
                }
            });
            return clId.get();
        }
        return this.wrapped.dropCluster(iClusterName, iTruncate);
    }

    @Override
    public boolean dropCluster(int iId, boolean iTruncate) {
        this.resetLastValidBackup();
        return this.wrapped.dropCluster(iId, iTruncate);
    }

    @Override
    public long count(int iClusterId) {
        return this.wrapped.count(iClusterId);
    }

    @Override
    public long count(int iClusterId, boolean countTombstones) {
        return this.wrapped.count(iClusterId, countTombstones);
    }

    @Override
    public long count(int[] iClusterIds) {
        return this.wrapped.count(iClusterIds);
    }

    @Override
    public long count(int[] iClusterIds, boolean countTombstones) {
        return this.wrapped.count(iClusterIds, countTombstones);
    }

    @Override
    public long getSize() {
        return this.wrapped.getSize();
    }

    @Override
    public long countRecords() {
        return this.wrapped.countRecords();
    }

    @Override
    public int getDefaultClusterId() {
        return this.wrapped.getDefaultClusterId();
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        this.wrapped.setDefaultClusterId(defaultClusterId);
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        return this.wrapped.getClusterIdByName(iClusterName);
    }

    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        return this.wrapped.getPhysicalClusterNameById(iClusterId);
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return this.wrapped.checkForRecordValidity(ppos);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.wrapped.getURL();
    }

    @Override
    public long getVersion() {
        return this.wrapped.getVersion();
    }

    @Override
    public void synch() {
        this.wrapped.synch();
    }

    @Override
    public long[] getClusterDataRange(int currentClusterId) {
        return this.wrapped.getClusterDataRange(currentClusterId);
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return this.wrapped.callInLock(iCallable, iExclusiveLock);
    }

    @Override
    public OStorage.STATUS getStatus() {
        return this.wrapped.getStatus();
    }

    public ODistributedStorageEventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(ODistributedStorageEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.higherPhysicalPositions(currentClusterId, entry);
    }

    public OServer getServer() {
        return this.serverInstance;
    }

    public ODistributedServerManager getDistributedManager() {
        return this.dManager;
    }

    public ODistributedConfiguration getDistributedConfiguration() {
        if (this.distributedConfiguration == null) {
            Map<String, Object> map = this.dManager.getConfigurationMap();
            if (map == null) {
                return null;
            }
            ODocument doc = (ODocument)map.get("database." + this.getName());
            if (doc != null) {
                ODistributedServerLog.info((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Downloaded configuration for database '%s' from the cluster", this.getName());
                this.setDistributedConfiguration(new OModifiableDistributedConfiguration(doc));
            } else {
                doc = this.loadDatabaseConfiguration(this.getDistributedConfigFile());
                if (doc == null) {
                    doc = this.loadDatabaseConfiguration(this.dManager.getDefaultDatabaseConfigFile());
                    if (doc == null) {
                        throw new OConfigurationException("Cannot load default distributed for database '" + this.getName() + "' config file: " + this.dManager.getDefaultDatabaseConfigFile());
                    }
                    this.setDistributedConfiguration(new OModifiableDistributedConfiguration(doc));
                } else {
                    this.distributedConfiguration = new ODistributedConfiguration(doc);
                }
                this.dManager.updateCachedDatabaseConfiguration(this.getName(), new OModifiableDistributedConfiguration(doc), true);
            }
        }
        return this.distributedConfiguration;
    }

    public void setDistributedConfiguration(OModifiableDistributedConfiguration distributedConfiguration) {
        if (this.distributedConfiguration == null || distributedConfiguration.getVersion() > this.distributedConfiguration.getVersion()) {
            this.distributedConfiguration = new ODistributedConfiguration(distributedConfiguration.getDocument().copy());
            String cfgOutput = ODistributedOutput.formatClusterTable(this.dManager, this.getName(), distributedConfiguration, this.dManager.getTotalNodes(this.getName()));
            ODistributedServerLog.info((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Setting new distributed configuration for database: %s (version=%d)%s\n", this.getName(), distributedConfiguration.getVersion(), cfgOutput);
            this.saveDatabaseConfiguration();
        }
    }

    @Override
    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.ceilingPhysicalPositions(clusterId, physicalPosition);
    }

    @Override
    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.floorPhysicalPositions(clusterId, physicalPosition);
    }

    @Override
    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.lowerPhysicalPositions(currentClusterId, entry);
    }

    @Override
    public OStorage getUnderlying() {
        return this.wrapped;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public OCurrentStorageComponentsFactory getComponentsFactory() {
        return this.wrapped.getComponentsFactory();
    }

    @Override
    public String getType() {
        return "distributed";
    }

    @Override
    public void freeze(boolean throwException) {
        String localNode = this.dManager.getLocalNodeName();
        this.prevStatus = this.dManager.getDatabaseStatus(localNode, this.getName());
        if (this.prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
            this.dManager.setDatabaseStatus(localNode, this.getName(), ODistributedServerManager.DB_STATUS.BACKUP);
        }
        this.getFreezableStorage().freeze(throwException);
    }

    @Override
    public boolean isFrozen() {
        return this.getFreezableStorage().isFrozen();
    }

    @Override
    public void release() {
        if (this.prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
            this.getLocalDistributedDatabase().setOnline();
        }
        this.getFreezableStorage().release();
    }

    @Override
    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        String localNode = this.dManager.getLocalNodeName();
        ODistributedServerManager.DB_STATUS prevStatus = this.dManager.getDatabaseStatus(localNode, this.getName());
        if (prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
            this.dManager.setDatabaseStatus(localNode, this.getName(), ODistributedServerManager.DB_STATUS.BACKUP);
        }
        try {
            List<String> list = this.wrapped.backup(out, options, callable, iListener, compressionLevel, bufferSize);
            return list;
        }
        catch (IOException e) {
            throw OException.wrapException(new OIOException("Error on executing backup"), e);
        }
        finally {
            if (prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
                this.dManager.getMessageService().getDatabase(this.getName()).setOnline();
            }
        }
    }

    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        this.wrapped.restore(in, options, callable, iListener);
    }

    public String getClusterNameByRID(ORecordId iRid) {
        OCluster cluster = this.getClusterById(iRid.getClusterId());
        return cluster != null ? cluster.getName() : "*";
    }

    @Override
    public String getStorageId() {
        return this.dManager.getLocalNodeName() + "." + this.getName();
    }

    @Override
    public String getNodeId() {
        return this.dManager != null ? this.dManager.getLocalNodeName() : "?";
    }

    @Override
    public void shutdown() {
        this.close(true, false);
    }

    public void shutdownAsynchronousWorker() {
        this.running = false;
        if (this.asynchWorker != null) {
            this.asynchWorker.interrupt();
            try {
                this.asynchWorker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.asynchronousOperationsQueue != null) {
            this.asynchronousOperationsQueue.clear();
        }
    }

    protected void checkNodeIsMaster(String localNodeName, ODistributedConfiguration dbCfg, String operation) {
        ODistributedConfiguration.ROLES nodeRole = dbCfg.getServerRole(localNodeName);
        if (nodeRole != ODistributedConfiguration.ROLES.MASTER) {
            throw new OWriteOperationNotPermittedException("Cannot execute write operation (" + operation + ") on node '" + localNodeName + "' because is non a master");
        }
    }

    public OSyncSource getLastValidBackup() {
        return this.lastValidBackup;
    }

    public void setLastValidBackup(OSyncSource lastValidBackup) {
        this.lastValidBackup = lastValidBackup;
    }

    protected void asynchronousExecution(OAsynchDistributedOperation iOperation) {
        this.asynchronousOperationsQueue.offer(iOperation);
    }

    protected OAsyncReplicationError getAsyncReplicationError() {
        if (((OExecutionThreadLocal.OExecutionThreadData)OExecutionThreadLocal.INSTANCE.get()).onAsyncReplicationError != null) {
            final OAsyncReplicationError subCallback = ((OExecutionThreadLocal.OExecutionThreadData)OExecutionThreadLocal.INSTANCE.get()).onAsyncReplicationError;
            ODatabaseDocumentInternal currentDatabase = ODatabaseRecordThreadLocal.instance().get();
            final ODatabaseDocumentInternal copyDatabase = currentDatabase.copy();
            currentDatabase.activateOnCurrentThread();
            return new OAsyncReplicationError(){

                @Override
                public OAsyncReplicationError.ACTION onAsyncReplicationError(Throwable iException, int iRetry) {
                    copyDatabase.activateOnCurrentThread();
                    switch (subCallback.onAsyncReplicationError(iException, iRetry)) {
                        case RETRY: {
                            break;
                        }
                    }
                    return OAsyncReplicationError.ACTION.IGNORE;
                }
            };
        }
        return null;
    }

    protected void handleDistributedException(String iMessage, Exception e, Object ... iParams) {
        if (e != null) {
            if (e instanceof OException) {
                throw (OException)e;
            }
            if (e.getCause() instanceof OException) {
                throw (OException)e.getCause();
            }
            if (e.getCause() != null && e.getCause().getCause() instanceof OException) {
                throw (OException)e.getCause().getCause();
            }
        }
        OLogManager.instance().error(this, iMessage, e, iParams);
        throw OException.wrapException(new OStorageException(String.format(iMessage, iParams)), e);
    }

    private OFreezableStorageComponent getFreezableStorage() {
        if (this.wrapped instanceof OFreezableStorageComponent) {
            return this.wrapped;
        }
        throw new UnsupportedOperationException("Storage engine " + this.wrapped.getType() + " does not support freeze operation");
    }

    public void resetLastValidBackup() {
        if (this.lastValidBackup != null) {
            this.lastValidBackup.invalidate();
        }
    }

    public void clearLastValidBackup() {
        if (this.lastValidBackup != null) {
            this.lastValidBackup = null;
        }
    }

    void executeUndoOnLocalServer(final ODistributedRequestId reqId, OAbstractReplicatedTask task) {
        final ORemoteTask undoTask = task.getUndoTask(this.dManager, reqId, OMultiValue.getSingletonList(this.dManager.getLocalNodeName()));
        if (undoTask != null) {
            ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Undo operation on local server (reqId=%s task=%s)", reqId, undoTask);
            OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    boolean databaseAlreadyDefined;
                    ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().getIfDefined();
                    if (database == null) {
                        databaseAlreadyDefined = false;
                        database = ODistributedStorage.this.serverInstance.openDatabase(ODistributedStorage.this.getName());
                    } else {
                        databaseAlreadyDefined = true;
                    }
                    try {
                        undoTask.execute(reqId, ODistributedStorage.this.dManager.getServerInstance(), ODistributedStorage.this.dManager, database);
                    }
                    catch (Exception e) {
                        ODistributedServerLog.error((Object)this, ODistributedStorage.this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on undo operation on local node (reqId=%s)", e, reqId);
                    }
                    finally {
                        if (!databaseAlreadyDefined) {
                            database.close();
                        }
                    }
                    return null;
                }
            });
        }
    }

    protected void dropStorageFiles() {
        ODistributedStorage.dropStorageFiles(this.wrapped);
    }

    public static void dropStorageFiles(OAbstractPaginatedStorage wrapped) {
        File dCfg = new File(((OLocalPaginatedStorage)wrapped).getStoragePath() + "/" + "distributed-config.json");
        try {
            File dCfg2;
            if (dCfg.exists()) {
                for (int i = 0; i < 10 && !dCfg.delete(); ++i) {
                    Thread.sleep(100L);
                }
            }
            if ((dCfg2 = new File(((OLocalPaginatedStorage)wrapped).getStoragePath() + "/" + "distributed-sync.json")).exists()) {
                for (int i = 0; i < 10 && !dCfg2.delete(); ++i) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String checkForCluster(ORecord record, String localNodeName, ODistributedConfiguration dbCfg) {
        if (!(record instanceof ODocument)) {
            return null;
        }
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid.getClusterId() < 0) {
            throw new IllegalArgumentException("RID " + rid + " is not valid");
        }
        String clusterName = this.getClusterNameByRID(rid);
        String ownerServer = dbCfg.getClusterOwner(clusterName);
        if (ownerServer.equals(localNodeName)) {
            return null;
        }
        OCluster cl = this.getClusterByName(clusterName);
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        OClass cls = db.getMetadata().getSchema().getClassByClusterId(cl.getId());
        String newClusterName = null;
        if (cls != null) {
            ODocument doc;
            String ownerUUID;
            if (!(cls instanceof OClassDistributed)) {
                throw new ODistributedException("Cannot install local cluster strategy on class '" + cls.getName() + "'");
            }
            dbCfg = ((OClassDistributed)cls).readConfiguration((ODatabaseDocumentDistributed)db, this.getDistributedManager());
            String newOwnerNode = dbCfg.getClusterOwner(clusterName);
            if (newOwnerNode.equals(localNodeName)) {
                return null;
            }
            if (!this.isLocalEnv() && this.dManager.isNodeAvailable(ownerServer, this.getName()) && (ownerUUID = this.dManager.getNodeUuidByName(ownerServer)) != null && (doc = this.dManager.getNodeConfigurationByUuid(ownerUUID, true)) != null) {
                String ownerServerIPAddress = ODistributedAbstractPlugin.getListeningBinaryAddress(doc);
                OLogManager.instance().debug((Object)this, "Local node '" + localNodeName + "' is not the owner for cluster '" + clusterName + "' (it is '" + ownerServer + "'). Sending a redirect to the client to connect it directly to the owner server", new Object[0]);
                throw new ODistributedRedirectException(this.getDistributedManager().getLocalNodeName(), ownerServer, ownerServerIPAddress, "Local node '" + localNodeName + "' is not the owner for cluster '" + clusterName + "' (it is '" + ownerServer + "')");
            }
            throw new ODistributedConfigurationChangedException("Local node '" + localNodeName + "' is not the owner for cluster '" + clusterName + "' (it is '" + ownerServer + "')");
        }
        if (!ownerServer.equals(localNodeName)) {
            throw new ODistributedException("Error on inserting into cluster '" + clusterName + "' where local node '" + localNodeName + "' is not the master of it, but it is '" + ownerServer + "'");
        }
        clusterName = newClusterName;
        ORecordId oldRID = rid.copy();
        rid.setClusterId(db.getClusterIdByName(newClusterName));
        OLogManager.instance().info((Object)this, "Reassigned local cluster '%s' to the record %s. New RID is %s", newClusterName, oldRID, rid);
        return clusterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument loadDatabaseConfiguration(File file) {
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        ODistributedServerLog.info((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Loaded configuration for database '%s' from disk: %s", this.getName(), file);
        FileInputStream f = null;
        try {
            f = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            f.read(buffer);
            ODocument doc = new ODocument().fromJSON(new String(buffer), "noMap");
            doc.field("version", 1);
            ODocument oDocument = doc;
            return oDocument;
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on loading distributed configuration file in: %s", e, file.getAbsolutePath());
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected void saveDatabaseConfiguration() {
        FileOutputStream f = null;
        try {
            File file = this.getDistributedConfigFile();
            ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Saving distributed configuration file for database '%s' to: %s", this.getName(), file);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            f = new FileOutputStream(file);
            f.write(this.distributedConfiguration.getDocument().toJSON().getBytes());
            f.flush();
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on saving distributed configuration file", e, new Object[0]);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected File getDistributedConfigFile() {
        return new File(this.serverInstance.getDatabaseDirectory() + this.getName() + "/" + "distributed-config.json");
    }

    public ODistributedDatabase getLocalDistributedDatabase() {
        return this.localDistributedDatabase;
    }

    @Override
    public void setSchemaRecordId(String schemaRecordId) {
        this.wrapped.setSchemaRecordId(schemaRecordId);
    }

    @Override
    public void setDateFormat(String dateFormat) {
        this.wrapped.setDateFormat(dateFormat);
    }

    @Override
    public void setTimeZone(TimeZone timeZoneValue) {
        this.wrapped.setTimeZone(timeZoneValue);
    }

    @Override
    public void setLocaleLanguage(String locale) {
        this.wrapped.setLocaleLanguage(locale);
    }

    @Override
    public void setCharset(String charset) {
        this.wrapped.setCharset(charset);
    }

    @Override
    public void setIndexMgrRecordId(String indexMgrRecordId) {
        this.wrapped.setIndexMgrRecordId(indexMgrRecordId);
    }

    @Override
    public void setDateTimeFormat(String dateTimeFormat) {
        this.wrapped.setDateTimeFormat(dateTimeFormat);
    }

    @Override
    public void setLocaleCountry(String localeCountry) {
        this.wrapped.setLocaleCountry(localeCountry);
    }

    @Override
    public void setClusterSelection(String clusterSelection) {
        this.wrapped.setClusterSelection(clusterSelection);
    }

    @Override
    public void setMinimumClusters(int minimumClusters) {
        this.wrapped.setMinimumClusters(minimumClusters);
    }

    @Override
    public void setValidation(boolean validation) {
        this.wrapped.setValidation(validation);
    }

    @Override
    public void removeProperty(String property) {
        this.wrapped.removeProperty(property);
    }

    @Override
    public void setProperty(String property, String value) {
        this.wrapped.setProperty(property, value);
    }

    @Override
    public void setRecordSerializer(String recordSerializer, int version) {
        this.wrapped.setRecordSerializer(recordSerializer, version);
    }

    @Override
    public void clearProperties() {
        this.wrapped.clearProperties();
    }
}

