/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.metadata;

import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.schema.OClassEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.metadata.OPropertyDistributed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class OClassDistributed
extends OClassEmbedded {
    private volatile int[] bestClusterIds;
    private volatile int lastVersion;

    protected OClassDistributed(OSchemaShared iOwner, String iName) {
        super(iOwner, iName);
    }

    public OClassDistributed(OSchemaShared iOwner, String iName, int[] iClusterIds) {
        super(iOwner, iName, iClusterIds);
    }

    public OClassDistributed(OSchemaShared iOwner, ODocument iDocument, String iName) {
        super(iOwner, iDocument, iName);
    }

    @Override
    protected OPropertyImpl createPropertyInstance(ODocument p) {
        return new OPropertyDistributed((OClassImpl)this, p);
    }

    @Override
    protected OPropertyEmbedded createPropertyInstance(OGlobalProperty global) {
        return new OPropertyDistributed((OClassImpl)this, global);
    }

    @Override
    public int getClusterForNewInstance(ODocument doc) {
        return this.getClusterForNewInstance((ODatabaseDocumentDistributed)this.getDatabase(), doc);
    }

    public int getClusterForNewInstance(ODatabaseDocumentDistributed db, ODocument doc) {
        OStorage storage = db.getStorage();
        if (!(storage instanceof ODistributedStorage)) {
            throw new IllegalStateException("Storage is not distributed");
        }
        ODistributedServerManager manager = ((ODistributedStorage)storage).getDistributedManager();
        if (this.bestClusterIds == null) {
            this.readConfiguration(db, manager);
        } else if (this.lastVersion != ((ODistributedStorage)storage).getConfigurationUpdated()) {
            this.readConfiguration(db, manager);
            ODistributedServerLog.info((Object)this, manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "New cluster list for class '%s': %s (dCfgVersion=%d)", this.getName(), Arrays.toString(this.bestClusterIds), this.lastVersion);
        }
        int size = this.bestClusterIds.length;
        if (size == 0) {
            return -1;
        }
        if (size == 1) {
            return this.bestClusterIds[0];
        }
        int cluster = super.getClusterSelection().getCluster(this, this.bestClusterIds, doc);
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Selected cluster %d for class '%s' from %s (threadId=%d dCfgVersion=%d)", cluster, this.getName(), Arrays.toString(this.bestClusterIds), Thread.currentThread().getId(), this.lastVersion);
        }
        return cluster;
    }

    public ODistributedConfiguration readConfiguration(ODatabaseDocumentDistributed db, ODistributedServerManager manager) {
        if (this.isAbstract()) {
            throw new IllegalArgumentException("Cannot create a new instance of abstract class");
        }
        int[] clusterIds = this.getClusterIds();
        ArrayList<String> clusterNames = new ArrayList<String>(clusterIds.length);
        for (int c : clusterIds) {
            clusterNames.add(db.getClusterNameById(c).toLowerCase(Locale.ENGLISH));
        }
        ODistributedConfiguration cfg = manager.getDatabaseConfiguration(db.getName());
        List<String> bestClusters = cfg.getOwnedClustersByServer(clusterNames, manager.getLocalNodeName());
        if (bestClusters.isEmpty()) {
            OModifiableDistributedConfiguration modifiableCfg = cfg.modify();
            manager.reassignClustersOwnership(manager.getLocalNodeName(), db.getName(), modifiableCfg, true);
            cfg = modifiableCfg;
            db.activateOnCurrentThread();
            clusterNames.clear();
            for (int c : clusterIds = this.getClusterIds()) {
                clusterNames.add(db.getClusterNameById(c).toLowerCase(Locale.ENGLISH));
            }
            bestClusters = cfg.getOwnedClustersByServer(clusterNames, manager.getLocalNodeName());
            if (bestClusters.isEmpty()) {
                StringBuilder buffer = new StringBuilder();
                for (String c : clusterNames) {
                    if (buffer.length() > 0) {
                        buffer.append(" ");
                    }
                    buffer.append(" ");
                    buffer.append(c);
                    buffer.append(":");
                    buffer.append(cfg.getServers(c, null));
                }
                ODistributedServerLog.warn((Object)this, manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Cannot find best cluster for class '%s'. Configured servers for clusters %s are %s (dCfgVersion=%d)", this.getName(), clusterNames, buffer.toString(), cfg.getVersion());
                throw new ODatabaseException("Cannot find best cluster for class '" + this.getName() + "' on server '" + manager.getLocalNodeName() + "' (clusterStrategy=" + this.getName() + " dCfgVersion=" + cfg.getVersion() + ")");
            }
        }
        db.activateOnCurrentThread();
        int[] newBestClusters = new int[bestClusters.size()];
        int i = 0;
        for (String c : bestClusters) {
            newBestClusters[i++] = db.getClusterIdByName(c);
        }
        this.bestClusterIds = newBestClusters;
        ODistributedStorage storage = db.getStorageDistributed();
        this.lastVersion = storage.getConfigurationUpdated();
        return cfg;
    }
}

