/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OCopyDatabaseChunkTask
extends OAbstractReplicatedTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 15;
    private String fileName;
    private int chunkNum;
    private long offset;
    private boolean compressed;

    public OCopyDatabaseChunkTask() {
    }

    public OCopyDatabaseChunkTask(String iFileName, int iChunkNum, long iOffset, boolean iCompressed) {
        this.fileName = iFileName;
        this.chunkNum = iChunkNum;
        this.offset = iOffset;
        this.compressed = iCompressed;
    }

    @Override
    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedStorage storage = (ODistributedStorage)database.getStorage();
        if (storage == null) {
            throw new ODistributedException("database not available anymore during sync");
        }
        OSyncSource b = storage.getLastValidBackup();
        ODistributedDatabaseChunk result = new ODistributedDatabaseChunk(b, 0x800000, null);
        ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "- transferring chunk #%d offset=%d size=%s...", this.chunkNum, result.offset, OFileUtils.getSizeAsNumber(result.buffer.length));
        if (result.last) {
            iManager.getMessageService().getDatabase(database.getName()).setOnline();
        }
        return result;
    }

    @Override
    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.ANY;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYCHUNK_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public String getName() {
        return "copy_db_chunk";
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.fileName);
        out.writeInt(this.chunkNum);
        out.writeLong(this.offset);
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.fileName = in.readUTF();
        this.chunkNum = in.readInt();
        this.offset = in.readLong();
    }

    @Override
    public boolean isNodeOnlineRequired() {
        return false;
    }

    @Override
    public int getFactoryId() {
        return 15;
    }
}

