/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ORestartServerTask
extends OAbstractRemoteTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 10;

    @Override
    public Object execute(ODistributedRequestId requestId, final OServer iServer, final ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedServerLog.warn((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Restarting server...", new Object[0]);
        iManager.setNodeStatus(ODistributedServerManager.NODE_STATUS.OFFLINE);
        Orient.instance().scheduleTask(new Runnable(){

            @Override
            public void run() {
                try {
                    iServer.restart();
                }
                catch (Exception e) {
                    ODistributedServerLog.error((Object)this, iManager.getLocalNodeName(), ORestartServerTask.this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Error on restarting server", e, new Object[0]);
                }
            }
        }, 1L, 0L);
        return true;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public String getName() {
        return "restart_server";
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
    }

    @Override
    public int getFactoryId() {
        return 10;
    }

    @Override
    public boolean isUsingDatabase() {
        return false;
    }
}

