/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.hazelcast;

import com.orientechnologies.orient.core.db.ODatabaseDocumentEmbeddedPooled;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.OEmbeddedDatabaseInstanceFactory;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributedPooled;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;

class ODistributedEmbeddedDatabaseInstanceFactory
implements OEmbeddedDatabaseInstanceFactory {
    private OHazelcastPlugin plugin;

    public ODistributedEmbeddedDatabaseInstanceFactory(OHazelcastPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public ODatabaseDocumentEmbedded newInstance(OStorage storage) {
        if ("OSystem".equals(storage.getName())) {
            return new ODatabaseDocumentEmbedded(storage);
        }
        this.plugin.registerNewDatabaseIfNeeded(storage.getName(), this.plugin.getDatabaseConfiguration(storage.getName()));
        return new ODatabaseDocumentDistributed(this.plugin.getStorage(storage.getName(), (OAbstractPaginatedStorage)storage), this.plugin);
    }

    @Override
    public ODatabaseDocumentEmbedded newPoolInstance(ODatabasePoolInternal pool, OStorage storage) {
        if ("OSystem".equals(storage.getName())) {
            return new ODatabaseDocumentEmbeddedPooled(pool, storage);
        }
        this.plugin.registerNewDatabaseIfNeeded(storage.getName(), this.plugin.getDatabaseConfiguration(storage.getName()));
        return new ODatabaseDocumentDistributedPooled(pool, this.plugin.getStorage(storage.getName(), (OAbstractPaginatedStorage)storage), this.plugin);
    }
}

