/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.iterator.OLazyWrapperIterator;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Collection;
import java.util.Iterator;

public class OrientVertexIterator
extends OLazyWrapperIterator<Vertex> {
    private final OrientVertex vertex;
    private final String[] iLabels;
    private final OPair<Direction, String> connection;

    public OrientVertexIterator(OrientVertex orientVertex, Object iMultiValue, Iterator<?> iterator, OPair<Direction, String> connection, String[] iLabels, int iSize) {
        super(iterator, iSize, iMultiValue);
        this.vertex = orientVertex;
        this.connection = connection;
        this.iLabels = iLabels;
    }

    @Override
    public Vertex createGraphElement(Object iObject) {
        OClass klass;
        if (iObject instanceof OrientVertex) {
            return (OrientVertex)iObject;
        }
        if (iObject == null) {
            return null;
        }
        Object rec = ((OIdentifiable)iObject).getRecord();
        if (rec == null || !(rec instanceof ODocument)) {
            return null;
        }
        final ODocument value = (ODocument)rec;
        if (ODocumentInternal.getImmutableSchemaClass(value) != null) {
            klass = ODocumentInternal.getImmutableSchemaClass(value);
        } else if (ODatabaseRecordThreadLocal.instance().getIfDefined() != null) {
            ODatabaseRecordThreadLocal.instance().getIfDefined().getMetadata().reload();
            klass = value.getSchemaClass();
        } else {
            throw new IllegalStateException("Invalid content found between connections: " + value);
        }
        return OGraphCommandExecutorSQLFactory.runWithAnyGraph(new OGraphCommandExecutorSQLFactory.GraphCallBack<Vertex>(){

            @Override
            public Vertex call(OrientBaseGraph graph) {
                OrientVertex v;
                if (klass.isVertexType()) {
                    v = graph.getVertex(value);
                } else if (klass.isEdgeType()) {
                    v = ((OrientVertexIterator)OrientVertexIterator.this).vertex.settings.isUseVertexFieldsForEdgeLabels() || OrientEdge.isLabeled(OrientEdge.getRecordLabel(value), OrientVertexIterator.this.iLabels) ? graph.getVertex(OrientEdge.getConnection(value, ((Direction)((Object)OrientVertexIterator.this.connection.getKey())).opposite())) : null;
                } else {
                    throw new IllegalStateException("Invalid content found between connections: " + value);
                }
                return v;
            }
        });
    }

    @Override
    public OIdentifiable getGraphElementRecord(Object iObject) {
        OIdentifiable v;
        Object rec = ((OIdentifiable)iObject).getRecord();
        if (rec == null || !(rec instanceof ODocument)) {
            return null;
        }
        ODocument value = (ODocument)rec;
        OImmutableClass immutableClass = ODocumentInternal.getImmutableSchemaClass(value);
        if (immutableClass.isVertexType()) {
            v = value;
        } else if (immutableClass.isEdgeType()) {
            v = this.vertex.settings.isUseVertexFieldsForEdgeLabels() || OrientEdge.isLabeled(OrientEdge.getRecordLabel(value), this.iLabels) ? OrientEdge.getConnection(value, ((Direction)((Object)this.connection.getKey())).opposite()) : null;
        } else {
            throw new IllegalStateException("Invalid content found between connections: " + value);
        }
        return v;
    }

    @Override
    public boolean canUseMultiValueDirectly() {
        return this.multiValue instanceof Collection ? ((Collection)this.multiValue).isEmpty() || this.isVertex((OIdentifiable)((Collection)this.multiValue).iterator().next()) : this.multiValue instanceof ORidBag && (((ORidBag)this.multiValue).isEmpty() || this.isVertex(((ORidBag)this.multiValue).iterator().next()));
    }

    @Override
    public boolean filter(Vertex iObject) {
        return !(iObject instanceof OrientVertex) || ((OrientVertex)iObject).getRecord() != null;
    }

    private boolean isVertex(OIdentifiable iObject) {
        Object rec = iObject.getRecord();
        if (rec == null || !(rec instanceof ODocument)) {
            return false;
        }
        ODocument value = (ODocument)rec;
        OClass klass = ODocumentInternal.getImmutableSchemaClass(value);
        if (klass == null && ODatabaseRecordThreadLocal.instance().getIfDefined() != null) {
            ODatabaseRecordThreadLocal.instance().getIfDefined().getMetadata().reload();
            klass = value.getSchemaClass();
        }
        if (klass.isVertexType()) {
            return true;
        }
        if (klass.isEdgeType()) {
            return false;
        }
        throw new IllegalStateException("Invalid content found between connections: " + value);
    }
}

