/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.ivy.Ivy;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.EncrytedProperties;
import org.apache.ivy.util.Message;

public final class CredentialsUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Credentials promptCredentials(Credentials c, File passfile) {
        if ((c = CredentialsUtil.loadPassfile(c, passfile)).getUserName() != null && c.getPasswd() != null) {
            return c;
        }
        CredentialPanel credentialPanel = new CredentialPanel(c, passfile);
        if (JOptionPane.showOptionDialog(null, credentialPanel, c.getHost() + " credentials", 2, 0, new ImageIcon(Ivy.class.getResource("logo.png")), null, new Integer(0)) == 0) {
            String username = credentialPanel.userNameField.getText();
            String passwd = credentialPanel.passwordField.getText();
            if (credentialPanel.rememberDataCB.isSelected()) {
                EncrytedProperties props2 = new EncrytedProperties();
                ((Properties)props2).setProperty("username", username);
                ((Properties)props2).setProperty("passwd", passwd);
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(passfile);
                    props2.store(fos, "");
                }
                catch (Exception e) {
                    Message.warn("error occurred while saving password file " + passfile + ": " + e);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            c = new Credentials(c.getRealm(), c.getHost(), username, passwd);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Credentials loadPassfile(Credentials c, File passfile) {
        if (passfile != null && passfile.exists()) {
            EncrytedProperties props2 = new EncrytedProperties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(passfile);
                props2.load(fis);
                String username = c.getUserName();
                String passwd = c.getPasswd();
                if (username == null) {
                    username = ((Properties)props2).getProperty("username");
                }
                if (passwd == null) {
                    passwd = ((Properties)props2).getProperty("passwd");
                }
                Credentials credentials = new Credentials(c.getRealm(), c.getHost(), username, passwd);
                return credentials;
            }
            catch (IOException e) {
                Message.warn("error occurred while loading password file " + passfile + ": " + e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return c;
    }

    private CredentialsUtil() {
    }

    private static final class CredentialPanel
    extends JPanel {
        private static final int FIELD_LENGTH = 20;
        private JTextField userNameField = new JTextField(20);
        private JTextField passwordField = new JPasswordField(20);
        private JCheckBox rememberDataCB = new JCheckBox("remember my information");

        CredentialPanel(Credentials credentials, File passfile) {
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.gridx = 1;
            c.gridheight = 1;
            c.gridwidth = 2;
            String prompt = credentials.getRealm() != null ? "Enter username and password for \"" + credentials.getRealm() + "\" at " + credentials.getHost() : "Enter username and password for " + credentials.getHost();
            this.add((Component)new JLabel(prompt), c);
            c.gridy = 1;
            c.gridwidth = 1;
            this.add((Component)new JLabel("username: "), c);
            c.gridx = 2;
            this.add((Component)this.userNameField, c);
            c.gridx = 1;
            ++c.gridy;
            if (credentials.getUserName() != null) {
                this.userNameField.setText(credentials.getUserName());
            }
            if (credentials.getPasswd() == null) {
                this.add((Component)new JLabel("passwd:  "), c);
                c.gridx = 2;
                this.add((Component)this.passwordField, c);
                c.gridx = 1;
                ++c.gridy;
            } else {
                this.passwordField.setText(credentials.getPasswd());
            }
            if (passfile != null) {
                c.gridwidth = 2;
                this.add((Component)this.rememberDataCB, c);
                ++c.gridy;
            }
            c.gridwidth = 2;
            this.add((Component)new JLabel(), c);
        }
    }
}

