/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.ProgramPhase;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;

public final class MemoryTraversalSideEffects
implements TraversalSideEffects {
    private TraversalSideEffects sideEffects;
    private Memory memory;
    private ProgramPhase phase;

    private MemoryTraversalSideEffects() {
    }

    public MemoryTraversalSideEffects(TraversalSideEffects sideEffects) {
        this.sideEffects = sideEffects;
        this.memory = null;
    }

    public TraversalSideEffects getSideEffects() {
        return this.sideEffects;
    }

    @Override
    public void set(String key, Object value) {
        this.sideEffects.set(key, value);
        if (null != this.memory) {
            this.memory.set(key, value);
        }
    }

    @Override
    public <V> V get(String key) throws IllegalArgumentException {
        return (V)(null != this.memory && this.memory.exists(key) ? this.memory.get(key) : this.sideEffects.get(key));
    }

    @Override
    public void remove(String key) {
        this.sideEffects.remove(key);
    }

    @Override
    public Set<String> keys() {
        return this.sideEffects.keys();
    }

    @Override
    public void add(String key, Object value) {
        if (this.phase.workerState()) {
            this.memory.add(key, value);
        } else {
            this.memory.set(key, this.sideEffects.getReducer(key).apply(this.memory.get(key), value));
        }
    }

    @Override
    public <V> void register(String key, Supplier<V> initialValue, BinaryOperator<V> reducer) {
        this.sideEffects.register(key, initialValue, reducer);
    }

    @Override
    public <V> void registerIfAbsent(String key, Supplier<V> initialValue, BinaryOperator<V> reducer) {
        this.sideEffects.registerIfAbsent(key, initialValue, reducer);
    }

    @Override
    public <V> BinaryOperator<V> getReducer(String key) {
        return this.sideEffects.getReducer(key);
    }

    @Override
    public <V> Supplier<V> getSupplier(String key) {
        return this.sideEffects.getSupplier(key);
    }

    @Override
    public <S> void setSack(Supplier<S> initialValue, UnaryOperator<S> splitOperator, BinaryOperator<S> mergeOperator) {
        this.sideEffects.setSack(initialValue, splitOperator, mergeOperator);
    }

    @Override
    public <S> Supplier<S> getSackInitialValue() {
        return this.sideEffects.getSackInitialValue();
    }

    @Override
    public <S> UnaryOperator<S> getSackSplitter() {
        return this.sideEffects.getSackSplitter();
    }

    @Override
    public <S> BinaryOperator<S> getSackMerger() {
        return this.sideEffects.getSackMerger();
    }

    @Override
    public TraversalSideEffects clone() {
        try {
            MemoryTraversalSideEffects clone = (MemoryTraversalSideEffects)super.clone();
            clone.sideEffects = this.sideEffects.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void mergeInto(TraversalSideEffects sideEffects) {
        this.sideEffects.mergeInto(sideEffects);
    }

    public void storeSideEffectsInMemory() {
        if (this.phase.workerState()) {
            this.sideEffects.forEach(this.memory::add);
        } else {
            this.sideEffects.forEach(this.memory::set);
        }
    }

    public static void setMemorySideEffects(Traversal.Admin<?, ?> traversal, Memory memory, ProgramPhase phase) {
        TraversalSideEffects sideEffects = traversal.getSideEffects();
        if (!(sideEffects instanceof MemoryTraversalSideEffects)) {
            traversal.setSideEffects(new MemoryTraversalSideEffects(sideEffects));
        }
        MemoryTraversalSideEffects memoryTraversalSideEffects = (MemoryTraversalSideEffects)traversal.getSideEffects();
        memoryTraversalSideEffects.memory = memory;
        memoryTraversalSideEffects.phase = phase;
    }

    public static Set<MemoryComputeKey> getMemoryComputeKeys(Traversal.Admin<?, ?> traversal) {
        HashSet<MemoryComputeKey> keys2 = new HashSet<MemoryComputeKey>();
        TraversalSideEffects sideEffects = traversal.getSideEffects() instanceof MemoryTraversalSideEffects ? ((MemoryTraversalSideEffects)traversal.getSideEffects()).getSideEffects() : traversal.getSideEffects();
        sideEffects.keys().stream().forEach((? super T key) -> keys2.add(MemoryComputeKey.of(key, sideEffects.getReducer((String)key), true, false)));
        return keys2;
    }
}

