/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.remote.traversal.strategy.decoration;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.decoration.VertexProgramStrategy;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteGraph;
import org.apache.tinkerpop.gremlin.process.remote.traversal.step.map.RemoteStep;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public final class RemoteStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private static final RemoteStrategy INSTANCE = new RemoteStrategy();
    private final Optional<RemoteConnection> remoteConnection;
    private static final Set<Class<? extends TraversalStrategy.DecorationStrategy>> POSTS = Collections.singleton(VertexProgramStrategy.class);

    private RemoteStrategy() {
        this.remoteConnection = Optional.empty();
    }

    public RemoteStrategy(RemoteConnection remoteConnection) {
        this.remoteConnection = Optional.ofNullable(remoteConnection);
    }

    @Deprecated
    public static RemoteStrategy instance() {
        return INSTANCE;
    }

    @Override
    public Set<Class<? extends TraversalStrategy.DecorationStrategy>> applyPost() {
        return POSTS;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (!this.remoteConnection.isPresent()) {
            if (!(traversal.getGraph().orElse(EmptyGraph.instance()) instanceof RemoteGraph)) {
                throw new IllegalStateException("RemoteStrategy expects a RemoteGraph instance attached to the Traversal");
            }
            RemoteGraph remoteGraph = (RemoteGraph)traversal.getGraph().get();
            if (null == remoteGraph.getConnection()) {
                throw new IllegalStateException("RemoteStrategy expects the RemoteGraph instance to have a RemoteConnection");
            }
        }
        if (!(traversal.getParent() instanceof EmptyStep)) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("is.testing", "false")).booleanValue() && (TraversalHelper.hasStepOfAssignableClassRecursively(ProfileSideEffectStep.class, traversal) || traversal.getBytecode().toString().contains("$"))) {
            throw new VerificationException("Test suite does not support profiling nor lambdas", traversal);
        }
        RemoteStep remoteStep = new RemoteStep(traversal, this.remoteConnection.orElseGet(() -> ((RemoteGraph)traversal.getGraph().get()).getConnection()));
        TraversalHelper.removeAllSteps(traversal);
        traversal.addStep(remoteStep);
        assert (traversal.getStartStep().equals(remoteStep));
        assert (traversal.getSteps().size() == 1);
        assert (traversal.getEndStep() == remoteStep);
    }
}

