/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util.event;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.MutationListener;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public interface Event {
    public void fireEvent(Iterator<MutationListener> var1);

    public static abstract class ElementPropertyEvent
    implements Event {
        private final Element element;
        private final Property oldValue;
        private final Object newValue;
        private final Object[] vertexPropertyKeyValues;

        public ElementPropertyEvent(Element element, Property oldValue, Object newValue, Object ... vertexPropertyKeyValues) {
            this.element = element;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.vertexPropertyKeyValues = vertexPropertyKeyValues;
        }

        abstract void fire(MutationListener var1, Element var2, Property var3, Object var4, Object ... var5);

        @Override
        public void fireEvent(Iterator<MutationListener> eventListeners) {
            while (eventListeners.hasNext()) {
                this.fire(eventListeners.next(), this.element, this.oldValue, this.newValue, this.vertexPropertyKeyValues);
            }
        }
    }

    public static abstract class ElementPropertyChangedEvent
    extends ElementPropertyEvent {
        public ElementPropertyChangedEvent(Element element, Property oldValue, Object newValue, Object ... vertexPropertyKeyValues) {
            super(element, oldValue, newValue, vertexPropertyKeyValues);
        }
    }

    public static class VertexRemovedEvent
    implements Event {
        private final Vertex vertex;

        public VertexRemovedEvent(Vertex vertex) {
            this.vertex = vertex;
        }

        @Override
        public void fireEvent(Iterator<MutationListener> eventListeners) {
            while (eventListeners.hasNext()) {
                eventListeners.next().vertexRemoved(this.vertex);
            }
        }
    }

    public static class VertexPropertyRemovedEvent
    implements Event {
        private final VertexProperty vertexProperty;

        public VertexPropertyRemovedEvent(VertexProperty vertexProperty) {
            this.vertexProperty = vertexProperty;
        }

        @Override
        public void fireEvent(Iterator<MutationListener> eventListeners) {
            while (eventListeners.hasNext()) {
                eventListeners.next().vertexPropertyRemoved(this.vertexProperty);
            }
        }
    }

    public static class VertexPropertyPropertyRemovedEvent
    extends ElementPropertyEvent {
        public VertexPropertyPropertyRemovedEvent(VertexProperty element, Property removed) {
            super(element, removed, null, new Object[0]);
        }

        @Override
        void fire(MutationListener listener, Element element, Property oldValue, Object newValue, Object ... vertexPropertyKeyValues) {
            listener.vertexPropertyPropertyRemoved((VertexProperty)element, oldValue);
        }
    }

    public static class VertexPropertyPropertyChangedEvent
    extends ElementPropertyChangedEvent {
        public VertexPropertyPropertyChangedEvent(VertexProperty element, Property oldValue, Object newValue) {
            super(element, oldValue, newValue, new Object[0]);
        }

        @Override
        void fire(MutationListener listener, Element element, Property oldValue, Object newValue, Object ... vertexPropertyKeyValues) {
            listener.vertexPropertyPropertyChanged((VertexProperty)element, oldValue, newValue);
        }
    }

    public static class VertexPropertyChangedEvent
    extends ElementPropertyChangedEvent {
        public VertexPropertyChangedEvent(Vertex element, Property oldValue, Object newValue, Object ... vertexPropertyKeyValues) {
            super(element, oldValue, newValue, vertexPropertyKeyValues);
        }

        @Override
        void fire(MutationListener listener, Element element, Property oldValue, Object newValue, Object ... vertexPropertyKeyValues) {
            listener.vertexPropertyChanged((Vertex)element, oldValue, newValue, vertexPropertyKeyValues);
        }
    }

    public static class VertexAddedEvent
    implements Event {
        private final Vertex vertex;

        public VertexAddedEvent(Vertex vertex) {
            this.vertex = vertex;
        }

        @Override
        public void fireEvent(Iterator<MutationListener> eventListeners) {
            while (eventListeners.hasNext()) {
                eventListeners.next().vertexAdded(this.vertex);
            }
        }
    }

    public static class EdgeRemovedEvent
    implements Event {
        private final Edge edge;

        public EdgeRemovedEvent(Edge edge) {
            this.edge = edge;
        }

        @Override
        public void fireEvent(Iterator<MutationListener> eventListeners) {
            while (eventListeners.hasNext()) {
                eventListeners.next().edgeRemoved(this.edge);
            }
        }
    }

    public static class EdgePropertyRemovedEvent
    extends ElementPropertyEvent {
        public EdgePropertyRemovedEvent(Edge element, Property removed) {
            super(element, removed, null, new Object[0]);
        }

        @Override
        void fire(MutationListener listener, Element element, Property oldValue, Object newValue, Object ... vertexPropertyKeyValues) {
            listener.edgePropertyRemoved((Edge)element, oldValue);
        }
    }

    public static class EdgePropertyChangedEvent
    extends ElementPropertyChangedEvent {
        public EdgePropertyChangedEvent(Edge edge, Property oldValue, Object newValue) {
            super(edge, oldValue, newValue, new Object[0]);
        }

        @Override
        void fire(MutationListener listener, Element element, Property oldValue, Object newValue, Object ... vertexPropertyKeyValues) {
            listener.edgePropertyChanged((Edge)element, oldValue, newValue);
        }
    }

    public static class EdgeAddedEvent
    implements Event {
        private final Edge edge;

        public EdgeAddedEvent(Edge edge) {
            this.edge = edge;
        }

        @Override
        public void fireEvent(Iterator<MutationListener> eventListeners) {
            while (eventListeners.hasNext()) {
                eventListeners.next().edgeAdded(this.edge);
            }
        }
    }
}

