/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoWriter;

public final class GryoIo
implements Io<GryoReader.Builder, GryoWriter.Builder, GryoMapper.Builder> {
    private final Graph graph;
    private Optional<Consumer<Mapper.Builder>> onMapper;

    private GryoIo(Builder builder) {
        this.graph = builder.graph;
        this.onMapper = Optional.ofNullable(builder.onMapper);
    }

    @Override
    public GryoReader.Builder reader() {
        return GryoReader.build().mapper(this.mapper().create());
    }

    @Override
    public GryoWriter.Builder writer() {
        return GryoWriter.build().mapper(this.mapper().create());
    }

    @Override
    public GryoMapper.Builder mapper() {
        GryoMapper.Builder builder = GryoMapper.build();
        this.onMapper.ifPresent(c -> c.accept(builder));
        return builder;
    }

    @Override
    public void writeGraph(String file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.writer().create().writeGraph(out, this.graph);
        }
    }

    @Override
    public void readGraph(String file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.reader().create().readGraph(in, this.graph);
        }
    }

    public static Io.Builder<GryoIo> build() {
        return new Builder();
    }

    public static final class Builder
    implements Io.Builder<GryoIo> {
        private Graph graph;
        private Consumer<Mapper.Builder> onMapper = null;

        @Override
        public Io.Builder<? extends Io> onMapper(Consumer<Mapper.Builder> onMapper) {
            this.onMapper = onMapper;
            return this;
        }

        @Override
        public Io.Builder<GryoIo> graph(Graph g) {
            this.graph = g;
            return this;
        }

        @Override
        public GryoIo create() {
            if (null == this.graph) {
                throw new IllegalArgumentException("The graph argument was not specified");
            }
            return new GryoIo(this);
        }
    }
}

