/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraphGryoSerializer;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.io.Input;

public final class GryoReader
implements GraphReader {
    private final Kryo kryo;
    private final Map<GraphFilter, StarGraphGryoSerializer> graphFilterCache = new HashMap<GraphFilter, StarGraphGryoSerializer>();
    private final long batchSize;

    private GryoReader(long batchSize, Mapper<Kryo> gryoMapper) {
        this.kryo = gryoMapper.createMapper();
        this.batchSize = batchSize;
    }

    @Override
    public void readGraph(InputStream inputStream, Graph graphToWriteTo) throws IOException {
        HashMap cache = new HashMap();
        AtomicLong counter = new AtomicLong(0L);
        Graph.Features.EdgeFeatures edgeFeatures = graphToWriteTo.features().edge();
        boolean supportsTx = graphToWriteTo.features().graph().supportsTransactions();
        IteratorUtils.iterate(new VertexInputIterator(new Input(inputStream), attachable -> {
            Vertex v = (Vertex)cache.put((StarGraph.StarVertex)attachable.get(), attachable.attach(Attachable.Method.create(graphToWriteTo)));
            if (supportsTx && counter.incrementAndGet() % this.batchSize == 0L) {
                graphToWriteTo.tx().commit();
            }
            return v;
        }, null, null));
        cache.entrySet().forEach(kv -> ((StarGraph.StarVertex)kv.getKey()).edges(Direction.IN, new String[0]).forEachRemaining(e -> {
            Vertex cachedOutV = (Vertex)cache.get(e.outVertex());
            Vertex cachedInV = (Vertex)cache.get(e.inVertex());
            if (null == cachedOutV) {
                throw new IllegalStateException(String.format("Could not find outV with id [%s] to create edge with id [%s]", e.outVertex().id(), e.id()));
            }
            if (null == cachedInV) {
                throw new IllegalStateException(String.format("Could not find inV with id [%s] to create edge with id [%s]", e.inVertex().id(), e.id()));
            }
            Edge newEdge = edgeFeatures.willAllowId(e.id()) ? cachedOutV.addEdge(e.label(), cachedInV, T.id, e.id()) : cachedOutV.addEdge(e.label(), cachedInV, new Object[0]);
            e.properties(new String[0]).forEachRemaining(p -> newEdge.property(p.key(), p.value()));
            if (supportsTx && counter.incrementAndGet() % this.batchSize == 0L) {
                graphToWriteTo.tx().commit();
            }
        }));
        if (supportsTx) {
            graphToWriteTo.tx().commit();
        }
    }

    @Override
    public Optional<Vertex> readVertex(InputStream inputStream, GraphFilter graphFilter) throws IOException {
        StarGraphGryoSerializer serializer = this.graphFilterCache.get(graphFilter);
        if (null == serializer) {
            serializer = StarGraphGryoSerializer.withGraphFilter(graphFilter);
            this.graphFilterCache.put(graphFilter, serializer);
        }
        Input input = new Input(inputStream);
        this.readHeader(input);
        StarGraph starGraph = this.kryo.readObject(input, StarGraph.class, serializer);
        this.kryo.readClassAndObject(input);
        return Optional.ofNullable(starGraph == null ? null : starGraph.getStarVertex());
    }

    @Override
    public Iterator<Vertex> readVertices(InputStream inputStream, Function<Attachable<Vertex>, Vertex> vertexAttachMethod, Function<Attachable<Edge>, Edge> edgeAttachMethod, Direction attachEdgesOfThisDirection) throws IOException {
        return new VertexInputIterator(new Input(inputStream), vertexAttachMethod, attachEdgesOfThisDirection, edgeAttachMethod);
    }

    @Override
    public Vertex readVertex(InputStream inputStream, Function<Attachable<Vertex>, Vertex> vertexAttachMethod) throws IOException {
        return this.readVertex(inputStream, vertexAttachMethod, null, null);
    }

    @Override
    public Vertex readVertex(InputStream inputStream, Function<Attachable<Vertex>, Vertex> vertexAttachMethod, Function<Attachable<Edge>, Edge> edgeAttachMethod, Direction attachEdgesOfThisDirection) throws IOException {
        Input input = new Input(inputStream);
        return this.readVertexInternal(vertexAttachMethod, edgeAttachMethod, attachEdgesOfThisDirection, input);
    }

    @Override
    public Edge readEdge(InputStream inputStream, Function<Attachable<Edge>, Edge> edgeAttachMethod) throws IOException {
        Input input = new Input(inputStream);
        this.readHeader(input);
        Attachable attachable = this.kryo.readObject(input, DetachedEdge.class);
        return edgeAttachMethod.apply(attachable);
    }

    @Override
    public VertexProperty readVertexProperty(InputStream inputStream, Function<Attachable<VertexProperty>, VertexProperty> vertexPropertyAttachMethod) throws IOException {
        Input input = new Input(inputStream);
        this.readHeader(input);
        Attachable attachable = this.kryo.readObject(input, DetachedVertexProperty.class);
        return vertexPropertyAttachMethod.apply(attachable);
    }

    @Override
    public Property readProperty(InputStream inputStream, Function<Attachable<Property>, Property> propertyAttachMethod) throws IOException {
        Input input = new Input(inputStream);
        this.readHeader(input);
        Attachable attachable = this.kryo.readObject(input, DetachedProperty.class);
        return propertyAttachMethod.apply(attachable);
    }

    @Override
    public <C> C readObject(InputStream inputStream, Class<? extends C> clazz) throws IOException {
        return clazz.cast(this.kryo.readClassAndObject(new Input(inputStream)));
    }

    private Vertex readVertexInternal(Function<Attachable<Vertex>, Vertex> vertexMaker, Function<Attachable<Edge>, Edge> edgeMaker, Direction d, Input input) throws IOException {
        this.readHeader(input);
        StarGraph starGraph = this.kryo.readObject(input, StarGraph.class);
        this.kryo.readClassAndObject(input);
        Vertex v = vertexMaker.apply(starGraph.getStarVertex());
        if (edgeMaker != null) {
            starGraph.getStarVertex().edges(d, new String[0]).forEachRemaining(e -> {
                Edge cfr_ignored_0 = (Edge)edgeMaker.apply((Attachable)((Object)e));
            });
        }
        return v;
    }

    private void readHeader(Input input) throws IOException {
        if (!Arrays.equals(GryoMapper.GIO, input.readBytes(3))) {
            throw new IOException("Invalid format - first three bytes of header do not match expected value");
        }
        input.readBytes(13);
    }

    public static Builder build() {
        return new Builder();
    }

    private class VertexInputIterator
    implements Iterator<Vertex> {
        private final Input input;
        private final Function<Attachable<Vertex>, Vertex> vertexMaker;
        private final Direction d;
        private final Function<Attachable<Edge>, Edge> edgeMaker;

        public VertexInputIterator(Input input, Function<Attachable<Vertex>, Vertex> vertexMaker, Direction d, Function<Attachable<Edge>, Edge> edgeMaker) {
            this.input = input;
            this.d = d;
            this.edgeMaker = edgeMaker;
            this.vertexMaker = vertexMaker;
        }

        @Override
        public boolean hasNext() {
            return !this.input.eof();
        }

        @Override
        public Vertex next() {
            try {
                return GryoReader.this.readVertexInternal(this.vertexMaker, this.edgeMaker, this.d, this.input);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static final class Builder
    implements GraphReader.ReaderBuilder<GryoReader> {
        private long batchSize = 10000L;
        private Mapper<Kryo> gryoMapper = GryoMapper.build().create();

        private Builder() {
        }

        public Builder batchSize(long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder mapper(Mapper<Kryo> gryoMapper) {
            this.gryoMapper = gryoMapper;
            return this;
        }

        @Override
        public GryoReader create() {
            return new GryoReader(this.batchSize, this.gryoMapper);
        }
    }
}

