/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.orient3;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Iterator;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001a\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u000f\u001a\n\u0010\u0014\u001a\u00020\u0013*\u00020\u000f\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"ORIENTDB3", "", "orientdbConnectionUrl", "createOrientdbConnectionUrl", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "open", "Lcom/orientechnologies/orient/core/db/ODatabaseSession;", "openGremlin", "Lorg/apache/tinkerpop/gremlin/orientdb/OrientGraph;", "getEdge", "Ljava/util/Optional;", "Lcom/orientechnologies/orient/core/record/OEdge;", "Lcom/orientechnologies/orient/core/db/document/ODatabaseDocument;", "document", "Lcom/orientechnologies/orient/core/record/impl/ODocument;", "getVertex", "Lcom/orientechnologies/orient/core/record/OVertex;", "isEdgeType", "", "isVertexType", "type", "arcade-connectors-orientdb3"})
public final class OrientDB3UtilsKt {
    @NotNull
    public static final String ORIENTDB3 = "ORIENTDB3";
    private static final String orientdbConnectionUrl = "remote:{server}:{port}";

    @NotNull
    public static final String createOrientdbConnectionUrl(@NotNull DataSourceInfo dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)orientdbConnectionUrl, (String)"{server}", (String)dataSource.getServer(), (boolean)false, (int)4, null), (String)"{port}", (String)String.valueOf(dataSource.getPort()), (boolean)false, (int)4, null);
    }

    @NotNull
    public static final ODatabaseSession open(@NotNull DataSourceInfo dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        String orientdbConnectionUrl = OrientDB3UtilsKt.createOrientdbConnectionUrl(dataSource);
        OrientDB orientDB = new OrientDB(orientdbConnectionUrl, OrientDBConfig.defaultConfig());
        ODatabaseSession oDatabaseSession = orientDB.open(dataSource.getDatabase(), dataSource.getUsername(), dataSource.getPassword());
        Intrinsics.checkNotNullExpressionValue((Object)oDatabaseSession, (String)"orientDB.open(dataSource\u2026ame, dataSource.password)");
        return oDatabaseSession;
    }

    @NotNull
    public static final OrientGraph openGremlin(@NotNull DataSourceInfo dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        String orientdbConnectionUrl = OrientDB3UtilsKt.createOrientdbConnectionUrl(dataSource);
        OrientDB orientDB = new OrientDB(orientdbConnectionUrl, OrientDBConfig.defaultConfig());
        OrientGraphFactory graphFactory = new OrientGraphFactory(orientDB, dataSource.getDatabase(), ODatabaseType.PLOCAL, dataSource.getUsername(), dataSource.getPassword());
        OrientGraph orientGraph = graphFactory.getNoTx();
        Intrinsics.checkNotNullExpressionValue((Object)orientGraph, (String)"graphFactory.noTx");
        return orientGraph;
    }

    @Nullable
    public static final Optional<OVertex> getVertex(@NotNull ODatabaseDocument $this$getVertex, @NotNull ODocument document) {
        Intrinsics.checkNotNullParameter((Object)$this$getVertex, (String)"$this$getVertex");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        String sql = "select * from V where @rid = ?";
        OResultSet oResultSet = $this$getVertex.query(sql, document.getIdentity().toString());
        Intrinsics.checkNotNullExpressionValue((Object)oResultSet, (String)"this.query(sql, document.identity.toString())");
        OResultSet result = oResultSet;
        Object object = SequencesKt.first((Sequence)SequencesKt.asSequence((Iterator)result));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.asSequence().first()");
        return ((OResult)object).getVertex();
    }

    @Nullable
    public static final Optional<OEdge> getEdge(@NotNull ODatabaseDocument $this$getEdge, @NotNull ODocument document) {
        Intrinsics.checkNotNullParameter((Object)$this$getEdge, (String)"$this$getEdge");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        String sql = "select * from E where @rid = ?";
        OResultSet oResultSet = $this$getEdge.query(sql, document.getIdentity().toString());
        Intrinsics.checkNotNullExpressionValue((Object)oResultSet, (String)"this.query(sql, document.identity.toString())");
        OResultSet result = oResultSet;
        Object object = SequencesKt.first((Sequence)SequencesKt.asSequence((Iterator)result));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.asSequence().first()");
        return ((OResult)object).getEdge();
    }

    public static final boolean isEdgeType(@NotNull ODocument $this$isEdgeType) {
        Intrinsics.checkNotNullParameter((Object)$this$isEdgeType, (String)"$this$isEdgeType");
        OClass oClass = $this$isEdgeType.getSchemaClass();
        Intrinsics.checkNotNullExpressionValue((Object)oClass, (String)"this.schemaClass");
        return oClass.isEdgeType();
    }

    public static final boolean isVertexType(@NotNull ODocument $this$isVertexType) {
        Intrinsics.checkNotNullParameter((Object)$this$isVertexType, (String)"$this$isVertexType");
        OClass oClass = $this$isVertexType.getSchemaClass();
        Intrinsics.checkNotNullExpressionValue((Object)oClass, (String)"this.schemaClass");
        return oClass.isVertexType();
    }

    @NotNull
    public static final String type(@NotNull ODocument $this$type) {
        Intrinsics.checkNotNullParameter((Object)$this$type, (String)"$this$type");
        return OrientDB3UtilsKt.isEdgeType($this$type) ? "edge" : (OrientDB3UtilsKt.isVertexType($this$type) ? "node" : "document");
    }
}

