/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonschema.JsonSerializableSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class BeanSerializerBase
extends StdSerializer<Object>
implements ContextualSerializer,
ResolvableSerializer,
JsonFormatVisitable,
SchemaAware {
    protected static final BeanPropertyWriter[] NO_PROPS = new BeanPropertyWriter[0];
    protected final BeanPropertyWriter[] _props;
    protected final BeanPropertyWriter[] _filteredProps;
    protected final AnyGetterWriter _anyGetterWriter;
    protected final Object _propertyFilterId;
    protected final AnnotatedMember _typeId;
    protected final ObjectIdWriter _objectIdWriter;
    protected final JsonFormat.Shape _serializationShape;

    protected BeanSerializerBase(JavaType javaType, BeanSerializerBuilder beanSerializerBuilder, BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        super(javaType);
        this._props = beanPropertyWriterArray;
        this._filteredProps = beanPropertyWriterArray2;
        if (beanSerializerBuilder == null) {
            this._typeId = null;
            this._anyGetterWriter = null;
            this._propertyFilterId = null;
            this._objectIdWriter = null;
            this._serializationShape = null;
        } else {
            this._typeId = beanSerializerBuilder.getTypeId();
            this._anyGetterWriter = beanSerializerBuilder.getAnyGetter();
            this._propertyFilterId = beanSerializerBuilder.getFilterId();
            this._objectIdWriter = beanSerializerBuilder.getObjectIdWriter();
            JsonFormat.Value value = beanSerializerBuilder.getBeanDescription().findExpectedFormat(null);
            this._serializationShape = value == null ? null : value.getShape();
        }
    }

    public BeanSerializerBase(BeanSerializerBase beanSerializerBase, BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        super(beanSerializerBase._handledType);
        this._props = beanPropertyWriterArray;
        this._filteredProps = beanPropertyWriterArray2;
        this._typeId = beanSerializerBase._typeId;
        this._anyGetterWriter = beanSerializerBase._anyGetterWriter;
        this._objectIdWriter = beanSerializerBase._objectIdWriter;
        this._propertyFilterId = beanSerializerBase._propertyFilterId;
        this._serializationShape = beanSerializerBase._serializationShape;
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, ObjectIdWriter objectIdWriter) {
        super(beanSerializerBase._handledType);
        this._props = beanSerializerBase._props;
        this._filteredProps = beanSerializerBase._filteredProps;
        this._typeId = beanSerializerBase._typeId;
        this._anyGetterWriter = beanSerializerBase._anyGetterWriter;
        this._objectIdWriter = objectIdWriter;
        this._propertyFilterId = beanSerializerBase._propertyFilterId;
        this._serializationShape = beanSerializerBase._serializationShape;
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, String[] stringArray) {
        super(beanSerializerBase._handledType);
        HashSet<String> hashSet = ArrayBuilders.arrayToSet(stringArray);
        BeanPropertyWriter[] beanPropertyWriterArray = beanSerializerBase._props;
        BeanPropertyWriter[] beanPropertyWriterArray2 = beanSerializerBase._filteredProps;
        int n = beanPropertyWriterArray.length;
        ArrayList<BeanPropertyWriter> arrayList = new ArrayList<BeanPropertyWriter>(n);
        ArrayList<BeanPropertyWriter> arrayList2 = beanPropertyWriterArray2 == null ? null : new ArrayList<BeanPropertyWriter>(n);
        for (int i = 0; i < n; ++i) {
            BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[i];
            if (hashSet.contains(beanPropertyWriter.getName())) continue;
            arrayList.add(beanPropertyWriter);
            if (beanPropertyWriterArray2 == null) continue;
            arrayList2.add(beanPropertyWriterArray2[i]);
        }
        this._props = arrayList.toArray(new BeanPropertyWriter[arrayList.size()]);
        this._filteredProps = arrayList2 == null ? null : arrayList2.toArray(new BeanPropertyWriter[arrayList2.size()]);
        this._typeId = beanSerializerBase._typeId;
        this._anyGetterWriter = beanSerializerBase._anyGetterWriter;
        this._objectIdWriter = beanSerializerBase._objectIdWriter;
        this._propertyFilterId = beanSerializerBase._propertyFilterId;
        this._serializationShape = beanSerializerBase._serializationShape;
    }

    public abstract BeanSerializerBase withObjectIdWriter(ObjectIdWriter var1);

    protected abstract BeanSerializerBase withIgnorals(String[] var1);

    protected abstract BeanSerializerBase asArraySerializer();

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase) {
        this(beanSerializerBase, beanSerializerBase._props, beanSerializerBase._filteredProps);
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, NameTransformer nameTransformer) {
        this(beanSerializerBase, BeanSerializerBase.rename(beanSerializerBase._props, nameTransformer), BeanSerializerBase.rename(beanSerializerBase._filteredProps, nameTransformer));
    }

    private static final BeanPropertyWriter[] rename(BeanPropertyWriter[] beanPropertyWriterArray, NameTransformer nameTransformer) {
        if (beanPropertyWriterArray == null || beanPropertyWriterArray.length == 0 || nameTransformer == null || nameTransformer == NameTransformer.NOP) {
            return beanPropertyWriterArray;
        }
        int n = beanPropertyWriterArray.length;
        BeanPropertyWriter[] beanPropertyWriterArray2 = new BeanPropertyWriter[n];
        for (int i = 0; i < n; ++i) {
            BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[i];
            if (beanPropertyWriter == null) continue;
            beanPropertyWriterArray2[i] = beanPropertyWriter.rename(nameTransformer);
        }
        return beanPropertyWriterArray2;
    }

    @Override
    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        int n = this._filteredProps == null ? 0 : this._filteredProps.length;
        int n2 = this._props.length;
        for (int i = 0; i < n2; ++i) {
            Object object;
            JsonSerializer<Object> jsonSerializer;
            BeanPropertyWriter beanPropertyWriter = this._props[i];
            if (!beanPropertyWriter.willSuppressNulls() && !beanPropertyWriter.hasNullSerializer() && (jsonSerializer = serializerProvider.findNullValueSerializer(beanPropertyWriter)) != null) {
                beanPropertyWriter.assignNullSerializer(jsonSerializer);
                if (i < n && (object = this._filteredProps[i]) != null) {
                    ((BeanPropertyWriter)object).assignNullSerializer(jsonSerializer);
                }
            }
            if (beanPropertyWriter.hasSerializer()) continue;
            jsonSerializer = this.findConvertingSerializer(serializerProvider, beanPropertyWriter);
            if (jsonSerializer == null) {
                TypeSerializer typeSerializer;
                object = beanPropertyWriter.getSerializationType();
                if (object == null && !((JavaType)(object = serializerProvider.constructType(beanPropertyWriter.getGenericPropertyType()))).isFinal()) {
                    if (!((JavaType)object).isContainerType() && ((JavaType)object).containedTypeCount() <= 0) continue;
                    beanPropertyWriter.setNonTrivialBaseType((JavaType)object);
                    continue;
                }
                jsonSerializer = serializerProvider.findValueSerializer((JavaType)object, (BeanProperty)beanPropertyWriter);
                if (((JavaType)object).isContainerType() && (typeSerializer = (TypeSerializer)((JavaType)object).getContentType().getTypeHandler()) != null && jsonSerializer instanceof ContainerSerializer) {
                    ContainerSerializer<?> containerSerializer = ((ContainerSerializer)jsonSerializer).withValueTypeSerializer(typeSerializer);
                    jsonSerializer = containerSerializer;
                }
            }
            beanPropertyWriter.assignSerializer(jsonSerializer);
            if (i >= n || (object = this._filteredProps[i]) == null) continue;
            ((BeanPropertyWriter)object).assignSerializer(jsonSerializer);
        }
        if (this._anyGetterWriter != null) {
            this._anyGetterWriter.resolve(serializerProvider);
        }
    }

    protected JsonSerializer<Object> findConvertingSerializer(SerializerProvider serializerProvider, BeanPropertyWriter beanPropertyWriter) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        if (annotationIntrospector != null && (object = annotationIntrospector.findSerializationConverter(beanPropertyWriter.getMember())) != null) {
            Converter<Object, Object> converter = serializerProvider.converterInstance(beanPropertyWriter.getMember(), object);
            JavaType javaType = converter.getOutputType(serializerProvider.getTypeFactory());
            JsonSerializer<Object> jsonSerializer = serializerProvider.findValueSerializer(javaType, (BeanProperty)beanPropertyWriter);
            return new StdDelegatingSerializer(converter, javaType, jsonSerializer);
        }
        return null;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        Serializable serializable;
        Object object2;
        AnnotatedMember annotatedMember;
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        String[] stringArray = null;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        AnnotatedMember annotatedMember2 = annotatedMember = beanProperty == null || annotationIntrospector == null ? null : beanProperty.getMember();
        if (annotatedMember != null) {
            stringArray = annotationIntrospector.findPropertiesToIgnore(annotatedMember);
            object2 = annotationIntrospector.findObjectIdInfo(annotatedMember);
            if (object2 == null) {
                if (objectIdWriter != null) {
                    object2 = annotationIntrospector.findObjectReferenceInfo(annotatedMember, new ObjectIdInfo("", null, null));
                    objectIdWriter = this._objectIdWriter.withAlwaysAsId(((ObjectIdInfo)object2).getAlwaysAsId());
                }
            } else {
                object2 = annotationIntrospector.findObjectReferenceInfo(annotatedMember, (ObjectIdInfo)object2);
                serializable = ((ObjectIdInfo)object2).getGeneratorType();
                JavaType javaType = serializerProvider.constructType((Type)((Object)serializable));
                JavaType javaType2 = serializerProvider.getTypeFactory().findTypeParameters(javaType, ObjectIdGenerator.class)[0];
                if (serializable == ObjectIdGenerators.PropertyGenerator.class) {
                    String string = ((ObjectIdInfo)object2).getPropertyName();
                    BeanPropertyWriter beanPropertyWriter = null;
                    int n = 0;
                    int n2 = this._props.length;
                    while (true) {
                        if (n == n2) {
                            throw new IllegalArgumentException("Invalid Object Id definition for " + this._handledType.getName() + ": can not find property with name '" + string + "'");
                        }
                        BeanPropertyWriter beanPropertyWriter2 = this._props[n];
                        if (string.equals(beanPropertyWriter2.getName())) {
                            beanPropertyWriter = beanPropertyWriter2;
                            if (n <= 0) break;
                            System.arraycopy(this._props, 0, this._props, 1, n);
                            this._props[0] = beanPropertyWriter;
                            if (this._filteredProps == null) break;
                            BeanPropertyWriter beanPropertyWriter3 = this._filteredProps[n];
                            System.arraycopy(this._filteredProps, 0, this._filteredProps, 1, n);
                            this._filteredProps[0] = beanPropertyWriter3;
                            break;
                        }
                        ++n;
                    }
                    javaType2 = beanPropertyWriter.getType();
                    object = new PropertyBasedObjectIdGenerator((ObjectIdInfo)object2, beanPropertyWriter);
                    objectIdWriter = ObjectIdWriter.construct(javaType2, null, object, ((ObjectIdInfo)object2).getAlwaysAsId());
                } else {
                    object = serializerProvider.objectIdGeneratorInstance(annotatedMember, (ObjectIdInfo)object2);
                    objectIdWriter = ObjectIdWriter.construct(javaType2, ((ObjectIdInfo)object2).getPropertyName(), object, ((ObjectIdInfo)object2).getAlwaysAsId());
                }
            }
        }
        object2 = this;
        if (objectIdWriter != null && (objectIdWriter = objectIdWriter.withSerializer((JsonSerializer<?>)(object = serializerProvider.findValueSerializer(objectIdWriter.idType, beanProperty)))) != this._objectIdWriter) {
            object2 = ((BeanSerializerBase)object2).withObjectIdWriter(objectIdWriter);
        }
        if (stringArray != null && stringArray.length != 0) {
            object2 = ((BeanSerializerBase)object2).withIgnorals(stringArray);
        }
        object = null;
        if (annotatedMember != null && (serializable = annotationIntrospector.findFormat((Annotated)annotatedMember)) != null) {
            object = serializable.getShape();
        }
        if (object == null) {
            object = this._serializationShape;
        }
        if (object == JsonFormat.Shape.ARRAY) {
            object2 = ((BeanSerializerBase)object2).asArraySerializer();
        }
        return object2;
    }

    @Override
    public boolean usesObjectId() {
        return this._objectIdWriter != null;
    }

    @Override
    public abstract void serialize(Object var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        String string;
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(object, jsonGenerator, serializerProvider, typeSerializer);
            return;
        }
        String string2 = string = this._typeId == null ? null : this._customTypeId(object);
        if (string == null) {
            typeSerializer.writeTypePrefixForObject(object, jsonGenerator);
        } else {
            typeSerializer.writeCustomTypePrefixForObject(object, jsonGenerator, string);
        }
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        if (string == null) {
            typeSerializer.writeTypeSuffixForObject(object, jsonGenerator);
        } else {
            typeSerializer.writeCustomTypeSuffixForObject(object, jsonGenerator, string);
        }
    }

    protected final void _serializeWithObjectId(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean bl) throws IOException, JsonGenerationException {
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        WritableObjectId writableObjectId = serializerProvider.findObjectId(object, objectIdWriter.generator);
        if (writableObjectId.writeAsId(jsonGenerator, serializerProvider, objectIdWriter)) {
            return;
        }
        Object object2 = writableObjectId.generateId(object);
        if (objectIdWriter.alwaysAsId) {
            objectIdWriter.serializer.serialize(object2, jsonGenerator, serializerProvider);
            return;
        }
        if (bl) {
            jsonGenerator.writeStartObject();
        }
        writableObjectId.writeAsField(jsonGenerator, serializerProvider, objectIdWriter);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        if (bl) {
            jsonGenerator.writeEndObject();
        }
    }

    protected final void _serializeWithObjectId(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        String string;
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        WritableObjectId writableObjectId = serializerProvider.findObjectId(object, objectIdWriter.generator);
        if (writableObjectId.writeAsId(jsonGenerator, serializerProvider, objectIdWriter)) {
            return;
        }
        Object object2 = writableObjectId.generateId(object);
        if (objectIdWriter.alwaysAsId) {
            objectIdWriter.serializer.serialize(object2, jsonGenerator, serializerProvider);
            return;
        }
        String string2 = string = this._typeId == null ? null : this._customTypeId(object);
        if (string == null) {
            typeSerializer.writeTypePrefixForObject(object, jsonGenerator);
        } else {
            typeSerializer.writeCustomTypePrefixForObject(object, jsonGenerator, string);
        }
        writableObjectId.writeAsField(jsonGenerator, serializerProvider, objectIdWriter);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        if (string == null) {
            typeSerializer.writeTypeSuffixForObject(object, jsonGenerator);
        } else {
            typeSerializer.writeCustomTypeSuffixForObject(object, jsonGenerator, string);
        }
    }

    private final String _customTypeId(Object object) {
        Object object2 = this._typeId.getValue(object);
        if (object2 == null) {
            return "";
        }
        return object2 instanceof String ? (String)object2 : object2.toString();
    }

    protected void serializeFields(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getActiveView() != null ? this._filteredProps : this._props;
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) continue;
                beanPropertyWriter.serializeAsField(object, jsonGenerator, serializerProvider);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(object, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException("Infinite recursion (StackOverflowError)", stackOverflowError);
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            jsonMappingException.prependPath(new JsonMappingException.Reference(object, string));
            throw jsonMappingException;
        }
    }

    protected void serializeFieldsFiltered(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getActiveView() != null ? this._filteredProps : this._props;
        BeanPropertyFilter beanPropertyFilter = this.findFilter(serializerProvider);
        if (beanPropertyFilter == null) {
            this.serializeFields(object, jsonGenerator, serializerProvider);
            return;
        }
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) continue;
                beanPropertyFilter.serializeAsField(object, jsonGenerator, serializerProvider, beanPropertyWriter);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(object, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException("Infinite recursion (StackOverflowError)", stackOverflowError);
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            jsonMappingException.prependPath(new JsonMappingException.Reference(object, string));
            throw jsonMappingException;
        }
    }

    protected BeanPropertyFilter findFilter(SerializerProvider serializerProvider) throws JsonMappingException {
        Object object = this._propertyFilterId;
        FilterProvider filterProvider = serializerProvider.getFilterProvider();
        if (filterProvider == null) {
            throw new JsonMappingException("Can not resolve BeanPropertyFilter with id '" + object + "'; no FilterProvider configured");
        }
        BeanPropertyFilter beanPropertyFilter = filterProvider.findFilter(object);
        return beanPropertyFilter;
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        Object object;
        ObjectNode objectNode = this.createSchemaNode("object", true);
        JsonSerializableSchema jsonSerializableSchema = this._handledType.getAnnotation(JsonSerializableSchema.class);
        if (jsonSerializableSchema != null && (object = jsonSerializableSchema.id()) != null && ((String)object).length() > 0) {
            objectNode.put("id", (String)object);
        }
        object = objectNode.objectNode();
        BeanPropertyFilter beanPropertyFilter = this._propertyFilterId != null ? this.findFilter(serializerProvider) : null;
        for (int i = 0; i < this._props.length; ++i) {
            BeanPropertyWriter beanPropertyWriter = this._props[i];
            if (beanPropertyFilter == null) {
                beanPropertyWriter.depositSchemaProperty((ObjectNode)object, serializerProvider);
                continue;
            }
            beanPropertyFilter.depositSchemaProperty(beanPropertyWriter, (ObjectNode)object, serializerProvider);
        }
        objectNode.put("properties", (JsonNode)object);
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        block4: {
            JsonObjectFormatVisitor jsonObjectFormatVisitor;
            JsonObjectFormatVisitor jsonObjectFormatVisitor2 = jsonObjectFormatVisitor = jsonFormatVisitorWrapper == null ? null : jsonFormatVisitorWrapper.expectObjectFormat(javaType);
            if (jsonObjectFormatVisitor == null) break block4;
            if (this._propertyFilterId != null) {
                BeanPropertyFilter beanPropertyFilter = this.findFilter(jsonFormatVisitorWrapper.getProvider());
                for (int i = 0; i < this._props.length; ++i) {
                    beanPropertyFilter.depositSchemaProperty(this._props[i], jsonObjectFormatVisitor, jsonFormatVisitorWrapper.getProvider());
                }
            } else {
                for (int i = 0; i < this._props.length; ++i) {
                    this._props[i].depositSchemaProperty(jsonObjectFormatVisitor);
                }
            }
        }
    }
}

