/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.console;

import com.orientechnologies.common.console.OCommandStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class OConsoleCommandStream
implements OCommandStream {
    public static final int BUFFER_SIZE = 1024;
    private Reader reader;
    private Character nextCharacter;
    private State state;
    private int nestingLevel = 0;

    public OConsoleCommandStream(String commands) {
        this.reader = new StringReader(commands);
        this.init();
    }

    public OConsoleCommandStream(File file) throws FileNotFoundException {
        this.reader = new BufferedReader(new FileReader(file), 1024);
        this.init();
    }

    private void init() {
        try {
            int next = this.reader.read();
            this.nextCharacter = next > -1 ? Character.valueOf((char)next) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Character nextCharacter() throws IOException {
        if (this.nextCharacter == null) {
            return null;
        }
        Character result = this.nextCharacter;
        int next = this.reader.read();
        this.nextCharacter = next < 0 ? null : Character.valueOf((char)next);
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.nextCharacter != null;
    }

    @Override
    public String nextCommand() {
        try {
            this.state = State.TEXT;
            StringBuilder result = new StringBuilder();
            block27: while (true) {
                Character c = this.nextCharacter();
                Symbol symbol = this.symbol(c);
                block1 : switch (this.state) {
                    case TEXT: {
                        switch (symbol) {
                            case LETTER: {
                                result.append(c);
                                break block1;
                            }
                            case DOUBLE_QUOTE: {
                                result.append(c);
                                this.state = State.DOUBLE_QUOTE_STRING;
                                break block1;
                            }
                            case SINGLE_QUOTE: {
                                result.append(c);
                                this.state = State.SINGLE_QUOTE_STRING;
                                break block1;
                            }
                            case LEFT_BRACKET: {
                                result.append(c);
                                ++this.nestingLevel;
                                break block1;
                            }
                            case RIGHT_BRAKET: {
                                result.append(c);
                                --this.nestingLevel;
                                if (this.nestingLevel > 0 || !this.isControlBlock(result)) break;
                                return result.toString().trim();
                            }
                            case HYPHEN: {
                                if (result.toString().trim().length() == 0) {
                                    this.state = State.HYPHEN;
                                    break block1;
                                }
                                result.append("-");
                                break block1;
                            }
                            case POUND: {
                                if (result.toString().trim().length() == 0) {
                                    this.state = State.SINGLE_LINE_COMMENT;
                                    break block1;
                                }
                                result.append("#");
                                break block1;
                            }
                            case SLASH: {
                                this.state = State.SLASH;
                                break block1;
                            }
                            case STRING_ESCAPE: 
                            case ASTERISK: {
                                result.append(c);
                                break block1;
                            }
                            case SEPARATOR: 
                            case NEW_LINE: {
                                if (this.nestingLevel <= 0) {
                                    this.state = State.TEXT;
                                    return result.toString().trim();
                                }
                                result.append("\n");
                                break block1;
                            }
                            case EOF: {
                                this.state = State.TEXT;
                                return result.toString().trim();
                            }
                        }
                        break;
                    }
                    case SINGLE_QUOTE_STRING: {
                        if (symbol == Symbol.EOF) {
                            return result.toString().trim();
                        }
                        if (symbol == Symbol.STRING_ESCAPE) {
                            this.state = State.ESCAPING_IN_SINGLE_QUOTE_STRING;
                            break;
                        }
                        if (symbol == Symbol.SINGLE_QUOTE) {
                            this.state = State.TEXT;
                        }
                        result.append(c);
                        break;
                    }
                    case DOUBLE_QUOTE_STRING: {
                        if (symbol == Symbol.EOF) {
                            return result.toString().trim();
                        }
                        if (symbol == Symbol.STRING_ESCAPE) {
                            this.state = State.ESCAPING_IN_DOUBLE_QUOTE_STRING;
                            break;
                        }
                        if (symbol == Symbol.DOUBLE_QUOTE) {
                            this.state = State.TEXT;
                        }
                        result.append(c);
                        break;
                    }
                    case SINGLE_LINE_COMMENT: {
                        if (symbol != Symbol.NEW_LINE && symbol != Symbol.EOF) continue block27;
                        this.state = State.TEXT;
                        return result.toString();
                    }
                    case MULTI_LINE_COMMENT: {
                        if (symbol == Symbol.EOF) {
                            return result.toString();
                        }
                        if (symbol != Symbol.ASTERISK) break;
                        this.state = State.CLOSING_ASTERISK;
                        break;
                    }
                    case HYPHEN: {
                        if (symbol == Symbol.EOF) {
                            this.state = State.TEXT;
                            result.append("-");
                            return result.toString().trim();
                        }
                        if (symbol == Symbol.HYPHEN) {
                            this.state = State.SINGLE_LINE_COMMENT;
                            break;
                        }
                        result.append("-");
                        result.append(c);
                        this.state = State.TEXT;
                        break;
                    }
                    case SLASH: {
                        if (symbol == Symbol.EOF) {
                            result.append("/");
                            return result.toString().trim();
                        }
                        if (symbol == Symbol.ASTERISK) {
                            this.state = State.MULTI_LINE_COMMENT;
                            break;
                        }
                        this.state = State.TEXT;
                        result.append("/");
                        result.append(c);
                        break;
                    }
                    case CLOSING_ASTERISK: {
                        if (symbol == Symbol.EOF) {
                            return result.toString().trim();
                        }
                        if (symbol != Symbol.SLASH) break;
                        this.state = State.TEXT;
                        break;
                    }
                    case ESCAPING_IN_SINGLE_QUOTE_STRING: {
                        if (symbol == Symbol.EOF) {
                            result.append('\\');
                            return result.toString().trim();
                        }
                        result.append('\\');
                        result.append(c);
                        this.state = State.SINGLE_QUOTE_STRING;
                        break;
                    }
                    case ESCAPING_IN_DOUBLE_QUOTE_STRING: {
                        if (symbol == Symbol.EOF) {
                            result.append('\\');
                            return result.toString().trim();
                        }
                        result.append('\\');
                        result.append(c);
                        this.state = State.DOUBLE_QUOTE_STRING;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isControlBlock(StringBuilder result) {
        String cmd = result.toString().trim();
        if (cmd.length() < 6) {
            return false;
        }
        if (cmd.substring(0, 6).equalsIgnoreCase("if ")) {
            return true;
        }
        if (cmd.substring(0, 6).equalsIgnoreCase("foreach ")) {
            return true;
        }
        return cmd.substring(0, 6).equalsIgnoreCase("while ");
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Symbol symbol(Character c) {
        if (c == null) {
            return Symbol.EOF;
        }
        if (c.equals(Character.valueOf('\''))) {
            return Symbol.SINGLE_QUOTE;
        }
        if (c.equals(Character.valueOf('\"'))) {
            return Symbol.DOUBLE_QUOTE;
        }
        if (c.equals(Character.valueOf('-'))) {
            return Symbol.HYPHEN;
        }
        if (c.equals(Character.valueOf('#'))) {
            return Symbol.POUND;
        }
        if (c.equals(Character.valueOf('/'))) {
            return Symbol.SLASH;
        }
        if (c.equals(Character.valueOf('*'))) {
            return Symbol.ASTERISK;
        }
        if (c.equals(Character.valueOf(';'))) {
            return Symbol.SEPARATOR;
        }
        if (c.equals(Character.valueOf('{'))) {
            return Symbol.LEFT_BRACKET;
        }
        if (c.equals(Character.valueOf('}'))) {
            return Symbol.RIGHT_BRAKET;
        }
        if (c.equals(Character.valueOf('\n')) || c.equals(Character.valueOf('\r'))) {
            return Symbol.NEW_LINE;
        }
        if (c.equals(Character.valueOf('\\'))) {
            return Symbol.STRING_ESCAPE;
        }
        return Symbol.LETTER;
    }

    private static enum Symbol {
        LETTER,
        DOUBLE_QUOTE,
        SINGLE_QUOTE,
        HYPHEN,
        POUND,
        SLASH,
        ASTERISK,
        SEPARATOR,
        NEW_LINE,
        STRING_ESCAPE,
        LEFT_BRACKET,
        RIGHT_BRAKET,
        EOF;

    }

    private static enum State {
        TEXT,
        SINGLE_QUOTE_STRING,
        DOUBLE_QUOTE_STRING,
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT,
        HYPHEN,
        SLASH,
        CLOSING_ASTERISK,
        ESCAPING_IN_SINGLE_QUOTE_STRING,
        ESCAPING_IN_DOUBLE_QUOTE_STRING;

    }
}

