/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.hash;

public class OMurmurHash3 {
    static long getblock(byte[] key, int i) {
        return (long)key[i + 0] & 0xFFL | ((long)key[i + 1] & 0xFFL) << 8 | ((long)key[i + 2] & 0xFFL) << 16 | ((long)key[i + 3] & 0xFFL) << 24 | ((long)key[i + 4] & 0xFFL) << 32 | ((long)key[i + 5] & 0xFFL) << 40 | ((long)key[i + 6] & 0xFFL) << 48 | ((long)key[i + 7] & 0xFFL) << 56;
    }

    static void bmix(State state) {
        State state2 = state;
        state2.k1 = state2.k1 * state.c1;
        state.k1 = state.k1 << 23 | state.k1 >>> 41;
        state2 = state;
        state2.k1 = state2.k1 * state.c2;
        state2 = state;
        state2.h1 = state2.h1 ^ state.k1;
        state2 = state;
        state2.h1 = state2.h1 + state.h2;
        state.h2 = state.h2 << 41 | state.h2 >>> 23;
        state2 = state;
        state2.k2 = state2.k2 * state.c2;
        state.k2 = state.k2 << 23 | state.k2 >>> 41;
        state2 = state;
        state2.k2 = state2.k2 * state.c1;
        state2 = state;
        state2.h2 = state2.h2 ^ state.k2;
        state2 = state;
        state2.h2 = state2.h2 + state.h1;
        state.h1 = state.h1 * 3L + 1390208809L;
        state.h2 = state.h2 * 3L + 944331445L;
        state.c1 = state.c1 * 5L + 2071795100L;
        state.c2 = state.c2 * 5L + 1808688022L;
    }

    static long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static long murmurHash3_x64_64(byte[] key, int seed) {
        State state;
        State state2 = new State();
        state2.h1 = 0x9368E53C2F6AF274L ^ (long)seed;
        state2.h2 = 0x586DCD208F7CD3FDL ^ (long)seed;
        state2.c1 = -8663945395140668459L;
        state2.c2 = 5545529020109919103L;
        for (int i = 0; i < key.length / 16; ++i) {
            state2.k1 = OMurmurHash3.getblock(key, i * 2 * 8);
            state2.k2 = OMurmurHash3.getblock(key, (i * 2 + 1) * 8);
            OMurmurHash3.bmix(state2);
        }
        state2.k1 = 0L;
        state2.k2 = 0L;
        int tail = key.length >>> 4 << 4;
        switch (key.length & 0xF) {
            case 15: {
                state = state2;
                state.k2 = state.k2 ^ (long)key[tail + 14] << 48;
            }
            case 14: {
                state = state2;
                state.k2 = state.k2 ^ (long)key[tail + 13] << 40;
            }
            case 13: {
                state = state2;
                state.k2 = state.k2 ^ (long)key[tail + 12] << 32;
            }
            case 12: {
                state = state2;
                state.k2 = state.k2 ^ (long)key[tail + 11] << 24;
            }
            case 11: {
                state = state2;
                state.k2 = state.k2 ^ (long)key[tail + 10] << 16;
            }
            case 10: {
                state = state2;
                state.k2 = state.k2 ^ (long)key[tail + 9] << 8;
            }
            case 9: {
                state = state2;
                state.k2 = state.k2 ^ (long)key[tail + 8];
            }
            case 8: {
                state = state2;
                state.k1 = state.k1 ^ (long)key[tail + 7] << 56;
            }
            case 7: {
                state = state2;
                state.k1 = state.k1 ^ (long)key[tail + 6] << 48;
            }
            case 6: {
                state = state2;
                state.k1 = state.k1 ^ (long)key[tail + 5] << 40;
            }
            case 5: {
                state = state2;
                state.k1 = state.k1 ^ (long)key[tail + 4] << 32;
            }
            case 4: {
                state = state2;
                state.k1 = state.k1 ^ (long)key[tail + 3] << 24;
            }
            case 3: {
                state = state2;
                state.k1 = state.k1 ^ (long)key[tail + 2] << 16;
            }
            case 2: {
                state = state2;
                state.k1 = state.k1 ^ (long)key[tail + 1] << 8;
            }
            case 1: {
                state = state2;
                state.k1 = state.k1 ^ (long)key[tail + 0];
                OMurmurHash3.bmix(state2);
            }
        }
        state = state2;
        state.h2 = state.h2 ^ (long)key.length;
        state = state2;
        state.h1 = state.h1 + state2.h2;
        state = state2;
        state.h2 = state.h2 + state2.h1;
        state2.h1 = OMurmurHash3.fmix(state2.h1);
        state2.h2 = OMurmurHash3.fmix(state2.h2);
        state = state2;
        state.h1 = state.h1 + state2.h2;
        state = state2;
        state.h2 = state.h2 + state2.h1;
        return state2.h1;
    }

    private static class State {
        private long h1;
        private long h2;
        private long k1;
        private long k2;
        private long c1;
        private long c2;

        private State() {
        }
    }
}

