/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class OBinaryTypeSerializer
implements OBinarySerializer<byte[]> {
    public static final OBinaryTypeSerializer INSTANCE = new OBinaryTypeSerializer();
    public static final byte ID = 17;

    public int getObjectSize(int length) {
        return length + 4;
    }

    @Override
    public int getObjectSize(byte[] object, Object ... hints) {
        return object.length + 4;
    }

    @Override
    public void serialize(byte[] object, byte[] stream, int startPosition, Object ... hints) {
        int len = object.length;
        OIntegerSerializer.INSTANCE.serializeLiteral(len, stream, startPosition);
        System.arraycopy(object, 0, stream, startPosition + 4, len);
    }

    @Override
    public byte[] deserialize(byte[] stream, int startPosition) {
        int len = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition);
        return Arrays.copyOfRange(stream, startPosition + 4, startPosition + 4 + len);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition) + 4;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition) + 4;
    }

    @Override
    public void serializeNativeObject(byte[] object, byte[] stream, int startPosition, Object ... hints) {
        int len = object.length;
        OIntegerSerializer.INSTANCE.serializeNative(len, stream, startPosition, hints);
        System.arraycopy(object, 0, stream, startPosition + 4, len);
    }

    @Override
    public byte[] deserializeNativeObject(byte[] stream, int startPosition) {
        int len = OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition);
        return Arrays.copyOfRange(stream, startPosition + 4, startPosition + 4 + len);
    }

    @Override
    public byte getId() {
        return 17;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }

    @Override
    public byte[] preprocess(byte[] value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(byte[] object, ByteBuffer buffer, Object ... hints) {
        int len = object.length;
        buffer.putInt(len);
        buffer.put(object);
    }

    @Override
    public byte[] deserializeFromByteBufferObject(ByteBuffer buffer) {
        int len = buffer.getInt();
        byte[] result = new byte[len];
        buffer.get(result);
        return result;
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return buffer.getInt() + 4;
    }

    @Override
    public byte[] deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        int len = walChanges.getIntValue(buffer, offset);
        return walChanges.getBinaryValue(buffer, offset += 4, len);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return walChanges.getIntValue(buffer, offset) + 4;
    }
}

