/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OFloatSerializer
implements OBinarySerializer<Float> {
    public static final byte ID = 7;
    public static final int FLOAT_SIZE = 4;
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static final OFloatSerializer INSTANCE = new OFloatSerializer();

    @Override
    public int getObjectSize(Float object, Object ... hints) {
        return 4;
    }

    @Override
    public void serialize(Float object, byte[] stream, int startPosition, Object ... hints) {
        OIntegerSerializer.INSTANCE.serializeLiteral(Float.floatToIntBits(object.floatValue()), stream, startPosition);
    }

    @Override
    public Float deserialize(byte[] stream, int startPosition) {
        return Float.valueOf(Float.intBitsToFloat(OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition)));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 4;
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 4;
    }

    @Override
    public void serializeNativeObject(Float object, byte[] stream, int startPosition, Object ... hints) {
        OFloatSerializer.checkBoundaries(stream, startPosition);
        CONVERTER.putInt(stream, startPosition, Float.floatToIntBits(object.floatValue()), ByteOrder.nativeOrder());
    }

    @Override
    public Float deserializeNativeObject(byte[] stream, int startPosition) {
        OFloatSerializer.checkBoundaries(stream, startPosition);
        return Float.valueOf(Float.intBitsToFloat(CONVERTER.getInt(stream, startPosition, ByteOrder.nativeOrder())));
    }

    public void serializeNative(float object, byte[] stream, int startPosition, Object ... hints) {
        OFloatSerializer.checkBoundaries(stream, startPosition);
        CONVERTER.putInt(stream, startPosition, Float.floatToIntBits(object), ByteOrder.nativeOrder());
    }

    public float deserializeNative(byte[] stream, int startPosition) {
        OFloatSerializer.checkBoundaries(stream, startPosition);
        return Float.intBitsToFloat(CONVERTER.getInt(stream, startPosition, ByteOrder.nativeOrder()));
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 4;
    }

    @Override
    public Float preprocess(Float value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(Float object, ByteBuffer buffer, Object ... hints) {
        buffer.putInt(Float.floatToIntBits(object.floatValue()));
    }

    @Override
    public Float deserializeFromByteBufferObject(ByteBuffer buffer) {
        return Float.valueOf(Float.intBitsToFloat(buffer.getInt()));
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return 4;
    }

    @Override
    public Float deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return Float.valueOf(Float.intBitsToFloat(walChanges.getIntValue(buffer, offset)));
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return 4;
    }

    private static void checkBoundaries(byte[] stream, int startPosition) {
        if (startPosition + 4 > stream.length) {
            throw new IllegalStateException("Requested stream size is " + (startPosition + 4) + " but provided stream has size " + stream.length);
        }
    }
}

