/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OBatchOperationsResponse;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OBatchOperationsRequest
implements OBinaryRequest<OBatchOperationsResponse> {
    private ORecordSerializerNetworkV37 serializer = ORecordSerializerNetworkV37.INSTANCE;
    private int txId;
    private List<ORecordOperationRequest> operations;

    public OBatchOperationsRequest(int txId, Iterable<ORecordOperation> operations) {
        this.txId = txId;
        ArrayList<ORecordOperationRequest> netOperations = new ArrayList<ORecordOperationRequest>();
        for (ORecordOperation txEntry : operations) {
            if (txEntry.type == 0) continue;
            ORecordOperationRequest request = new ORecordOperationRequest();
            request.setType(txEntry.type);
            request.setVersion(txEntry.getRecord().getVersion());
            request.setId(txEntry.getRecord().getIdentity());
            request.setRecordType(ORecordInternal.getRecordType(txEntry.getRecord()));
            switch (txEntry.type) {
                case 1: 
                case 3: {
                    request.setRecord(this.serializer.toStream(txEntry.getRecord()));
                    request.setContentChanged(ORecordInternal.isContentChanged(txEntry.getRecord()));
                }
            }
            netOperations.add(request);
        }
        this.operations = netOperations;
    }

    public OBatchOperationsRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeInt(this.txId);
        for (ORecordOperationRequest txEntry : this.operations) {
            network.writeByte((byte)1);
            OMessageHelper.writeTransactionEntry(network, txEntry, this.serializer);
        }
        network.writeByte((byte)0);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        byte hasEntry;
        this.txId = channel.readInt();
        this.operations = new ArrayList<ORecordOperationRequest>();
        do {
            if ((hasEntry = channel.readByte()) != 1) continue;
            ORecordOperationRequest entry = OMessageHelper.readTransactionEntry(channel, serializer);
            this.operations.add(entry);
        } while (hasEntry == 1);
    }

    @Override
    public byte getCommand() {
        return 35;
    }

    @Override
    public OBatchOperationsResponse createResponse() {
        return new OBatchOperationsResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeBatchOperations(this);
    }

    @Override
    public String getDescription() {
        return "Batch Request for Create/Update/Delete";
    }

    public List<ORecordOperationRequest> getOperations() {
        return this.operations;
    }

    public int getTxId() {
        return this.txId;
    }
}

