/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryAsyncRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OCleanOutRecordResponse;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OCleanOutRecordRequest
implements OBinaryAsyncRequest<OCleanOutRecordResponse> {
    private int recordVersion;
    private ORecordId recordId;
    private byte mode;

    public OCleanOutRecordRequest() {
    }

    public OCleanOutRecordRequest(int recordVersion, ORecordId recordId) {
        this.recordVersion = recordVersion;
        this.recordId = recordId;
    }

    @Override
    public byte getCommand() {
        return 38;
    }

    @Override
    public String getDescription() {
        return "Clean out record";
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.recordId = channel.readRID();
        this.recordVersion = channel.readVersion();
        this.mode = channel.readByte();
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeRID(this.recordId);
        network.writeVersion(this.recordVersion);
        network.writeByte(this.mode);
    }

    @Override
    public byte getMode() {
        return this.mode;
    }

    public ORecordId getRecordId() {
        return this.recordId;
    }

    public int getRecordVersion() {
        return this.recordVersion;
    }

    @Override
    public void setMode(byte mode) {
        this.mode = mode;
    }

    @Override
    public OCleanOutRecordResponse createResponse() {
        return new OCleanOutRecordResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeCleanOutRecord(this);
    }
}

