/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.resource.OPartitionedObjectPool;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OContextVariableResolver;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandExecutorUtility;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OTemporaryRidGenerator;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.sql.parser.OIfStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.ParseException;
import com.orientechnologies.orient.core.sql.query.OLegacyResultSet;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class OCommandExecutorScript
extends OCommandExecutorAbstract
implements OCommandDistributedReplicateRequest,
OTemporaryRidGenerator {
    private static final int MAX_DELAY = 100;
    protected OCommandScript request;
    protected OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE executionMode = OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    protected AtomicInteger serialTempRID = new AtomicInteger(0);

    public OCommandExecutorScript parse(OCommandRequest iRequest) {
        this.request = (OCommandScript)iRequest;
        this.executionMode = ((OCommandScript)iRequest).getExecutionMode();
        return this;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return this.executionMode;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.context == null) {
            this.context = new OBasicCommandContext();
        }
        return this.executeInContext(this.context, iArgs);
    }

    public Object executeInContext(OCommandContext iContext, Map<Object, Object> iArgs) {
        String language = this.request.getLanguage();
        this.parserText = this.request.getText();
        this.parameters = iArgs;
        this.parameters = iArgs;
        if (language.equalsIgnoreCase("SQL")) {
            try {
                this.parserText = this.preParse(this.parserText, iArgs);
            }
            catch (ParseException e) {
                throw OException.wrapException(new OCommandExecutionException("Invalid script:" + e.getMessage()), e);
            }
            return this.executeSQL();
        }
        return this.executeJsr223Script(language, iContext, iArgs);
    }

    private String preParse(String parserText, Map<Object, Object> iArgs) throws ParseException {
        boolean strict = OCommandExecutorScript.getDatabase().getStorage().getConfiguration().isStrictSql();
        if (strict) {
            byte[] bytes;
            parserText = this.addSemicolons(parserText);
            ODatabaseDocumentInternal db = OCommandExecutorScript.getDatabase();
            try {
                bytes = db == null ? parserText.getBytes() : parserText.getBytes(OCommandExecutorScript.getDatabase().getStorage().getConfiguration().getCharset());
            }
            catch (UnsupportedEncodingException e) {
                OLogManager.instance().warn((Object)this, "Invalid charset for database " + OCommandExecutorScript.getDatabase() + " " + OCommandExecutorScript.getDatabase().getStorage().getConfiguration().getCharset(), new Object[0]);
                bytes = parserText.getBytes();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            OrientSql osql = null;
            try {
                osql = db == null ? new OrientSql(is) : new OrientSql(is, db.getStorage().getConfiguration().getCharset());
            }
            catch (UnsupportedEncodingException e) {
                OLogManager.instance().warn((Object)this, "Invalid charset for database " + OCommandExecutorScript.getDatabase() + " " + OCommandExecutorScript.getDatabase().getStorage().getConfiguration().getCharset(), new Object[0]);
                osql = new OrientSql(is);
            }
            List<OStatement> statements = osql.parseScript();
            StringBuilder result = new StringBuilder();
            for (OStatement stm : statements) {
                stm.toString(iArgs, result);
                if (!(stm instanceof OIfStatement)) {
                    result.append(";");
                }
                result.append("\n");
            }
            return result.toString();
        }
        return parserText;
    }

    private String addSemicolons(String parserText) {
        String[] rows = parserText.split("\n");
        StringBuilder builder = new StringBuilder();
        for (String row : rows) {
            row = row.trim();
            builder.append(row);
            if (!row.endsWith(";") && !row.endsWith("{")) {
                builder.append(";");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    /*
     * Loose catch block
     */
    protected Object executeJsr223Script(String language, OCommandContext iContext, Map<Object, Object> iArgs) {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        OScriptManager scriptManager = db.getSharedContext().getOrientDB().getScriptManager();
        CompiledScript compiledScript = this.request.getCompiledScript();
        OPartitionedObjectPool.PoolEntry<ScriptEngine> entry = scriptManager.acquireDatabaseEngine(db.getName(), language);
        ScriptEngine scriptEngine = (ScriptEngine)entry.object;
        try {
            if (compiledScript == null) {
                if (!(scriptEngine instanceof Compilable)) {
                    throw new OCommandExecutionException("Language '" + language + "' does not support compilation");
                }
                Compilable c = (Compilable)((Object)scriptEngine);
                try {
                    compiledScript = c.compile(this.parserText);
                }
                catch (ScriptException e) {
                    scriptManager.throwErrorMessage(e, this.parserText);
                }
                this.request.setCompiledScript(compiledScript);
            }
            Bindings binding = scriptManager.bind(scriptEngine, compiledScript.getEngine().getBindings(100), db, iContext, iArgs);
            try {
                Object ob = compiledScript.eval(binding);
                Object object = OCommandExecutorUtility.transformResult(ob);
                return object;
            }
            catch (ScriptException e) {
                throw OException.wrapException(new OCommandScriptException("Error on execution of the script", this.request.getText(), e.getColumnNumber()), e);
            }
            finally {
                scriptManager.unbind(scriptEngine, binding, iContext, iArgs);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            scriptManager.releaseDatabaseEngine(language, db.getName(), entry);
        }
    }

    protected Object executeSQL() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            return this.executeSQLScript(this.parserText, db);
        }
        catch (IOException e) {
            throw OException.wrapException(new OCommandExecutionException("Error on executing command: " + this.parserText), e);
        }
    }

    @Override
    protected void throwSyntaxErrorException(String iText) {
        throw new OCommandScriptException("Error on execution of the script: " + iText, this.request.getText(), 0);
    }

    protected Object executeSQLScript(String iText, ODatabaseDocument db) throws IOException {
        Object lastResult = null;
        int maxRetry = 1;
        this.context.setVariable("transactionRetries", 0);
        this.context.setVariable("parentQuery", this);
        block7: for (int retry = 1; retry <= maxRetry; ++retry) {
            try {
                try {
                    String lastLine;
                    int line;
                    int txBegunAtLine = -1;
                    int txBegunAtPart = -1;
                    lastResult = null;
                    int nestedLevel = 0;
                    int skippingScriptsAtNestedLevel = -1;
                    BufferedReader reader = new BufferedReader(new StringReader(iText));
                    int linePart = 0;
                    boolean txBegun = false;
                    for (line = 0; line < txBegunAtLine; ++line) {
                        reader.readLine();
                    }
                    while ((lastLine = reader.readLine()) != null) {
                        lastLine = lastLine.trim();
                        List<String> lineParts = this.splitBySemicolon(lastLine);
                        boolean breakReturn = false;
                        for (linePart = line == txBegunAtLine ? txBegunAtPart : 0; linePart < lineParts.size(); ++linePart) {
                            String lastCommand = lineParts.get(linePart);
                            if (this.isIfCondition(lastCommand)) {
                                boolean ifResult;
                                ++nestedLevel;
                                if (skippingScriptsAtNestedLevel >= 0 || (ifResult = this.evaluateIfCondition(lastCommand))) continue;
                                skippingScriptsAtNestedLevel = nestedLevel;
                                continue;
                            }
                            if (lastCommand.equals("}")) {
                                if (skippingScriptsAtNestedLevel <= --nestedLevel) continue;
                                skippingScriptsAtNestedLevel = -1;
                                continue;
                            }
                            if (skippingScriptsAtNestedLevel >= 0) continue;
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "let ")) {
                                lastResult = this.executeLet(lastCommand, db);
                                continue;
                            }
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "begin")) {
                                String next;
                                if (txBegun) {
                                    throw new OCommandSQLParsingException("Transaction already begun");
                                }
                                if (db.getTransaction().isActive()) {
                                    db.commit();
                                }
                                txBegun = true;
                                txBegunAtLine = line;
                                txBegunAtPart = linePart;
                                db.begin();
                                if (lastCommand.length() <= "begin ".length() || !OStringSerializerHelper.startsWithIgnoreCase(next = lastCommand.substring("begin ".length()).trim(), "isolation ")) continue;
                                next = next.substring("isolation ".length()).trim();
                                db.getTransaction().setIsolationLevel(OTransaction.ISOLATION_LEVEL.valueOf(next.toUpperCase(Locale.ENGLISH)));
                                continue;
                            }
                            if ("rollback".equalsIgnoreCase(lastCommand)) {
                                if (!txBegun) {
                                    throw new OCommandSQLParsingException("Transaction not begun");
                                }
                                db.rollback();
                                txBegun = false;
                                txBegunAtLine = -1;
                                txBegunAtPart = -1;
                                continue;
                            }
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "commit")) {
                                String next;
                                if (txBegunAtLine < 0) {
                                    throw new OCommandSQLParsingException("Transaction not begun");
                                }
                                if (retry == 1 && lastCommand.length() > "commit ".length() && OStringSerializerHelper.startsWithIgnoreCase(next = lastCommand.substring("commit ".length()).trim(), "retry ")) {
                                    next = next.substring("retry ".length()).trim();
                                    maxRetry = Integer.parseInt(next);
                                }
                                db.commit();
                                txBegun = false;
                                txBegunAtLine = -1;
                                txBegunAtPart = -1;
                                continue;
                            }
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "sleep ")) {
                                this.executeSleep(lastCommand);
                                continue;
                            }
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "console.log ")) {
                                this.executeConsoleLog(lastCommand, db);
                                continue;
                            }
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "console.output ")) {
                                this.executeConsoleOutput(lastCommand, db);
                                continue;
                            }
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "console.error ")) {
                                this.executeConsoleError(lastCommand, db);
                                continue;
                            }
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "return ")) {
                                lastResult = this.getValue(lastCommand.substring("return ".length()), db);
                                breakReturn = true;
                                break;
                            }
                            if (lastCommand == null || lastCommand.length() <= 0) continue;
                            lastResult = this.executeCommand(lastCommand, db);
                        }
                        if (!breakReturn) {
                            ++line;
                            continue;
                        }
                        break block7;
                    }
                    break;
                }
                catch (RuntimeException ex) {
                    if (db.getTransaction().isActive()) {
                        db.rollback();
                    }
                    throw ex;
                }
            }
            catch (OTransactionException e) {
                this.context.setVariable("retries", retry);
                OCommandExecutorScript.getDatabase().getLocalCache().clear();
                if (retry >= maxRetry) {
                    throw e;
                }
                this.waitForNextRetry();
                continue;
            }
            catch (ORecordDuplicatedException e) {
                this.context.setVariable("retries", retry);
                OCommandExecutorScript.getDatabase().getLocalCache().clear();
                if (retry >= maxRetry) {
                    throw e;
                }
                this.waitForNextRetry();
                continue;
            }
            catch (ORecordNotFoundException e) {
                this.context.setVariable("retries", retry);
                OCommandExecutorScript.getDatabase().getLocalCache().clear();
                if (retry < maxRetry) continue;
                throw e;
            }
            catch (ONeedRetryException e) {
                this.context.setVariable("retries", retry);
                OCommandExecutorScript.getDatabase().getLocalCache().clear();
                if (retry >= maxRetry) {
                    throw e;
                }
                this.waitForNextRetry();
            }
        }
        return lastResult;
    }

    private List<String> splitBySemicolon(String lastLine) {
        if (lastLine == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        Character prev = null;
        Character lastQuote = null;
        StringBuilder buffer = new StringBuilder();
        for (char c : lastLine.toCharArray()) {
            if (c == ';' && lastQuote == null) {
                if (buffer.toString().trim().length() > 0) {
                    result.add(buffer.toString().trim());
                }
                buffer = new StringBuilder();
                prev = null;
                continue;
            }
            if (!(c != '\"' && c != '\'' || prev != null && prev.equals(Character.valueOf('\\')))) {
                if (lastQuote != null && lastQuote.equals(Character.valueOf(c))) {
                    lastQuote = null;
                } else if (lastQuote == null) {
                    lastQuote = Character.valueOf(c);
                }
            }
            buffer.append(c);
            prev = Character.valueOf(c);
        }
        if (buffer.toString().trim().length() > 0) {
            result.add(buffer.toString().trim());
        }
        return result;
    }

    private boolean evaluateIfCondition(String lastCommand) {
        String cmd = lastCommand;
        cmd = cmd.trim().substring(2);
        cmd = cmd.trim().substring(0, cmd.trim().length() - 1);
        OSQLFilter condition = OSQLEngine.getInstance().parseCondition(cmd, this.getContext(), "IF");
        Object result = null;
        try {
            result = condition.evaluate(null, null, this.getContext());
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Could not evaluate IF condition: " + cmd + " - " + e.getMessage()), e);
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isIfCondition(String iCommand) {
        if (iCommand == null) {
            return false;
        }
        String cmd = iCommand.trim();
        if (cmd.length() < 3) {
            return false;
        }
        if (!OStringSerializerHelper.startsWithIgnoreCase(cmd, "if ") && !OStringSerializerHelper.startsWithIgnoreCase(cmd, "if(")) {
            return false;
        }
        return cmd.endsWith("{");
    }

    protected void waitForNextRetry() {
        try {
            Thread.sleep(new Random().nextInt(99) + 1);
        }
        catch (InterruptedException e) {
            OLogManager.instance().error(this, "Wait was interrupted", e, new Object[0]);
        }
    }

    private Object executeCommand(String lastCommand, ODatabaseDocument db) {
        OCommandSQL command = new OCommandSQL(lastCommand);
        Object result = db.command(command.setContext(this.getContext())).execute(this.toMap(this.parameters));
        this.request.setFetchPlan(command.getFetchPlan());
        return result;
    }

    private Object toMap(Object parameters) {
        if (parameters instanceof SimpleBindings) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.putAll((SimpleBindings)parameters);
            return result;
        }
        return parameters;
    }

    private Object getValue(String iValue, ODatabaseDocument db) {
        Object lastResult = null;
        boolean recordResultSet = true;
        if (iValue.equalsIgnoreCase("NULL")) {
            lastResult = null;
        } else if (iValue.startsWith("[") && iValue.endsWith("]")) {
            ArrayList<String> items = new ArrayList<String>();
            OStringSerializerHelper.getCollection(iValue, 0, items);
            ArrayList<Object> result = new ArrayList<Object>(items.size());
            for (int i = 0; i < items.size(); ++i) {
                String item = (String)items.get(i);
                result.add(this.getValue(item, db));
            }
            lastResult = result;
            this.checkIsRecordResultSet(lastResult);
        } else if (iValue.startsWith("{") && iValue.endsWith("}")) {
            Map<String, String> map = OStringSerializerHelper.getMap(iValue);
            HashMap<Object, Object> result = new HashMap<Object, Object>(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String stringValue;
                String stringKey = entry.getKey();
                if (stringKey == null) continue;
                Object key = (stringKey = stringKey.trim()).startsWith("$") ? this.getContext().getVariable(stringKey) : stringKey;
                if (OMultiValue.isMultiValue(key) && OMultiValue.getSize(key) == 1) {
                    key = OMultiValue.getFirstValue(key);
                }
                if ((stringValue = entry.getValue()) == null) continue;
                Object value = (stringValue = stringValue.trim()).toString().startsWith("$") ? this.getContext().getVariable(stringValue) : stringValue;
                result.put(key, value);
            }
            lastResult = result;
            this.checkIsRecordResultSet(lastResult);
        } else if (iValue.startsWith("\"") && iValue.endsWith("\"") || iValue.startsWith("'") && iValue.endsWith("'")) {
            lastResult = new OContextVariableResolver(this.context).parse(OIOUtils.getStringContent(iValue));
            this.checkIsRecordResultSet(lastResult);
        } else {
            lastResult = iValue.startsWith("(") && iValue.endsWith(")") ? this.executeCommand(iValue, db) : new OSQLPredicate(iValue).evaluate(this.context);
        }
        return lastResult;
    }

    private void checkIsRecordResultSet(Object result) {
        if (!(result instanceof OIdentifiable) && !(result instanceof OLegacyResultSet)) {
            if (!OMultiValue.isMultiValue(result)) {
                this.request.setRecordResultSet(false);
            } else {
                for (Object val : OMultiValue.getMultiValueIterable(result)) {
                    if (val instanceof OIdentifiable) continue;
                    this.request.setRecordResultSet(false);
                }
            }
        }
    }

    private void executeSleep(String lastCommand) {
        String sleepTimeInMs = lastCommand.substring("sleep ".length()).trim();
        try {
            Thread.sleep(Integer.parseInt(sleepTimeInMs));
        }
        catch (InterruptedException e) {
            OLogManager.instance().debug((Object)this, "Sleep was interrupted in SQL batch", e, new Object[0]);
        }
    }

    private void executeConsoleLog(String lastCommand, ODatabaseDocument db) {
        String value = lastCommand.substring("console.log ".length()).trim();
        OLogManager.instance().info((Object)this, "%s", this.getValue(OIOUtils.wrapStringContent(value, '\''), db));
    }

    private void executeConsoleOutput(String lastCommand, ODatabaseDocument db) {
        String value = lastCommand.substring("console.output ".length()).trim();
        System.out.println(this.getValue(OIOUtils.wrapStringContent(value, '\''), db));
    }

    private void executeConsoleError(String lastCommand, ODatabaseDocument db) {
        String value = lastCommand.substring("console.error ".length()).trim();
        System.err.println(this.getValue(OIOUtils.wrapStringContent(value, '\''), db));
    }

    private Object executeLet(String lastCommand, ODatabaseDocument db) {
        int equalsPos = lastCommand.indexOf(61);
        String variable = lastCommand.substring("let ".length(), equalsPos).trim();
        String cmd = lastCommand.substring(equalsPos + 1).trim();
        if (cmd == null) {
            return null;
        }
        Object lastResult = null;
        lastResult = cmd.equalsIgnoreCase("NULL") || cmd.startsWith("$") || cmd.startsWith("[") && cmd.endsWith("]") || cmd.startsWith("{") && cmd.endsWith("}") || cmd.startsWith("\"") && cmd.endsWith("\"") || cmd.startsWith("'") && cmd.endsWith("'") || cmd.startsWith("(") && cmd.endsWith(")") || cmd.startsWith("#") ? this.getValue(cmd, db) : this.executeCommand(cmd, db);
        this.getContext().setVariable(variable, lastResult);
        return lastResult;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public int getTemporaryRIDCounter(OCommandContext iContext) {
        return this.serialTempRID.incrementAndGet();
    }
}

