/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.common.concur.resource.OPartitionedObjectPool;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.command.script.transformer.OScriptTransformer;
import com.orientechnologies.orient.core.command.traverse.OAbstractScriptExecutor;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class OJsr223ScriptExecutor
extends OAbstractScriptExecutor {
    private final OScriptTransformer transformer;
    private String language;

    public OJsr223ScriptExecutor(String language, OScriptTransformer scriptTransformer) {
        super(language);
        this.language = language;
        this.transformer = scriptTransformer;
    }

    @Override
    public OResultSet execute(ODatabaseDocumentInternal database, String script, Object ... params) {
        this.preExecute(database, script, params);
        HashMap<Integer, Object> par = new HashMap<Integer, Object>();
        for (int i = 0; i < params.length; ++i) {
            par.put(i, params[i]);
        }
        return this.execute(database, script, par);
    }

    /*
     * Loose catch block
     */
    @Override
    public OResultSet execute(ODatabaseDocumentInternal database, String script, Map params) {
        this.preExecute(database, script, params);
        OScriptManager scriptManager = database.getSharedContext().getOrientDB().getScriptManager();
        CompiledScript compiledScript = null;
        OPartitionedObjectPool.PoolEntry<ScriptEngine> entry = scriptManager.acquireDatabaseEngine(database.getName(), this.language);
        ScriptEngine scriptEngine = (ScriptEngine)entry.object;
        try {
            if (!(scriptEngine instanceof Compilable)) {
                throw new OCommandExecutionException("Language '" + this.language + "' does not support compilation");
            }
            Compilable c = (Compilable)((Object)scriptEngine);
            try {
                compiledScript = c.compile(script);
            }
            catch (ScriptException e) {
                scriptManager.throwErrorMessage(e, script);
            }
            Bindings binding = scriptManager.bindContextVariables(compiledScript.getEngine(), compiledScript.getEngine().getBindings(100), database, null, params);
            try {
                Object ob = compiledScript.eval(binding);
                OResultSet oResultSet = this.transformer.toResultSet(ob);
                return oResultSet;
            }
            catch (ScriptException e) {
                throw OException.wrapException(new OCommandScriptException("Error on execution of the script", script, e.getColumnNumber()), e);
            }
            finally {
                scriptManager.unbind(scriptEngine, binding, null, params);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            scriptManager.releaseDatabaseEngine(this.language, database.getName(), entry);
        }
    }
}

