/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.common.concur.resource.OPartitionedObjectPool;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.common.util.OClassLoaderHelper;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OScriptExecutor;
import com.orientechnologies.orient.core.command.OScriptExecutorRegister;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.command.script.ODatabaseScriptManager;
import com.orientechnologies.orient.core.command.script.OJavascriptScriptExecutor;
import com.orientechnologies.orient.core.command.script.OJsr223ScriptExecutor;
import com.orientechnologies.orient.core.command.script.OScriptDatabaseWrapper;
import com.orientechnologies.orient.core.command.script.OScriptInjection;
import com.orientechnologies.orient.core.command.script.OScriptOrientWrapper;
import com.orientechnologies.orient.core.command.script.OScriptResultHandler;
import com.orientechnologies.orient.core.command.script.OSecuredScriptFactory;
import com.orientechnologies.orient.core.command.script.formatter.OGroovyScriptFormatter;
import com.orientechnologies.orient.core.command.script.formatter.OJSScriptFormatter;
import com.orientechnologies.orient.core.command.script.formatter.ORubyScriptFormatter;
import com.orientechnologies.orient.core.command.script.formatter.OSQLScriptFormatter;
import com.orientechnologies.orient.core.command.script.formatter.OScriptFormatter;
import com.orientechnologies.orient.core.command.script.js.OJSScriptEngineFactory;
import com.orientechnologies.orient.core.command.script.transformer.OScriptTransformerImpl;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.function.OFunctionUtilWrapper;
import com.orientechnologies.orient.core.sql.OSQLScriptEngineFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class OScriptManager {
    protected static final Object[] EMPTY_PARAMS = new Object[0];
    protected static final int LINES_AROUND_ERROR = 5;
    protected static final String DEF_LANGUAGE = "javascript";
    protected String defaultLanguage = "javascript";
    protected ScriptEngineManager scriptEngineManager;
    protected Map<String, ScriptEngineFactory> engines = new HashMap<String, ScriptEngineFactory>();
    protected Map<String, OScriptFormatter> formatters = new HashMap<String, OScriptFormatter>();
    protected List<OScriptInjection> injections = new ArrayList<OScriptInjection>();
    protected ConcurrentHashMap<String, ODatabaseScriptManager> dbManagers = new ConcurrentHashMap();
    protected Map<String, OScriptResultHandler> handlers = new HashMap<String, OScriptResultHandler>();
    protected Map<String, Function<String, OScriptExecutor>> executorsFactories = new HashMap<String, Function<String, OScriptExecutor>>();
    protected OCommandManager commandManager = new OCommandManager();

    public OScriptManager() {
        this.scriptEngineManager = new ScriptEngineManager();
        this.executorsFactories.put(DEF_LANGUAGE, lang -> new OJavascriptScriptExecutor((String)lang, new OScriptTransformerImpl()));
        this.executorsFactories.put("ecmascript", lang -> new OJavascriptScriptExecutor((String)lang, new OScriptTransformerImpl()));
        for (ScriptEngineFactory f : this.scriptEngineManager.getEngineFactories()) {
            this.registerEngine(f.getLanguageName().toLowerCase(Locale.ENGLISH), f);
            if (this.defaultLanguage != null) continue;
            this.defaultLanguage = f.getLanguageName();
        }
        if (!this.existsEngine(DEF_LANGUAGE)) {
            ScriptEngine defEngine = this.scriptEngineManager.getEngineByName(DEF_LANGUAGE);
            if (defEngine == null) {
                OLogManager.instance().warnNoDb(this, "Cannot find default script language for %s", DEF_LANGUAGE);
            } else {
                this.registerEngine(DEF_LANGUAGE, defEngine.getFactory());
                this.defaultLanguage = DEF_LANGUAGE;
            }
        }
        this.registerFormatter("sql", new OSQLScriptFormatter());
        this.registerFormatter(DEF_LANGUAGE, new OJSScriptFormatter());
        this.registerFormatter("ruby", new ORubyScriptFormatter());
        this.registerFormatter("groovy", new OGroovyScriptFormatter());
        for (String lang2 : this.engines.keySet()) {
            Function<String, OScriptExecutor> factory = this.executorsFactories.get(lang2);
            OScriptExecutor executor = null;
            executor = factory != null ? factory.apply(lang2) : new OJsr223ScriptExecutor(lang2, new OScriptTransformerImpl());
            this.commandManager.registerScriptExecutor(lang2, executor);
        }
        this.registerEngine("sql", new OSQLScriptEngineFactory());
        Iterator<OScriptExecutorRegister> customExecutors = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OScriptExecutorRegister.class);
        customExecutors.forEachRemaining(e -> e.registerExecutor(this, this.commandManager));
    }

    public String getFunctionDefinition(OFunction iFunction) {
        OScriptFormatter formatter = this.formatters.get(iFunction.getLanguage().toLowerCase(Locale.ENGLISH));
        if (formatter == null) {
            throw new IllegalArgumentException("Cannot find script formatter for the language '" + iFunction.getLanguage() + "'");
        }
        return formatter.getFunctionDefinition(iFunction);
    }

    public String getFunctionInvoke(OFunction iFunction, Object[] iArgs) {
        OScriptFormatter formatter = this.formatters.get(iFunction.getLanguage().toLowerCase(Locale.ENGLISH));
        if (formatter == null) {
            throw new IllegalArgumentException("Cannot find script formatter for the language '" + iFunction.getLanguage() + "'");
        }
        return formatter.getFunctionInvoke(iFunction, iArgs);
    }

    public String getLibrary(ODatabase<?> db, String iLanguage) {
        if (db == null) {
            return null;
        }
        StringBuilder code = new StringBuilder();
        Set<String> functions = db.getMetadata().getFunctionLibrary().getFunctionNames();
        for (String fName : functions) {
            String def;
            OFunction f = db.getMetadata().getFunctionLibrary().getFunction(fName);
            if (f.getLanguage() == null) {
                throw new OConfigurationException("Database function '" + fName + "' has no language");
            }
            if (!f.getLanguage().equalsIgnoreCase(iLanguage) || (def = this.getFunctionDefinition(f)) == null) continue;
            code.append(def);
            code.append("\n");
        }
        return code.length() == 0 ? null : code.toString();
    }

    public boolean existsEngine(String iLanguage) {
        if (iLanguage == null) {
            return false;
        }
        iLanguage = iLanguage.toLowerCase(Locale.ENGLISH);
        return this.engines.containsKey(iLanguage);
    }

    public ScriptEngine getEngine(String iLanguage) {
        if (iLanguage == null) {
            throw new OCommandScriptException("No language was specified");
        }
        String lang = iLanguage.toLowerCase(Locale.ENGLISH);
        ScriptEngineFactory scriptEngineFactory = this.engines.get(lang);
        if (scriptEngineFactory == null) {
            throw new OCommandScriptException("Unsupported language: " + iLanguage + ". Supported languages are: " + this.getSupportedLanguages());
        }
        return scriptEngineFactory.getScriptEngine();
    }

    public OPartitionedObjectPool.PoolEntry<ScriptEngine> acquireDatabaseEngine(String databaseName, String language) {
        ODatabaseScriptManager prev;
        ODatabaseScriptManager dbManager = this.dbManagers.get(databaseName);
        if (dbManager == null && (prev = this.dbManagers.putIfAbsent(databaseName, dbManager = new ODatabaseScriptManager(this, databaseName))) != null) {
            dbManager.close();
            dbManager = prev;
        }
        return dbManager.acquireEngine(language);
    }

    public void releaseDatabaseEngine(String iLanguage, String iDatabaseName, OPartitionedObjectPool.PoolEntry<ScriptEngine> poolEntry) {
        ODatabaseScriptManager dbManager = this.dbManagers.get(iDatabaseName);
        if (dbManager != null) {
            dbManager.releaseEngine(iLanguage, poolEntry);
        }
    }

    public Iterable<String> getSupportedLanguages() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.engines.keySet());
        return result;
    }

    public Bindings bindContextVariables(ScriptEngine engine, Bindings binding, ODatabaseDocumentInternal db, OCommandContext iContext, Map<Object, Object> iArgs) {
        binding.put("db", (Object)new OScriptDatabaseWrapper(db));
        this.bindInjectors(engine, binding, db);
        this.bindContext(binding, iContext);
        this.bindParameters(binding, iArgs);
        return binding;
    }

    @Deprecated
    public Bindings bind(ScriptEngine scriptEngine, Bindings binding, ODatabaseDocumentInternal db, OCommandContext iContext, Map<Object, Object> iArgs) {
        this.bindLegacyDatabaseAndUtil(binding, db);
        this.bindDatabase(binding, db);
        this.bindInjectors(scriptEngine, binding, db);
        this.bindContext(binding, iContext);
        this.bindParameters(binding, iArgs);
        return binding;
    }

    private void bindInjectors(ScriptEngine engine, Bindings binding, ODatabaseDocument database) {
        for (OScriptInjection i : this.injections) {
            i.bind(engine, binding, database);
        }
    }

    private void bindContext(Bindings binding, OCommandContext iContext) {
        if (iContext != null) {
            binding.put("ctx", (Object)iContext);
            for (Map.Entry<String, Object> a : iContext.getVariables().entrySet()) {
                binding.put(a.getKey(), a.getValue());
            }
        }
    }

    private void bindLegacyDatabaseAndUtil(Bindings binding, ODatabaseDocumentInternal db) {
        if (db != null) {
            binding.put("orient", (Object)new OScriptOrientWrapper(db));
        }
        binding.put("util", (Object)new OFunctionUtilWrapper());
    }

    private void bindDatabase(Bindings binding, ODatabaseDocumentInternal db) {
        if (db != null) {
            binding.put("db", (Object)new OScriptDatabaseWrapper(db));
        }
    }

    private void bindParameters(Bindings binding, Map<Object, Object> iArgs) {
        if (iArgs != null) {
            for (Map.Entry<Object, Object> a : iArgs.entrySet()) {
                binding.put(a.getKey().toString(), a.getValue());
            }
            binding.put("params", (Object)iArgs.values().toArray());
        } else {
            binding.put("params", (Object)EMPTY_PARAMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String throwErrorMessage(ScriptException e, String lib) {
        String excMessage;
        int pos;
        int errorLineNumber = e.getLineNumber();
        if (errorLineNumber <= 0 && (pos = (excMessage = e.toString()).indexOf("<Unknown Source>#")) > -1) {
            int end = excMessage.indexOf(41, pos + "<Unknown Source>#".length());
            String lineNumberAsString = excMessage.substring(pos + "<Unknown Source>#".length(), end);
            errorLineNumber = Integer.parseInt(lineNumberAsString);
        }
        if (errorLineNumber <= 0) {
            throw new OCommandScriptException("Error on evaluation of the script library. Error: " + e.getMessage() + "\nScript library was:\n" + lib);
        }
        StringBuilder code = new StringBuilder();
        try (Scanner scanner = new Scanner(lib);){
            scanner.useDelimiter("\n");
            String currentLine = null;
            String lastFunctionName = "unknown";
            int currentLineNumber = 1;
            while (scanner.hasNext()) {
                String[] words;
                currentLine = scanner.next();
                int pos2 = currentLine.indexOf("function");
                if (pos2 > -1 && (words = OStringParser.getWords(currentLine.substring(Math.min(pos2 + "function".length() + 1, currentLine.length())), " \r\n\t")).length > 0 && words[0] != "(") {
                    lastFunctionName = words[0];
                }
                if (currentLineNumber == errorLineNumber) {
                    code.append(String.format("%4d: >>> %s\n", currentLineNumber, currentLine));
                } else if (Math.abs(currentLineNumber - errorLineNumber) <= 5) {
                    code.append(String.format("%4d: %s\n", currentLineNumber, currentLine));
                }
                ++currentLineNumber;
            }
            code.insert(0, String.format("ScriptManager: error %s.\nFunction %s:\n\n", e.getMessage(), lastFunctionName));
        }
        throw new OCommandScriptException(code.toString());
    }

    public void unbind(ScriptEngine scriptEngine, Bindings binding, OCommandContext iContext, Map<Object, Object> iArgs) {
        for (OScriptInjection oScriptInjection : this.injections) {
            oScriptInjection.unbind(scriptEngine, binding);
        }
        binding.put("db", (Object)null);
        binding.put("orient", (Object)null);
        binding.put("util", (Object)null);
        binding.put("ctx", (Object)null);
        if (iContext != null) {
            for (Map.Entry entry : iContext.getVariables().entrySet()) {
                binding.put((String)entry.getKey(), (Object)null);
            }
        }
        if (iArgs != null) {
            for (Map.Entry entry : iArgs.entrySet()) {
                binding.put(entry.getKey().toString(), (Object)null);
            }
        }
        binding.put("params", (Object)null);
    }

    public void registerInjection(OScriptInjection iInj) {
        if (!this.injections.contains(iInj)) {
            this.injections.add(iInj);
        }
    }

    public void addAllowedPackages(Set<String> packages) {
        this.engines.entrySet().forEach(e -> {
            if (e.getValue() instanceof OSecuredScriptFactory) {
                ((OSecuredScriptFactory)e.getValue()).addAllowedPackages(packages);
            }
        });
    }

    public void removeAllowedPackages(Set<String> packages) {
        this.engines.entrySet().forEach(e -> {
            if (e.getValue() instanceof OSecuredScriptFactory) {
                ((OSecuredScriptFactory)e.getValue()).removeAllowedPackages(packages);
            }
        });
    }

    public void unregisterInjection(OScriptInjection iInj) {
        this.injections.remove(iInj);
    }

    public List<OScriptInjection> getInjections() {
        return this.injections;
    }

    public OScriptManager registerEngine(String iLanguage, ScriptEngineFactory iEngine) {
        this.engines.put(iLanguage, OJSScriptEngineFactory.maybeWrap(iEngine));
        return this;
    }

    public OScriptManager registerFormatter(String iLanguage, OScriptFormatter iFormatterImpl) {
        this.formatters.put(iLanguage.toLowerCase(Locale.ENGLISH), iFormatterImpl);
        return this;
    }

    public OScriptManager registerResultHandler(String iLanguage, OScriptResultHandler resultHandler) {
        this.handlers.put(iLanguage.toLowerCase(Locale.ENGLISH), resultHandler);
        return this;
    }

    public Object handleResult(String language, Object result, ScriptEngine engine, Bindings binding, ODatabaseDocument database) {
        OScriptResultHandler handler = this.handlers.get(language);
        if (handler != null) {
            return handler.handle(result, engine, binding, database);
        }
        return result;
    }

    public Map<String, OScriptFormatter> getFormatters() {
        return this.formatters;
    }

    public void close(String iDatabaseName) {
        ODatabaseScriptManager dbPool = this.dbManagers.remove(iDatabaseName);
        if (dbPool != null) {
            dbPool.close();
        }
    }

    public void closeAll() {
        this.dbManagers.entrySet().forEach(e -> ((ODatabaseScriptManager)e.getValue()).close());
    }

    public OCommandManager getCommandManager() {
        return this.commandManager;
    }
}

