/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import java.io.Serializable;

public class OStorageSegmentConfiguration
implements Serializable {
    public transient OStorageConfiguration root;
    public volatile int id;
    public volatile String name;
    public volatile String maxSize = "0";
    public volatile String fileType = "mmap";
    public volatile String fileStartSize = "500Kb";
    public volatile String fileMaxSize = "500Mb";
    public volatile String fileIncrementSize = "50%";
    public volatile String defrag = "auto";
    public volatile STATUS status = STATUS.ONLINE;
    public OStorageFileConfiguration[] infoFiles = OCommonConst.EMPTY_FILE_CONFIGURATIONS_ARRAY;
    protected String location;

    public void setRoot(OStorageConfiguration iRoot) {
        this.root = iRoot;
        for (OStorageFileConfiguration f : this.infoFiles) {
            f.parent = this;
        }
    }

    public String getLocation() {
        if (this.location != null) {
            return this.location;
        }
        return this.root != null ? this.root.getDirectory() : null;
    }

    public static enum STATUS {
        ONLINE,
        OFFLINE;

    }
}

