/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.OCachedDatabasePoolFactory;
import com.orientechnologies.orient.core.db.ODatabasePoolImpl;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.security.OSecurityManager;
import java.util.TimerTask;

public class OCachedDatabasePoolFactoryImpl
implements OCachedDatabasePoolFactory {
    private volatile int maxPoolSize = 100;
    private volatile boolean closed;
    private final ConcurrentLinkedHashMap<String, ODatabasePoolInternal> poolCache;
    private final OrientDBInternal orientDB;
    private final long timeout;

    public OCachedDatabasePoolFactoryImpl(OrientDBInternal orientDB, int capacity, long timeout) {
        this.poolCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(capacity).listener((identity, databasePool) -> databasePool.close()).build();
        this.orientDB = orientDB;
        this.timeout = timeout;
        this.scheduleCleanUpCache(this.createCleanUpTask());
    }

    protected void scheduleCleanUpCache(TimerTask task) {
        this.orientDB.schedule(task, this.timeout, this.timeout);
    }

    private TimerTask createCleanUpTask() {
        return new TimerTask(){

            @Override
            public void run() {
                if (OCachedDatabasePoolFactoryImpl.this.closed) {
                    this.cancel();
                } else {
                    OCachedDatabasePoolFactoryImpl.this.cleanUpCache();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpCache() {
        OCachedDatabasePoolFactoryImpl oCachedDatabasePoolFactoryImpl = this;
        synchronized (oCachedDatabasePoolFactoryImpl) {
            for (ODatabasePoolInternal pool : this.poolCache.values()) {
                long delta = System.currentTimeMillis() - pool.getLastCloseTime();
                if (!pool.isUnused() || delta <= this.timeout) continue;
                pool.close();
            }
            this.poolCache.values().removeIf(ODatabasePoolInternal::isClosed);
        }
    }

    @Override
    public ODatabasePoolInternal get(String database, String username, String password, OrientDBConfig parentConfig) {
        this.checkForClose();
        String key = OSecurityManager.instance().createSHA256(database + username + password);
        ODatabasePoolInternal pool = this.poolCache.get(key);
        if (pool != null && !pool.isClosed()) {
            return pool;
        }
        OrientDBConfig config = OrientDBConfig.builder().addConfig(OGlobalConfiguration.DB_POOL_MAX, this.maxPoolSize).build();
        if (parentConfig != null) {
            config.setParent(parentConfig);
        }
        pool = new ODatabasePoolImpl(this.orientDB, database, username, password, config);
        this.poolCache.put(key, pool);
        return pool;
    }

    @Override
    public OCachedDatabasePoolFactory reset() {
        this.poolCache.forEach((key, pool) -> pool.close());
        this.poolCache.clear();
        return this;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.closed = true;
            this.reset();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public OCachedDatabasePoolFactory setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    private void checkForClose() {
        if (this.closed) {
            throw new IllegalStateException("Cached pool factory is closed!");
        }
    }
}

