/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.config;

import com.orientechnologies.orient.core.db.config.OMulticastConfguration;
import com.orientechnologies.orient.core.db.config.ONodeConfiguration;
import com.orientechnologies.orient.core.db.config.OUDPUnicastConfiguration;
import java.util.UUID;

public class ONodeConfigurationBuilder {
    private int quorum = 2;
    private String nodeName = UUID.randomUUID().toString();
    private String groupName = "OrientDB";
    private Integer tcpPort = null;
    private String groupPassword = "OrientDB";
    private OMulticastConfguration multicastConfguration;
    private OUDPUnicastConfiguration unicastConfiguration;

    protected ONodeConfigurationBuilder() {
    }

    public ONodeConfigurationBuilder setQuorum(int quorum) {
        this.quorum = quorum;
        return this;
    }

    public ONodeConfigurationBuilder setNodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public ONodeConfigurationBuilder setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public ONodeConfigurationBuilder setTcpPort(int tcpPort) {
        this.tcpPort = tcpPort;
        return this;
    }

    public ONodeConfigurationBuilder setGroupPassword(String groupPassword) {
        this.groupPassword = groupPassword;
        return this;
    }

    public ONodeConfigurationBuilder setMulticast(OMulticastConfguration multicast) {
        this.multicastConfguration = multicast;
        return this;
    }

    public ONodeConfigurationBuilder setUnicast(OUDPUnicastConfiguration config) {
        this.unicastConfiguration = config;
        return this;
    }

    public ONodeConfiguration build() {
        if (this.multicastConfguration != null) {
            return new ONodeConfiguration(this.nodeName, this.groupName, this.groupPassword, this.quorum, this.tcpPort, this.multicastConfguration);
        }
        if (this.unicastConfiguration != null) {
            return new ONodeConfiguration(this.nodeName, this.groupName, this.groupPassword, this.quorum, this.tcpPort, this.unicastConfiguration);
        }
        return new ONodeConfiguration(this.nodeName, this.groupName, this.groupPassword, this.quorum, this.tcpPort, new OMulticastConfguration());
    }
}

