/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCommandCacheHook;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OScriptExecutor;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.OHookReplacedRecordThreadLocal;
import com.orientechnologies.orient.core.db.OLiveQueryMonitor;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OSharedContextEmbedded;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.db.document.OQueryLifecycleListener;
import com.orientechnologies.orient.core.db.document.RecordReader;
import com.orientechnologies.orient.core.db.record.OClassTrigger;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibraryImpl;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.metadata.security.OImmutableUser;
import com.orientechnologies.orient.core.metadata.security.OPropertyAccess;
import com.orientechnologies.orient.core.metadata.security.OPropertyEncryptionNone;
import com.orientechnologies.orient.core.metadata.security.ORestrictedAccessHook;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityInternal;
import com.orientechnologies.orient.core.metadata.security.OSecurityPolicy;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceAction;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryProxy;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.query.live.OLiveQueryMonitorEmbedded;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.impl.ODirtyManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OEdgeDelegate;
import com.orientechnologies.orient.core.record.impl.OVertexDelegate;
import com.orientechnologies.orient.core.schedule.OScheduledEvent;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.executor.LiveQueryListenerImpl;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSetLifecycleDecorator;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageInfo;
import com.orientechnologies.orient.core.storage.cluster.OOfflineClusterException;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OMicroTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionData;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class ODatabaseDocumentEmbedded
extends ODatabaseDocumentAbstract
implements OQueryLifecycleListener {
    private OrientDBConfig config;
    private OStorage storage;

    public ODatabaseDocumentEmbedded(OStorage storage) {
        this.activateOnCurrentThread();
        try {
            this.status = ODatabase.STATUS.CLOSED;
            this.url = storage.getURL();
            this.storage = storage;
            this.componentsFactory = storage.getComponentsFactory();
            this.unmodifiableHooks = Collections.unmodifiableMap(this.hooks);
            this.localCache = new OLocalRecordCache();
            this.init();
            this.databaseOwner = this;
        }
        catch (Exception t) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw OException.wrapException(new ODatabaseException("Error on opening database "), t);
        }
    }

    @Override
    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Use OrientDB");
    }

    public void init(OrientDBConfig config, OSharedContext sharedContext) {
        this.sharedContext = sharedContext;
        this.activateOnCurrentThread();
        this.config = config;
        this.applyAttributes(config);
        this.applyListeners(config);
        try {
            this.status = ODatabase.STATUS.OPEN;
            if (this.initialized) {
                return;
            }
            ORecordSerializerFactory serializerFactory = ORecordSerializerFactory.instance();
            String serializeName = this.getStorageInfo().getConfiguration().getRecordSerializer();
            if (serializeName == null) {
                throw new ODatabaseException("Impossible to open database from version before 2.x use export import instead");
            }
            this.serializer = serializerFactory.getFormat(serializeName);
            if (this.serializer == null) {
                throw new ODatabaseException("RecordSerializer with name '" + serializeName + "' not found ");
            }
            if (this.getStorageInfo().getConfiguration().getRecordSerializerVersion() > this.serializer.getMinSupportedVersion()) {
                throw new ODatabaseException("Persistent record serializer version is not support by the current implementation");
            }
            this.localCache.startup();
            this.loadMetadata(this.sharedContext);
            this.installHooksEmbedded();
            if (this.getMetadata().getCommandCache().isEnabled()) {
                this.registerHook(new OCommandCacheHook(this), ORecordHook.HOOK_POSITION.REGULAR);
            }
            this.user = null;
            this.initialized = true;
        }
        catch (OException e) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw e;
        }
        catch (Exception e) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw OException.wrapException(new ODatabaseException("Cannot open database url=" + this.getURL()), e);
        }
    }

    public void internalOpen(String iUserName, String iUserPassword) {
        this.internalOpen(iUserName, iUserPassword, true);
    }

    public void internalOpen(String iUserName, String iUserPassword, boolean checkPassword) {
        try {
            OSecurityInternal security = this.sharedContext.getSecurity();
            if (this.user == null || this.user.getVersion() != security.getVersion(this) || !this.user.getName().equalsIgnoreCase(iUserName)) {
                OUser usr = checkPassword ? security.authenticate(this, iUserName, iUserPassword) : security.getUser((ODatabaseSession)this, iUserName);
                this.user = usr != null ? new OImmutableUser(security.getVersion(this), usr) : null;
                this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_READ, new Object[0]);
            }
        }
        catch (OException e) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw e;
        }
        catch (Exception e) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw OException.wrapException(new ODatabaseException("Cannot open database url=" + this.getURL()), e);
        }
    }

    private void applyListeners(OrientDBConfig config) {
        if (config != null) {
            for (ODatabaseListener listener : config.getListeners()) {
                this.registerListener(listener);
            }
        }
    }

    @Override
    @Deprecated
    public <DB extends ODatabase> DB open(OToken iToken) {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    @Override
    public <DB extends ODatabase> DB create() {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    public void internalCreate(OrientDBConfig config, OSharedContext ctx) {
        this.sharedContext = ctx;
        this.status = ODatabase.STATUS.OPEN;
        this.applyAttributes(config);
        this.applyListeners(config);
        this.metadata = new OMetadataDefault(this);
        this.installHooksEmbedded();
        this.createMetadata(ctx);
        if (this.getMetadata().getCommandCache().isEnabled()) {
            this.registerHook(new OCommandCacheHook(this), ORecordHook.HOOK_POSITION.REGULAR);
        }
    }

    public void callOnCreateListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onCreate(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onCreate(this);
            }
            catch (Exception exception) {}
        }
    }

    protected void createMetadata(OSharedContext shared) {
        this.metadata.init(shared);
        ((OSharedContextEmbedded)shared).create(this);
    }

    @Override
    protected void loadMetadata() {
        this.loadMetadata(this.sharedContext);
    }

    @Override
    protected void loadMetadata(OSharedContext shared) {
        this.metadata = new OMetadataDefault(this);
        this.sharedContext = shared;
        this.metadata.init(this.sharedContext);
        this.sharedContext.load(this);
    }

    private void applyAttributes(OrientDBConfig config) {
        if (config != null) {
            for (Map.Entry<ODatabase.ATTRIBUTES, Object> attrs : config.getAttributes().entrySet()) {
                this.set(attrs.getKey(), attrs.getValue());
            }
        }
    }

    @Override
    public <DB extends ODatabase> DB set(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        this.checkIfActive();
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = OIOUtils.getStringContent(iValue != null ? iValue.toString() : null);
        OStorage storage = this.getStorage();
        switch (iAttribute) {
            case STATUS: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("DB status can't be null");
                }
                this.setStatus(ODatabase.STATUS.valueOf(stringValue.toUpperCase(Locale.ENGLISH)));
                break;
            }
            case DEFAULTCLUSTERID: {
                if (iValue == null) break;
                if (iValue instanceof Number) {
                    storage.setDefaultClusterId(((Number)iValue).intValue());
                    break;
                }
                storage.setDefaultClusterId(storage.getClusterIdByName(iValue.toString()));
                break;
            }
            case TYPE: {
                throw new IllegalArgumentException("Database type cannot be changed at run-time");
            }
            case DATEFORMAT: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("date format is null");
                }
                new SimpleDateFormat(stringValue).format(new Date());
                storage.setDateFormat(stringValue);
                break;
            }
            case DATETIMEFORMAT: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("date format is null");
                }
                new SimpleDateFormat(stringValue).format(new Date());
                storage.setDateTimeFormat(stringValue);
                break;
            }
            case TIMEZONE: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("Timezone can't be null");
                }
                TimeZone timeZoneValue = TimeZone.getTimeZone(stringValue.toUpperCase(Locale.ENGLISH));
                if (timeZoneValue.equals(TimeZone.getTimeZone("GMT"))) {
                    timeZoneValue = TimeZone.getTimeZone(stringValue);
                }
                storage.setTimeZone(timeZoneValue);
                break;
            }
            case LOCALECOUNTRY: {
                storage.setLocaleCountry(stringValue);
                break;
            }
            case LOCALELANGUAGE: {
                storage.setLocaleLanguage(stringValue);
                break;
            }
            case CHARSET: {
                storage.setCharset(stringValue);
                break;
            }
            case CUSTOM: {
                int indx;
                int n = indx = stringValue != null ? stringValue.indexOf(61) : -1;
                if (indx < 0) {
                    if ("clear".equalsIgnoreCase(stringValue)) {
                        this.clearCustomInternal();
                        break;
                    }
                    throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                }
                String customName = stringValue.substring(0, indx).trim();
                String customValue = stringValue.substring(indx + 1).trim();
                if (customValue.isEmpty()) {
                    this.removeCustomInternal(customName);
                    break;
                }
                this.setCustomInternal(customName, customValue);
                break;
            }
            case CLUSTERSELECTION: {
                storage.setClusterSelection(stringValue);
                break;
            }
            case MINIMUMCLUSTERS: {
                if (iValue != null) {
                    if (iValue instanceof Number) {
                        storage.setMinimumClusters(((Number)iValue).intValue());
                        break;
                    }
                    storage.setMinimumClusters(Integer.parseInt(stringValue));
                    break;
                }
                storage.setMinimumClusters(1);
                break;
            }
            case CONFLICTSTRATEGY: {
                storage.setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(stringValue));
                break;
            }
            case VALIDATION: {
                storage.setValidation(Boolean.parseBoolean(stringValue));
                break;
            }
            default: {
                throw new IllegalArgumentException("Option '" + (Object)((Object)iAttribute) + "' not supported on alter database");
            }
        }
        return (DB)this;
    }

    private void clearCustomInternal() {
        this.getStorage().clearProperties();
    }

    private void removeCustomInternal(String iName) {
        this.setCustomInternal(iName, null);
    }

    private void setCustomInternal(String iName, String iValue) {
        OStorage storage = this.getStorage();
        if (iValue == null || "null".equalsIgnoreCase(iValue)) {
            storage.removeProperty(iName);
        } else {
            storage.setProperty(iName, iValue);
        }
    }

    @Override
    public <DB extends ODatabase> DB setCustom(String name, Object iValue) {
        this.checkIfActive();
        if ("clear".equalsIgnoreCase(name) && iValue == null) {
            this.clearCustomInternal();
        } else {
            String customValue;
            String customName = name;
            String string = customValue = iValue == null ? null : "" + iValue;
            if (customName == null || customValue.isEmpty()) {
                this.removeCustomInternal(customName);
            } else {
                this.setCustomInternal(customName, customValue);
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase> DB create(String incrementalBackupPath) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    @Override
    public <DB extends ODatabase> DB create(Map<OGlobalConfiguration, Object> iInitialSettings) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    @Override
    public void drop() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    @Override
    public ODatabaseDocumentInternal copy() {
        ODatabaseDocumentEmbedded database = new ODatabaseDocumentEmbedded(this.getSharedContext().getStorage());
        database.init(this.config, this.sharedContext);
        String user = this.getUser() != null ? this.getUser().getName() : null;
        database.internalOpen(user, null, false);
        database.callOnOpenListeners();
        this.activateOnCurrentThread();
        return database;
    }

    @Override
    public boolean exists() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    @Override
    public boolean isClosed() {
        return this.status == ODatabase.STATUS.CLOSED || this.getStorage().isClosed();
    }

    public void rebuildIndexes() {
        if (this.metadata.getIndexManagerInternal().autoRecreateIndexesAfterCrash(this)) {
            this.metadata.getIndexManagerInternal().recreateIndexes(this);
        }
    }

    protected void installHooksEmbedded() {
        this.hooks.clear();
    }

    @Override
    public OStorage getStorage() {
        return this.storage;
    }

    @Override
    public OStorageInfo getStorageInfo() {
        return this.storage;
    }

    @Override
    public void replaceStorage(OStorage iNewStorage) {
        this.getSharedContext().setStorage(iNewStorage);
        this.storage = iNewStorage;
    }

    @Override
    public OResultSet query(String query, Object[] args) {
        this.checkOpenness();
        this.checkIfActive();
        OStatement statement = OSQLEngine.parse(query, this);
        if (!statement.isIdempotent()) {
            throw new OCommandExecutionException("Cannot execute query on non idempotent statement: " + query);
        }
        OResultSet original = statement.execute((ODatabase)this, args, true);
        OLocalResultSetLifecycleDecorator result = new OLocalResultSetLifecycleDecorator(original);
        this.queryStarted(result.getQueryId(), result);
        result.addLifecycleListener(this);
        return result;
    }

    @Override
    public OResultSet query(String query, Map args) {
        this.checkOpenness();
        this.checkIfActive();
        OStatement statement = OSQLEngine.parse(query, this);
        if (!statement.isIdempotent()) {
            throw new OCommandExecutionException("Cannot execute query on non idempotent statement: " + query);
        }
        OResultSet original = statement.execute((ODatabase)this, args, true);
        OLocalResultSetLifecycleDecorator result = new OLocalResultSetLifecycleDecorator(original);
        this.queryStarted(result.getQueryId(), result);
        result.addLifecycleListener(this);
        return result;
    }

    @Override
    public OResultSet command(String query, Object[] args) {
        OLocalResultSetLifecycleDecorator result;
        this.checkOpenness();
        this.checkIfActive();
        OStatement statement = OSQLEngine.parse(query, this);
        OResultSet original = statement.execute((ODatabase)this, args, true);
        if (!statement.isIdempotent()) {
            OInternalResultSet prefetched = new OInternalResultSet();
            original.forEachRemaining((Consumer<? super OResult>)((Consumer<OResult>)x -> prefetched.add((OResult)x)));
            original.close();
            result = new OLocalResultSetLifecycleDecorator(prefetched);
        } else {
            result = new OLocalResultSetLifecycleDecorator(original);
            this.queryStarted(result.getQueryId(), result);
            result.addLifecycleListener(this);
        }
        return result;
    }

    @Override
    public OResultSet command(String query, Map args) {
        OLocalResultSetLifecycleDecorator result;
        this.checkOpenness();
        this.checkIfActive();
        OStatement statement = OSQLEngine.parse(query, this);
        OResultSet original = statement.execute((ODatabase)this, args, true);
        if (!statement.isIdempotent()) {
            OInternalResultSet prefetched = new OInternalResultSet();
            original.forEachRemaining((Consumer<? super OResult>)((Consumer<OResult>)x -> prefetched.add((OResult)x)));
            original.close();
            result = new OLocalResultSetLifecycleDecorator(prefetched);
        } else {
            result = new OLocalResultSetLifecycleDecorator(original);
            this.queryStarted(result.getQueryId(), result);
            result.addLifecycleListener(this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OResultSet execute(String language, String script, Object ... args) {
        OResultSet original;
        this.checkOpenness();
        this.checkIfActive();
        if (!"sql".equalsIgnoreCase(language)) {
            this.checkSecurity(ORule.ResourceGeneric.COMMAND, ORole.PERMISSION_EXECUTE, (Object)language);
        }
        OScriptExecutor executor = this.getSharedContext().getOrientDB().getScriptManager().getCommandManager().getScriptExecutor(language);
        ((OAbstractPaginatedStorage)this.storage.getUnderlying()).pauseConfigurationUpdateNotifications();
        try {
            original = executor.execute((ODatabaseDocumentInternal)this, script, args);
        }
        finally {
            ((OAbstractPaginatedStorage)this.storage.getUnderlying()).fireConfigurationUpdateNotifications();
        }
        OLocalResultSetLifecycleDecorator result = new OLocalResultSetLifecycleDecorator(original);
        this.queryStarted(result.getQueryId(), result);
        result.addLifecycleListener(this);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OResultSet execute(String language, String script, Map<String, ?> args) {
        OResultSet original;
        this.checkOpenness();
        this.checkIfActive();
        if (!"sql".equalsIgnoreCase(language)) {
            this.checkSecurity(ORule.ResourceGeneric.COMMAND, ORole.PERMISSION_EXECUTE, (Object)language);
        }
        OScriptExecutor executor = this.sharedContext.getOrientDB().getScriptManager().getCommandManager().getScriptExecutor(language);
        ((OAbstractPaginatedStorage)this.storage.getUnderlying()).pauseConfigurationUpdateNotifications();
        try {
            original = executor.execute((ODatabaseDocumentInternal)this, script, args);
        }
        finally {
            ((OAbstractPaginatedStorage)this.storage.getUnderlying()).fireConfigurationUpdateNotifications();
        }
        OLocalResultSetLifecycleDecorator result = new OLocalResultSetLifecycleDecorator(original);
        this.queryStarted(result.getQueryId(), result);
        result.addLifecycleListener(this);
        return result;
    }

    public OLocalResultSetLifecycleDecorator query(OExecutionPlan plan, Map<Object, Object> params) {
        this.checkOpenness();
        this.checkIfActive();
        OBasicCommandContext ctx = new OBasicCommandContext();
        ctx.setDatabase(this);
        ctx.setInputParameters(params);
        OLocalResultSet result = new OLocalResultSet((OInternalExecutionPlan)plan);
        OLocalResultSetLifecycleDecorator decorator = new OLocalResultSetLifecycleDecorator(result);
        this.queryStarted(decorator.getQueryId(), decorator);
        decorator.addLifecycleListener(this);
        return decorator;
    }

    public OrientDBConfig getConfig() {
        return this.config;
    }

    @Override
    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Object ... args) {
        this.checkOpenness();
        this.checkIfActive();
        LiveQueryListenerImpl queryListener = new LiveQueryListenerImpl(listener, query, (ODatabaseDocument)this, args);
        ODatabaseDocumentInternal dbCopy = this.copy();
        this.activateOnCurrentThread();
        OLiveQueryMonitorEmbedded monitor = new OLiveQueryMonitorEmbedded(queryListener.getToken(), dbCopy);
        return monitor;
    }

    @Override
    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Map<String, ?> args) {
        this.checkOpenness();
        this.checkIfActive();
        LiveQueryListenerImpl queryListener = new LiveQueryListenerImpl(listener, query, (ODatabaseDocument)this, args);
        ODatabaseDocumentInternal dbCopy = this.copy();
        this.activateOnCurrentThread();
        OLiveQueryMonitorEmbedded monitor = new OLiveQueryMonitorEmbedded(queryListener.getToken(), dbCopy);
        return monitor;
    }

    @Override
    public void recycle(ORecord record) {
        throw new UnsupportedOperationException();
    }

    protected OMicroTransaction beginMicroTransaction() {
        OAbstractPaginatedStorage abstractPaginatedStorage = (OAbstractPaginatedStorage)this.getStorage().getUnderlying();
        if (this.microTransaction == null) {
            this.microTransaction = new OMicroTransaction(abstractPaginatedStorage, this);
        }
        this.microTransaction.begin();
        this.microTransaction.setNoTxLocks(((OTransactionAbstract)this.getTransaction()).getInternalLocks());
        return this.microTransaction;
    }

    @Override
    public int addBlobCluster(String iClusterName, Object ... iParameters) {
        int id = !this.existsCluster(iClusterName) ? this.addCluster(iClusterName, iParameters) : this.getClusterIdByName(iClusterName);
        this.getMetadata().getSchema().addBlobCluster(id);
        return id;
    }

    @Override
    public void executeDeleteRecord(OIdentifiable identifiable, int iVersion, boolean iRequired, ODatabase.OPERATION_MODE iMode, boolean prohibitTombstones) {
        this.checkOpenness();
        this.checkIfActive();
        ORecordId rid = (ORecordId)identifiable.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot delete record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return;
        }
        Object record = identifiable.getRecord();
        if (record == null) {
            return;
        }
        OMicroTransaction microTx = this.beginMicroTransaction();
        try {
            Set<ORecord> newRecords;
            Set<ORecord> records = ORecordInternal.getDirtyManager(record).getUpdateRecords();
            if (records != null) {
                for (ORecord rec : records) {
                    microTx.saveRecord(rec, null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
                }
            }
            if ((newRecords = ORecordInternal.getDirtyManager(record).getNewRecords()) != null) {
                for (ORecord rec : newRecords) {
                    microTx.saveRecord(rec, null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
                }
            }
            microTx.deleteRecord((ORecord)record, iMode);
        }
        catch (Exception e) {
            this.endMicroTransaction(false);
            throw e;
        }
        this.endMicroTransaction(true);
    }

    private void endMicroTransaction(boolean success) {
        block8: {
            assert (this.microTransaction != null);
            try {
                if (success) {
                    try {
                        this.microTransaction.commit();
                        OLiveQueryHook.notifyForTxChanges(this);
                        OLiveQueryHookV2.notifyForTxChanges(this);
                        break block8;
                    }
                    catch (Exception e) {
                        this.microTransaction.rollbackAfterFailedCommit();
                        OLiveQueryHook.removePendingDatabaseOps(this);
                        OLiveQueryHookV2.removePendingDatabaseOps(this);
                        throw e;
                    }
                }
                this.microTransaction.rollback();
                OLiveQueryHook.removePendingDatabaseOps(this);
                OLiveQueryHookV2.removePendingDatabaseOps(this);
            }
            finally {
                if (!this.microTransaction.isActive()) {
                    this.microTransaction = null;
                }
            }
        }
    }

    @Override
    public OIdentifiable beforeCreateOperations(OIdentifiable id, String iClusterName) {
        this.checkClusterSecurity(ORole.PERMISSION_CREATE, id, iClusterName);
        ORecordHook.RESULT triggerChanged = null;
        boolean changed = false;
        if (id instanceof ODocument) {
            ODocument doc = (ODocument)id;
            if (!this.getSharedContext().getSecurity().canCreate(this, doc)) {
                throw new OSecurityException("Cannot update record " + doc + ": the resource has restricted access due to security policies");
            }
            OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(this, doc);
            if (clazz != null) {
                if (clazz.isScheduler()) {
                    this.getSharedContext().getScheduler().initScheduleRecord(doc);
                    changed = true;
                }
                if (clazz.isOuser()) {
                    changed = OUser.encodePassword(doc);
                }
                if (clazz.isTriggered()) {
                    triggerChanged = OClassTrigger.onRecordBeforeCreate(doc, this);
                }
                if (clazz.isRestricted()) {
                    changed = ORestrictedAccessHook.onRecordBeforeCreate(doc, this);
                }
                if (clazz.isFunction()) {
                    OFunctionLibraryImpl.validateFunctionRecord(doc);
                }
                ODocumentInternal.setPropertyEncryption(doc, OPropertyEncryptionNone.instance());
            }
        }
        ORecordHook.RESULT res = this.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, id);
        if (changed || res == ORecordHook.RESULT.RECORD_CHANGED || triggerChanged == ORecordHook.RESULT.RECORD_CHANGED) {
            if (id instanceof ODocument) {
                ((ODocument)id).validate();
            }
            return id;
        }
        if (res == ORecordHook.RESULT.RECORD_REPLACED || triggerChanged == ORecordHook.RESULT.RECORD_REPLACED) {
            ORecord replaced = (ORecord)OHookReplacedRecordThreadLocal.INSTANCE.get();
            if (replaced instanceof ODocument) {
                ((ODocument)replaced).validate();
            }
            return replaced;
        }
        return null;
    }

    @Override
    public OIdentifiable beforeUpdateOperations(OIdentifiable id, String iClusterName) {
        ORecordHook.RESULT res;
        ODocument doc;
        OImmutableClass clazz;
        this.checkClusterSecurity(ORole.PERMISSION_UPDATE, id, iClusterName);
        ORecordHook.RESULT triggerChanged = null;
        boolean changed = false;
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass(this, doc = (ODocument)id)) != null) {
            if (clazz.isScheduler()) {
                this.getSharedContext().getScheduler().handleUpdateSchedule(doc);
                changed = true;
            }
            if (clazz.isOuser()) {
                changed = OUser.encodePassword(doc);
            }
            if (clazz.isTriggered()) {
                triggerChanged = OClassTrigger.onRecordBeforeUpdate(doc, this);
            }
            if (clazz.isRestricted() && !ORestrictedAccessHook.isAllowed(this, doc, ORestrictedOperation.ALLOW_UPDATE, true)) {
                throw new OSecurityException("Cannot update record " + doc.getIdentity() + ": the resource has restricted access");
            }
            if (clazz.isFunction()) {
                OFunctionLibraryImpl.validateFunctionRecord(doc);
            }
            if (!this.getSharedContext().getSecurity().canUpdate(this, doc)) {
                throw new OSecurityException("Cannot update record " + doc.getIdentity() + ": the resource has restricted access due to security policies");
            }
            ODocumentInternal.setPropertyEncryption(doc, OPropertyEncryptionNone.instance());
        }
        if ((res = this.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, id)) == ORecordHook.RESULT.RECORD_CHANGED || triggerChanged == ORecordHook.RESULT.RECORD_CHANGED) {
            if (id instanceof ODocument) {
                ((ODocument)id).validate();
            }
            return id;
        }
        if (res == ORecordHook.RESULT.RECORD_REPLACED || triggerChanged == ORecordHook.RESULT.RECORD_REPLACED) {
            ORecord replaced = (ORecord)OHookReplacedRecordThreadLocal.INSTANCE.get();
            if (replaced instanceof ODocument) {
                ((ODocument)replaced).validate();
            }
            return replaced;
        }
        if (changed) {
            return id;
        }
        return null;
    }

    public ODatabaseDocumentAbstract delete(ORecord record) {
        this.checkOpenness();
        if (record == null) {
            throw new ODatabaseException("Cannot delete null document");
        }
        if (record instanceof OElement) {
            if (((OElement)record).isVertex()) {
                OVertexDelegate.deleteLinks(((OElement)record).asVertex().get());
            } else if (((OElement)record).isEdge()) {
                OEdgeDelegate.deleteLinks(((OElement)record).asEdge().get());
            }
        }
        if (record instanceof ODocument && ((ODocument)record).getClassName() != null) {
            this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_DELETE, (Object)((ODocument)record).getClassName());
        }
        try {
            this.currentTx.deleteRecord(record, ODatabase.OPERATION_MODE.SYNCHRONOUS);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            if (record instanceof ODocument) {
                throw OException.wrapException(new ODatabaseException("Error on deleting record " + record.getIdentity() + " of class '" + ((ODocument)record).getClassName() + "'"), e);
            }
            throw OException.wrapException(new ODatabaseException("Error on deleting record " + record.getIdentity()), e);
        }
        return this;
    }

    @Override
    public void beforeDeleteOperations(OIdentifiable id, String iClusterName) {
        ODocument doc;
        OImmutableClass clazz;
        this.checkClusterSecurity(ORole.PERMISSION_DELETE, id, iClusterName);
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass(this, doc = (ODocument)id)) != null) {
            if (clazz.isTriggered()) {
                OClassTrigger.onRecordBeforeDelete(doc, this);
            }
            if (clazz.isRestricted() && !ORestrictedAccessHook.isAllowed(this, doc, ORestrictedOperation.ALLOW_DELETE, true)) {
                throw new OSecurityException("Cannot delete record " + doc.getIdentity() + ": the resource has restricted access");
            }
            if (!this.getSharedContext().getSecurity().canDelete(this, doc)) {
                throw new OSecurityException("Cannot delete record " + doc.getIdentity() + ": the resource has restricted access due to security policies");
            }
        }
        this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, id);
    }

    @Override
    public void afterCreateOperations(OIdentifiable id) {
        if (id instanceof ODocument) {
            ODocument doc = (ODocument)id;
            OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(this, doc);
            if (clazz != null) {
                OClassIndexManager.checkIndexesAfterCreate(doc, this);
                if (clazz.isFunction()) {
                    this.getSharedContext().getFunctionLibrary().createdFunction(doc);
                    this.sharedContext.getOrientDB().getScriptManager().close(this.getName());
                }
                if (clazz.isOuser() || clazz.isOrole() || clazz.isSubClassOf(OSecurityPolicy.class.getSimpleName())) {
                    this.sharedContext.getSecurity().incrementVersion(this);
                }
                if (clazz.isSequence()) {
                    ((OSequenceLibraryProxy)this.getMetadata().getSequenceLibrary()).getDelegate().onSequenceCreated(this, doc);
                }
                if (clazz.isScheduler()) {
                    this.getMetadata().getScheduler().scheduleEvent(new OScheduledEvent(doc));
                }
                if (clazz.isTriggered()) {
                    OClassTrigger.onRecordAfterCreate(doc, this);
                }
                this.getSharedContext().getViewManager().recordAdded(clazz, doc, this);
            }
            OLiveQueryHook.addOp(doc, (byte)3, this);
            OLiveQueryHookV2.addOp(doc, (byte)3, this);
        }
        this.callbackHooks(ORecordHook.TYPE.AFTER_CREATE, id);
    }

    @Override
    public void afterUpdateOperations(OIdentifiable id) {
        if (id instanceof ODocument) {
            ODocument doc = (ODocument)id;
            OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(this, doc);
            if (clazz != null) {
                OClassIndexManager.checkIndexesAfterUpdate((ODocument)id, this);
                if (clazz.isFunction()) {
                    this.getSharedContext().getFunctionLibrary().updatedFunction(doc);
                    this.sharedContext.getOrientDB().getScriptManager().close(this.getName());
                }
                if (clazz.isOuser() || clazz.isOrole() || clazz.isSubClassOf(OSecurityPolicy.class.getSimpleName())) {
                    this.sharedContext.getSecurity().incrementVersion(this);
                }
                if (clazz.isSequence()) {
                    ((OSequenceLibraryProxy)this.getMetadata().getSequenceLibrary()).getDelegate().onSequenceUpdated(this, doc);
                }
                if (clazz.isTriggered()) {
                    OClassTrigger.onRecordAfterUpdate(doc, this);
                }
                this.getSharedContext().getViewManager().recordUpdated(clazz, doc, this);
            }
            OLiveQueryHook.addOp(doc, (byte)1, this);
            OLiveQueryHookV2.addOp(doc, (byte)1, this);
        }
        this.callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, id);
    }

    @Override
    public void afterDeleteOperations(OIdentifiable id) {
        if (id instanceof ODocument) {
            ODocument doc = (ODocument)id;
            OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(this, doc);
            if (clazz != null) {
                OClassIndexManager.checkIndexesAfterDelete(doc, this);
                if (clazz.isFunction()) {
                    this.getSharedContext().getFunctionLibrary().droppedFunction(doc);
                    this.sharedContext.getOrientDB().getScriptManager().close(this.getName());
                }
                if (clazz.isSequence()) {
                    ((OSequenceLibraryProxy)this.getMetadata().getSequenceLibrary()).getDelegate().onSequenceDropped(this, doc);
                }
                if (clazz.isScheduler()) {
                    String eventName = (String)doc.field("name");
                    this.getSharedContext().getScheduler().removeEventInternal(eventName);
                }
                if (clazz.isTriggered()) {
                    OClassTrigger.onRecordAfterDelete(doc, this);
                }
                this.getSharedContext().getViewManager().recordDeleted(clazz, doc, this);
            }
            OLiveQueryHook.addOp(doc, (byte)2, this);
            OLiveQueryHookV2.addOp(doc, (byte)2, this);
        }
        this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, id);
    }

    @Override
    public void afterReadOperations(OIdentifiable identifiable) {
        ODocument doc;
        OImmutableClass clazz;
        if (identifiable instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass(this, doc = (ODocument)identifiable)) != null && clazz.isTriggered()) {
            OClassTrigger.onRecordAfterRead(doc, this);
        }
        this.callbackHooks(ORecordHook.TYPE.AFTER_READ, identifiable);
    }

    @Override
    public boolean beforeReadOperations(OIdentifiable identifiable) {
        ODocument doc;
        OImmutableClass clazz;
        if (identifiable instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass(this, doc = (ODocument)identifiable)) != null) {
            ORecordHook.RESULT val;
            if (clazz.isTriggered() && (val = OClassTrigger.onRecordBeforeRead(doc, this)) == ORecordHook.RESULT.SKIP) {
                return true;
            }
            if (clazz.isRestricted() && !ORestrictedAccessHook.isAllowed(this, doc, ORestrictedOperation.ALLOW_READ, false)) {
                return true;
            }
            try {
                this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)clazz.getName());
            }
            catch (OSecurityException e) {
                return true;
            }
            if (!this.getSharedContext().getSecurity().canRead(this, doc)) {
                return true;
            }
            ODocumentInternal.setPropertyAccess(doc, new OPropertyAccess(this, doc, this.getSharedContext().getSecurity()));
            ODocumentInternal.setPropertyEncryption(doc, OPropertyEncryptionNone.instance());
        }
        return this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, identifiable) == ORecordHook.RESULT.SKIP;
    }

    @Override
    protected void afterCommitOperations() {
        super.afterCommitOperations();
        OLiveQueryHook.notifyForTxChanges(this);
        OLiveQueryHookV2.notifyForTxChanges(this);
    }

    @Override
    protected void afterRollbackOperations() {
        super.afterRollbackOperations();
        OLiveQueryHook.removePendingDatabaseOps(this);
        OLiveQueryHookV2.removePendingDatabaseOps(this);
    }

    @Override
    public ORecord saveAll(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        Object toRet = null;
        ODirtyManager dirtyManager = ORecordInternal.getDirtyManager(iRecord);
        Set<ORecord> newRecord = dirtyManager.getNewRecords();
        Set<ORecord> updatedRecord = dirtyManager.getUpdateRecords();
        dirtyManager.clearForSave();
        if (iRecord.getIdentity().isNew()) {
            if (newRecord == null) {
                newRecord = Collections.newSetFromMap(new IdentityHashMap());
            }
            newRecord.add(iRecord);
        } else {
            if (updatedRecord == null) {
                updatedRecord = Collections.newSetFromMap(new IdentityHashMap());
            }
            updatedRecord.add(iRecord);
        }
        OMicroTransaction microTx = this.beginMicroTransaction();
        try {
            if (newRecord != null) {
                for (ORecord rn : newRecord) {
                    String cluster = iRecord == rn ? iClusterName : this.getClusterName(rn);
                    microTx.saveRecord(rn, cluster, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
                }
            }
            if (updatedRecord != null) {
                for (ORecord rn : updatedRecord) {
                    microTx.saveRecord(rn, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
                }
            }
        }
        catch (Exception e) {
            this.endMicroTransaction(false);
            throw e;
        }
        this.endMicroTransaction(true);
        return iRecord;
    }

    @Override
    public String getClusterName(ORecord record) {
        int clusterId = record.getIdentity().getClusterId();
        if (clusterId == -1) {
            OClass schemaClass = null;
            if (record instanceof ODocument) {
                schemaClass = ODocumentInternal.getImmutableSchemaClass(this, (ODocument)record);
            }
            if (schemaClass != null) {
                if (schemaClass.isAbstract()) {
                    throw new OSchemaException("Document belongs to abstract class '" + schemaClass.getName() + "' and cannot be saved");
                }
                clusterId = schemaClass.getClusterForNewInstance((ODocument)record);
                return this.getClusterNameById(clusterId);
            }
            return this.getClusterNameById(this.getStorage().getDefaultClusterId());
        }
        return this.getClusterNameById(clusterId);
    }

    @Override
    public OView getViewFromCluster(int cluster) {
        String viewName;
        OImmutableSchema schema = this.getMetadata().getImmutableSchemaSnapshot();
        OView view = schema.getViewByClusterId(cluster);
        if (view == null && (viewName = this.getSharedContext().getViewManager().getViewFromOldCluster(cluster)) != null) {
            view = schema.getView(viewName);
        }
        return view;
    }

    @Override
    public <RET extends ORecord> RET executeReadRecord(ORecordId rid, ORecord iRecord, int recordVersion, String fetchPlan, boolean ignoreCache, boolean iUpdateCache, boolean loadTombstones, OStorage.LOCKING_STRATEGY lockingStrategy, RecordReader recordReader) {
        this.checkOpenness();
        this.checkIfActive();
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        ORecordSerializationContext.pushContext();
        try {
            ORawBuffer recordBuffer;
            this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)this.getClusterNameById(rid.getClusterId()));
            assert (!this.getTransaction().isActive() || this.microTransaction == null || !this.microTransaction.isActive());
            ORecord record = this.getTransaction().getRecord(rid);
            if (record == OBasicTransaction.DELETED_RECORD) {
                RET RET = null;
                return RET;
            }
            if (record == null && this.microTransaction != null && this.microTransaction.isActive() && (record = this.microTransaction.getRecord(rid)) == OBasicTransaction.DELETED_RECORD) {
                RET RET = null;
                return RET;
            }
            if (record == null && !ignoreCache) {
                record = this.getLocalCache().findRecord(rid);
            }
            if (record != null) {
                if (iRecord != null) {
                    iRecord.fromStream(record.toStream());
                    ORecordInternal.setVersion(iRecord, record.getVersion());
                    record = iRecord;
                }
                OFetchHelper.checkFetchPlanValid(fetchPlan);
                if (this.beforeReadOperations(record)) {
                    RET RET = null;
                    return RET;
                }
                if (record.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    record.reload();
                }
                if (lockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_SHARED_LOCK) {
                    OLogManager.instance().warn((Object)this, "You use deprecated record locking strategy: %s it may lead to deadlocks " + (Object)((Object)lockingStrategy), new Object[0]);
                    record.lock(false);
                } else if (lockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK) {
                    OLogManager.instance().warn((Object)this, "You use deprecated record locking strategy: %s it may lead to deadlocks " + (Object)((Object)lockingStrategy), new Object[0]);
                    record.lock(true);
                }
                this.afterReadOperations(record);
                if (record instanceof ODocument) {
                    ODocumentInternal.checkClass((ODocument)record, this);
                }
                ORecord oRecord = record;
                return (RET)oRecord;
            }
            if (!rid.isValid()) {
                recordBuffer = null;
            } else {
                OFetchHelper.checkFetchPlanValid(fetchPlan);
                int version = iRecord != null ? iRecord.getVersion() : recordVersion;
                recordBuffer = recordReader.readRecord(this.getStorage(), rid, fetchPlan, ignoreCache, version);
            }
            if (recordBuffer == null) {
                RET RET = null;
                return RET;
            }
            if (iRecord == null || ORecordInternal.getRecordType(iRecord) != recordBuffer.recordType) {
                iRecord = Orient.instance().getRecordFactoryManager().newInstance(recordBuffer.recordType, rid.getClusterId(), this);
            }
            ORecordInternal.setRecordSerializer(iRecord, this.getSerializer());
            ORecordInternal.fill(iRecord, rid, recordBuffer.version, recordBuffer.buffer, false, this);
            if (iRecord instanceof ODocument) {
                ODocumentInternal.checkClass((ODocument)iRecord, this);
            }
            if (ORecordVersionHelper.isTombstone(iRecord.getVersion())) {
                ORecord oRecord = iRecord;
                return (RET)oRecord;
            }
            if (this.beforeReadOperations(iRecord)) {
                RET RET = null;
                return RET;
            }
            iRecord.fromStream(recordBuffer.buffer);
            this.afterReadOperations(iRecord);
            if (iUpdateCache) {
                this.getLocalCache().updateRecord(iRecord);
            }
            ORecord oRecord = iRecord;
            return (RET)oRecord;
        }
        catch (OOfflineClusterException t) {
            throw t;
        }
        catch (ORecordNotFoundException t) {
            throw t;
        }
        catch (Exception t) {
            if (rid.isTemporary()) {
                throw OException.wrapException(new ODatabaseException("Error on retrieving record using temporary RID: " + rid), t);
            }
            throw OException.wrapException(new ODatabaseException("Error on retrieving record " + rid + " (cluster: " + this.getStorage().getPhysicalClusterNameById(rid.getClusterId()) + ")"), t);
        }
        finally {
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    @Override
    public void internalLockRecord(OIdentifiable iRecord, OStorage.LOCKING_STRATEGY lockingStrategy) {
        this.internalLockRecord(iRecord, lockingStrategy, 0L);
    }

    public void internalLockRecord(OIdentifiable iRecord, OStorage.LOCKING_STRATEGY lockingStrategy, long timeout) {
        ORecordId rid = new ORecordId(iRecord.getIdentity());
        OTransactionAbstract transaction = (OTransactionAbstract)this.getTransaction();
        if (!transaction.isLockedRecord(iRecord)) {
            if (lockingStrategy == OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK) {
                ((OAbstractPaginatedStorage)this.getStorage().getUnderlying()).acquireWriteLock(rid, timeout);
            } else if (lockingStrategy == OStorage.LOCKING_STRATEGY.SHARED_LOCK) {
                ((OAbstractPaginatedStorage)this.getStorage().getUnderlying()).acquireReadLock(rid, timeout);
            } else {
                throw new IllegalStateException("Unsupported locking strategy " + (Object)((Object)lockingStrategy));
            }
        }
        transaction.trackLockedRecord(iRecord.getIdentity(), lockingStrategy);
    }

    @Override
    public void internalUnlockRecord(OIdentifiable iRecord) {
        ORID rid = iRecord.getIdentity();
        OTransactionAbstract transaction = (OTransactionAbstract)this.getTransaction();
        OStorage.LOCKING_STRATEGY strategy = transaction.trackUnlockRecord(rid);
        if (strategy == OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK) {
            ((OAbstractPaginatedStorage)this.getStorage().getUnderlying()).releaseWriteLock(rid);
        } else if (strategy == OStorage.LOCKING_STRATEGY.SHARED_LOCK) {
            ((OAbstractPaginatedStorage)this.getStorage().getUnderlying()).releaseReadLock(rid);
        }
    }

    @Override
    public <RET extends ORecord> RET lock(ORID recordId) throws OLockException {
        this.checkOpenness();
        this.checkIfActive();
        this.pessimisticLockChecks(recordId);
        this.internalLockRecord(recordId, OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK);
        return (RET)this.load(recordId, (String)null, true);
    }

    @Override
    public <RET extends ORecord> RET lock(ORID recordId, long timeout, TimeUnit timeoutUnit) throws OLockException {
        this.checkOpenness();
        this.checkIfActive();
        this.pessimisticLockChecks(recordId);
        this.internalLockRecord(recordId, OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK, timeoutUnit.toMillis(timeout));
        return (RET)this.load(recordId, (String)null, true);
    }

    @Override
    public void unlock(ORID recordId) throws OLockException {
        this.checkOpenness();
        this.checkIfActive();
        this.internalUnlockRecord(recordId);
    }

    @Override
    public <T> T sendSequenceAction(OSequenceAction action) throws ExecutionException, InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        if (this.user != null) {
            try {
                this.user.allow(resourceGeneric, resourceSpecific, iOperation);
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "User '%s' tried to access the reserved resource '%s.%s', operation '%s'", this.getUser(), resourceGeneric, resourceSpecific, iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        if (iResourcesSpecific == null || iResourcesSpecific.length == 0) {
            this.checkSecurity(iResourceGeneric, null, iOperation);
        } else {
            for (Object target : iResourcesSpecific) {
                this.checkSecurity(iResourceGeneric, target == null ? null : target.toString(), iOperation);
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric iResourceGeneric, int iOperation, Object iResourceSpecific) {
        this.checkOpenness();
        this.checkSecurity(iResourceGeneric, iResourceSpecific == null ? null : iResourceSpecific.toString(), iOperation);
        return (DB)this;
    }

    @Override
    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResource, int iOperation) {
        String resourceSpecific = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (resourceSpecific == null || resourceSpecific.equals("*")) {
            this.checkSecurity(resourceGeneric, null, iOperation);
        }
        return this.checkSecurity(resourceGeneric, resourceSpecific, iOperation);
    }

    @Override
    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResourceGeneric, int iOperation, Object iResourceSpecific) {
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResourceGeneric);
        if (iResourceSpecific == null || iResourceSpecific.equals("*")) {
            return this.checkSecurity(resourceGeneric, iOperation, (Object)null);
        }
        return this.checkSecurity(resourceGeneric, iOperation, iResourceSpecific);
    }

    @Override
    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResourceGeneric);
        return this.checkSecurity(resourceGeneric, iOperation, iResourcesSpecific);
    }

    @Override
    public void syncCommit(OTransactionData data) {
        OScenarioThreadLocal.executeAsDistributed(() -> {
            assert (!this.getTransaction().isActive());
            OTransactionOptimistic tx = new OTransactionOptimistic(this);
            data.fill(tx, this);
            this.rawBegin(tx);
            this.commit();
            return null;
        });
    }
}

