/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OSimpleMultiValueTracker;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class OTrackedSet<T>
extends LinkedHashSet<T>
implements ORecordElement,
OTrackedMultiValue<T, T>,
Serializable {
    protected final ORecordElement sourceRecord;
    private final boolean embeddedCollection;
    protected Class<?> genericClass;
    private boolean dirty = false;
    private boolean transactionDirty = false;
    private OSimpleMultiValueTracker<T, T> tracker = new OSimpleMultiValueTracker(this);

    public OTrackedSet(ORecordElement iRecord, Collection<? extends T> iOrigin, Class<?> cls) {
        this(iRecord);
        this.genericClass = cls;
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.addAll(iOrigin);
        }
    }

    public OTrackedSet(ORecordElement iSourceRecord) {
        this.sourceRecord = iSourceRecord;
        this.embeddedCollection = this.getClass().equals(OTrackedSet.class);
    }

    @Override
    public ORecordElement getOwner() {
        return this.sourceRecord;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private T current;
            private final Iterator<T> underlying;
            {
                this.underlying = OTrackedSet.super.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.underlying.hasNext();
            }

            @Override
            public T next() {
                this.current = this.underlying.next();
                return this.current;
            }

            @Override
            public void remove() {
                this.underlying.remove();
                OTrackedSet.this.removeEvent(this.current);
            }
        };
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean convert = false;
        if (c instanceof OAutoConvertToRecord) {
            convert = ((OAutoConvertToRecord)((Object)c)).isAutoConvertToRecord();
            ((OAutoConvertToRecord)((Object)c)).setAutoConvertToRecord(false);
        }
        boolean modified = false;
        for (T o : c) {
            if (!this.add(o)) continue;
            modified = true;
        }
        if (c instanceof OAutoConvertToRecord) {
            ((OAutoConvertToRecord)((Object)c)).setAutoConvertToRecord(convert);
        }
        return modified;
    }

    @Override
    public boolean add(T e) {
        if (super.add(e)) {
            this.addEvent(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean addInternal(T e) {
        if (super.add(e)) {
            this.addOwnerToEmbeddedDoc(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.removeEvent(o);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (T item : this) {
            this.removeEvent(item);
        }
        super.clear();
    }

    private void addEvent(T added) {
        this.addOwnerToEmbeddedDoc(added);
        if (this.tracker.isEnabled()) {
            this.tracker.add(added, added);
        } else {
            this.setDirty();
        }
    }

    private void updateEvent(T oldValue, T newValue) {
        if (oldValue instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)oldValue, this);
        }
        this.addOwnerToEmbeddedDoc(newValue);
        if (this.tracker.isEnabled()) {
            this.tracker.updated(oldValue, newValue, oldValue);
        } else {
            this.setDirty();
        }
    }

    private void removeEvent(T removed) {
        if (removed instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)removed, this);
        }
        if (this.tracker.isEnabled()) {
            this.tracker.remove(removed, removed);
        } else {
            this.setDirty();
        }
    }

    public OTrackedSet<T> setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
        this.dirty = true;
        this.transactionDirty = true;
        return this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirtyNoChanged();
        }
    }

    public Set<T> returnOriginalState(List<OMultiValueChangeEvent<T, T>> multiValueChangeEvents) {
        HashSet<T> reverted = new HashSet<T>(this);
        ListIterator<OMultiValueChangeEvent<T, T>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block4: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<T, T> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block4;
                }
                case REMOVE: {
                    reverted.add(event.getOldValue());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    @Override
    public Class<?> getGenericClass() {
        return this.genericClass;
    }

    private void addOwnerToEmbeddedDoc(T e) {
        if (this.embeddedCollection && e instanceof ODocument && !((ODocument)e).getIdentity().isValid()) {
            ODocumentInternal.addOwner((ODocument)e, this);
            ORecordInternal.track(this.sourceRecord, (ODocument)e);
        }
    }

    private Object writeReplace() {
        return new HashSet(this);
    }

    @Override
    public void replace(OMultiValueChangeEvent<Object, Object> event, Object newValue) {
        super.remove(event.getKey());
        super.add(newValue);
    }

    @Override
    public void enableTracking(ORecordElement parent) {
        if (!this.tracker.isEnabled()) {
            this.tracker.enable();
            if (this instanceof ORecordLazyMultiValue) {
                OTrackedMultiValue.nestedEnabled(((ORecordLazyMultiValue)((Object)this)).rawIterator(), this);
            } else {
                OTrackedMultiValue.nestedEnabled(this.iterator(), this);
            }
        }
    }

    @Override
    public void disableTracking(ORecordElement document) {
        if (this.tracker.isEnabled()) {
            this.tracker.disable();
            if (this instanceof ORecordLazyMultiValue) {
                OTrackedMultiValue.nestedDisable(((ORecordLazyMultiValue)((Object)this)).rawIterator(), this);
            } else {
                OTrackedMultiValue.nestedDisable(this.iterator(), this);
            }
        }
        this.dirty = false;
    }

    @Override
    public void transactionClear() {
        this.tracker.transactionClear();
        if (this instanceof ORecordLazyMultiValue) {
            OTrackedMultiValue.nestedTransactionClear(((ORecordLazyMultiValue)((Object)this)).rawIterator());
        } else {
            OTrackedMultiValue.nestedTransactionClear(this.iterator());
        }
        this.transactionDirty = false;
    }

    @Override
    public boolean isModified() {
        return this.dirty;
    }

    @Override
    public boolean isTransactionModified() {
        return this.transactionDirty;
    }

    @Override
    public OMultiValueChangeTimeLine<Object, Object> getTimeLine() {
        return this.tracker.getTimeLine();
    }

    @Override
    public OMultiValueChangeTimeLine<T, T> getTransactionTimeLine() {
        return this.tracker.getTransactionTimeLine();
    }
}

