/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImpExpAbstract;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class ODatabaseCompare
extends ODatabaseImpExpAbstract {
    private final ODatabaseDocumentInternal databaseOne;
    private final ODatabaseDocumentInternal databaseTwo;
    private boolean compareEntriesForAutomaticIndexes = false;
    private boolean autoDetectExportImportMap = true;
    private int differences = 0;
    private boolean compareIndexMetadata = false;
    private final Set<String> excludeIndexes = new HashSet<String>();
    private int clusterDifference = 0;

    public ODatabaseCompare(String iDb1URL, String iDb2URL, String userName, String userPassword, OCommandOutputListener iListener) {
        super(null, null, iListener);
        this.listener.onMessage("\nComparing two local databases:\n1) " + iDb1URL + "\n2) " + iDb2URL + "\n");
        this.databaseOne = new ODatabaseDocumentTx(iDb1URL);
        this.databaseOne.open(userName, userPassword);
        this.databaseTwo = new ODatabaseDocumentTx(iDb2URL);
        this.databaseTwo.open(userName, userPassword);
        this.excludeClusters.add("orids");
        this.excludeClusters.add("index");
        this.excludeClusters.add("manindex");
        this.excludeIndexes.add("___exportImportRIDMapIndex");
        OSchema schema = this.databaseTwo.getMetadata().getSchema();
        OClass cls = schema.getClass("___exportImportRIDMap");
        if (cls != null) {
            int[] clusterIds;
            for (int clusterId : clusterIds = cls.getClusterIds()) {
                String clusterName = this.databaseTwo.getClusterNameById(clusterId);
                this.excludeClusters.add(clusterName);
            }
            this.clusterDifference = clusterIds.length;
        }
    }

    @Override
    public void run() {
        this.compare();
    }

    public void addExcludeIndexes(String index) {
        this.excludeIndexes.add(index);
    }

    public void addExcludeClusters(String cluster) {
        this.excludeClusters.add(cluster);
    }

    public boolean compare() {
        try {
            ODocumentHelper.RIDMapper ridMapper = null;
            if (this.autoDetectExportImportMap) {
                this.listener.onMessage("\nAuto discovery of mapping between RIDs of exported and imported records is switched on, try to discover mapping data on disk.");
                if (this.databaseTwo.getMetadata().getSchema().getClass("___exportImportRIDMap") != null) {
                    this.listener.onMessage("\nMapping data were found and will be loaded.");
                    ridMapper = rid -> {
                        if (rid == null) {
                            return null;
                        }
                        if (!rid.isPersistent()) {
                            return null;
                        }
                        this.databaseTwo.activateOnCurrentThread();
                        try (OResultSet resultSet = this.databaseTwo.query("select value from ___exportImportRIDMap where key = ?", rid.toString());){
                            if (resultSet.hasNext()) {
                                ORecordId oRecordId = new ORecordId((String)resultSet.next().getProperty("value"));
                                return oRecordId;
                            }
                            ORID oRID = null;
                            return oRID;
                        }
                    };
                } else {
                    this.listener.onMessage("\nMapping data were not found.");
                }
            }
            this.compareClusters();
            this.compareRecords(ridMapper);
            this.compareSchema();
            this.compareIndexes(ridMapper);
            if (this.differences == 0) {
                this.listener.onMessage("\n\nDatabases match.");
                boolean bl = true;
                return bl;
            }
            this.listener.onMessage("\n\nDatabases do not match. Found " + this.differences + " difference(s).");
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            OLogManager.instance().error(this, "Error on comparing database '%s' against '%s'", e, this.databaseOne.getName(), this.databaseTwo.getName());
            throw new ODatabaseExportException("Error on comparing database '" + this.databaseOne.getName() + "' against '" + this.databaseTwo.getName() + "'", e);
        }
        finally {
            ODocumentHelper.makeDbCall(this.databaseOne, database -> {
                database.close();
                return null;
            });
            ODocumentHelper.makeDbCall(this.databaseTwo, database -> {
                database.close();
                return null;
            });
        }
    }

    private void compareSchema() {
        OImmutableSchema schema1 = this.databaseOne.getMetadata().getImmutableSchemaSnapshot();
        OImmutableSchema schema2 = this.databaseTwo.getMetadata().getImmutableSchemaSnapshot();
        boolean ok = true;
        for (OClass clazz : schema1.getClasses()) {
            OClass clazz2 = schema2.getClass(clazz.getName());
            if (clazz2 == null) {
                this.listener.onMessage("\n- ERR: Class definition " + clazz.getName() + " for DB2 is null.");
                continue;
            }
            List<String> sc1 = clazz.getSuperClassesNames();
            List<String> sc2 = clazz2.getSuperClassesNames();
            if (!(sc1.isEmpty() && sc2.isEmpty() || sc1.containsAll(sc2) && sc2.containsAll(sc1))) {
                this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " in DB1 is not equals in superclasses in DB2.");
                ok = false;
            }
            if (!clazz.getClassIndexes().equals(clazz2.getClassIndexes())) {
                this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " in DB1 is not equals in indexes in DB2.");
                ok = false;
            }
            if (!Arrays.equals(clazz.getClusterIds(), clazz2.getClusterIds())) {
                this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " in DB1 is not equals in clusters in DB2.");
                ok = false;
            }
            if (!clazz.getCustomKeys().equals(clazz2.getCustomKeys())) {
                this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " in DB1 is not equals in custom keys in DB2.");
                ok = false;
            }
            if (clazz.getOverSize() != clazz2.getOverSize()) {
                this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " in DB1 is not equals in overSize in DB2.");
                ok = false;
            }
            if (clazz.getDefaultClusterId() != clazz2.getDefaultClusterId()) {
                this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " in DB1 is not equals in default cluser id in DB2.");
                ok = false;
            }
            for (OProperty prop : clazz.declaredProperties()) {
                OProperty prop2 = clazz2.getProperty(prop.getName());
                if (prop2 == null) {
                    this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " as missed property " + prop.getName() + "in DB2.");
                    ok = false;
                    continue;
                }
                if (prop.getType() != prop2.getType()) {
                    this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " as not same type for property " + prop.getName() + "in DB2. ");
                    ok = false;
                }
                if (prop.getLinkedType() != prop2.getLinkedType()) {
                    this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " as not same linkedtype for property " + prop.getName() + "in DB2.");
                    ok = false;
                }
                if (prop.getMin() != null && !prop.getMin().equals(prop2.getMin())) {
                    this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " as not same min for property " + prop.getName() + "in DB2.");
                    ok = false;
                }
                if (prop.getMax() != null && !prop.getMax().equals(prop2.getMax())) {
                    this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " as not same max for property " + prop.getName() + "in DB2.");
                    ok = false;
                }
                if (prop.getMax() != null && !prop.getMax().equals(prop2.getMax())) {
                    this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " as not same regexp for property " + prop.getName() + "in DB2.");
                    ok = false;
                }
                if (prop.getLinkedClass() != null && !prop.getLinkedClass().equals(prop2.getLinkedClass())) {
                    this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " as not same linked class for property " + prop.getName() + "in DB2.");
                    ok = false;
                }
                if (prop.getLinkedClass() != null && !prop.getCustomKeys().equals(prop2.getCustomKeys())) {
                    this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " as not same custom keys for property " + prop.getName() + "in DB2.");
                    ok = false;
                }
                if (prop.isMandatory() != prop2.isMandatory()) {
                    this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " as not same mandatory flag for property " + prop.getName() + "in DB2.");
                    ok = false;
                }
                if (prop.isNotNull() != prop2.isNotNull()) {
                    this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " as not same nut null flag for property " + prop.getName() + "in DB2.");
                    ok = false;
                }
                if (prop.isReadonly() == prop2.isReadonly()) continue;
                this.listener.onMessage("\n- ERR: Class definition for " + clazz.getName() + " as not same readonly flag setting for property " + prop.getName() + "in DB2.");
                ok = false;
            }
            if (ok) continue;
            ++this.differences;
            ok = true;
        }
    }

    private void compareIndexes(ODocumentHelper.RIDMapper ridMapper) {
        this.listener.onMessage("\nStarting index comparison:");
        boolean ok = true;
        OIndexManagerAbstract indexManagerOne = ODocumentHelper.makeDbCall(this.databaseOne, database -> database.getMetadata().getIndexManagerInternal());
        OIndexManagerAbstract indexManagerTwo = ODocumentHelper.makeDbCall(this.databaseTwo, database -> database.getMetadata().getIndexManagerInternal());
        Collection indexesOne = ODocumentHelper.makeDbCall(this.databaseOne, indexManagerOne::getIndexes);
        int indexesSizeOne = ODocumentHelper.makeDbCall(this.databaseTwo, database -> indexesOne.size());
        int indexesSizeTwo = ODocumentHelper.makeDbCall(this.databaseTwo, database -> indexManagerTwo.getIndexes(database).size());
        if (ODocumentHelper.makeDbCall(this.databaseTwo, database -> indexManagerTwo.getIndex(database, "___exportImportRIDMapIndex") != null).booleanValue()) {
            --indexesSizeTwo;
        }
        if (indexesSizeOne != indexesSizeTwo) {
            ok = false;
            this.listener.onMessage("\n- ERR: Amount of indexes are different.");
            this.listener.onMessage("\n--- DB1: " + indexesSizeOne);
            this.listener.onMessage("\n--- DB2: " + indexesSizeTwo);
            this.listener.onMessage("\n");
            ++this.differences;
        }
        Iterator iteratorOne = ODocumentHelper.makeDbCall(this.databaseOne, database -> indexesOne.iterator());
        while (ODocumentHelper.makeDbCall(this.databaseOne, database -> iteratorOne.hasNext()).booleanValue()) {
            long indexTwoSize;
            OIndex indexOne = ODocumentHelper.makeDbCall(this.databaseOne, database -> (OIndex)iteratorOne.next());
            String indexName = ODocumentHelper.makeDbCall(this.databaseOne, database -> indexOne.getName());
            if (this.excludeIndexes.contains(indexName)) continue;
            OIndex indexTwo = ODocumentHelper.makeDbCall(this.databaseTwo, database -> indexManagerTwo.getIndex(database, indexOne.getName()));
            if (indexTwo == null) {
                ok = false;
                this.listener.onMessage("\n- ERR: Index " + indexOne.getName() + " is absent in DB2.");
                ++this.differences;
                continue;
            }
            if (!indexOne.getType().equals(indexTwo.getType())) {
                ok = false;
                this.listener.onMessage("\n- ERR: Index types for index " + indexOne.getName() + " are different.");
                this.listener.onMessage("\n--- DB1: " + indexOne.getType());
                this.listener.onMessage("\n--- DB2: " + indexTwo.getType());
                this.listener.onMessage("\n");
                ++this.differences;
                continue;
            }
            if (!indexOne.getClusters().equals(indexTwo.getClusters())) {
                ok = false;
                this.listener.onMessage("\n- ERR: Clusters to index for index " + indexOne.getName() + " are different.");
                this.listener.onMessage("\n--- DB1: " + indexOne.getClusters());
                this.listener.onMessage("\n--- DB2: " + indexTwo.getClusters());
                this.listener.onMessage("\n");
                ++this.differences;
                continue;
            }
            if (indexOne.getDefinition() == null && indexTwo.getDefinition() != null) {
                this.listener.onMessage("\n- WARN: Index definition for index " + indexOne.getName() + " for DB2 is not null.");
                continue;
            }
            if (indexOne.getDefinition() != null && indexTwo.getDefinition() == null) {
                ok = false;
                this.listener.onMessage("\n- ERR: Index definition for index " + indexOne.getName() + " for DB2 is null.");
                ++this.differences;
                continue;
            }
            if (indexOne.getDefinition() != null && !indexOne.getDefinition().equals(indexTwo.getDefinition())) {
                ok = false;
                this.listener.onMessage("\n- ERR: Index definitions for index " + indexOne.getName() + " are different.");
                this.listener.onMessage("\n--- DB1: " + indexOne.getDefinition());
                this.listener.onMessage("\n--- DB2: " + indexTwo.getDefinition());
                this.listener.onMessage("\n");
                ++this.differences;
                continue;
            }
            long indexOneSize = ODocumentHelper.makeDbCall(this.databaseOne, database -> ((OIndexInternal)indexOne).size());
            if (indexOneSize != (indexTwoSize = ODocumentHelper.makeDbCall(this.databaseTwo, database -> ((OIndexInternal)indexTwo).size()).longValue())) {
                ok = false;
                this.listener.onMessage("\n- ERR: Amount of entries for index " + indexOne.getName() + " are different.");
                this.listener.onMessage("\n--- DB1: " + indexOneSize);
                this.listener.onMessage("\n--- DB2: " + indexTwoSize);
                this.listener.onMessage("\n");
                ++this.differences;
            }
            if (this.compareIndexMetadata) {
                ODocument metadataOne = indexOne.getMetadata();
                ODocument metadataTwo = indexTwo.getMetadata();
                if (metadataOne == null && metadataTwo != null) {
                    ok = false;
                    this.listener.onMessage("\n- ERR: Metadata for index " + indexOne.getName() + " for DB1 is null but for DB2 is not.");
                    this.listener.onMessage("\n");
                    ++this.differences;
                } else if (metadataOne != null && metadataTwo == null) {
                    ok = false;
                    this.listener.onMessage("\n- ERR: Metadata for index " + indexOne.getName() + " for DB1 is not null but for DB2 is null.");
                    this.listener.onMessage("\n");
                    ++this.differences;
                } else if (metadataOne != null && !ODocumentHelper.hasSameContentOf(metadataOne, this.databaseOne, metadataTwo, this.databaseTwo, ridMapper)) {
                    ok = false;
                    this.listener.onMessage("\n- ERR: Metadata for index " + indexOne.getName() + " for DB1 and for DB2 are different.");
                    ODocumentHelper.makeDbCall(this.databaseOne, database -> {
                        this.listener.onMessage("\n--- M1: " + metadataOne);
                        return null;
                    });
                    ODocumentHelper.makeDbCall(this.databaseTwo, database -> {
                        this.listener.onMessage("\n--- M2: " + metadataTwo);
                        return null;
                    });
                    this.listener.onMessage("\n");
                    ++this.differences;
                }
            }
            if ((!this.compareEntriesForAutomaticIndexes || indexOne.getType().equals("DICTIONARY")) && indexOne.isAutomatic()) continue;
            Stream keyStream = ODocumentHelper.makeDbCall(this.databaseOne, database -> ((OIndexInternal)indexOne).keyStream());
            Throwable throwable = null;
            try {
                Iterator indexKeyIteratorOne = ODocumentHelper.makeDbCall(this.databaseOne, database -> keyStream.iterator());
                while (ODocumentHelper.makeDbCall(this.databaseOne, database -> indexKeyIteratorOne.hasNext()).booleanValue()) {
                    Object indexKey = ODocumentHelper.makeDbCall(this.databaseOne, database -> indexKeyIteratorOne.next());
                    try (Stream indexOneStream = ODocumentHelper.makeDbCall(this.databaseOne, database -> indexOne.getInternal().getRids(indexKey));
                         Stream indexTwoValue = ODocumentHelper.makeDbCall(this.databaseTwo, database -> indexTwo.getInternal().getRids(indexKey));){
                        this.differences = ODatabaseCompare.compareIndexStreams(indexKey, indexOneStream, indexTwoValue, ridMapper, this.listener);
                    }
                    ok = ok && this.differences > 0;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (keyStream == null) continue;
                if (throwable != null) {
                    try {
                        keyStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                keyStream.close();
            }
        }
        if (ok) {
            this.listener.onMessage("OK");
        }
    }

    private static int compareIndexStreams(Object indexKey, Stream<ORID> streamOne, Stream<ORID> streamTwo, ODocumentHelper.RIDMapper ridMapper, OCommandOutputListener listener) {
        ORID rid;
        HashSet<ORID> streamTwoSet = new HashSet<ORID>();
        Iterator streamOneIterator = streamOne.iterator();
        Iterator streamTwoIterator = streamTwo.iterator();
        int differences = 0;
        while (streamOneIterator.hasNext()) {
            if (ridMapper == null) {
                rid = (ORID)streamOneIterator.next();
            } else {
                ORID streamOneRid = (ORID)streamOneIterator.next();
                rid = ridMapper.map(streamOneRid);
                if (rid == null) {
                    rid = streamOneRid;
                }
            }
            if (streamTwoSet.remove(rid)) continue;
            if (!streamTwoIterator.hasNext()) {
                listener.onMessage("\r\nEntry " + indexKey + ":" + rid + " is present in DB1 but absent in DB2");
                ++differences;
                continue;
            }
            boolean found = false;
            while (streamTwoIterator.hasNext()) {
                ORID streamRid = (ORID)streamTwoIterator.next();
                if (streamRid.equals(rid)) {
                    found = true;
                    break;
                }
                streamTwoSet.add(streamRid);
            }
            if (found) continue;
            listener.onMessage("\r\nEntry " + indexKey + ":" + rid + " is present in DB1 but absent in DB2");
        }
        while (streamTwoIterator.hasNext()) {
            rid = (ORID)streamTwoIterator.next();
            listener.onMessage("\r\nEntry " + indexKey + ":" + rid + " is present in DB2 but absent in DB1");
            ++differences;
        }
        for (ORID rid2 : streamTwoSet) {
            listener.onMessage("\r\nEntry " + indexKey + ":" + rid2 + " is present in DB2 but absent in DB1");
            ++differences;
        }
        return differences;
    }

    private static boolean compareIndexValues(Collection<ORID> oneValue, Collection<ORID> secondValue, ODocumentHelper.RIDMapper ridMapper) {
        HashMap<ORID, Integer> firstMap = new HashMap<ORID, Integer>();
        HashMap<ORID, Integer> secondMap = new HashMap<ORID, Integer>();
        for (ORID rid : oneValue) {
            ORID ridToInsert;
            if (ridMapper != null) {
                if (rid.isPersistent()) {
                    ridToInsert = ridMapper.map(rid);
                    if (ridToInsert == null) {
                        ridToInsert = rid;
                    }
                } else {
                    ridToInsert = rid;
                }
            } else {
                ridToInsert = rid;
            }
            firstMap.compute(ridToInsert, (k, v) -> {
                if (v == null) {
                    return 1;
                }
                return v + 1;
            });
        }
        for (ORID rid : secondValue) {
            secondMap.compute(rid, (k, v) -> {
                if (v == null) {
                    return 1;
                }
                return v + 1;
            });
        }
        return firstMap.equals(secondMap);
    }

    private void compareClusters() {
        this.listener.onMessage("\nStarting shallow comparison of clusters:");
        this.listener.onMessage("\nChecking the number of clusters...");
        Collection clusterNames1 = ODocumentHelper.makeDbCall(this.databaseOne, ODatabase::getClusterNames);
        Collection clusterNames2 = ODocumentHelper.makeDbCall(this.databaseTwo, ODatabase::getClusterNames);
        if (clusterNames1.size() != clusterNames2.size() - this.clusterDifference) {
            this.listener.onMessage("ERR: cluster sizes are different: " + clusterNames1.size() + " <-> " + clusterNames2.size());
            ++this.differences;
        }
        for (String clusterName : clusterNames1) {
            long countCluster2;
            long countCluster1;
            int cluster2Id;
            if (this.includeClusters != null ? !this.includeClusters.contains(clusterName) : this.excludeClusters != null && this.excludeClusters.contains(clusterName)) continue;
            boolean ok = true;
            int cluster1Id = ODocumentHelper.makeDbCall(this.databaseTwo, database -> database.getClusterIdByName(clusterName));
            this.listener.onMessage("\n- Checking cluster " + String.format("%-25s: ", "'" + clusterName + "'"));
            if (cluster1Id == -1) {
                this.listener.onMessage("ERR: cluster name '" + clusterName + "' was not found on database " + this.databaseTwo.getName());
                ++this.differences;
                ok = false;
            }
            if (cluster1Id != (cluster2Id = ODocumentHelper.makeDbCall(this.databaseOne, database -> database.getClusterIdByName(clusterName)).intValue())) {
                this.listener.onMessage("ERR: cluster id is different for cluster " + clusterName + ": " + cluster2Id + " <-> " + cluster1Id);
                ++this.differences;
                ok = false;
            }
            if ((countCluster1 = ODocumentHelper.makeDbCall(this.databaseOne, database -> database.getStorage().count(cluster1Id)).longValue()) != (countCluster2 = ODocumentHelper.makeDbCall(this.databaseOne, database -> database.getStorage().count(cluster2Id)).longValue())) {
                this.listener.onMessage("ERR: number of records different in cluster '" + clusterName + "' (id=" + cluster1Id + "): " + countCluster1 + " <-> " + countCluster2);
                ++this.differences;
                ok = false;
            }
            if (!ok) continue;
            this.listener.onMessage("OK");
        }
        this.listener.onMessage("\n\nShallow analysis done.");
    }

    private void compareRecords(ODocumentHelper.RIDMapper ridMapper) {
        this.listener.onMessage("\nStarting deep comparison record by record. This may take a few minutes. Wait please...");
        Collection clusterNames1 = ODocumentHelper.makeDbCall(this.databaseOne, ODatabase::getClusterNames);
        for (String clusterName : clusterNames1) {
            if (this.includeClusters != null ? !this.includeClusters.contains(clusterName) : this.excludeClusters != null && this.excludeClusters.contains(clusterName)) continue;
            int clusterId1 = ODocumentHelper.makeDbCall(this.databaseOne, database -> database.getClusterIdByName(clusterName));
            long[] db1Range = ODocumentHelper.makeDbCall(this.databaseOne, database -> database.getStorage().getClusterDataRange(clusterId1));
            long[] db2Range = ODocumentHelper.makeDbCall(this.databaseTwo, database -> database.getStorage().getClusterDataRange(clusterId1));
            long db1Max = db1Range[1];
            long db2Max = db2Range[1];
            this.databaseOne.activateOnCurrentThread();
            ODocument doc1 = new ODocument();
            this.databaseTwo.activateOnCurrentThread();
            ODocument doc2 = new ODocument();
            ORecordId rid = new ORecordId(clusterId1);
            long clusterMax = Math.max(db1Max, db2Max);
            ODatabaseDocumentInternal selectedDatabase = clusterMax == db1Max ? this.databaseOne : this.databaseTwo;
            OPhysicalPosition[] physicalPositions = ODocumentHelper.makeDbCall(selectedDatabase, database -> database.getStorage().ceilingPhysicalPositions(clusterId1, new OPhysicalPosition(0L)));
            OStorageConfiguration configuration1 = ODocumentHelper.makeDbCall(this.databaseOne, database -> database.getStorage().getConfiguration());
            OStorageConfiguration configuration2 = ODocumentHelper.makeDbCall(this.databaseTwo, database -> database.getStorage().getConfiguration());
            String storageType1 = ODocumentHelper.makeDbCall(this.databaseOne, database -> database.getStorage().getType());
            String storageType2 = ODocumentHelper.makeDbCall(this.databaseTwo, database -> database.getStorage().getType());
            long recordsCounter = 0L;
            while (physicalPositions.length > 0) {
                block4: for (OPhysicalPosition physicalPosition : physicalPositions) {
                    try {
                        ORID newRid;
                        ++recordsCounter;
                        long position = physicalPosition.clusterPosition;
                        rid.setClusterPosition(position);
                        if (rid.equals(new ORecordId(configuration1.getIndexMgrRecordId())) && rid.equals(new ORecordId(configuration2.getIndexMgrRecordId())) || rid.equals(new ORecordId(configuration1.getSchemaRecordId())) && rid.equals(new ORecordId(configuration2.getSchemaRecordId())) || rid.getClusterId() == 0 && rid.getClusterPosition() == 0L && !storageType1.equals(storageType2)) continue;
                        ORecordId rid2 = ridMapper == null ? rid : ((newRid = ridMapper.map(rid)) == null ? rid : new ORecordId(newRid));
                        ORawBuffer buffer1 = ODocumentHelper.makeDbCall(this.databaseOne, database -> database.getStorage().readRecord(rid, null, true, false, null).getResult());
                        ORawBuffer buffer2 = ODocumentHelper.makeDbCall(this.databaseTwo, database -> database.getStorage().readRecord(rid2, null, true, false, null).getResult());
                        if (buffer1 == null && buffer2 == null) continue;
                        if (buffer1 == null) {
                            this.listener.onMessage("\n- ERR: RID=" + clusterId1 + ":" + position + " is null in DB1");
                            ++this.differences;
                            continue;
                        }
                        if (buffer2 == null) {
                            this.listener.onMessage("\n- ERR: RID=" + clusterId1 + ":" + position + " is null in DB2");
                            ++this.differences;
                            continue;
                        }
                        if (buffer1.recordType != buffer2.recordType) {
                            this.listener.onMessage("\n- ERR: RID=" + clusterId1 + ":" + position + " recordType is different: " + (char)buffer1.recordType + " <-> " + (char)buffer2.recordType);
                            ++this.differences;
                        }
                        if (buffer1.buffer == null && buffer2.buffer == null) continue;
                        if (buffer1.buffer == null) {
                            this.listener.onMessage("\n- ERR: RID=" + clusterId1 + ":" + position + " content is different: null <-> " + buffer2.buffer.length);
                            ++this.differences;
                            continue;
                        }
                        if (buffer2.buffer == null) {
                            this.listener.onMessage("\n- ERR: RID=" + clusterId1 + ":" + position + " content is different: " + buffer1.buffer.length + " <-> null");
                            ++this.differences;
                            continue;
                        }
                        if (buffer1.recordType == 100) {
                            ODocumentHelper.makeDbCall(this.databaseOne, database -> {
                                doc1.reset();
                                doc1.fromStream(buffer1.buffer);
                                return null;
                            });
                            ODocumentHelper.makeDbCall(this.databaseTwo, database -> {
                                doc2.reset();
                                doc2.fromStream(buffer2.buffer);
                                return null;
                            });
                            if (rid.toString().equals(configuration1.getSchemaRecordId()) && rid.toString().equals(configuration2.getSchemaRecordId())) {
                                ODocumentHelper.makeDbCall(this.databaseOne, database -> {
                                    ODatabaseCompare.convertSchemaDoc(doc1);
                                    return null;
                                });
                                ODocumentHelper.makeDbCall(this.databaseTwo, database -> {
                                    ODatabaseCompare.convertSchemaDoc(doc2);
                                    return null;
                                });
                            }
                            if (ODocumentHelper.hasSameContentOf(doc1, this.databaseOne, doc2, this.databaseTwo, ridMapper)) continue;
                            this.listener.onMessage("\n- ERR: RID=" + clusterId1 + ":" + position + " document content is different");
                            this.listener.onMessage("\n--- REC1: " + new String(buffer1.buffer));
                            this.listener.onMessage("\n--- REC2: " + new String(buffer2.buffer));
                            this.listener.onMessage("\n");
                            ++this.differences;
                            continue;
                        }
                        if (buffer1.buffer.length != buffer2.buffer.length) {
                            String rec1 = new String(buffer1.buffer).trim();
                            String rec2 = new String(buffer2.buffer).trim();
                            if (rec1.length() == rec2.length()) continue;
                            this.listener.onMessage("\n- ERR: RID=" + clusterId1 + ":" + position + " content length is different: " + buffer1.buffer.length + " <-> " + buffer2.buffer.length);
                            if (buffer1.recordType == 100) {
                                this.listener.onMessage("\n--- REC1: " + rec1);
                            }
                            if (buffer2.recordType == 100) {
                                this.listener.onMessage("\n--- REC2: " + rec2);
                            }
                            this.listener.onMessage("\n");
                            ++this.differences;
                            continue;
                        }
                        for (int b = 0; b < buffer1.buffer.length; ++b) {
                            if (buffer1.buffer[b] == buffer2.buffer[b]) continue;
                            this.listener.onMessage("\n- ERR: RID=" + clusterId1 + ":" + position + " content is different at byte #" + b + ": " + buffer1.buffer[b] + " <-> " + buffer2.buffer[b]);
                            this.listener.onMessage("\n--- REC1: " + new String(buffer1.buffer));
                            this.listener.onMessage("\n--- REC2: " + new String(buffer2.buffer));
                            this.listener.onMessage("\n");
                            ++this.differences;
                            continue block4;
                        }
                    }
                    catch (RuntimeException e) {
                        OLogManager.instance().error(this, "Error during data comparison of records with rid " + rid, e, new Object[0]);
                        throw e;
                    }
                }
                OPhysicalPosition[] curPosition = physicalPositions;
                physicalPositions = ODocumentHelper.makeDbCall(selectedDatabase, database -> database.getStorage().higherPhysicalPositions(clusterId1, curPosition[curPosition.length - 1]));
                if (recordsCounter % 10000L != 0L) continue;
                this.listener.onMessage("\n" + recordsCounter + " records were processed for cluster " + clusterName + " ...");
            }
            this.listener.onMessage("\nCluster comparison was finished, " + recordsCounter + " records were processed for cluster " + clusterName + " ...");
        }
    }

    public void setCompareIndexMetadata(boolean compareIndexMetadata) {
        this.compareIndexMetadata = compareIndexMetadata;
    }

    public boolean isCompareEntriesForAutomaticIndexes() {
        return this.compareEntriesForAutomaticIndexes;
    }

    public void setCompareEntriesForAutomaticIndexes(boolean compareEntriesForAutomaticIndexes) {
        this.compareEntriesForAutomaticIndexes = compareEntriesForAutomaticIndexes;
    }

    public void setAutoDetectExportImportMap(boolean autoDetectExportImportMap) {
        this.autoDetectExportImportMap = autoDetectExportImportMap;
    }

    private static void convertSchemaDoc(ODocument document) {
        if (document.field("classes") != null) {
            document.setFieldType("classes", OType.EMBEDDEDSET);
            for (ODocument classDoc : (Set)document.field("classes")) {
                classDoc.setFieldType("properties", OType.EMBEDDEDSET);
            }
        }
    }

    private void reportIndexDiff(OIndex indexOne, Object key, Object indexOneValue, Object indexTwoValue) {
        this.listener.onMessage("\n- ERR: Entry values for key '" + key + "' are different for index " + indexOne.getName());
        this.listener.onMessage("\n--- DB1: " + ODocumentHelper.makeDbCall(this.databaseOne, database -> indexOneValue.toString()));
        this.listener.onMessage("\n--- DB2: " + ODocumentHelper.makeDbCall(this.databaseOne, database -> indexTwoValue.toString()));
        this.listener.onMessage("\n");
        ++this.differences;
    }
}

