/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.util.Collections;
import java.util.List;

public abstract class ODatabaseTool
implements Runnable {
    protected OCommandOutputListener output;
    protected ODatabaseDocumentInternal database;
    protected boolean verbose = false;

    protected abstract void parseSetting(String var1, List<String> var2);

    protected void message(String iMessage, Object ... iArgs) {
        if (this.output != null) {
            this.output.onMessage(String.format(iMessage, iArgs));
        }
    }

    public ODatabaseTool setOptions(String iOptions) {
        if (iOptions != null) {
            List<String> options = OStringSerializerHelper.smartSplit(iOptions, ' ', new char[0]);
            for (String o : options) {
                int sep = o.indexOf(61);
                if (sep == -1) {
                    this.parseSetting(o, Collections.EMPTY_LIST);
                    continue;
                }
                String option = o.substring(0, sep);
                String value = OIOUtils.getStringContent(o.substring(sep + 1));
                List<String> items = OStringSerializerHelper.smartSplit(value, ' ', new char[0]);
                this.parseSetting(option, items);
            }
        }
        return this;
    }

    public ODatabaseTool setOutputListener(OCommandOutputListener iListener) {
        this.output = iListener;
        return this;
    }

    public ODatabaseTool setDatabase(ODatabaseDocumentInternal database) {
        this.database = database;
        return this;
    }

    public ODatabaseTool setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }
}

