/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OClassIndexManager {
    public static void checkIndexesAfterCreate(ODocument document, ODatabaseDocumentInternal database) {
        document = OClassIndexManager.checkForLoading(document);
        ArrayList<IndexChange> ops = new ArrayList<IndexChange>();
        OClassIndexManager.processIndexOnCreate(database, document, ops);
        OClassIndexManager.applyChanges(ops);
    }

    public static void processIndexOnCreate(ODatabaseDocumentInternal database, ODocument document, List<IndexChange> ops) {
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(database, document);
        if (cls != null) {
            Set<OIndex> indexes = cls.getRawIndexes();
            OClassIndexManager.addIndexesEntries(database, document, indexes, ops);
        }
    }

    public static void checkIndexesAfterUpdate(ODocument iDocument, ODatabaseDocumentInternal database) {
        iDocument = OClassIndexManager.checkForLoading(iDocument);
        ArrayList<IndexChange> changes = new ArrayList<IndexChange>();
        OClassIndexManager.processIndexOnUpdate(database, iDocument, changes);
        OClassIndexManager.applyChanges(changes);
    }

    public static void processIndexOnUpdate(ODatabaseDocumentInternal database, ODocument iDocument, List<IndexChange> changes) {
        HashSet<String> dirtyFields;
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(database, iDocument);
        if (cls == null) {
            return;
        }
        Set<OIndex> indexes = cls.getRawIndexes();
        if (!indexes.isEmpty() && !(dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()))).isEmpty()) {
            for (OIndex index : indexes) {
                OClassIndexManager.processIndexUpdate(iDocument, dirtyFields, OClassIndexManager.getTransactionalIndex(database, index), changes);
            }
        }
    }

    private static OIndex getTransactionalIndex(ODatabaseDocumentInternal database, OIndex index) {
        return database.getMetadata().getIndexManagerInternal().preProcessBeforeReturn(database, index);
    }

    public static void checkIndexesAfterDelete(ODocument iDocument, ODatabaseDocumentInternal database) {
        ArrayList<IndexChange> changes = new ArrayList<IndexChange>();
        OClassIndexManager.processIndexOnDelete(database, iDocument, changes);
        OClassIndexManager.applyChanges(changes);
    }

    protected static void putInIndex(OIndex index, Object key, OIdentifiable value) {
        index.put(key, value);
    }

    protected static void removeFromIndex(OIndex index, Object key, OIdentifiable value) {
        index.remove(key, value);
    }

    private static void processCompositeIndexUpdate(OIndex index, Set<String> dirtyFields, ODocument iRecord, List<IndexChange> changes) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        String multiValueField = indexDefinition.getMultiValueField();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField == null) {
                Object origValue = indexDefinition.createValue(origValues);
                Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                if (!indexDefinition.isNullValuesIgnored() || origValue != null) {
                    OClassIndexManager.addRemove(changes, index, origValue, iRecord);
                }
                if (!indexDefinition.isNullValuesIgnored() || newValue != null) {
                    OClassIndexManager.addPut(changes, index, newValue, iRecord.getIdentity());
                }
            } else {
                OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine == null) {
                    if (dirtyFields.contains(multiValueField)) {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                    } else {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                    }
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue, changes);
                } else if (dirtyFields.size() == 1 && indexDefinition.isNullValuesIgnored()) {
                    HashMap<OCompositeKey, Integer> keysToAdd = new HashMap<OCompositeKey, Integer>();
                    HashMap<OCompositeKey, Integer> keysToRemove = new HashMap<OCompositeKey, Integer>();
                    for (OMultiValueChangeEvent<Object, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                        indexDefinition.processChangeEvent(changeEvent, keysToAdd, keysToRemove, origValues.toArray());
                    }
                    for (OMultiValueChangeEvent<Object, Object> keyToRemove : keysToRemove.keySet()) {
                        OClassIndexManager.addRemove(changes, index, keyToRemove, iRecord);
                    }
                    for (OMultiValueChangeEvent<Object, Object> keyToAdd : keysToAdd.keySet()) {
                        OClassIndexManager.addPut(changes, index, keyToAdd, iRecord.getIdentity());
                    }
                } else {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue, changes);
                }
            }
            return;
        }
    }

    private static void processSingleIndexUpdate(OIndex index, Set<String> dirtyFields, ODocument iRecord, List<IndexChange> changes) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return;
        }
        String indexField = indexFields.get(0);
        if (!dirtyFields.contains(indexField)) {
            return;
        }
        OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
        if (multiValueChangeTimeLine != null) {
            OIndexDefinitionMultiValue indexDefinitionMultiValue = (OIndexDefinitionMultiValue)indexDefinition;
            HashMap<Object, Integer> keysToAdd = new HashMap<Object, Integer>();
            HashMap<Object, Integer> keysToRemove = new HashMap<Object, Integer>();
            for (OMultiValueChangeEvent<Object, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                indexDefinitionMultiValue.processChangeEvent(changeEvent, keysToAdd, keysToRemove);
            }
            for (OMultiValueChangeEvent<Object, Object> keyToRemove : keysToRemove.keySet()) {
                OClassIndexManager.addRemove(changes, index, keyToRemove, iRecord);
            }
            for (OMultiValueChangeEvent<Object, Object> keyToAdd : keysToAdd.keySet()) {
                OClassIndexManager.addPut(changes, index, keyToAdd, iRecord.getIdentity());
            }
        } else {
            Object origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
            OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue, changes);
        }
    }

    private static void processIndexUpdateFieldAssignment(OIndex index, ODocument iRecord, Object origValue, Object newValue, List<IndexChange> changes) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (origValue instanceof Collection && newValue instanceof Collection) {
            HashSet valuesToRemove = new HashSet((Collection)origValue);
            HashSet valuesToAdd = new HashSet((Collection)newValue);
            valuesToRemove.removeAll((Collection)newValue);
            valuesToAdd.removeAll((Collection)origValue);
            for (Object valueToRemove : valuesToRemove) {
                if (indexDefinition.isNullValuesIgnored() && valueToRemove == null) continue;
                OClassIndexManager.addRemove(changes, index, valueToRemove, iRecord);
            }
            for (Object valueToAdd : valuesToAdd) {
                if (indexDefinition.isNullValuesIgnored() && valueToAdd == null) continue;
                OClassIndexManager.addPut(changes, index, valueToAdd, iRecord);
            }
        } else {
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue, changes);
            if (newValue instanceof Collection) {
                for (Object newValueItem : (Collection)newValue) {
                    OClassIndexManager.addPut(changes, index, newValueItem, iRecord.getIdentity());
                }
            } else if (!indexDefinition.isNullValuesIgnored() || newValue != null) {
                OClassIndexManager.addPut(changes, index, newValue, iRecord.getIdentity());
            }
        }
    }

    private static boolean processCompositeIndexDelete(OIndex index, Set<String> dirtyFields, ODocument iRecord, List<IndexChange> changes) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        String multiValueField = indexDefinition.getMultiValueField();
        List<String> indexFields = indexDefinition.getFields();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField != null) {
                OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine != null) {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                } else if (dirtyFields.contains(multiValueField)) {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                } else {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                }
            }
            Object origValue = indexDefinition.createValue(origValues);
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue, changes);
            return true;
        }
        return false;
    }

    private static void deleteIndexKey(OIndex index, ODocument iRecord, Object origValue, List<IndexChange> changes) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (origValue instanceof Collection) {
            for (Object valueItem : (Collection)origValue) {
                if (indexDefinition.isNullValuesIgnored() && valueItem == null) continue;
                OClassIndexManager.addRemove(changes, index, valueItem, iRecord);
            }
        } else if (!indexDefinition.isNullValuesIgnored() || origValue != null) {
            OClassIndexManager.addRemove(changes, index, origValue, iRecord);
        }
    }

    private static boolean processSingleIndexDelete(OIndex index, Set<String> dirtyFields, ODocument iRecord, List<IndexChange> changes) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return false;
        }
        String indexField = indexFields.iterator().next();
        if (dirtyFields.contains(indexField)) {
            Object origValue;
            OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
            if (multiValueChangeTimeLine != null) {
                OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(indexField);
                Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                origValue = indexDefinition.createValue(restoredMultiValue);
            } else {
                origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            }
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue, changes);
            return true;
        }
        return false;
    }

    private static ODocument checkForLoading(ODocument iRecord) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                return (ODocument)iRecord.load();
            }
            catch (ORecordNotFoundException e) {
                throw OException.wrapException(new OIndexException("Error during loading of record with id " + iRecord.getIdentity()), e);
            }
        }
        return iRecord;
    }

    public static void processIndexUpdate(ODocument iDocument, Set<String> dirtyFields, OIndex index, List<IndexChange> changes) {
        if (index.getDefinition() instanceof OCompositeIndexDefinition) {
            OClassIndexManager.processCompositeIndexUpdate(index, dirtyFields, iDocument, changes);
        } else {
            OClassIndexManager.processSingleIndexUpdate(index, dirtyFields, iDocument, changes);
        }
    }

    private static void addIndexesEntries(ODatabaseDocumentInternal database, ODocument document, Collection<OIndex> indexes, List<IndexChange> changes) {
        ORID rid = document.getIdentity();
        for (OIndex index : indexes) {
            OClassIndexManager.addIndexEntry(document, rid, OClassIndexManager.getTransactionalIndex(database, index), changes);
        }
    }

    private static void addIndexEntry(ODocument document, OIdentifiable rid, OIndex index, List<IndexChange> changes) {
        OIndexDefinition indexDefinition = index.getDefinition();
        Object key = indexDefinition.getDocumentValueToIndex(document);
        if (key instanceof Collection) {
            for (Object keyItem : (Collection)key) {
                if (indexDefinition.isNullValuesIgnored() && keyItem == null) continue;
                OClassIndexManager.addPut(changes, index, keyItem, rid);
            }
        } else if (!indexDefinition.isNullValuesIgnored() || key != null) {
            OClassIndexManager.addPut(changes, index, key, rid);
        }
    }

    public static void processIndexOnDelete(ODatabaseDocumentInternal database, ODocument iDocument, List<IndexChange> changes) {
        HashSet<String> dirtyFields;
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(database, iDocument);
        if (cls == null) {
            return;
        }
        ArrayList<OIndex> indexes = new ArrayList<OIndex>();
        for (OIndex index : cls.getRawIndexes()) {
            indexes.add(OClassIndexManager.getTransactionalIndex(database, index));
        }
        if (!indexes.isEmpty() && !(dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()))).isEmpty()) {
            Iterator indexIterator = indexes.iterator();
            while (indexIterator.hasNext()) {
                OIndex index = (OIndex)indexIterator.next();
                boolean result = index.getDefinition() instanceof OCompositeIndexDefinition ? OClassIndexManager.processCompositeIndexDelete(index, dirtyFields, iDocument, changes) : OClassIndexManager.processSingleIndexDelete(index, dirtyFields, iDocument, changes);
                if (!result) continue;
                indexIterator.remove();
            }
        }
        for (OIndex index : indexes) {
            Object key = index.getDefinition().getDocumentValueToIndex(iDocument);
            OClassIndexManager.deleteIndexKey(index, iDocument, key, changes);
        }
    }

    private static void addPut(List<IndexChange> changes, OIndex index, Object key, OIdentifiable value) {
        changes.add(new IndexChange(index, OTransactionIndexChanges.OPERATION.PUT, key, value));
    }

    private static void addRemove(List<IndexChange> changes, OIndex index, Object key, OIdentifiable value) {
        changes.add(new IndexChange(index, OTransactionIndexChanges.OPERATION.REMOVE, key, value));
    }

    private static void applyChanges(List<IndexChange> changes) {
        for (IndexChange op : changes) {
            if (op.operation == OTransactionIndexChanges.OPERATION.PUT) {
                OClassIndexManager.putInIndex(op.index, op.key, op.value);
                continue;
            }
            OClassIndexManager.removeFromIndex(op.index, op.key, op.value);
        }
    }

    public static class IndexChange {
        public final OIndex index;
        public final OTransactionIndexChanges.OPERATION operation;
        public final Object key;
        public final OIdentifiable value;

        public IndexChange(OIndex indexName, OTransactionIndexChanges.OPERATION operation, Object key, OIdentifiable value) {
            this.index = indexName;
            this.operation = operation;
            this.key = key;
            this.value = value;
        }
    }
}

