/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class OCompositeKey
implements Comparable<OCompositeKey>,
Serializable,
ODocumentSerializable {
    private static final long serialVersionUID = 1L;
    private final List<Object> keys;

    public OCompositeKey(List<?> keys2) {
        this.keys = new ArrayList<Object>(keys2.size());
        for (Object key : keys2) {
            this.addKey(key);
        }
    }

    public OCompositeKey(Object ... keys2) {
        this.keys = new ArrayList<Object>(keys2.length);
        for (Object key : keys2) {
            this.addKey(key);
        }
    }

    public OCompositeKey() {
        this.keys = new ArrayList<Object>();
    }

    public void reset() {
        if (this.keys != null) {
            this.keys.clear();
        }
    }

    public List<Object> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public void addKey(Object key) {
        if (key instanceof OCompositeKey) {
            OCompositeKey compositeKey = (OCompositeKey)key;
            for (Object inKey : compositeKey.keys) {
                this.addKey(inKey);
            }
        } else {
            this.keys.add(key);
        }
    }

    @Override
    public int compareTo(OCompositeKey otherKey) {
        Iterator<Object> inIter = this.keys.iterator();
        Iterator<Object> outIter = otherKey.keys.iterator();
        while (inIter.hasNext() && outIter.hasNext()) {
            Object inKey = inIter.next();
            Object outKey = outIter.next();
            if (outKey instanceof OAlwaysGreaterKey) {
                return -1;
            }
            if (outKey instanceof OAlwaysLessKey) {
                return 1;
            }
            if (inKey instanceof OAlwaysGreaterKey) {
                return 1;
            }
            if (inKey instanceof OAlwaysLessKey) {
                return -1;
            }
            int result = ODefaultComparator.INSTANCE.compare(inKey, outKey);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCompositeKey that = (OCompositeKey)o;
        return this.keys.equals(that.keys);
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public String toString() {
        return "OCompositeKey{keys=" + this.keys + '}';
    }

    @Override
    public ODocument toDocument() {
        ODocument document = new ODocument();
        for (int i = 0; i < this.keys.size(); ++i) {
            document.field("key" + i, this.keys.get(i));
        }
        return document;
    }

    @Override
    public void fromDocument(ODocument document) {
        document.setLazyLoad(false);
        String[] fieldNames = document.fieldNames();
        TreeMap keyMap = new TreeMap();
        for (String fieldName : fieldNames) {
            if (!fieldName.startsWith("key")) continue;
            String keyIndex = fieldName.substring(3);
            keyMap.put(Integer.valueOf(keyIndex), document.field(fieldName));
        }
        this.keys.clear();
        this.keys.addAll(keyMap.values());
    }

    public void toStream(ORecordSerializerNetworkV37 serializer, DataOutput out) throws IOException {
        int l = this.keys.size();
        out.writeInt(l);
        for (Object key : this.keys) {
            if (key instanceof OCompositeKey) {
                throw new OSerializationException("Cannot serialize unflattened nested composite key.");
            }
            if (key == null) {
                out.writeByte(-1);
                continue;
            }
            OType type = OType.getTypeByValue(key);
            byte[] bytes = serializer.serializeValue(key, type);
            out.writeByte((byte)type.getId());
            out.writeInt(bytes.length);
            out.write(bytes);
        }
    }

    public void fromStream(ORecordSerializerNetworkV37 serializer, DataInput in) throws IOException {
        int l = in.readInt();
        for (int i = 0; i < l; ++i) {
            byte b = in.readByte();
            if (b == -1) {
                this.addKey(null);
                continue;
            }
            int len = in.readInt();
            byte[] bytes = new byte[len];
            in.readFully(bytes);
            OType type = OType.getById(b);
            Object k = serializer.deserializeValue(bytes, type);
            this.addKey(k);
        }
    }
}

