/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.index.engine.v1.OCellBTreeMultiValueIndexEngine;
import com.orientechnologies.orient.core.index.engine.v1.OCellBTreeSingleValueIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.index.engine.ORemoteIndexEngine;
import com.orientechnologies.orient.core.storage.index.engine.OSBTreeIndexEngine;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ODefaultIndexFactory
implements OIndexFactory {
    private static final String SBTREE_ALGORITHM = "SBTREE";
    static final String SBTREE_BONSAI_VALUE_CONTAINER = "SBTREEBONSAISET";
    public static final String NONE_VALUE_CONTAINER = "NONE";
    static final String CELL_BTREE_ALGORITHM = "CELL_BTREE";
    private static final Set<String> TYPES;
    private static final Set<String> ALGORITHMS;

    static boolean isMultiValueIndex(String indexType) {
        switch (OClass.INDEX_TYPE.valueOf(indexType)) {
            case UNIQUE: 
            case UNIQUE_HASH_INDEX: 
            case DICTIONARY: 
            case DICTIONARY_HASH_INDEX: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<String> getTypes() {
        return TYPES;
    }

    @Override
    public Set<String> getAlgorithms() {
        return ALGORITHMS;
    }

    @Override
    public OIndexInternal createIndex(String name, OStorage storage, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata, int version) throws OConfigurationException {
        if (valueContainerAlgorithm == null) {
            valueContainerAlgorithm = NONE_VALUE_CONTAINER;
        }
        if (version < 0) {
            version = this.getLastVersion(algorithm);
        }
        return ODefaultIndexFactory.createSBTreeIndex(name, indexType, valueContainerAlgorithm, metadata, (OAbstractPaginatedStorage)storage.getUnderlying(), version, algorithm);
    }

    private static OIndexInternal createSBTreeIndex(String name, String indexType, String valueContainerAlgorithm, ODocument metadata, OAbstractPaginatedStorage storage, int version, String algorithm) {
        int binaryFormatVersion = storage.getConfiguration().getBinaryFormatVersion();
        if (OClass.INDEX_TYPE.UNIQUE.toString().equals(indexType)) {
            return new OIndexUnique(name, indexType, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        if (OClass.INDEX_TYPE.NOTUNIQUE.toString().equals(indexType)) {
            return new OIndexNotUnique(name, indexType, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        if (OClass.INDEX_TYPE.FULLTEXT.toString().equals(indexType)) {
            OLogManager.instance().warnNoDb(ODefaultIndexFactory.class, "You are creating native full text index instance. That is unsafe because this type of index is deprecated and will be removed in future.", new Object[0]);
            return new OIndexFullText(name, indexType, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        if (OClass.INDEX_TYPE.DICTIONARY.toString().equals(indexType)) {
            return new OIndexDictionary(name, indexType, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        throw new OConfigurationException("Unsupported type: " + indexType);
    }

    @Override
    public int getLastVersion(String algorithm) {
        switch (algorithm) {
            case "SBTREE": {
                return 2;
            }
            case "CELL_BTREE": {
                return 4;
            }
        }
        throw new IllegalStateException("Invalid algorithm name " + algorithm);
    }

    @Override
    public OBaseIndexEngine createIndexEngine(int indexId, String algorithm, String name, Boolean durableInNonTxMode, OStorage storage, int version, int apiVersion, boolean multiValue, Map<String, String> engineProperties) {
        OBaseIndexEngine indexEngine;
        if (algorithm == null) {
            throw new OIndexException("Name of algorithm is not specified");
        }
        String storageType = storage.getType();
        if (storageType.equals("distributed")) {
            storage = storage.getUnderlying();
            storageType = storage.getType();
        }
        block5 : switch (storageType) {
            case "memory": 
            case "plocal": {
                switch (algorithm) {
                    case "SBTREE": {
                        indexEngine = new OSBTreeIndexEngine(indexId, name, (OAbstractPaginatedStorage)storage, version);
                        break block5;
                    }
                    case "CELL_BTREE": {
                        if (multiValue) {
                            indexEngine = new OCellBTreeMultiValueIndexEngine(indexId, name, (OAbstractPaginatedStorage)storage, version);
                            break block5;
                        }
                        indexEngine = new OCellBTreeSingleValueIndexEngine(indexId, name, (OAbstractPaginatedStorage)storage, version);
                        break block5;
                    }
                }
                throw new IllegalStateException("Invalid name of algorithm :''");
            }
            case "remote": {
                indexEngine = new ORemoteIndexEngine(indexId, name);
                break;
            }
            default: {
                throw new OIndexException("Unsupported storage type: " + storageType);
            }
        }
        return indexEngine;
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OClass.INDEX_TYPE.UNIQUE.toString());
        types.add(OClass.INDEX_TYPE.NOTUNIQUE.toString());
        types.add(OClass.INDEX_TYPE.FULLTEXT.toString());
        types.add(OClass.INDEX_TYPE.DICTIONARY.toString());
        TYPES = Collections.unmodifiableSet(types);
        HashSet<String> algorithms = new HashSet<String>();
        algorithms.add(SBTREE_ALGORITHM);
        algorithms.add(CELL_BTREE_ALGORITHM);
        ALGORITHMS = Collections.unmodifiableSet(algorithms);
    }
}

