/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;

public class OIndexDictionary
extends OIndexOneValue {
    public OIndexDictionary(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata, int binaryFormatVersion) {
        super(name, typeId, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
    }

    @Override
    public OIndexOneValue put(Object key, OIdentifiable value) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        while (true) {
            try {
                this.doPut(this.storage, key, value.getIdentity());
                OIndexDictionary oIndexDictionary = this;
                return oIndexDictionary;
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void doPut(OAbstractPaginatedStorage storage, Object key, ORID rid) throws OInvalidIndexEngineIdException {
        if (this.apiVersion == 0) {
            OIndexDictionary.putV0(storage, this.indexId, key, rid);
        } else if (this.apiVersion == 1) {
            OIndexDictionary.putV1(storage, this.indexId, key, rid);
        } else {
            throw new IllegalStateException("Invalid API version, " + this.apiVersion);
        }
    }

    @Override
    public boolean isNativeTxSupported() {
        return true;
    }

    private static void putV0(OAbstractPaginatedStorage storage, int indexId, Object key, OIdentifiable value) throws OInvalidIndexEngineIdException {
        storage.putIndexValue(indexId, key, value);
    }

    private static void putV1(OAbstractPaginatedStorage storage, int indexId, Object key, OIdentifiable value) throws OInvalidIndexEngineIdException {
        storage.putRidIndexEntry(indexId, key, value.getIdentity());
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return true;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }

    @Override
    public Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(OTransactionIndexChangesPerKey changes) {
        return changes.interpret(OTransactionIndexChangesPerKey.Interpretation.Dictionary);
    }
}

