/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OPropertyAccess;
import com.orientechnologies.orient.core.metadata.security.OSecurityInternal;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceProperty;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface OIndexInternal
extends OIndex {
    public static final String CONFIG_KEYTYPE = "keyType";
    public static final String CONFIG_AUTOMATIC = "automatic";
    public static final String CONFIG_TYPE = "type";
    public static final String ALGORITHM = "algorithm";
    public static final String VALUE_CONTAINER_ALGORITHM = "valueContainerAlgorithm";
    public static final String CONFIG_NAME = "name";
    public static final String INDEX_DEFINITION = "indexDefinition";
    public static final String INDEX_DEFINITION_CLASS = "indexDefinitionClass";
    public static final String INDEX_VERSION = "indexVersion";
    public static final String METADATA = "metadata";

    public Object getCollatingValue(Object var1);

    public boolean loadFromConfiguration(ODocument var1);

    public ODocument updateConfiguration();

    public OIndex addCluster(String var1);

    public OIndex removeCluster(String var1);

    public boolean canBeUsedInEqualityOperators();

    public boolean hasRangeQuerySupport();

    public OIndexMetadata loadMetadata(ODocument var1);

    public void close();

    public void preCommit(OIndexAbstract.IndexTxSnapshot var1);

    public void addTxOperation(OIndexAbstract.IndexTxSnapshot var1, OTransactionIndexChanges var2);

    public void commit(OIndexAbstract.IndexTxSnapshot var1);

    public void postCommit(OIndexAbstract.IndexTxSnapshot var1);

    public void setType(OType var1);

    public String getIndexNameByKey(Object var1);

    public boolean acquireAtomicExclusiveLock(Object var1);

    public long size();

    public Stream<ORID> getRids(Object var1);

    public Stream<ORawPair<Object, ORID>> stream();

    public Stream<ORawPair<Object, ORID>> descStream();

    public Stream<Object> keyStream();

    public Stream<ORawPair<Object, ORID>> streamEntriesBetween(Object var1, boolean var2, Object var3, boolean var4, boolean var5);

    public Stream<ORawPair<Object, ORID>> streamEntries(Collection<?> var1, boolean var2);

    public Stream<ORawPair<Object, ORID>> streamEntriesMajor(Object var1, boolean var2, boolean var3);

    public Stream<ORawPair<Object, ORID>> streamEntriesMinor(Object var1, boolean var2, boolean var3);

    public static OIdentifiable securityFilterOnRead(OIndex idx, OIdentifiable item) {
        String indexProp;
        if (idx.getDefinition() == null) {
            return item;
        }
        String indexClass = idx.getDefinition().getClassName();
        if (indexClass == null) {
            return item;
        }
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db == null) {
            return item;
        }
        OSecurityInternal security = db.getSharedContext().getSecurity();
        if (OIndexInternal.isReadRestrictedBySecurityPolicy(indexClass, db, security)) {
            item = item.getRecord();
        }
        if (item == null) {
            return null;
        }
        if (idx.getDefinition().getFields().size() == 1 && OIndexInternal.isLabelSecurityDefined(db, security, indexClass, indexProp = idx.getDefinition().getFields().get(0))) {
            if ((item = item.getRecord()) == null) {
                return null;
            }
            if (!(item instanceof ODocument)) {
                return item;
            }
            OPropertyAccess access = ODocumentInternal.getPropertyAccess((ODocument)item);
            if (access != null && !access.isReadable(indexProp)) {
                return null;
            }
        }
        return item;
    }

    public static boolean isLabelSecurityDefined(ODatabaseDocumentInternal database, OSecurityInternal security, String indexClass, String propertyName) {
        HashSet<String> classesToCheck = new HashSet<String>();
        classesToCheck.add(indexClass);
        OClass clazz = database.getClass(indexClass);
        if (clazz == null) {
            return false;
        }
        clazz.getAllSubclasses().forEach(x -> classesToCheck.add(x.getName()));
        clazz.getAllSuperClasses().forEach(x -> classesToCheck.add(x.getName()));
        Set<OSecurityResourceProperty> allFilteredProperties = security.getAllFilteredProperties(database);
        for (String className : classesToCheck) {
            Optional<OSecurityResourceProperty> item = allFilteredProperties.stream().filter(x -> x.getClassName().equalsIgnoreCase(className)).filter(x -> x.getPropertyName().equals(propertyName)).findFirst();
            if (!item.isPresent()) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadRestrictedBySecurityPolicy(String indexClass, ODatabaseDocumentInternal db, OSecurityInternal security) {
        if (security.isReadRestrictedBySecurityPolicy(db, "database.class." + indexClass)) {
            return true;
        }
        OClass clazz = db.getClass(indexClass);
        if (clazz != null) {
            Collection<OClass> sub = clazz.getSubclasses();
            for (OClass subClass : sub) {
                if (!OIndexInternal.isReadRestrictedBySecurityPolicy(subClass.getName(), db, security)) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection securityFilterOnRead(OIndex idx, Collection<OIdentifiable> items) {
        String indexProp;
        String indexClass;
        if (idx.getMetadata() == null && idx.getDefinition() == null) {
            return items;
        }
        String string = indexClass = idx.getMetadata() == null ? idx.getDefinition().getClassName() : idx.getMetadata().getClassName();
        if (indexClass == null) {
            return items;
        }
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db == null) {
            return items;
        }
        OSecurityInternal security = db.getSharedContext().getSecurity();
        if (OIndexInternal.isReadRestrictedBySecurityPolicy(indexClass, db, security)) {
            items = items.stream().map(x -> x.getRecord()).filter(x -> x != null).map(x -> ((ORecord)x).getIdentity()).collect(Collectors.toList());
        }
        if (idx.getDefinition().getFields().size() == 1 && OIndexInternal.isLabelSecurityDefined(db, security, indexClass, indexProp = idx.getDefinition().getFields().get(0))) {
            items = items.stream().map(x -> x.getRecord()).filter(x -> x != null).filter(x -> !(x instanceof ODocument) || ODocumentInternal.getPropertyAccess((ODocument)x) == null || ODocumentInternal.getPropertyAccess((ODocument)x).isReadable(indexProp)).map(x -> ((ORecord)x).getIdentity()).collect(Collectors.toList());
        }
        return items;
    }

    public boolean isNativeTxSupported();

    public Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(OTransactionIndexChangesPerKey var1);

    public void doPut(OAbstractPaginatedStorage var1, Object var2, ORID var3) throws OInvalidIndexEngineIdException;

    public boolean doRemove(OAbstractPaginatedStorage var1, Object var2, ORID var3) throws OInvalidIndexEngineIdException;

    public boolean doRemove(OAbstractPaginatedStorage var1, Object var2) throws OInvalidIndexEngineIdException;
}

