/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.IndexStreamSecurityDecorator;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexUpdateAction;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OIndexRIDContainer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OIndexRIDContainerSBTree;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OMixedIndexRIDContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class OIndexMultiValues
extends OIndexAbstract {
    OIndexMultiValues(String name, String type, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata, int binaryFormatVersion) {
        super(name, type, algorithm, valueContainerAlgorithm, metadata, version, storage, binaryFormatVersion);
    }

    @Override
    @Deprecated
    public Collection<ORID> get(Object key) {
        List<ORID> rids;
        try (Stream<ORID> stream = this.getRids(key);){
            rids = stream.collect(Collectors.toList());
        }
        return rids;
    }

    @Override
    public Stream<ORID> getRids(Object key) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        while (true) {
            try {
                Stream<ORID> stream;
                Object values;
                if (this.apiVersion == 0) {
                    values = (Collection)this.storage.getIndexValue(this.indexId, key);
                    stream = values != null ? values.stream() : Stream.empty();
                } else if (this.apiVersion == 1) {
                    stream = this.storage.getIndexValues(this.indexId, key);
                } else {
                    throw new IllegalStateException("Invalid version of index API - " + this.apiVersion);
                }
                values = IndexStreamSecurityDecorator.decorateRidStream(this, stream);
                return values;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexMultiValues put(Object key, OIdentifiable singleValue) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            if (!singleValue.getIdentity().isValid()) {
                singleValue.getRecord().save();
            }
            ORID identity = singleValue.getIdentity();
            while (true) {
                try {
                    this.doPut(this.storage, key, identity);
                    OIndexMultiValues oIndexMultiValues = this;
                    return oIndexMultiValues;
                }
                catch (OInvalidIndexEngineIdException e) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void doPut(OAbstractPaginatedStorage storage, Object key, ORID rid) throws OInvalidIndexEngineIdException {
        if (this.apiVersion == 0) {
            OIndexMultiValues.doPutV0(this.indexId, storage, this.binaryFormatVersion, this.valueContainerAlgorithm, this.getName(), key, rid);
        } else if (this.apiVersion == 1) {
            OIndexMultiValues.doPutV1(storage, this.indexId, key, rid);
        } else {
            throw new IllegalStateException("Invalid API version, " + this.apiVersion);
        }
    }

    @Override
    public boolean isNativeTxSupported() {
        return true;
    }

    private static void doPutV0(int indexId, OAbstractPaginatedStorage storage, int binaryFormatVersion, String valueContainerAlgorithm, String indexName, Object key, ORID identity) throws OInvalidIndexEngineIdException {
        OIndexKeyUpdater<Object> creator = (oldValue, bonsayFileId) -> {
            Set<OIdentifiable> toUpdate = (Set<OIdentifiable>)oldValue;
            if (toUpdate == null) {
                if ("SBTREEBONSAISET".equals(valueContainerAlgorithm)) {
                    toUpdate = binaryFormatVersion >= 13 ? new OMixedIndexRIDContainer(indexName, bonsayFileId) : new OIndexRIDContainer(indexName, true, bonsayFileId);
                } else {
                    throw new IllegalStateException("MVRBTree is not supported any more");
                }
            }
            if (toUpdate instanceof OIndexRIDContainer) {
                boolean isTree = !((OIndexRIDContainer)toUpdate).isEmbedded();
                toUpdate.add(identity);
                if (isTree) {
                    return OIndexUpdateAction.nothing();
                }
                return OIndexUpdateAction.changed(toUpdate);
            }
            if (toUpdate instanceof OMixedIndexRIDContainer) {
                OMixedIndexRIDContainer ridContainer = (OMixedIndexRIDContainer)toUpdate;
                boolean embeddedWasUpdated = ridContainer.addEntry(identity);
                if (!embeddedWasUpdated) {
                    return OIndexUpdateAction.nothing();
                }
                return OIndexUpdateAction.changed(toUpdate);
            }
            if (toUpdate.add(identity)) {
                return OIndexUpdateAction.changed(toUpdate);
            }
            return OIndexUpdateAction.nothing();
        };
        storage.updateIndexEntry(indexId, key, creator);
    }

    private static void doPutV1(OAbstractPaginatedStorage storage, int indexId, Object key, ORID identity) throws OInvalidIndexEngineIdException {
        storage.putRidIndexEntry(indexId, key, identity);
    }

    @Override
    public boolean remove(Object key, OIdentifiable value) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        while (true) {
            try {
                boolean bl = this.doRemove(this.storage, key, value.getIdentity());
                return bl;
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean doRemove(OAbstractPaginatedStorage storage, Object key, ORID rid) throws OInvalidIndexEngineIdException {
        if (this.apiVersion == 0) {
            return OIndexMultiValues.doRemoveV0(this.indexId, storage, key, rid);
        }
        if (this.apiVersion == 1) {
            return OIndexMultiValues.doRemoveV1(this.indexId, storage, key, rid);
        }
        throw new IllegalStateException("Invalid API version, " + this.apiVersion);
    }

    private static boolean doRemoveV0(int indexId, OAbstractPaginatedStorage storage, Object key, OIdentifiable value) throws OInvalidIndexEngineIdException {
        Set values = (Set)storage.getIndexValue(indexId, key);
        if (values == null) {
            return false;
        }
        OModifiableBoolean removed = new OModifiableBoolean(false);
        EntityRemover creator = new EntityRemover(value, removed);
        storage.updateIndexEntry(indexId, key, creator);
        return removed.getValue();
    }

    private static boolean doRemoveV1(int indexId, OAbstractPaginatedStorage storage, Object key, OIdentifiable value) throws OInvalidIndexEngineIdException {
        return storage.removeRidIndexEntry(indexId, key, value.getIdentity());
    }

    @Override
    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OIndexMultiValues)super.create(indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, this.determineValueSerializer());
    }

    @Override
    protected OBinarySerializer determineValueSerializer() {
        if (this.binaryFormatVersion >= 13) {
            return this.storage.getComponentsFactory().binarySerializerFactory.getObjectSerializer((byte)23);
        }
        return this.storage.getComponentsFactory().binarySerializerFactory.getObjectSerializer((byte)21);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        while (true) {
            try {
                Stream<ORawPair<Object, ORID>> stream = IndexStreamSecurityDecorator.decorateStream(this, this.storage.iterateIndexEntriesBetween(this.indexId, fromKey, fromInclusive, toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE));
                return stream;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        this.acquireSharedLock();
        while (true) {
            try {
                Stream<ORawPair<Object, ORID>> stream = IndexStreamSecurityDecorator.decorateStream(this, this.storage.iterateIndexEntriesMajor(this.indexId, fromKey, fromInclusive, ascOrder, MultiValuesTransformer.INSTANCE));
                return stream;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        while (true) {
            try {
                Stream<ORawPair<Object, ORID>> stream = IndexStreamSecurityDecorator.decorateStream(this, this.storage.iterateIndexEntriesMinor(this.indexId, toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE));
                return stream;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntries(Collection<?> keys2, boolean ascSortOrder) {
        ArrayList sortedKeys = new ArrayList(keys2);
        Comparator<Object> comparator = ascSortOrder ? ODefaultComparator.INSTANCE : Collections.reverseOrder(ODefaultComparator.INSTANCE);
        sortedKeys.sort(comparator);
        return IndexStreamSecurityDecorator.decorateStream(this, sortedKeys.stream().flatMap(key -> {
            Object entryKey = key = this.getCollatingValue(key);
            this.acquireSharedLock();
            while (true) {
                block8: {
                    block7: {
                        if (this.apiVersion != 0) break block7;
                        Stream stream = Optional.ofNullable((Collection)this.storage.getIndexValue(this.indexId, key)).map(rids -> rids.stream().map(rid -> new ORawPair<Object, ORID>(entryKey, (ORID)rid))).orElse(Stream.empty());
                        this.releaseSharedLock();
                        return stream;
                    }
                    if (this.apiVersion != 1) break block8;
                    Stream<ORawPair> stream = this.storage.getIndexValues(this.indexId, key).map(rid -> new ORawPair<Object, ORID>(entryKey, (ORID)rid));
                    this.releaseSharedLock();
                    return stream;
                }
                try {
                    try {
                        throw new IllegalStateException("Invalid version of index API - " + this.apiVersion);
                    }
                    catch (OInvalidIndexEngineIdException ignore) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                break;
            }
        }));
    }

    @Override
    public long size() {
        this.acquireSharedLock();
        while (true) {
            try {
                long l = this.storage.getIndexSize(this.indexId, MultiValuesTransformer.INSTANCE);
                return l;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Stream<ORawPair<Object, ORID>> stream() {
        this.acquireSharedLock();
        while (true) {
            try {
                Stream<ORawPair<Object, ORID>> stream = IndexStreamSecurityDecorator.decorateStream(this, this.storage.getIndexStream(this.indexId, MultiValuesTransformer.INSTANCE));
                return stream;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Stream<ORawPair<Object, ORID>> descStream() {
        this.acquireSharedLock();
        while (true) {
            try {
                Stream<ORawPair<Object, ORID>> stream = IndexStreamSecurityDecorator.decorateStream(this, this.storage.getIndexDescStream(this.indexId, MultiValuesTransformer.INSTANCE));
                return stream;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static class EntityRemover
    implements OIndexKeyUpdater<Object> {
        private final OIdentifiable value;
        private final OModifiableBoolean removed;

        private EntityRemover(OIdentifiable value, OModifiableBoolean removed) {
            this.value = value;
            this.removed = removed;
        }

        @Override
        public OIndexUpdateAction<Object> update(Object persistentValue, AtomicLong bonsayFileId) {
            Set values = (Set)persistentValue;
            if (this.value == null) {
                this.removed.setValue(true);
                return OIndexUpdateAction.remove();
            }
            if (values.remove(this.value)) {
                this.removed.setValue(true);
                if (values.isEmpty()) {
                    if (values instanceof OMixedIndexRIDContainer) {
                        ((OMixedIndexRIDContainer)values).delete();
                    } else if (values instanceof OIndexRIDContainerSBTree) {
                        ((OIndexRIDContainerSBTree)values).delete();
                    }
                    return OIndexUpdateAction.remove();
                }
                return OIndexUpdateAction.changed(values);
            }
            return OIndexUpdateAction.changed(values);
        }
    }

    private static final class MultiValuesTransformer
    implements OBaseIndexEngine.ValuesTransformer {
        private static final MultiValuesTransformer INSTANCE = new MultiValuesTransformer();

        private MultiValuesTransformer() {
        }

        @Override
        public Collection<ORID> transformFromValue(Object value) {
            return (Collection)value;
        }
    }
}

