/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.index.OIndex;

public class OIndexRebuildOutputListener
implements OProgressListener {
    private long startTime;
    private long lastDump;
    private long lastCounter = 0L;
    private boolean rebuild = false;
    private final OIndex idx;

    public OIndexRebuildOutputListener(OIndex idx) {
        this.idx = idx;
    }

    @Override
    public void onBegin(Object iTask, long iTotal, Object iRebuild) {
        this.lastDump = this.startTime = System.currentTimeMillis();
        this.rebuild = (Boolean)iRebuild;
        if (iTotal > 0L) {
            if (this.rebuild) {
                OLogManager.instance().info((Object)this, "- Rebuilding index %s.%s (estimated %,d items)...", this.idx.getDatabaseName(), this.idx.getName(), iTotal);
            } else {
                OLogManager.instance().debug((Object)this, "- Building index %s.%s (estimated %,d items)...", this.idx.getDatabaseName(), this.idx.getName(), iTotal);
            }
        }
    }

    @Override
    public boolean onProgress(Object iTask, long iCounter, float iPercent) {
        long now = System.currentTimeMillis();
        if (now - this.lastDump > 10000L) {
            if (this.rebuild) {
                OLogManager.instance().info((Object)this, "--> %3.2f%% progress, %,d indexed so far (%,d items/sec)", Float.valueOf(iPercent), iCounter, (iCounter - this.lastCounter) / 10L);
            } else {
                OLogManager.instance().info((Object)this, "--> %3.2f%% progress, %,d indexed so far (%,d items/sec)", Float.valueOf(iPercent), iCounter, (iCounter - this.lastCounter) / 10L);
            }
            this.lastDump = now;
            this.lastCounter = iCounter;
        }
        return true;
    }

    @Override
    public void onCompletition(Object iTask, boolean iSucceed) {
        long idxSize = this.idx.getInternal().size();
        if (idxSize > 0L) {
            if (this.rebuild) {
                OLogManager.instance().info((Object)this, "--> OK, indexed %,d items in %,d ms", idxSize, System.currentTimeMillis() - this.startTime);
            } else {
                OLogManager.instance().debug((Object)this, "--> OK, indexed %,d items in %,d ms", idxSize, System.currentTimeMillis() - this.startTime);
            }
        }
    }
}

