/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexAbstractDelegate;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import java.util.stream.Stream;

public abstract class OIndexTxAware<T>
extends OIndexAbstractDelegate {
    private static final OAlwaysLessKey ALWAYS_LESS_KEY = new OAlwaysLessKey();
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
    protected ODatabaseDocumentInternal database;

    public OIndexTxAware(ODatabaseDocumentInternal database, OIndexInternal delegate) {
        super(delegate);
        this.database = database;
    }

    @Override
    public long size() {
        long tot = this.delegate.size();
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges != null) {
            try (Stream<ORawPair<Object, ORID>> stream = this.stream();){
                long l = stream.count();
                return l;
            }
        }
        return tot;
    }

    @Override
    public OIndexTxAware<T> put(Object key, OIdentifiable value) {
        this.checkForKeyType(key);
        ORID rid = value.getIdentity();
        if (!rid.isValid()) {
            if (value instanceof ORecord) {
                ((ORecord)value).save();
            } else {
                throw new IllegalArgumentException("Cannot store non persistent RID as index value for key '" + key + "'");
            }
        }
        key = this.getCollatingValue(key);
        this.database.getMicroOrRegularTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.PUT, key, value);
        return this;
    }

    @Override
    public boolean remove(Object key) {
        key = this.getCollatingValue(key);
        this.database.getMicroOrRegularTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, key, null);
        return true;
    }

    @Override
    public boolean remove(Object key, OIdentifiable rid) {
        key = this.getCollatingValue(key);
        this.database.getMicroOrRegularTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, key, rid);
        return true;
    }

    @Override
    public OIndexTxAware<T> clear() {
        this.database.getMicroOrRegularTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.CLEAR, null, null);
        return this;
    }

    private Object enhanceCompositeKey(Object key, PartialSearchMode partialSearchMode) {
        if (!(key instanceof OCompositeKey)) {
            return key;
        }
        OCompositeKey compositeKey = (OCompositeKey)key;
        int keySize = this.getDefinition().getParamCount();
        if (keySize != 1 && compositeKey.getKeys().size() != keySize && !partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            OCompositeKey fullKey = new OCompositeKey(compositeKey);
            int itemsToAdd = keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            return fullKey;
        }
        return key;
    }

    protected Object enhanceToCompositeKeyBetweenAsc(Object keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    protected Object enhanceFromCompositeKeyBetweenAsc(Object keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    protected Object enhanceToCompositeKeyBetweenDesc(Object keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    protected Object enhanceFromCompositeKeyBetweenDesc(Object keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    public static enum PartialSearchMode {
        NONE,
        HIGHEST_BOUNDARY,
        LOWEST_BOUNDARY;

    }
}

