/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.spliterators.Streams;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.IndexStreamSecurityDecorator;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexTxAware;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class OIndexTxAwareOneValue
extends OIndexTxAware<OIdentifiable> {
    public OIndexTxAwareOneValue(ODatabaseDocumentInternal database, OIndexInternal delegate) {
        super(database, delegate);
    }

    @Override
    @Deprecated
    public OIdentifiable get(Object key) {
        try (Stream<ORID> stream = this.getRids(key);){
            Iterator iterator = stream.iterator();
            if (iterator.hasNext()) {
                OIdentifiable oIdentifiable = (OIdentifiable)iterator.next();
                return oIdentifiable;
            }
        }
        return null;
    }

    @Override
    public Stream<ORID> getRids(Object key) {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.getRids(key);
        }
        Object collatedKey = this.getCollatingValue(key);
        ORID rid = !indexChanges.cleared ? (ORID)super.getRids(key).findFirst().orElse(null) : null;
        ORawPair<Object, ORID> txIndexEntry = this.calculateTxIndexEntry(key, rid, indexChanges);
        if (txIndexEntry == null) {
            return Stream.empty();
        }
        return IndexStreamSecurityDecorator.decorateRidStream(this, Stream.of(txIndexEntry.second));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> stream() {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.stream();
        }
        Stream<ORawPair<Object, ORID>> txStream = StreamSupport.stream(new PureTxBetweenIndexForwardSpliterator(null, true, null, true, indexChanges), false);
        if (indexChanges.cleared) {
            return IndexStreamSecurityDecorator.decorateStream(this, txStream);
        }
        Stream<ORawPair<Object, ORID>> backedStream = super.stream();
        return IndexStreamSecurityDecorator.decorateStream(this, this.mergeTxAndBackedStreams(indexChanges, txStream, backedStream, true));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> descStream() {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.descStream();
        }
        Stream<ORawPair<Object, ORID>> txStream = StreamSupport.stream(new PureTxBetweenIndexBackwardSpliterator(null, true, null, true, indexChanges), false);
        if (indexChanges.cleared) {
            return IndexStreamSecurityDecorator.decorateStream(this, txStream);
        }
        Stream<ORawPair<Object, ORID>> backedStream = super.descStream();
        return IndexStreamSecurityDecorator.decorateStream(this, this.mergeTxAndBackedStreams(indexChanges, txStream, backedStream, false));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.streamEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder);
        }
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        Stream<ORawPair<Object, ORID>> txStream = ascOrder ? StreamSupport.stream(new PureTxBetweenIndexForwardSpliterator(fromKey, fromInclusive, toKey, toInclusive, indexChanges), false) : StreamSupport.stream(new PureTxBetweenIndexBackwardSpliterator(fromKey, fromInclusive, toKey, toInclusive, indexChanges), false);
        if (indexChanges.cleared) {
            return IndexStreamSecurityDecorator.decorateStream(this, txStream);
        }
        Stream<ORawPair<Object, ORID>> backedStream = super.streamEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder);
        return IndexStreamSecurityDecorator.decorateStream(this, this.mergeTxAndBackedStreams(indexChanges, txStream, backedStream, ascOrder));
    }

    private Stream<ORawPair<Object, ORID>> mergeTxAndBackedStreams(OTransactionIndexChanges indexChanges, Stream<ORawPair<Object, ORID>> txStream, Stream<ORawPair<Object, ORID>> backedStream, boolean ascSortOrder) {
        return Streams.mergeSortedSpliterators(txStream, backedStream.map(entry -> this.calculateTxIndexEntry(this.getCollatingValue(entry.first), (ORID)entry.second, indexChanges)).filter(Objects::nonNull), (entryOne, entryTwo) -> {
            if (ascSortOrder) {
                return ODefaultComparator.INSTANCE.compare(entryOne.first, entryTwo.first);
            }
            return -ODefaultComparator.INSTANCE.compare(entryOne.first, entryTwo.first);
        });
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.streamEntriesMajor(fromKey, fromInclusive, ascOrder);
        }
        fromKey = this.getCollatingValue(fromKey);
        Object lastKey = indexChanges.getLastKey();
        Stream<ORawPair<Object, ORID>> txStream = ascOrder ? StreamSupport.stream(new PureTxBetweenIndexForwardSpliterator(fromKey, fromInclusive, lastKey, true, indexChanges), false) : StreamSupport.stream(new PureTxBetweenIndexBackwardSpliterator(fromKey, fromInclusive, lastKey, true, indexChanges), false);
        if (indexChanges.cleared) {
            return IndexStreamSecurityDecorator.decorateStream(this, txStream);
        }
        Stream<ORawPair<Object, ORID>> backedStream = super.streamEntriesMajor(fromKey, fromInclusive, ascOrder);
        return IndexStreamSecurityDecorator.decorateStream(this, this.mergeTxAndBackedStreams(indexChanges, txStream, backedStream, ascOrder));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.streamEntriesMinor(toKey, toInclusive, ascOrder);
        }
        toKey = this.getCollatingValue(toKey);
        Object firstKey = indexChanges.getFirstKey();
        Stream<ORawPair<Object, ORID>> txStream = ascOrder ? StreamSupport.stream(new PureTxBetweenIndexForwardSpliterator(firstKey, true, toKey, toInclusive, indexChanges), false) : StreamSupport.stream(new PureTxBetweenIndexBackwardSpliterator(firstKey, true, toKey, toInclusive, indexChanges), false);
        if (indexChanges.cleared) {
            return IndexStreamSecurityDecorator.decorateStream(this, txStream);
        }
        Stream<ORawPair<Object, ORID>> backedStream = super.streamEntriesMinor(toKey, toInclusive, ascOrder);
        return IndexStreamSecurityDecorator.decorateStream(this, this.mergeTxAndBackedStreams(indexChanges, txStream, backedStream, ascOrder));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntries(Collection<?> keys2, boolean ascSortOrder) {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.streamEntries(keys2, ascSortOrder);
        }
        Stream<ORawPair<Object, ORID>> txStream = keys2.stream().map(key -> this.calculateTxIndexEntry(this.getCollatingValue(key), null, indexChanges)).filter(Objects::nonNull).sorted((entryOne, entryTwo) -> {
            if (ascSortOrder) {
                return ODefaultComparator.INSTANCE.compare(entryOne.first, entryTwo.first);
            }
            return -ODefaultComparator.INSTANCE.compare(entryOne.first, entryTwo.first);
        });
        if (indexChanges.cleared) {
            return IndexStreamSecurityDecorator.decorateStream(this, txStream);
        }
        Stream<ORawPair<Object, ORID>> backedStream = super.streamEntries(keys2, ascSortOrder);
        return IndexStreamSecurityDecorator.decorateStream(this, this.mergeTxAndBackedStreams(indexChanges, txStream, backedStream, ascSortOrder));
    }

    private ORawPair<Object, ORID> calculateTxIndexEntry(Object key, ORID backendValue, OTransactionIndexChanges indexChanges) {
        key = this.getCollatingValue(key);
        ORID result = backendValue;
        OTransactionIndexChangesPerKey changesPerKey = indexChanges.getChangesPerKey(key);
        if (changesPerKey.entries.isEmpty()) {
            if (backendValue == null) {
                return null;
            }
            return new ORawPair<Object, ORID>(key, backendValue);
        }
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : changesPerKey.entries) {
            if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                result = null;
                continue;
            }
            if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
            result = entry.value.getIdentity();
        }
        if (result == null) {
            return null;
        }
        return new ORawPair<Object, ORID>(key, result);
    }

    private class PureTxBetweenIndexBackwardSpliterator
    implements Spliterator<ORawPair<Object, ORID>> {
        private final OTransactionIndexChanges indexChanges;
        private Object firstKey;
        private Object nextKey;

        private PureTxBetweenIndexBackwardSpliterator(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, OTransactionIndexChanges indexChanges) {
            Object[] keys2;
            this.indexChanges = indexChanges;
            if (fromKey != null) {
                fromKey = OIndexTxAwareOneValue.this.enhanceFromCompositeKeyBetweenDesc(fromKey, fromInclusive);
            }
            if (toKey != null) {
                toKey = OIndexTxAwareOneValue.this.enhanceToCompositeKeyBetweenDesc(toKey, toInclusive);
            }
            if ((keys2 = indexChanges.firstAndLastKeys(fromKey, fromInclusive, toKey, toInclusive)).length == 0) {
                this.nextKey = null;
            } else {
                this.firstKey = keys2[0];
                this.nextKey = keys2[1];
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super ORawPair<Object, ORID>> action) {
            ORawPair result;
            if (this.nextKey == null) {
                return false;
            }
            do {
                result = OIndexTxAwareOneValue.this.calculateTxIndexEntry(this.nextKey, null, this.indexChanges);
                this.nextKey = this.indexChanges.getLowerKey(this.nextKey);
                if (this.nextKey == null || ODefaultComparator.INSTANCE.compare(this.nextKey, this.firstKey) >= 0) continue;
                this.nextKey = null;
            } while (result == null && this.nextKey != null);
            if (result == null) {
                return false;
            }
            action.accept(result);
            return true;
        }

        @Override
        public Spliterator<ORawPair<Object, ORID>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 276;
        }

        @Override
        public Comparator<? super ORawPair<Object, ORID>> getComparator() {
            return (entryOne, entryTwo) -> -ODefaultComparator.INSTANCE.compare(entryOne.first, entryTwo.first);
        }
    }

    private class PureTxBetweenIndexForwardSpliterator
    implements Spliterator<ORawPair<Object, ORID>> {
        private final OTransactionIndexChanges indexChanges;
        private Object lastKey;
        private Object nextKey;

        private PureTxBetweenIndexForwardSpliterator(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, OTransactionIndexChanges indexChanges) {
            Object[] keys2;
            this.indexChanges = indexChanges;
            if (fromKey != null) {
                fromKey = OIndexTxAwareOneValue.this.enhanceFromCompositeKeyBetweenAsc(fromKey, fromInclusive);
            }
            if (toKey != null) {
                toKey = OIndexTxAwareOneValue.this.enhanceToCompositeKeyBetweenAsc(toKey, toInclusive);
            }
            if ((keys2 = indexChanges.firstAndLastKeys(fromKey, fromInclusive, toKey, toInclusive)).length == 0) {
                this.nextKey = null;
            } else {
                Object firstKey = keys2[0];
                this.lastKey = keys2[1];
                this.nextKey = firstKey;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super ORawPair<Object, ORID>> action) {
            ORawPair result;
            if (this.nextKey == null) {
                return false;
            }
            do {
                result = OIndexTxAwareOneValue.this.calculateTxIndexEntry(this.nextKey, null, this.indexChanges);
                this.nextKey = this.indexChanges.getHigherKey(this.nextKey);
                if (this.nextKey == null || ODefaultComparator.INSTANCE.compare(this.nextKey, this.lastKey) <= 0) continue;
                this.nextKey = null;
            } while (result == null && this.nextKey != null);
            if (result == null) {
                return false;
            }
            action.accept(result);
            return true;
        }

        @Override
        public Spliterator<ORawPair<Object, ORID>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 276;
        }

        @Override
        public Comparator<? super ORawPair<Object, ORID>> getComparator() {
            return (entryOne, entryTwo) -> ODefaultComparator.INSTANCE.compare(entryOne.first, entryTwo.first);
        }
    }
}

