/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.viewmanager.ViewCreationListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableView;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.metadata.schema.OViewConfig;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionFactory;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OImmutableSchema
implements OSchema {
    private final Map<Integer, OClass> clustersToClasses;
    private final Map<String, OClass> classes;
    private final Set<Integer> blogClusters;
    private final Map<Integer, OView> clustersToViews;
    private final Map<String, OView> views;
    public final int version;
    private final ORID identity;
    private final List<OGlobalProperty> properties;
    private final OClusterSelectionFactory clusterSelectionFactory;

    public OImmutableSchema(OSchemaShared schemaShared, ODatabaseDocumentInternal database) {
        OImmutableClass immutableClass;
        assert (schemaShared.getDocument().getInternalStatus() == ORecordElement.STATUS.LOADED);
        assert (database.getSharedContext().getIndexManager().getDocument().getInternalStatus() == ORecordElement.STATUS.LOADED);
        this.version = schemaShared.getVersion();
        this.identity = schemaShared.getIdentity();
        this.clusterSelectionFactory = schemaShared.getClusterSelectionFactory();
        this.clustersToClasses = new HashMap<Integer, OClass>(schemaShared.getClasses(database).size() * 3);
        this.classes = new HashMap<String, OClass>(schemaShared.getClasses(database).size());
        for (OClass oClass : schemaShared.getClasses(database)) {
            immutableClass = new OImmutableClass(oClass, this);
            this.classes.put(immutableClass.getName().toLowerCase(Locale.ENGLISH), immutableClass);
            if (immutableClass.getShortName() != null) {
                this.classes.put(immutableClass.getShortName().toLowerCase(Locale.ENGLISH), immutableClass);
            }
            for (int clusterId : immutableClass.getClusterIds()) {
                this.clustersToClasses.put(clusterId, immutableClass);
            }
        }
        this.properties = new ArrayList<OGlobalProperty>();
        for (OGlobalProperty oGlobalProperty : schemaShared.getGlobalProperties()) {
            this.properties.add(oGlobalProperty);
        }
        for (OClass oClass : this.classes.values()) {
            ((OImmutableClass)oClass).init();
        }
        this.blogClusters = Collections.unmodifiableSet(new HashSet<Integer>(schemaShared.getBlobClusters()));
        this.clustersToViews = new HashMap<Integer, OView>(schemaShared.getViews(database).size() * 3);
        this.views = new HashMap<String, OView>(schemaShared.getViews(database).size());
        for (OView oView : schemaShared.getViews(database)) {
            immutableClass = new OImmutableView(oView, this);
            this.views.put(immutableClass.getName().toLowerCase(Locale.ENGLISH), (OView)((Object)immutableClass));
            if (immutableClass.getShortName() != null) {
                this.views.put(immutableClass.getShortName().toLowerCase(Locale.ENGLISH), (OView)((Object)immutableClass));
            }
            for (int clusterId : immutableClass.getClusterIds()) {
                this.clustersToViews.put(clusterId, (OView)((Object)immutableClass));
            }
        }
    }

    @Override
    public OImmutableSchema makeSnapshot() {
        return this;
    }

    @Override
    public int countClasses() {
        return this.classes.size();
    }

    @Override
    public int countViews() {
        return this.views.size();
    }

    @Override
    public OClass createClass(String iClassName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createClass(String iClassName, OClass ... superClasses) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass, int[] iClusterIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createClass(String className, int clusters, OClass ... superClasses) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createClass(String className, int[] clusterIds, OClass ... superClasses) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createAbstractClass(String iClassName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createAbstractClass(String iClassName, OClass iSuperClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createAbstractClass(String iClassName, OClass ... superClasses) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dropClass(String iClassName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OSchema reload() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean existsClass(String iClassName) {
        return this.classes.containsKey(iClassName.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public OClass getClass(Class<?> iClass) {
        if (iClass == null) {
            return null;
        }
        return this.getClass(iClass.getSimpleName());
    }

    @Override
    public OClass getClass(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        OClass cls = this.classes.get(iClassName.toLowerCase(Locale.ENGLISH));
        if (cls != null) {
            return cls;
        }
        return null;
    }

    @Override
    public OClass getOrCreateClass(String iClassName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass getOrCreateClass(String iClassName, OClass iSuperClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass getOrCreateClass(String iClassName, OClass ... superClasses) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<OClass> getClasses() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        return new HashSet<OClass>(this.classes.values());
    }

    @Override
    public Collection<OView> getViews() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        return new HashSet<OView>(this.views.values());
    }

    @Override
    public void create() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public ORID getIdentity() {
        return new ORecordId(this.identity);
    }

    @Override
    public Set<OClass> getClassesRelyOnCluster(String clusterName) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        int clusterId = this.getDatabase().getClusterIdByName(clusterName);
        HashSet<OClass> result = new HashSet<OClass>();
        for (OClass c : this.classes.values()) {
            if (!OArrays.contains(c.getPolymorphicClusterIds(), clusterId)) continue;
            result.add(c);
        }
        return result;
    }

    @Override
    public OClass getClassByClusterId(int clusterId) {
        return this.clustersToClasses.get(clusterId);
    }

    @Override
    public OView getViewByClusterId(int clusterId) {
        return this.clustersToViews.get(clusterId);
    }

    @Override
    public OGlobalProperty getGlobalPropertyById(int id) {
        if (id >= this.properties.size()) {
            return null;
        }
        return this.properties.get(id);
    }

    @Override
    public List<OGlobalProperty> getGlobalProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    @Override
    public OGlobalProperty createGlobalProperty(String name, OType type, Integer id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClusterSelectionFactory getClusterSelectionFactory() {
        return this.clusterSelectionFactory;
    }

    private ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    public Set<Integer> getBlobClusters() {
        return this.blogClusters;
    }

    @Override
    public OView getView(String name) {
        if (name == null) {
            return null;
        }
        OView cls = this.views.get(name.toLowerCase(Locale.ENGLISH));
        if (cls != null) {
            return cls;
        }
        return null;
    }

    @Override
    public OView createView(String viewName, String statement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OView createView(ODatabaseDocumentInternal database, String viewName, String statement, Map<String, Object> metadata) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OView createView(OViewConfig config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OView createView(OViewConfig config, ViewCreationListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean existsView(String name) {
        return this.views.containsKey(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void dropView(String name) {
        throw new UnsupportedOperationException();
    }
}

