/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OSharedContextEmbedded;
import com.orientechnologies.orient.core.db.viewmanager.ViewCreationListener;
import com.orientechnologies.orient.core.db.viewmanager.ViewManager;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.metadata.schema.OViewConfig;
import com.orientechnologies.orient.core.metadata.schema.OViewEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OViewImpl;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OSchemaEmbedded
extends OSchemaShared {
    public OSchemaEmbedded(OSharedContext sharedContext) {
    }

    @Override
    public OClass createClass(ODatabaseDocumentInternal database, String className, int[] clusterIds, OClass ... superClasses) {
        OClass result;
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid(className);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in class name '" + className + "'");
        }
        int retry = 0;
        while (true) {
            try {
                result = this.doCreateClass(database, className, clusterIds, retry, superClasses);
            }
            catch (OSchemaShared.ClusterIdsAreEmptyException ignore) {
                this.classes.remove(className.toLowerCase(Locale.ENGLISH));
                clusterIds = this.createClusters(database, className);
                ++retry;
                continue;
            }
            break;
        }
        return result;
    }

    @Override
    public OClass createClass(ODatabaseDocumentInternal database, String className, int clusters, OClass ... superClasses) {
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid(className);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in class name '" + className + "'");
        }
        return this.doCreateClass(database, className, clusters, superClasses);
    }

    private OClass doCreateClass(ODatabaseDocumentInternal database, String className, int clusters, OClass ... superClasses) {
        OClass result;
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
        if (superClasses != null) {
            OClassImpl.checkParametersConflict(Arrays.asList(superClasses));
        }
        this.acquireSchemaWriteLock(database);
        try {
            String key = className.toLowerCase(Locale.ENGLISH);
            if (this.classes.containsKey(key)) {
                throw new OSchemaException("Class '" + className + "' already exists in current database");
            }
            ArrayList<OClass> superClassesList = new ArrayList<OClass>();
            if (superClasses != null && superClasses.length > 0) {
                for (OClass superClass : superClasses) {
                    if (superClass == null) continue;
                    superClassesList.add(superClass);
                }
            }
            int[] clusterIds = clusters > 0 ? this.createClusters(database, className, clusters) : new int[]{-1};
            this.doRealCreateClass(database, className, superClassesList, clusterIds);
            result = (OClass)this.classes.get(className.toLowerCase(Locale.ENGLISH));
            Iterator<Object> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onCreateClass(database, result);
            }
            it = database.getListeners().iterator();
            while (it.hasNext()) {
                ((ODatabaseListener)it.next()).onCreateClass(database, result);
            }
        }
        catch (OSchemaShared.ClusterIdsAreEmptyException e) {
            throw OException.wrapException(new OSchemaException("Cannot create class '" + className + "'"), e);
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
        return result;
    }

    protected void doRealCreateClass(ODatabaseDocumentInternal database, String className, List<OClass> superClassesList, int[] clusterIds) throws OSchemaShared.ClusterIdsAreEmptyException {
        this.createClassInternal(database, className, clusterIds, superClassesList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OClass createClassInternal(ODatabaseDocumentInternal database, String className, int[] clusterIdsToAdd, List<OClass> superClasses) throws OSchemaShared.ClusterIdsAreEmptyException {
        this.acquireSchemaWriteLock(database);
        try {
            if (className == null || className.length() == 0) {
                throw new OSchemaException("Found class name null or empty");
            }
            this.checkEmbedded();
            this.checkClustersAreAbsent(clusterIdsToAdd);
            if (clusterIdsToAdd == null || clusterIdsToAdd.length == 0) {
                throw new OSchemaShared.ClusterIdsAreEmptyException();
            }
            int[] clusterIds = clusterIdsToAdd;
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
            String key = className.toLowerCase(Locale.ENGLISH);
            if (this.classes.containsKey(key)) {
                throw new OSchemaException("Class '" + className + "' already exists in current database");
            }
            OClassImpl cls = this.createClassInstance(className, clusterIds);
            this.classes.put(key, cls);
            if (superClasses != null && superClasses.size() > 0) {
                cls.setSuperClassesInternal(superClasses);
                for (OClass superClass : superClasses) {
                    int[] clustersToIndex = superClass.getPolymorphicClusterIds();
                    String[] clusterNames = new String[clustersToIndex.length];
                    for (int i = 0; i < clustersToIndex.length; ++i) {
                        clusterNames[i] = database.getClusterNameById(clustersToIndex[i]);
                    }
                    for (OIndex index : superClass.getIndexes()) {
                        for (String clusterName : clusterNames) {
                            if (clusterName == null) continue;
                            database.getMetadata().getIndexManagerInternal().addClusterToIndex(clusterName, index.getName());
                        }
                    }
                }
            }
            this.addClusterClassMap(cls);
            OClassImpl oClassImpl = cls;
            return oClassImpl;
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    @Override
    public OView createView(ODatabaseDocumentInternal database, String viewName, String statement, Map<String, Object> metadata) {
        OViewConfig cfg = new OViewConfig(viewName, statement);
        if (metadata != null) {
            Object indexes;
            Object originRidField;
            Object nodes;
            Object watchClasses;
            Object updateStrategy;
            cfg.setUpdatable(Boolean.TRUE.equals(metadata.get("updatable")));
            Object updateInterval = metadata.get("updateIntervalSeconds");
            if (updateInterval instanceof Integer) {
                cfg.setUpdateIntervalSeconds((Integer)updateInterval);
            }
            if ((updateStrategy = metadata.get("updateStrategy")) instanceof String) {
                cfg.setUpdateStrategy((String)updateStrategy);
            }
            if ((watchClasses = metadata.get("watchClasses")) instanceof List) {
                cfg.setWatchClasses((List)watchClasses);
            }
            if ((nodes = metadata.get("nodes")) instanceof List) {
                cfg.setNodes((List)nodes);
            }
            if ((originRidField = metadata.get("originRidField")) instanceof String) {
                cfg.setOriginRidField((String)originRidField);
            }
            if ((indexes = metadata.get("indexes")) instanceof Collection) {
                for (Object index : (Collection)indexes) {
                    if (!(index instanceof Map)) continue;
                    OViewConfig.OViewIndexConfig idxConfig = cfg.addIndex((String)((Map)index).get("type"), (String)((Map)index).get("engine"));
                    for (Map.Entry entry : ((Map)((Map)index).get("properties")).entrySet()) {
                        OType val = OType.valueOf(((String)entry.getValue()).toUpperCase(Locale.ENGLISH));
                        if (val == null) {
                            throw new IllegalArgumentException("Invalid value for index key type: " + (String)entry.getValue());
                        }
                        idxConfig.addProperty((String)entry.getKey(), val);
                    }
                }
            }
        }
        return this.createView(database, cfg);
    }

    @Override
    public OView createView(ODatabaseDocumentInternal database, OViewConfig cfg) {
        return this.createView(database, cfg, null);
    }

    @Override
    public OView createView(ODatabaseDocumentInternal database, OViewConfig cfg, ViewCreationListener listener) {
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid(cfg.getName());
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in view name '" + cfg.getName() + "'");
        }
        return this.doCreateView(database, cfg, listener);
    }

    private OView doCreateView(ODatabaseDocumentInternal database, OViewConfig config, final ViewCreationListener listener) {
        OView result;
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
        this.acquireSchemaWriteLock(database);
        try {
            String key = config.getName().toLowerCase(Locale.ENGLISH);
            if (this.classes.containsKey(key) || this.views.containsKey(key)) {
                throw new OSchemaException("View (or class) '" + config.getName() + "' already exists in current database");
            }
            int[] clusterIds = this.createClusters(database, config.getName(), 1);
            this.doRealCreateView(database, config, clusterIds);
            result = (OView)this.views.get(config.getName().toLowerCase(Locale.ENGLISH));
            Iterator<Object> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onCreateView(database, result);
            }
            it = database.getListeners().iterator();
            while (it.hasNext()) {
                ((ODatabaseListener)it.next()).onCreateView(database, result);
            }
            final ViewManager viewMgr = ((OSharedContextEmbedded)database.getSharedContext()).getViewManager();
            viewMgr.updateViewAsync(result.getName(), new ViewCreationListener(){

                @Override
                public void afterCreate(ODatabaseSession database, String viewName) {
                    try {
                        viewMgr.registerLiveUpdateFor(database, viewName);
                    }
                    catch (Exception e) {
                        if (listener != null) {
                            listener.onError(viewName, e);
                        }
                        return;
                    }
                    if (listener != null) {
                        listener.afterCreate(database, viewName);
                    }
                }

                @Override
                public void onError(String viewName, Exception exception) {
                    if (listener != null) {
                        listener.onError(viewName, exception);
                    }
                }
            });
        }
        catch (OSchemaShared.ClusterIdsAreEmptyException e) {
            throw OException.wrapException(new OSchemaException("Cannot create view '" + config.getName() + "'"), e);
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
        return result;
    }

    protected void doRealCreateView(ODatabaseDocumentInternal database, OViewConfig config, int[] clusterIds) throws OSchemaShared.ClusterIdsAreEmptyException {
        this.createViewInternal(database, config, clusterIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OClass createViewInternal(ODatabaseDocumentInternal database, OViewConfig cfg, int[] clusterIdsToAdd) throws OSchemaShared.ClusterIdsAreEmptyException {
        this.acquireSchemaWriteLock(database);
        try {
            if (cfg.getName() == null || cfg.getName().length() == 0) {
                throw new OSchemaException("Found view name null or empty");
            }
            this.checkEmbedded();
            this.checkClustersAreAbsent(clusterIdsToAdd);
            if (clusterIdsToAdd == null || clusterIdsToAdd.length == 0) {
                throw new OSchemaShared.ClusterIdsAreEmptyException();
            }
            int[] clusterIds = clusterIdsToAdd;
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
            String key = cfg.getName().toLowerCase(Locale.ENGLISH);
            if (this.views.containsKey(key)) {
                throw new OSchemaException("View '" + cfg.getName() + "' already exists in current database");
            }
            OViewImpl cls = this.createViewInstance(cfg, clusterIds);
            this.views.put(key, cls);
            this.addClusterViewMap(cls);
            OViewImpl oViewImpl = cls;
            return oViewImpl;
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    protected OClassImpl createClassInstance(String className, int[] clusterIds) {
        return new OClassEmbedded((OSchemaShared)this, className, clusterIds);
    }

    protected OViewImpl createViewInstance(OViewConfig cfg, int[] clusterIds) {
        if (cfg.getQuery() == null) {
            throw new IllegalArgumentException("Invalid view configuration: no query defined");
        }
        return new OViewEmbedded(this, cfg.getName(), cfg, clusterIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OClass getOrCreateClass(ODatabaseDocumentInternal database, String iClassName, OClass ... superClasses) {
        OClass cls;
        if (iClassName == null) {
            return null;
        }
        this.acquireSchemaReadLock();
        try {
            cls = (OClass)this.classes.get(iClassName.toLowerCase(Locale.ENGLISH));
            if (cls != null) {
                OClass oClass = cls;
                return oClass;
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
        int[] clusterIds = null;
        int retry = 0;
        while (true) {
            try {
                this.acquireSchemaWriteLock(database);
                try {
                    cls = (OClass)this.classes.get(iClassName.toLowerCase(Locale.ENGLISH));
                    if (cls != null) {
                        OClass oClass = cls;
                        return oClass;
                    }
                    cls = this.doCreateClass(database, iClassName, clusterIds, retry, superClasses);
                    this.addClusterClassMap(cls);
                    return cls;
                }
                finally {
                    this.releaseSchemaWriteLock(database);
                }
            }
            catch (OSchemaShared.ClusterIdsAreEmptyException ignore) {
                clusterIds = this.createClusters(database, iClassName);
                ++retry;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OClass doCreateClass(ODatabaseDocumentInternal database, String className, int[] clusterIds, int retry, OClass ... superClasses) throws OSchemaShared.ClusterIdsAreEmptyException {
        OClass result;
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
        if (superClasses != null) {
            OClassImpl.checkParametersConflict(Arrays.asList(superClasses));
        }
        this.acquireSchemaWriteLock(database);
        try {
            String key = className.toLowerCase(Locale.ENGLISH);
            if (this.classes.containsKey(key) && retry == 0) {
                throw new OSchemaException("Class '" + className + "' already exists in current database");
            }
            if (!this.executeThroughDistributedStorage(database)) {
                this.checkClustersAreAbsent(clusterIds);
            }
            if (clusterIds == null || clusterIds.length == 0) {
                clusterIds = this.createClusters(database, className, database.getStorage().getConfiguration().getMinimumClusters());
            }
            ArrayList<OClass> superClassesList = new ArrayList<OClass>();
            if (superClasses != null && superClasses.length > 0) {
                for (OClass superClass : superClasses) {
                    if (superClass == null) continue;
                    superClassesList.add(superClass);
                }
            }
            this.doRealCreateClass(database, className, superClassesList, clusterIds);
            result = (OClass)this.classes.get(className.toLowerCase(Locale.ENGLISH));
            Iterator<Object> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onCreateClass(database, result);
            }
            it = database.getListeners().iterator();
            while (it.hasNext()) {
                ((ODatabaseListener)it.next()).onCreateClass(database, result);
            }
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
        return result;
    }

    private int[] createClusters(ODatabaseDocumentInternal database, String iClassName) {
        return this.createClusters(database, iClassName, database.getStorage().getConfiguration().getMinimumClusters());
    }

    protected int[] createClusters(ODatabaseDocumentInternal database, String className, int minimumClusters) {
        if (internalClasses.contains((className = className.toLowerCase(Locale.ENGLISH)).toLowerCase(Locale.ENGLISH))) {
            minimumClusters = 1;
        }
        int[] clusterIds = new int[minimumClusters];
        clusterIds[0] = database.getClusterIdByName(className);
        if (clusterIds[0] > -1) {
            OClass cls = (OClass)this.clustersToClasses.get(clusterIds[0]);
            if (cls != null) {
                clusterIds[0] = database.addCluster(this.getNextAvailableClusterName(database, className), new Object[0]);
            }
        } else {
            clusterIds[0] = database.addCluster(className, new Object[0]);
        }
        for (int i = 1; i < minimumClusters; ++i) {
            clusterIds[i] = database.addCluster(this.getNextAvailableClusterName(database, className), new Object[0]);
        }
        return clusterIds;
    }

    private String getNextAvailableClusterName(ODatabaseDocumentInternal database, String className) {
        int i = 1;
        String clusterName;
        while (database.getClusterIdByName(clusterName = className + "_" + i) >= 0) {
            ++i;
        }
        return clusterName;
    }

    protected void checkClustersAreAbsent(int[] iClusterIds) {
        if (iClusterIds == null) {
            return;
        }
        for (int clusterId : iClusterIds) {
            if (clusterId < 0 || !this.clustersToClasses.containsKey(clusterId)) continue;
            throw new OSchemaException("Cluster with id " + clusterId + " already belongs to class " + this.clustersToClasses.get(clusterId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropClass(ODatabaseDocumentInternal database, String className) {
        this.acquireSchemaWriteLock(database);
        try {
            if (database.getTransaction().isActive()) {
                throw new IllegalStateException("Cannot drop a class inside a transaction");
            }
            if (className == null) {
                throw new IllegalArgumentException("Class name is null");
            }
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
            String key = className.toLowerCase(Locale.ENGLISH);
            OClass cls = (OClass)this.classes.get(key);
            if (cls == null) {
                throw new OSchemaException("Class '" + className + "' was not found in current database");
            }
            if (!cls.getSubclasses().isEmpty()) {
                throw new OSchemaException("Class '" + className + "' cannot be dropped because it has sub classes " + cls.getSubclasses() + ". Remove the dependencies before trying to drop it again");
            }
            this.doDropClass(database, className);
            database.getLocalCache().freeCluster(cls.getDefaultClusterId());
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    protected void doDropClass(ODatabaseDocumentInternal database, String className) {
        this.dropClassInternal(database, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropClassInternal(ODatabaseDocumentInternal database, String className) {
        this.acquireSchemaWriteLock(database);
        try {
            if (database.getTransaction().isActive()) {
                throw new IllegalStateException("Cannot drop a class inside a transaction");
            }
            if (className == null) {
                throw new IllegalArgumentException("Class name is null");
            }
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
            String key = className.toLowerCase(Locale.ENGLISH);
            OClass cls = (OClass)this.classes.get(key);
            if (cls == null) {
                throw new OSchemaException("Class '" + className + "' was not found in current database");
            }
            if (!cls.getSubclasses().isEmpty()) {
                throw new OSchemaException("Class '" + className + "' cannot be dropped because it has sub classes " + cls.getSubclasses() + ". Remove the dependencies before trying to drop it again");
            }
            this.checkEmbedded();
            for (OClass superClass : cls.getSuperClasses()) {
                ((OClassImpl)superClass).removeBaseClassInternal(cls);
            }
            for (Object id : (Object)cls.getClusterIds()) {
                if (id == -1) continue;
                this.deleteCluster(database, (int)id);
            }
            this.dropClassIndexes(database, cls);
            this.classes.remove(key);
            if (cls.getShortName() != null) {
                this.classes.remove(cls.getShortName().toLowerCase(Locale.ENGLISH));
            }
            this.removeClusterClassMap(cls);
            Iterator<Object> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onDropClass(database, cls);
            }
            it = database.getListeners().iterator();
            while (it.hasNext()) {
                ((ODatabaseListener)it.next()).onDropClass(database, cls);
            }
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropView(ODatabaseDocumentInternal database, String name) {
        try {
            this.acquireSchemaWriteLock(database);
            if (database.getTransaction().isActive()) {
                throw new IllegalStateException("Cannot drop a class inside a transaction");
            }
            if (name == null) {
                throw new IllegalArgumentException("Class name is null");
            }
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
            String key = name.toLowerCase(Locale.ENGLISH);
            OView cls = (OView)this.views.get(key);
            if (cls == null) {
                throw new OSchemaException("View '" + name + "' was not found in current database");
            }
            if (!cls.getSubclasses().isEmpty()) {
                throw new OSchemaException("View '" + name + "' cannot be dropped because it has sub classes " + cls.getSubclasses() + ". Remove the dependencies before trying to drop it again");
            }
            this.doDropView(database, name);
            database.getLocalCache().freeCluster(cls.getDefaultClusterId());
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    protected void doDropView(ODatabaseDocumentInternal database, String name) {
        this.dropViewInternal(database, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropViewInternal(ODatabaseDocumentInternal database, String view) {
        this.acquireSchemaWriteLock(database);
        try {
            if (database.getTransaction().isActive()) {
                throw new IllegalStateException("Cannot drop a class inside a transaction");
            }
            if (view == null) {
                throw new IllegalArgumentException("Class name is null");
            }
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
            String key = view.toLowerCase(Locale.ENGLISH);
            OView cls = (OView)this.views.get(key);
            if (cls == null) {
                throw new OSchemaException("View '" + view + "' was not found in current database");
            }
            if (!cls.getSubclasses().isEmpty()) {
                throw new OSchemaException("View '" + view + "' cannot be dropped because it has sub classes " + cls.getSubclasses() + ". Remove the dependencies before trying to drop it again");
            }
            this.checkEmbedded();
            for (int id : cls.getClusterIds()) {
                if (id == -1) continue;
                this.deleteCluster(database, id);
            }
            this.dropClassIndexes(database, cls);
            this.views.remove(key);
            if (cls.getShortName() != null) {
                this.views.remove(cls.getShortName().toLowerCase(Locale.ENGLISH));
            }
            this.removeClusterViewMap(cls);
            Iterator<Object> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onDropView(database, cls);
            }
            it = database.getListeners().iterator();
            while (it.hasNext()) {
                ((ODatabaseListener)it.next()).onDropView(database, cls);
            }
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    @Override
    protected OClassImpl createClassInstance(ODocument c) {
        return new OClassEmbedded((OSchemaShared)this, c, (String)c.field("name"));
    }

    @Override
    protected OViewImpl createViewInstance(ODocument c) {
        return new OViewEmbedded((OSchemaShared)this, c, (String)c.field("name"));
    }

    private void dropClassIndexes(ODatabaseDocumentInternal database, OClass cls) {
        OIndexManagerAbstract indexManager = database.getMetadata().getIndexManagerInternal();
        for (OIndex index : indexManager.getClassIndexes(database, cls.getName())) {
            indexManager.dropIndex(database, index.getName());
        }
    }

    private void deleteCluster(ODatabaseDocumentInternal db, int clusterId) {
        ORecordIteratorCluster iteratorCluster;
        String clusterName = db.getClusterNameById(clusterId);
        if (clusterName != null && (iteratorCluster = db.browseCluster(clusterName)) != null) {
            while (iteratorCluster.hasNext()) {
                ODocument document = (ODocument)iteratorCluster.next();
                document.delete();
            }
            db.getStorage().dropCluster(clusterId);
        }
        db.getLocalCache().freeCluster(clusterId);
    }

    private void removeClusterClassMap(OClass cls) {
        for (int clusterId : cls.getClusterIds()) {
            if (clusterId < 0) continue;
            this.clustersToClasses.remove(clusterId);
        }
    }

    private void removeClusterViewMap(OView cls) {
        for (int clusterId : cls.getClusterIds()) {
            if (clusterId < 0) continue;
            this.clustersToViews.remove(clusterId);
        }
    }

    @Override
    public void checkEmbedded() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClusterForClass(ODatabaseDocumentInternal database, int clusterId, OClass cls) {
        this.acquireSchemaWriteLock(database);
        try {
            if (clusterId < 0) {
                return;
            }
            this.checkEmbedded();
            OClass existingCls = (OClass)this.clustersToClasses.get(clusterId);
            if (existingCls != null && !cls.equals(existingCls)) {
                throw new OSchemaException("Cluster with id " + clusterId + " already belongs to class " + this.clustersToClasses.get(clusterId));
            }
            this.clustersToClasses.put(clusterId, cls);
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClusterForView(ODatabaseDocumentInternal database, int clusterId, OView view) {
        this.acquireSchemaWriteLock(database);
        try {
            if (clusterId < 0) {
                return;
            }
            this.checkEmbedded();
            OView existingView = (OView)this.clustersToViews.get(clusterId);
            if (existingView != null && !view.equals(existingView)) {
                throw new OSchemaException("Cluster with id " + clusterId + " already belongs to view " + this.clustersToViews.get(clusterId));
            }
            this.clustersToViews.put(clusterId, view);
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClusterForClass(ODatabaseDocumentInternal database, int clusterId, OClass cls) {
        this.acquireSchemaWriteLock(database);
        try {
            if (clusterId < 0) {
                return;
            }
            this.checkEmbedded();
            this.clustersToClasses.remove(clusterId);
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClusterForView(ODatabaseDocumentInternal database, int clusterId, OView view) {
        this.acquireSchemaWriteLock(database);
        try {
            if (clusterId < 0) {
                return;
            }
            this.checkEmbedded();
            this.clustersToViews.remove(clusterId);
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    protected boolean isRunLocal(ODatabaseDocumentInternal database) {
        return true;
    }
}

