/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.metadata.schema.OViewConfig;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class OViewImpl
extends OClassImpl
implements OView {
    private OViewConfig cfg;
    private Set<String> activeIndexNames = new HashSet<String>();
    private List<String> inactiveIndexNames = new ArrayList<String>();

    protected OViewImpl(OSchemaShared iOwner, String iName, OViewConfig cfg, int[] iClusterIds) {
        super(iOwner, iName, iClusterIds);
        this.cfg = cfg.copy();
    }

    protected OViewImpl(OSchemaShared iOwner, ODocument iDocument, String iName) {
        super(iOwner, iDocument, iName);
    }

    @Override
    public void fromStream() {
        super.fromStream();
        String query = (String)this.document.getProperty("query");
        this.cfg = new OViewConfig(this.getName(), query);
        this.cfg.setUpdatable(Boolean.TRUE.equals(this.document.getProperty("updatable")));
        List idxData = (List)this.document.getProperty("indexes");
        for (Map idx : idxData) {
            String type = (String)idx.get("type");
            String engine = (String)idx.get("engine");
            OViewConfig.OViewIndexConfig indexConfig = this.cfg.addIndex(type, engine);
            for (Map.Entry prop : ((Map)idx.get("properties")).entrySet()) {
                indexConfig.addProperty((String)prop.getKey(), OType.valueOf((String)prop.getValue()));
            }
        }
        if (this.document.getProperty("updateIntervalSeconds") instanceof Integer) {
            this.cfg.setUpdateIntervalSeconds((Integer)this.document.getProperty("updateIntervalSeconds"));
        }
        if (this.document.getProperty("updateStrategy") instanceof String) {
            this.cfg.setUpdateStrategy((String)this.document.getProperty("updateStrategy"));
        }
        if (this.document.getProperty("watchClasses") instanceof List) {
            this.cfg.setWatchClasses((List)this.document.getProperty("watchClasses"));
        }
        if (this.document.getProperty("originRidField") instanceof String) {
            this.cfg.setOriginRidField((String)this.document.getProperty("originRidField"));
        }
        if (this.document.getProperty("nodes") instanceof List) {
            this.cfg.setNodes((List)this.document.getProperty("nodes"));
        }
        if (this.document.getProperty("activeIndexNames") instanceof Set) {
            this.activeIndexNames = (Set)this.document.getProperty("activeIndexNames");
        }
        if (this.document.getProperty("inactiveIndexNames") instanceof List) {
            this.inactiveIndexNames = (List)this.document.getProperty("inactiveIndexNames");
        }
    }

    @Override
    public ODocument toStream() {
        ODocument result = super.toStream();
        result.setProperty("query", this.cfg.getQuery());
        result.setProperty("updatable", this.cfg.isUpdatable());
        ArrayList indexes = new ArrayList();
        for (OViewConfig.OViewIndexConfig idx : this.cfg.indexes) {
            HashMap<String, Object> indexDescriptor = new HashMap<String, Object>();
            indexDescriptor.put("type", idx.type);
            indexDescriptor.put("engine", idx.engine);
            HashMap properties = new HashMap();
            for (OPair<String, OType> s : idx.props) {
                properties.put(s.key, ((OType)((Object)s.value)).toString());
            }
            indexDescriptor.put("properties", properties);
            indexes.add(indexDescriptor);
        }
        result.setProperty("indexes", indexes);
        result.setProperty("updateIntervalSeconds", this.cfg.getUpdateIntervalSeconds());
        result.setProperty("updateStrategy", this.cfg.getUpdateStrategy());
        result.setProperty("watchClasses", this.cfg.getWatchClasses());
        result.setProperty("originRidField", this.cfg.getOriginRidField());
        result.setProperty("nodes", this.cfg.getNodes());
        result.setProperty("activeIndexNames", this.activeIndexNames);
        result.setProperty("inactiveIndexNames", this.inactiveIndexNames);
        return result;
    }

    @Override
    public ODocument toNetworkStream() {
        ODocument result = super.toNetworkStream();
        result.setProperty("query", this.cfg.getQuery());
        result.setProperty("updatable", this.cfg.isUpdatable());
        ArrayList indexes = new ArrayList();
        for (OViewConfig.OViewIndexConfig idx : this.cfg.indexes) {
            HashMap<String, Object> indexDescriptor = new HashMap<String, Object>();
            indexDescriptor.put("type", idx.type);
            indexDescriptor.put("engine", idx.engine);
            HashMap properties = new HashMap();
            for (OPair<String, OType> s : idx.props) {
                properties.put(s.key, ((OType)((Object)s.value)).toString());
            }
            indexDescriptor.put("properties", properties);
            indexes.add(indexDescriptor);
        }
        result.setProperty("indexes", indexes);
        result.setProperty("updateIntervalSeconds", this.cfg.getUpdateIntervalSeconds());
        result.setProperty("updateStrategy", this.cfg.getUpdateStrategy());
        result.setProperty("watchClasses", this.cfg.getWatchClasses());
        result.setProperty("originRidField", this.cfg.getOriginRidField());
        result.setProperty("nodes", this.cfg.getNodes());
        result.setProperty("activeIndexNames", this.activeIndexNames);
        result.setProperty("inactiveIndexNames", this.inactiveIndexNames);
        return result;
    }

    @Override
    public String getQuery() {
        return this.cfg.getQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(boolean isPolymorphic) {
        this.acquireSchemaReadLock();
        try {
            long l = this.getDatabase().countView(this.getName());
            return l;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int getUpdateIntervalSeconds() {
        return this.cfg.updateIntervalSeconds;
    }

    @Override
    public List<String> getWatchClasses() {
        return this.cfg.getWatchClasses();
    }

    @Override
    public String getOriginRidField() {
        return this.cfg.getOriginRidField();
    }

    @Override
    public boolean isUpdatable() {
        return this.cfg.isUpdatable();
    }

    @Override
    public String getUpdateStrategy() {
        return this.cfg.getUpdateStrategy();
    }

    @Override
    public List<String> getNodes() {
        return this.cfg.getNodes();
    }

    @Override
    public List<OViewConfig.OViewIndexConfig> getRequiredIndexesInfo() {
        return this.cfg.getIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIndex> getClassIndexes() {
        if (this.activeIndexNames == null || this.activeIndexNames.isEmpty()) {
            return new HashSet<OIndex>();
        }
        this.acquireSchemaReadLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OIndexManagerAbstract idxManager = database.getMetadata().getIndexManagerInternal();
            if (idxManager == null) {
                HashSet<OIndex> hashSet = new HashSet<OIndex>();
                return hashSet;
            }
            Set<OIndex> set = this.activeIndexNames.stream().map(name -> idxManager.getIndex(database, (String)name)).filter(Objects::nonNull).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getClassIndexes(Collection<OIndex> indexes) {
        this.acquireSchemaReadLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OIndexManagerAbstract idxManager = database.getMetadata().getIndexManagerInternal();
            if (idxManager == null) {
                return;
            }
            this.activeIndexNames.stream().map(name -> idxManager.getIndex(database, (String)name)).filter(Objects::nonNull).forEach(indexes::add);
            idxManager.getClassIndexes(database, this.name, indexes);
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public void inactivateIndexes() {
        this.acquireSchemaReadLock();
        try {
            this.inactiveIndexNames.addAll(this.activeIndexNames);
            this.activeIndexNames.clear();
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public void inactivateIndex(String name) {
        this.acquireSchemaReadLock();
        try {
            this.activeIndexNames.remove(name);
            this.inactiveIndexNames.add(name);
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public List<String> getInactiveIndexes() {
        return this.inactiveIndexNames;
    }

    public void addActiveIndexes(List<String> names) {
        this.acquireSchemaReadLock();
        try {
            this.activeIndexNames.addAll(names);
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }
}

