/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.OIdentityChangeListener;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODirtyManager;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cluster.OOfflineClusterException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class ORecordAbstract
implements ORecord {
    protected ORecordId recordId;
    protected int recordVersion = 0;
    protected byte[] source;
    protected int size;
    protected transient ORecordSerializer recordFormat;
    protected boolean dirty = true;
    protected boolean contentChanged = true;
    protected ORecordElement.STATUS status = ORecordElement.STATUS.LOADED;
    private transient Set<OIdentityChangeListener> newIdentityChangeListeners = null;
    protected ODirtyManager dirtyManager;

    public ORecordAbstract() {
    }

    public ORecordAbstract(byte[] iSource) {
        this.source = iSource;
        this.size = iSource.length;
        this.unsetDirty();
    }

    @Override
    public ORID getIdentity() {
        return this.recordId;
    }

    protected ORecordAbstract setIdentity(ORecordId iIdentity) {
        this.recordId = iIdentity;
        return this;
    }

    @Override
    public ORecordElement getOwner() {
        return null;
    }

    public ORecord getRecord() {
        return this;
    }

    @Override
    public boolean detach() {
        return true;
    }

    public ORecordAbstract clear() {
        this.setDirty();
        return this;
    }

    public ORecordAbstract reset() {
        this.status = ORecordElement.STATUS.LOADED;
        this.recordVersion = 0;
        this.size = 0;
        this.source = null;
        this.setDirty();
        if (this.recordId != null) {
            this.recordId.reset();
        }
        return this;
    }

    @Override
    public byte[] toStream() {
        if (this.source == null) {
            this.source = this.recordFormat.toStream(this);
        }
        return this.source;
    }

    @Override
    public ORecordAbstract fromStream(byte[] iRecordBuffer) {
        this.dirty = false;
        this.contentChanged = false;
        this.dirtyManager = null;
        this.source = iRecordBuffer;
        this.size = iRecordBuffer != null ? iRecordBuffer.length : 0;
        this.status = ORecordElement.STATUS.LOADED;
        return this;
    }

    public ORecordAbstract setDirty() {
        if (!this.dirty && this.status != ORecordElement.STATUS.UNMARSHALLING) {
            this.dirty = true;
            this.source = null;
        }
        this.contentChanged = true;
        return this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (!this.dirty && this.status != ORecordElement.STATUS.UNMARSHALLING) {
            this.dirty = true;
            this.source = null;
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    public <RET extends ORecord> RET fromJSON(String iSource, String iOptions) {
        ORecordSerializerJSON.INSTANCE.fromString(iSource, this, null, iOptions, false);
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET fromJSON(String iSource) {
        ORecordSerializerJSON.INSTANCE.fromString(iSource, this, null);
        return (RET)this;
    }

    public <RET extends ORecord> RET fromJSON(String iSource, boolean needReload) {
        return (RET)ORecordSerializerJSON.INSTANCE.fromString(iSource, this, null, needReload);
    }

    public <RET extends ORecord> RET fromJSON(InputStream iContentResult) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OIOUtils.copyStream(iContentResult, out, -1L);
        ORecordSerializerJSON.INSTANCE.fromString(out.toString(), this, null);
        return (RET)this;
    }

    @Override
    public String toJSON() {
        return this.toJSON("rid,version,class,type,attribSameRow,keepTypes,alwaysFetchEmbedded,fetchPlan:*:0");
    }

    @Override
    public String toJSON(String iFormat) {
        return ORecordSerializerJSON.INSTANCE.toString(this, new StringBuilder(1024), iFormat == null ? "" : iFormat).toString();
    }

    public void toJSON(String iFormat, OutputStream stream) throws IOException {
        stream.write(this.toJSON(iFormat).toString().getBytes());
    }

    public void toJSON(OutputStream stream) throws IOException {
        stream.write(this.toJSON().toString().getBytes());
    }

    public String toString() {
        return (this.recordId.isValid() ? this.recordId : "") + (this.source != null ? Arrays.toString(this.source) : "[]") + " v" + this.recordVersion;
    }

    @Override
    public int getVersion() {
        return this.recordVersion;
    }

    protected void setVersion(int iVersion) {
        this.recordVersion = iVersion;
    }

    public ORecordAbstract unload() {
        this.status = ORecordElement.STATUS.NOT_LOADED;
        this.source = null;
        this.unsetDirty();
        return this;
    }

    public ORecord load() {
        if (!this.getIdentity().isValid()) {
            throw new ORecordNotFoundException(this.getIdentity(), "The record has no id, probably it's new or transient yet ");
        }
        ORecord result = (ORecord)this.getDatabase().load(this);
        if (result == null) {
            throw new ORecordNotFoundException(this.getIdentity());
        }
        return result;
    }

    @Override
    public ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    public ODatabaseDocumentInternal getDatabaseIfDefined() {
        return ODatabaseRecordThreadLocal.instance().getIfDefined();
    }

    public ORecord reload() {
        return this.reload(null, true, true);
    }

    public ORecord reload(String fetchPlan) {
        return this.reload(fetchPlan, true);
    }

    public ORecord reload(String fetchPlan, boolean ignoreCache) {
        return this.reload(fetchPlan, ignoreCache, true);
    }

    public ORecord reload(String fetchPlan, boolean ignoreCache, boolean force) throws ORecordNotFoundException {
        if (!this.getIdentity().isValid()) {
            throw new ORecordNotFoundException(this.getIdentity(), "The record has no id. It is probably new or still transient");
        }
        try {
            this.getDatabase().reload(this, fetchPlan, ignoreCache, force);
            return this;
        }
        catch (OOfflineClusterException e) {
            throw e;
        }
        catch (ORecordNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw OException.wrapException(new ORecordNotFoundException(this.getIdentity()), e);
        }
    }

    public ORecordAbstract save() {
        return this.save(false);
    }

    public ORecordAbstract save(String iClusterName) {
        return this.save(iClusterName, false);
    }

    public ORecordAbstract save(boolean forceCreate) {
        this.getDatabase().save(this, ODatabase.OPERATION_MODE.SYNCHRONOUS, forceCreate, null, null);
        return this;
    }

    public ORecordAbstract save(String iClusterName, boolean forceCreate) {
        return (ORecordAbstract)this.getDatabase().save(this, iClusterName, ODatabase.OPERATION_MODE.SYNCHRONOUS, forceCreate, null, null);
    }

    public ORecordAbstract delete() {
        this.getDatabase().delete(this);
        return this;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void lock(boolean iExclusive) {
        ODatabaseRecordThreadLocal.instance().get().getTransaction().lockRecord(this, iExclusive ? OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK : OStorage.LOCKING_STRATEGY.SHARED_LOCK);
    }

    @Override
    public boolean isLocked() {
        return ODatabaseRecordThreadLocal.instance().get().getTransaction().isLockedRecord(this);
    }

    @Override
    public OStorage.LOCKING_STRATEGY lockingStrategy() {
        return ODatabaseRecordThreadLocal.instance().get().getTransaction().lockingStrategy(this);
    }

    @Override
    public void unlock() {
        ODatabaseRecordThreadLocal.instance().get().getTransaction().unlockRecord(this);
    }

    public int hashCode() {
        return this.recordId != null ? this.recordId.hashCode() : 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof OIdentifiable) {
            return this.recordId.equals(((OIdentifiable)obj).getIdentity());
        }
        return false;
    }

    @Override
    public int compare(OIdentifiable iFirst, OIdentifiable iSecond) {
        if (iFirst == null || iSecond == null) {
            return -1;
        }
        return iFirst.compareTo(iSecond);
    }

    @Override
    public int compareTo(OIdentifiable iOther) {
        if (iOther == null) {
            return 1;
        }
        if (this.recordId == null) {
            return iOther.getIdentity() == null ? 0 : 1;
        }
        return this.recordId.compareTo(iOther.getIdentity());
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.status = iStatus;
    }

    public ORecordAbstract copyTo(ORecordAbstract cloned) {
        cloned.source = this.source;
        cloned.size = this.size;
        cloned.recordId = this.recordId.copy();
        cloned.recordVersion = this.recordVersion;
        cloned.status = this.status;
        cloned.recordFormat = this.recordFormat;
        cloned.dirty = false;
        cloned.contentChanged = false;
        cloned.dirtyManager = null;
        return cloned;
    }

    protected ORecordAbstract fill(ORID iRid, int iVersion, byte[] iBuffer, boolean iDirty) {
        this.recordId.setClusterId(iRid.getClusterId());
        this.recordId.setClusterPosition(iRid.getClusterPosition());
        this.recordVersion = iVersion;
        this.status = ORecordElement.STATUS.LOADED;
        this.source = iBuffer;
        int n = this.size = iBuffer != null ? iBuffer.length : 0;
        if (this.source != null && this.source.length > 0) {
            this.dirty = iDirty;
            this.contentChanged = iDirty;
        }
        return this;
    }

    protected ORecordAbstract fill(ORID iRid, int iVersion, byte[] iBuffer, boolean iDirty, ODatabaseDocumentInternal db) {
        this.recordId.setClusterId(iRid.getClusterId());
        this.recordId.setClusterPosition(iRid.getClusterPosition());
        this.recordVersion = iVersion;
        this.status = ORecordElement.STATUS.LOADED;
        this.source = iBuffer;
        int n = this.size = iBuffer != null ? iBuffer.length : 0;
        if (this.source != null && this.source.length > 0) {
            this.dirty = iDirty;
            this.contentChanged = iDirty;
        }
        return this;
    }

    protected ORecordAbstract setIdentity(int iClusterId, long iClusterPosition) {
        if (this.recordId == null || this.recordId == ORecordId.EMPTY_RECORD_ID) {
            this.recordId = new ORecordId(iClusterId, iClusterPosition);
        } else {
            this.recordId.setClusterId(iClusterId);
            this.recordId.setClusterPosition(iClusterPosition);
        }
        return this;
    }

    protected void unsetDirty() {
        this.contentChanged = false;
        this.dirty = false;
    }

    protected abstract byte getRecordType();

    protected void onBeforeIdentityChanged(ORecord iRecord) {
        if (this.newIdentityChangeListeners != null) {
            for (OIdentityChangeListener changeListener : this.newIdentityChangeListeners) {
                changeListener.onBeforeIdentityChange(this);
            }
        }
    }

    protected void onAfterIdentityChanged(ORecord iRecord) {
        if (this.newIdentityChangeListeners != null) {
            for (OIdentityChangeListener changeListener : this.newIdentityChangeListeners) {
                changeListener.onAfterIdentityChange(this);
            }
        }
    }

    protected ODatabaseDocumentInternal getDatabaseInternal() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    protected ODatabaseDocumentInternal getDatabaseIfDefinedInternal() {
        return ODatabaseRecordThreadLocal.instance().getIfDefined();
    }

    protected <RET extends ORecord> RET flatCopy() {
        return this.copy();
    }

    protected void addIdentityChangeListener(OIdentityChangeListener identityChangeListener) {
        if (this.newIdentityChangeListeners == null) {
            this.newIdentityChangeListeners = Collections.newSetFromMap(new WeakHashMap());
        }
        this.newIdentityChangeListeners.add(identityChangeListener);
    }

    protected void removeIdentityChangeListener(OIdentityChangeListener identityChangeListener) {
        if (this.newIdentityChangeListeners != null) {
            this.newIdentityChangeListeners.remove(identityChangeListener);
        }
    }

    protected void setup(ODatabaseDocumentInternal db) {
        if (this.recordId == null) {
            this.recordId = new ORecordId();
        }
    }

    protected void checkForLoading() {
        if (this.status == ORecordElement.STATUS.NOT_LOADED && ODatabaseRecordThreadLocal.instance().isDefined()) {
            this.reload(null, true);
        }
    }

    protected boolean isContentChanged() {
        return this.contentChanged;
    }

    protected void setContentChanged(boolean contentChanged) {
        this.contentChanged = contentChanged;
    }

    protected void clearSource() {
        this.source = null;
    }

    protected ODirtyManager getDirtyManager() {
        if (this.dirtyManager == null) {
            this.dirtyManager = new ODirtyManager();
            if (this.getIdentity().isNew() && this.getOwner() == null) {
                this.dirtyManager.setDirty(this);
            }
        }
        return this.dirtyManager;
    }

    protected void setDirtyManager(ODirtyManager dirtyManager) {
        if (this.dirtyManager != null && dirtyManager != null) {
            dirtyManager.merge(this.dirtyManager);
        }
        this.dirtyManager = dirtyManager;
        if (this.getIdentity().isNew() && this.getOwner() == null && this.dirtyManager != null) {
            this.dirtyManager.setDirty(this);
        }
    }

    protected void track(OIdentifiable id) {
        this.getDirtyManager().track(this, id);
    }

    protected void unTrack(OIdentifiable id) {
        this.getDirtyManager().unTrack(this, id);
    }
}

